/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.io.Serializable;
import javax.media.jai.JaiI18N;

public abstract class Warp
implements Serializable {
    protected Warp() {
    }

    public int[] warpRect(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (nArray != null && nArray.length < n3 * n4 * 2) {
            throw new IllegalArgumentException(JaiI18N.getString("Warp0"));
        }
        return this.warpSparseRect(n, n2, n3, n4, 1, 1, n5, n6, nArray);
    }

    public float[] warpRect(int n, int n2, int n3, int n4, float[] fArray) {
        if (fArray != null && fArray.length < n3 * n4 * 2) {
            throw new IllegalArgumentException(JaiI18N.getString("Warp0"));
        }
        return this.warpSparseRect(n, n2, n3, n4, 1, 1, fArray);
    }

    public int[] warpPoint(int n, int n2, int n3, int n4, int[] nArray) {
        if (nArray != null && nArray.length < 2) {
            throw new IllegalArgumentException(JaiI18N.getString("Warp0"));
        }
        return this.warpSparseRect(n, n2, 1, 1, 1, 1, n3, n4, nArray);
    }

    public float[] warpPoint(int n, int n2, float[] fArray) {
        if (fArray != null && fArray.length < 2) {
            throw new IllegalArgumentException(JaiI18N.getString("Warp0"));
        }
        return this.warpSparseRect(n, n2, 1, 1, 1, 1, fArray);
    }

    public int[] warpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        int n9 = 2 * ((n3 + n5 - 1) / n5) * ((n4 + n6 - 1) / n6);
        if (nArray != null && nArray.length < n9) {
            throw new IllegalArgumentException(JaiI18N.getString("Warp0"));
        }
        float[] fArray = this.warpSparseRect(n, n2, n3, n4, n5, n6, null);
        int n10 = fArray.length;
        if (nArray == null) {
            nArray = new int[n10];
        }
        int n11 = 1 << n7;
        int n12 = 1 << n8;
        int n13 = 0;
        while (n13 < n10) {
            nArray[n13] = (int)Math.floor(fArray[n13] * (float)n11);
            nArray[n13 + 1] = (int)Math.floor(fArray[n13 + 1] * (float)n12);
            n13 += 2;
        }
        return nArray;
    }

    public abstract float[] warpSparseRect(int var1, int var2, int var3, int var4, int var5, int var6, float[] var7);

    public Rectangle mapSourceRect(Rectangle rectangle) {
        return null;
    }

    public Rectangle mapDestRect(Rectangle rectangle) {
        float f;
        float f2;
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        float[] fArray = new float[Math.max(n3 * 2, (n4 - 2) * 2)];
        int n5 = n3 * 2;
        this.warpSparseRect(n, n2, n3, 1, 1, 1, fArray);
        float f3 = fArray[0];
        float f4 = fArray[0];
        float f5 = fArray[1];
        float f6 = fArray[1];
        int n6 = 2;
        while (n6 < n5) {
            f2 = fArray[n6];
            f = fArray[n6 + 1];
            if (f2 < f3) {
                f3 = f2;
            } else if (f2 > f4) {
                f4 = f2;
            }
            if (f < f5) {
                f5 = f;
            } else if (f > f6) {
                f6 = f;
            }
            n6 += 2;
        }
        this.warpSparseRect(n, n2 + n4 - 1, n3, 1, 1, 1, fArray);
        int n7 = 0;
        while (n7 < n5) {
            f2 = fArray[n7];
            f = fArray[n7 + 1];
            if (f2 < f3) {
                f3 = f2;
            } else if (f2 > f4) {
                f4 = f2;
            }
            if (f < f5) {
                f5 = f;
            } else if (f > f6) {
                f6 = f;
            }
            n7 += 2;
        }
        n5 = (n4 - 2) * 2;
        this.warpSparseRect(n, n2 + 1, 1, n4 - 2, 1, 1, fArray);
        int n8 = 0;
        while (n8 < n5) {
            f2 = fArray[n8];
            f = fArray[n8 + 1];
            if (f2 < f3) {
                f3 = f2;
            } else if (f2 > f4) {
                f4 = f2;
            }
            if (f < f5) {
                f5 = f;
            } else if (f > f6) {
                f6 = f;
            }
            n8 += 2;
        }
        this.warpSparseRect(n + n3 - 1, n2 + 1, 1, n4 - 2, 1, 1, fArray);
        int n9 = 0;
        while (n9 < n5) {
            f2 = fArray[n9];
            f = fArray[n9 + 1];
            if (f2 < f3) {
                f3 = f2;
            } else if (f2 > f4) {
                f4 = f2;
            }
            if (f < f5) {
                f5 = f;
            } else if (f > f6) {
                f6 = f;
            }
            n9 += 2;
        }
        n = (int)Math.floor(f3);
        n2 = (int)Math.floor(f5);
        n3 = (int)Math.ceil(f4 - (float)n) + 1;
        n4 = (int)Math.ceil(f6 - (float)n2) + 1;
        return new Rectangle(n, n2, n3, n4);
    }
}

