/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.Rational;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;

public abstract class ScaleOpImage
extends GeometricOpImage {
    protected float scaleX;
    protected float scaleY;
    protected float transX;
    protected float transY;
    protected Rational scaleXRational;
    protected Rational scaleYRational;
    protected long scaleXRationalNum;
    protected long scaleXRationalDenom;
    protected long scaleYRationalNum;
    protected long scaleYRationalDenom;
    protected Rational invScaleXRational;
    protected Rational invScaleYRational;
    protected long invScaleXRationalNum;
    protected long invScaleXRationalDenom;
    protected long invScaleYRationalNum;
    protected long invScaleYRationalDenom;
    protected Rational transXRational;
    protected Rational transYRational;
    protected long transXRationalNum;
    protected long transXRationalDenom;
    protected long transYRationalNum;
    protected long transYRationalDenom;
    protected static float rationalTolerance = 1.0E-6f;
    private int lpad;
    private int rpad;
    private int tpad;
    private int bpad;

    private static ImageLayout layoutHelper(RenderedImage renderedImage, float f, float f2, float f3, float f4, Interpolation interpolation, ImageLayout imageLayout) {
        int n;
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        Rational rational = Rational.approximate(f, rationalTolerance);
        Rational rational2 = Rational.approximate(f2, rationalTolerance);
        long l9 = rational.num;
        long l10 = rational.denom;
        long l11 = rational2.num;
        long l12 = rational2.denom;
        Rational rational3 = Rational.approximate(f3, rationalTolerance);
        Rational rational4 = Rational.approximate(f4, rationalTolerance);
        long l13 = rational3.num;
        long l14 = rational3.denom;
        long l15 = rational4.num;
        long l16 = rational4.denom;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n2 = renderedImage.getMinX();
        int n3 = renderedImage.getMinY();
        int n4 = renderedImage.getWidth();
        int n5 = renderedImage.getHeight();
        if (interpolation instanceof InterpolationNearest) {
            l8 = n2;
            l7 = 1L;
            l6 = n3;
            l5 = 1L;
            l4 = n2 + n4;
            l3 = 1L;
            l2 = n3 + n5;
            l = 1L;
        } else {
            l8 = 2 * n2 + 1;
            l7 = 2L;
            l6 = 2 * n3 + 1;
            l5 = 2L;
            l4 = 2 * n2 + 2 * n4 + 1;
            l3 = 2L;
            l2 = 2 * n3 + 2 * n5 + 1;
            l = 2L;
        }
        l8 *= l9;
        l7 *= l10;
        l6 *= l11;
        l5 *= l12;
        l4 *= l9;
        l3 *= l10;
        l2 *= l11;
        l *= l12;
        l8 = l8 * l14 + l13 * l7;
        l7 *= l14;
        l6 = l6 * l16 + l15 * l5;
        l5 *= l16;
        l4 = l4 * l14 + l13 * l3;
        l3 *= l14;
        l2 = l2 * l16 + l15 * l;
        l *= l16;
        l8 = 2L * l8 - l7;
        l6 = 2L * l6 - l5;
        int n6 = Rational.ceil(l8, l7 *= 2L);
        int n7 = Rational.ceil(l6, l5 *= 2L);
        l4 = 2L * l4 - l3;
        l2 = 2L * l2 - l;
        l *= 2L;
        int n8 = Rational.floor(l4, l3 *= 2L);
        if ((long)n8 * l3 == l4) {
            --n8;
        }
        if ((long)(n = Rational.floor(l2, l)) * l == l2) {
            --n;
        }
        imageLayout2.setMinX(n6);
        imageLayout2.setMinY(n7);
        imageLayout2.setWidth(n8 - n6 + 1);
        imageLayout2.setHeight(n - n7 + 1);
        return imageLayout2;
    }

    public ScaleOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation, float f, float f2, float f3, float f4) {
        super(OpImage.vectorize(renderedImage), ScaleOpImage.layoutHelper(renderedImage, f, f2, f3, f4, interpolation, imageLayout), map, bl, borderExtender, interpolation);
        this.scaleX = f;
        this.scaleY = f2;
        this.transX = f3;
        this.transY = f4;
        this.scaleXRational = Rational.approximate(f, rationalTolerance);
        this.scaleYRational = Rational.approximate(f2, rationalTolerance);
        this.scaleXRationalNum = this.scaleXRational.num;
        this.scaleXRationalDenom = this.scaleXRational.denom;
        this.scaleYRationalNum = this.scaleYRational.num;
        this.scaleYRationalDenom = this.scaleYRational.denom;
        this.transXRational = Rational.approximate(f3, rationalTolerance);
        this.transYRational = Rational.approximate(f4, rationalTolerance);
        this.transXRationalNum = this.transXRational.num;
        this.transXRationalDenom = this.transXRational.denom;
        this.transYRationalNum = this.transYRational.num;
        this.transYRationalDenom = this.transYRational.denom;
        this.invScaleXRational = new Rational(this.scaleXRational);
        this.invScaleXRational.invert();
        this.invScaleYRational = new Rational(this.scaleYRational);
        this.invScaleYRational.invert();
        this.invScaleXRationalNum = this.invScaleXRational.num;
        this.invScaleXRationalDenom = this.invScaleXRational.denom;
        this.invScaleYRationalNum = this.invScaleYRational.num;
        this.invScaleYRationalDenom = this.invScaleYRational.denom;
        this.lpad = interpolation.getLeftPadding();
        this.rpad = interpolation.getRightPadding();
        this.tpad = interpolation.getTopPadding();
        this.bpad = interpolation.getBottomPadding();
        if (borderExtender == null) {
            int n;
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            long l6;
            long l7;
            long l8;
            int n2 = renderedImage.getMinX();
            int n3 = renderedImage.getMinY();
            int n4 = renderedImage.getWidth();
            int n5 = renderedImage.getHeight();
            if (interpolation instanceof InterpolationNearest) {
                l8 = n2;
                l7 = 1L;
                l6 = n3;
                l5 = 1L;
                l4 = n2 + n4;
                l3 = 1L;
                l2 = n3 + n5;
                l = 1L;
            } else {
                l8 = 2 * n2 + 1;
                l7 = 2L;
                l6 = 2 * n3 + 1;
                l5 = 2L;
                l4 = 2 * n2 + 2 * n4 + 1;
                l3 = 2L;
                l2 = 2 * n3 + 2 * n5 + 1;
                l = 2L;
                l8 += l7 * (long)this.lpad;
                l6 += l5 * (long)this.tpad;
                l4 -= l3 * (long)this.rpad;
                l2 -= l * (long)this.bpad;
            }
            l8 *= this.scaleXRationalNum;
            l8 = l8 * this.transXRationalDenom + this.transXRationalNum * (l7 *= this.scaleXRationalDenom);
            l7 *= this.transXRationalDenom;
            l6 *= this.scaleYRationalNum;
            l6 = l6 * this.transYRationalDenom + this.transYRationalNum * (l5 *= this.scaleYRationalDenom);
            l5 *= this.transYRationalDenom;
            l4 *= this.scaleXRationalNum;
            l4 = l4 * this.transXRationalDenom + this.transXRationalNum * (l3 *= this.scaleXRationalDenom);
            l3 *= this.transXRationalDenom;
            l2 *= this.scaleYRationalNum;
            l2 = l2 * this.transYRationalDenom + this.transYRationalNum * (l *= this.scaleYRationalDenom);
            l *= this.transYRationalDenom;
            l8 = 2L * l8 - l7;
            l6 = 2L * l6 - l5;
            int n6 = Rational.ceil(l8, l7 *= 2L);
            int n7 = Rational.ceil(l6, l5 *= 2L);
            l4 = 2L * l4 - l3;
            l2 = 2L * l2 - l;
            l *= 2L;
            int n8 = Rational.floor(l4, l3 *= 2L);
            if ((long)n8 * l3 == l4) {
                --n8;
            }
            if ((long)(n = Rational.floor(l2, l)) * l == l2) {
                --n;
            }
            this.computableBounds = new Rectangle(n6, n7, n8 - n6 + 1, n - n7 + 1);
        } else {
            this.computableBounds = this.getBounds();
        }
    }

    public int getLeftPadding() {
        return this.interp == null ? 0 : this.interp.getLeftPadding();
    }

    public int getRightPadding() {
        return this.interp == null ? 0 : this.interp.getRightPadding();
    }

    public int getTopPadding() {
        return this.interp == null ? 0 : this.interp.getTopPadding();
    }

    public int getBottomPadding() {
        return this.interp == null ? 0 : this.interp.getBottomPadding();
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        int n2;
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (this.interp instanceof InterpolationNearest) {
            l8 = n3;
            l7 = 1L;
            l6 = n4;
            l5 = 1L;
            l4 = n3 + n5;
            l3 = 1L;
            l2 = n4 + n6;
            l = 1L;
        } else {
            l8 = 2 * n3 + 1;
            l7 = 2L;
            l6 = 2 * n4 + 1;
            l5 = 2L;
            l4 = 2 * n3 + 2 * n5 + 1;
            l3 = 2L;
            l2 = 2 * n4 + 2 * n6 + 1;
            l = 2L;
        }
        l8 *= this.scaleXRationalNum;
        l7 *= this.scaleXRationalDenom;
        l6 *= this.scaleYRationalNum;
        l5 *= this.scaleYRationalDenom;
        l4 *= this.scaleXRationalNum;
        l3 *= this.scaleXRationalDenom;
        l2 *= this.scaleYRationalNum;
        l *= this.scaleYRationalDenom;
        l8 = l8 * this.transXRationalDenom + this.transXRationalNum * l7;
        l7 *= this.transXRationalDenom;
        l6 = l6 * this.transYRationalDenom + this.transYRationalNum * l5;
        l5 *= this.transYRationalDenom;
        l4 = l4 * this.transXRationalDenom + this.transXRationalNum * l3;
        l3 *= this.transXRationalDenom;
        l2 = l2 * this.transYRationalDenom + this.transYRationalNum * l;
        l *= this.transYRationalDenom;
        l8 = 2L * l8 - l7;
        l6 = 2L * l6 - l5;
        int n7 = Rational.ceil(l8, l7 *= 2L);
        int n8 = Rational.ceil(l6, l5 *= 2L);
        l4 = 2L * l4 - l3;
        l2 = 2L * l2 - l;
        l *= 2L;
        int n9 = Rational.floor(l4, l3 *= 2L);
        if ((long)n9 * l3 == l4) {
            --n9;
        }
        if ((long)(n2 = Rational.floor(l2, l)) * l == l2) {
            --n2;
        }
        return new Rectangle(n7, n8, n9 - n7 + 1, n2 - n8 + 1);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        long l = n2 * 2 + 1;
        long l2 = 2L;
        long l3 = n3 * 2 + 1;
        long l4 = 2L;
        long l5 = 2 * n2 + 2 * n4 - 1;
        long l6 = 2L;
        long l7 = 2 * n3 + 2 * n5 - 1;
        long l8 = 2L;
        l = l * this.transXRationalDenom - this.transXRationalNum * l2;
        l2 *= this.transXRationalDenom;
        l3 = l3 * this.transYRationalDenom - this.transYRationalNum * l4;
        l4 *= this.transYRationalDenom;
        l5 = l5 * this.transXRationalDenom - this.transXRationalNum * l6;
        l6 *= this.transXRationalDenom;
        l7 = l7 * this.transYRationalDenom - this.transYRationalNum * l8;
        l8 *= this.transYRationalDenom;
        l *= this.invScaleXRationalNum;
        l2 *= this.invScaleXRationalDenom;
        l3 *= this.invScaleYRationalNum;
        l4 *= this.invScaleYRationalDenom;
        l5 *= this.invScaleXRationalNum;
        l6 *= this.invScaleXRationalDenom;
        l7 *= this.invScaleYRationalNum;
        l8 *= this.invScaleYRationalDenom;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.interp instanceof InterpolationNearest) {
            n6 = Rational.floor(l, l2);
            n7 = Rational.floor(l3, l4);
            n8 = Rational.floor(l5, l6);
            n9 = Rational.floor(l7, l8);
        } else {
            n6 = Rational.floor(2L * l - l2, 2L * l2);
            n7 = Rational.floor(2L * l3 - l4, 2L * l4);
            n8 = Rational.floor(2L * l5 - l6, 2L * l6);
            n9 = Rational.floor(2L * l7 - l8, 2L * l8);
        }
        return new Rectangle(n6, n7, n8 - n6 + 1, n9 - n7 + 1);
    }

    public Raster computeTile(int n, int n2) {
        if (!this.cobbleSources) {
            return super.computeTile(n, n2);
        }
        int n3 = this.tileXToX(n);
        int n4 = this.tileYToY(n2);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
        Rectangle rectangle = new Rectangle(n3, n4, this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.computableBounds);
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return writableRaster;
        }
        Rectangle rectangle3 = this.mapDestRect(rectangle2, 0);
        Raster[] rasterArray = new Raster[1];
        PlanarImage planarImage = this.getSource(0);
        IntegerSequence integerSequence = new IntegerSequence();
        IntegerSequence integerSequence2 = new IntegerSequence();
        planarImage.getSplits(integerSequence, integerSequence2, rectangle3);
        if (integerSequence.getNumElements() == 1 && integerSequence2.getNumElements() == 1) {
            rasterArray[0] = this.extender == null ? planarImage.getData(rectangle3) : planarImage.getExtendedData(rectangle3, this.extender);
            this.computeRect(rasterArray, writableRaster, rectangle2);
        } else {
            int n5 = planarImage.getTileWidth();
            int n6 = planarImage.getTileHeight();
            integerSequence2.startEnumeration();
            while (integerSequence2.hasMoreElements()) {
                int n7 = integerSequence2.nextElement();
                integerSequence.startEnumeration();
                while (integerSequence.hasMoreElements()) {
                    Rectangle rectangle4;
                    Rectangle rectangle5;
                    int n8 = integerSequence.nextElement();
                    Rectangle rectangle6 = new Rectangle(n8, n7, n5, n6);
                    Rectangle rectangle7 = rectangle3.intersection(rectangle6);
                    if (!(this.interp instanceof InterpolationNearest)) {
                        if (rectangle7.width <= this.interp.getWidth()) {
                            rectangle5 = new Rectangle();
                            rectangle5.x = rectangle7.x;
                            rectangle5.y = rectangle7.y - this.tpad - 1;
                            rectangle5.width = 2 * (this.lpad + this.rpad + 1);
                            rectangle5.height = rectangle7.height + this.bpad + this.tpad + 2;
                            rectangle5 = rectangle5.intersection(planarImage.getBounds());
                            rectangle4 = this.mapSourceRect(rectangle5, 0);
                            rectangle4 = rectangle4.intersection(rectangle2);
                            if (rectangle4.width > 0 && rectangle4.height > 0) {
                                rasterArray[0] = this.extender == null ? planarImage.getData(rectangle5) : planarImage.getExtendedData(rectangle5, this.extender);
                                this.computeRect(rasterArray, writableRaster, rectangle4);
                            }
                        }
                        if (rectangle7.height <= this.interp.getHeight()) {
                            rectangle5 = new Rectangle();
                            rectangle5.x = rectangle7.x - this.lpad - 1;
                            rectangle5.y = rectangle7.y;
                            rectangle5.width = rectangle7.width + this.lpad + this.rpad + 2;
                            rectangle5.height = 2 * (this.tpad + this.bpad + 1);
                            rectangle5 = rectangle5.intersection(planarImage.getBounds());
                            rectangle4 = this.mapSourceRect(rectangle5, 0);
                            rectangle4 = rectangle4.intersection(rectangle2);
                            if (rectangle4.width > 0 && rectangle4.height > 0) {
                                rasterArray[0] = this.extender == null ? planarImage.getData(rectangle5) : planarImage.getExtendedData(rectangle5, this.extender);
                                this.computeRect(rasterArray, writableRaster, rectangle4);
                            }
                        }
                    }
                    if (rectangle7.width <= 0 || rectangle7.height <= 0) continue;
                    rectangle5 = this.mapSourceRect(rectangle7, 0);
                    rectangle5 = rectangle5.intersection(rectangle2);
                    if (rectangle5.width > 0 && rectangle5.height > 0) {
                        rasterArray[0] = this.extender == null ? planarImage.getData(rectangle7) : planarImage.getExtendedData(rectangle7, this.extender);
                        this.computeRect(rasterArray, writableRaster, rectangle5);
                    }
                    if (this.interp instanceof InterpolationNearest) continue;
                    rectangle4 = new Rectangle();
                    rectangle4.x = rectangle7.x + rectangle7.width - 1 - this.rpad - this.lpad;
                    rectangle4.y = rectangle7.y;
                    rectangle4.width = 2 * (this.lpad + this.rpad + 1);
                    rectangle4.height = rectangle7.height;
                    Rectangle rectangle8 = this.mapSourceRect(rectangle4, 0);
                    rectangle8 = rectangle8.intersection(rectangle2);
                    rectangle4 = this.mapDestRect(rectangle8, 0);
                    if (rectangle8.width > 0 && rectangle8.height > 0) {
                        rasterArray[0] = this.extender == null ? planarImage.getData(rectangle4) : planarImage.getExtendedData(rectangle4, this.extender);
                        this.computeRect(rasterArray, writableRaster, rectangle8);
                    }
                    Rectangle rectangle9 = new Rectangle();
                    rectangle9.x = rectangle7.x;
                    rectangle9.y = rectangle7.y + rectangle7.height - 1 - this.bpad - this.tpad;
                    rectangle9.width = rectangle7.width;
                    rectangle9.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle rectangle10 = this.mapSourceRect(rectangle9, 0);
                    rectangle10 = rectangle10.intersection(rectangle2);
                    rectangle9 = this.mapDestRect(rectangle10, 0);
                    if (rectangle10.width > 0 && rectangle10.height > 0) {
                        rasterArray[0] = this.extender == null ? planarImage.getData(rectangle9) : planarImage.getExtendedData(rectangle9, this.extender);
                        this.computeRect(rasterArray, writableRaster, rectangle10);
                    }
                    Rectangle rectangle11 = new Rectangle();
                    rectangle11.x = rectangle7.x + rectangle7.width - 1 - this.rpad - this.lpad;
                    rectangle11.y = rectangle7.y + rectangle7.height - 1 - this.bpad - this.tpad;
                    rectangle11.width = 2 * (this.rpad + this.lpad + 1);
                    rectangle11.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle rectangle12 = this.mapSourceRect(rectangle11, 0);
                    rectangle12 = rectangle12.intersection(rectangle2);
                    rectangle11 = this.mapDestRect(rectangle12, 0);
                    if (rectangle12.width <= 0 || rectangle12.height <= 0) continue;
                    rasterArray[0] = this.extender == null ? planarImage.getData(rectangle11) : planarImage.getExtendedData(rectangle11, this.extender);
                    this.computeRect(rasterArray, writableRaster, rectangle12);
                }
            }
        }
        return writableRaster;
    }
}

