/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.JaiI18N;
import com.sun.media.jai.util.Job;
import com.sun.media.jai.util.Request;
import com.sun.media.jai.util.RequestJob;
import com.sun.media.jai.util.TileJob;
import com.sun.media.jai.util.WorkerThread;
import java.awt.Point;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;

public final class SunTileScheduler
implements TileScheduler {
    private static final int NUM_THREADS_DEFAULT = 2;
    private static final int NUM_PREFETCH_THREADS_DEFAULT = 1;
    private int parallelism = 2;
    private int prefetchParallelism = 1;
    private int priority = 5;
    private int prefetchPriority = 1;
    private LinkedList queue = null;
    private LinkedList prefetchQueue = null;
    private Vector workers = new Vector();
    private Vector prefetchWorkers = new Vector();
    private int numWorkerThreads = 0;
    private int numPrefetchThreads = 0;
    private Map tilesInProgress = new HashMap();
    Map tileRequests = new HashMap();
    Map tileJobs = new HashMap();

    static Long tileKey(PlanarImage planarImage, int n, int n2) {
        long l = n2 * planarImage.getNumXTiles() + n;
        return new Long((long)planarImage.hashCode() << 32 | (l &= 0xFFFFFFFFL));
    }

    static Set getListeners(List list) {
        int n = list.size();
        HashSet hashSet = null;
        int n2 = 0;
        while (n2 < n) {
            Request request = (Request)list.get(n2);
            if (request.listeners != null && !request.listeners.isEmpty()) {
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                hashSet.addAll(request.listeners);
            }
            ++n2;
        }
        return hashSet;
    }

    private static String getStackTraceString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        String string = byteArrayOutputStream.toString();
        printStream.close();
        return string;
    }

    public SunTileScheduler(int n, int n2, int n3, int n4) {
        this();
        this.setParallelism(n);
        this.setPriority(n2);
        this.setPrefetchParallelism(n3);
        this.setPrefetchPriority(n4);
    }

    public SunTileScheduler() {
        this.queue = new LinkedList();
        this.prefetchQueue = new LinkedList();
    }

    Exception compute(PlanarImage planarImage, Point[] pointArray, Raster[] rasterArray, int n, int n2, Request request) {
        Object object;
        Exception exception = null;
        int n3 = n;
        if (request == null || request.listeners == null) {
            int n4 = 0;
            while (n4 < n2) {
                Point point = pointArray[n3];
                try {
                    rasterArray[n3] = planarImage.getTile(point.x, point.y);
                }
                catch (Exception exception2) {
                    exception = exception2;
                    break;
                }
                ++n4;
                ++n3;
            }
        } else {
            TileRequest[] tileRequestArray = new Request[]{request};
            int n5 = 0;
            while (n5 < n2) {
                Point point = pointArray[n3];
                Integer n6 = new Integer(1);
                request.tileStatus.put(point, n6);
                try {
                    rasterArray[n3] = planarImage.getTile(point.x, point.y);
                    object = request.listeners.iterator();
                    while (object.hasNext()) {
                        n6 = new Integer(2);
                        request.tileStatus.put(point, n6);
                        TileComputationListener tileComputationListener = (TileComputationListener)object.next();
                        tileComputationListener.tileComputed(this, tileRequestArray, planarImage, point.x, point.y, rasterArray[n3]);
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                    break;
                }
                ++n5;
                ++n3;
            }
        }
        if (exception != null && request != null && request.listeners != null) {
            int n7 = n3;
            int n8 = n2 - (n7 - n);
            int n9 = 0;
            int n10 = n7;
            while (n9 < n8) {
                object = new Integer(4);
                request.tileStatus.put(pointArray[n10++], object);
                ++n9;
            }
            object = new Request[]{request};
            int n11 = 0;
            int n12 = n7;
            while (n11 < n8) {
                Point point = pointArray[n12++];
                Iterator iterator = request.listeners.iterator();
                while (iterator.hasNext()) {
                    TileComputationListener tileComputationListener = (TileComputationListener)iterator.next();
                    tileComputationListener.tileComputationFailure(this, (TileRequest[])object, planarImage, point.x, point.y, exception);
                }
                ++n11;
            }
        }
        return exception;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Raster scheduleTile(OpImage opImage, int n, int n2) {
        if (opImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler1"));
        }
        Raster raster = null;
        Long l = SunTileScheduler.tileKey(opImage, n, n2);
        boolean bl = false;
        Object[] objectArray = null;
        Map map = this.tilesInProgress;
        // MONITORENTER : map
        bl = !this.tilesInProgress.containsKey(l);
        if (bl) {
            objectArray = new Object[1];
            this.tilesInProgress.put(l, objectArray);
        } else {
            objectArray = (Object[])this.tilesInProgress.get(l);
        }
        // MONITOREXIT : map
        if (bl) {
            try {
                try {
                    raster = opImage.computeTile(n, n2);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (!(throwable instanceof RuntimeException)) throw new RuntimeException(throwable.getMessage() + "\n" + SunTileScheduler.getStackTraceString(throwable));
                    throw (RuntimeException)throwable;
                }
                Object var11_9 = null;
                Object[] objectArray2 = objectArray;
                // MONITORENTER : objectArray2
                objectArray[0] = raster != null ? raster : new Object();
                objectArray.notifyAll();
                Map map2 = this.tilesInProgress;
                // MONITORENTER : map2
                this.tilesInProgress.remove(l);
                // MONITOREXIT : map2
                // MONITOREXIT : objectArray2
                return raster;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                Object[] objectArray3 = objectArray;
                // MONITORENTER : objectArray3
                objectArray[0] = raster != null ? raster : new Object();
                objectArray.notifyAll();
                Map map3 = this.tilesInProgress;
                // MONITORENTER : map3
                this.tilesInProgress.remove(l);
                // MONITOREXIT : map3
                // MONITOREXIT : objectArray3
                throw throwable;
            }
        }
        Object[] objectArray4 = objectArray;
        // MONITORENTER : objectArray4
        if (objectArray[0] == null) {
            try {
                objectArray.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (objectArray[0] instanceof Raster) {
            raster = (Raster)objectArray[0];
        }
        // MONITOREXIT : objectArray4
        return raster;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object scheduleJob(PlanarImage var1_1, Point[] var2_2, boolean var3_3, boolean var4_4, TileComputationListener[] var5_5) {
        block25: {
            if (var1_1 == null) throw new IllegalArgumentException();
            if (var2_2 == null) {
                throw new IllegalArgumentException();
            }
            if ((var3_3 || var4_4) && var5_5 != null) {
                throw new IllegalArgumentException();
            }
            if (var3_3 && var4_4) {
                throw new IllegalArgumentException();
            }
            var6_6 = var2_2.length;
            var8_8 /* !! */  = var7_7 = new Raster[var6_6];
            var9_9 = 0;
            var10_10 = null;
            var11_11 = 0;
            var12_12 = this.getWorkers(var4_4);
            synchronized (var12_12) {
                block23: {
                    block24: {
                        var9_9 = this.getNumThreads(var4_4);
                        if (var9_9 <= 0) break block23;
                        if (var6_6 > var9_9 && (var3_3 || var4_4)) break block24;
                        var10_10 = new Job[var6_6];
                        if (var3_3 || var4_4) ** GOTO lbl56
                        var13_13 = new Request(this, var1_1, var2_2, var5_5);
                        var8_8 /* !! */  = var13_13;
                        if (true) ** GOTO lbl52
                    }
                    var13_14 = 1.0f / (2.0f * (float)var9_9);
                    var14_16 = var9_9 == 1 ? var6_6 : Math.min(Math.max(1, (int)(var13_14 * (float)var6_6 / 2.0f + 0.5f)), var6_6);
                    var15_19 = var9_9 == 1 ? 1 : (int)((float)var6_6 / (float)var14_16 + 0.5f);
                    var10_10 = new TileJob[var15_19];
                    var16_21 = 0;
                    var17_24 = var6_6 - var16_21;
                    if (true) ** GOTO lbl69
                    do {
                        var14_15 /* !! */  = var2_2[var11_11];
                        var15_18 = SunTileScheduler.tileKey(var1_1, var14_15 /* !! */ .x, var14_15 /* !! */ .y);
                        var16_20 = this.tileRequests;
                        synchronized (var16_20) {
                            var17_23 = null;
                            if (this.tileRequests.containsKey(var15_18)) {
                                var17_23 = (List)this.tileRequests.get(var15_18);
                                var17_23.add(var13_13);
                                --var6_6;
                            } else {
                                var17_23 = new ArrayList<Object>();
                                var17_23.add(var13_13);
                                this.tileRequests.put(var15_18, var17_23);
                                var10_10[var11_11] = new RequestJob(this, var1_1, var14_15 /* !! */ .x, var14_15 /* !! */ .y, var7_7, var11_11);
                                this.tileJobs.put(var15_18, var10_10[var11_11]);
                                this.addJob(var10_10[var11_11++], false);
                            }
                        }
lbl52:
                        // 3 sources

                    } while (var11_11 < var6_6);
                    break block23;
lbl-1000:
                    // 1 sources

                    {
                        var10_10[var11_11] = new TileJob(this, var3_3, var1_1, var2_2, var7_7, var11_11, 1);
                        this.addJob(var10_10[var11_11++], var4_4);
lbl56:
                        // 2 sources

                        ** while (var11_11 < var6_6)
                    }
lbl57:
                    // 1 sources

                    break block23;
                    do {
                        if ((var18_26 = (int)(var13_14 * (float)var17_24 + 0.5f)) < var14_16) {
                            var18_26 = var14_16;
                        }
                        if (var18_26 > var17_24) {
                            var18_26 = var17_24;
                        }
                        if ((var17_24 -= var18_26) < var14_16) {
                            var18_26 += var17_24;
                            var17_24 = 0;
                        }
                        var10_10[var11_11] = new TileJob(this, var3_3, var1_1, var2_2, var7_7, var16_21, var18_26);
                        this.addJob(var10_10[var11_11++], var4_4);
                        var16_21 += var18_26;
lbl69:
                        // 2 sources

                    } while (var17_24 > 0);
                }
                if (var9_9 == 0) break block25;
            }
            if (var3_3 == false) return var8_8 /* !! */ ;
            var13_13 = this.getQueue(var4_4);
            var14_17 = 0;
            if (true) ** GOTO lbl97
        }
        var13_13 = null;
        if (!var3_3 && !var4_4) {
            var13_13 = new Request(this, var1_1, var2_2, var5_5);
            var8_8 /* !! */  = var13_13;
        }
        if ((var14_15 /* !! */  = this.compute(var1_1, var2_2, var7_7, 0, var6_6, (Request)var13_13)) == null) return var8_8 /* !! */ ;
        throw new RuntimeException(var14_15 /* !! */ .getMessage() + "\n" + SunTileScheduler.getStackTraceString(var14_15 /* !! */ ));
        do {
            var15_18 = this;
            synchronized (var15_18) {
                while (var10_10[var14_17].notDone()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var16_22) {
                        // empty catch block
                    }
                }
            }
            var16_20 = var10_10[var14_17].getException();
            if (var16_20 != null) {
                throw new RuntimeException(var16_20.getMessage() + "\n" + SunTileScheduler.getStackTraceString((Throwable)var16_20));
            }
            ++var14_17;
lbl97:
            // 2 sources

        } while (var14_17 < var11_11);
        return var8_8 /* !! */ ;
    }

    public Raster[] scheduleTiles(OpImage opImage, Point[] pointArray) {
        if (opImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler0"));
        }
        return (Raster[])this.scheduleJob(opImage, pointArray, true, false, null);
    }

    public TileRequest scheduleTiles(PlanarImage planarImage, Point[] pointArray, TileComputationListener[] tileComputationListenerArray) {
        if (planarImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler4"));
        }
        return (TileRequest)this.scheduleJob(planarImage, pointArray, false, false, tileComputationListenerArray);
    }

    public void cancelTiles(TileRequest tileRequest, Point[] pointArray) {
        if (tileRequest == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler3"));
        }
        Request request = (Request)tileRequest;
        Map map = this.tileRequests;
        synchronized (map) {
            Point[] pointArray2;
            List list = request.indices;
            if (pointArray != null && pointArray.length > 0) {
                List<Point> list2 = Arrays.asList(pointArray);
                list2.retainAll(list);
                pointArray2 = list2.toArray(new Point[0]);
            } else {
                pointArray2 = list.toArray(new Point[0]);
            }
            int n = pointArray2.length;
            Integer n2 = new Integer(3);
            int n3 = 0;
            while (n3 < n) {
                Point point = pointArray2[n3];
                Long l = SunTileScheduler.tileKey(request.image, point.x, point.y);
                List list3 = (List)this.tileRequests.get(l);
                if (list3 != null) {
                    Object object;
                    TileRequest[] tileRequestArray;
                    list3.remove(request);
                    if (list3.isEmpty()) {
                        tileRequestArray = this.queue;
                        synchronized (tileRequestArray) {
                            object = this.tileJobs.remove(l);
                            if (object != null) {
                                this.queue.remove(object);
                            }
                        }
                        this.tileRequests.remove(l);
                    }
                    request.tileStatus.put(point, n2);
                    if (request.listeners != null) {
                        tileRequestArray = new TileRequest[]{request};
                        object = request.listeners.iterator();
                        while (object.hasNext()) {
                            TileComputationListener tileComputationListener = (TileComputationListener)object.next();
                            tileComputationListener.tileCancelled(this, tileRequestArray, request.image, point.x, point.y);
                        }
                    }
                }
                ++n3;
            }
        }
    }

    public void prefetchTiles(PlanarImage planarImage, Point[] pointArray) {
        if (planarImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler0"));
        }
        this.scheduleJob(planarImage, pointArray, false, true, null);
    }

    public void setParallelism(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler2"));
        }
        this.parallelism = n;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setPrefetchParallelism(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler0"));
        }
        this.prefetchParallelism = n;
    }

    public int getPrefetchParallelism() {
        return this.prefetchParallelism;
    }

    public void setPriority(int n) {
        this.priority = Math.max(Math.min(n, 10), 1);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPrefetchPriority(int n) {
        this.prefetchPriority = Math.max(Math.min(n, 10), 1);
    }

    public int getPrefetchPriority() {
        return this.prefetchPriority;
    }

    /*
     * Unable to fully structure code
     */
    private int getNumThreads(boolean var1_1) {
        block8: {
            var2_2 = this.getWorkers(var1_1);
            if (var1_1) {
                var3_3 = this.numPrefetchThreads;
                var4_4 = this.prefetchParallelism;
                var5_5 = this.prefetchPriority;
            } else {
                var3_3 = this.numWorkerThreads;
                var4_4 = this.parallelism;
                var5_5 = this.priority;
            }
            if (var3_3 > 0 && ((Thread)var2_2.get(0)).getPriority() != var5_5) {
                var6_6 = var2_2.size();
                var7_8 = 0;
                while (var7_8 < var6_6) {
                    var8_9 = (Thread)var2_2.get(var7_8);
                    var8_9.setPriority(var5_5);
                    ++var7_8;
                }
            }
            if (var3_3 >= var4_4) ** GOTO lbl29
            while (var3_3 < var4_4) {
                var6_7 = new WorkerThread(this, var1_1);
                var6_7.setPriority(var5_5);
                var2_2.add(var6_7);
                ++var3_3;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                this.addJob(WorkerThread.TERMINATE, var1_1);
                --var3_3;
lbl29:
                // 2 sources

                ** while (var3_3 > var4_4)
            }
        }
        if (var1_1) {
            this.numPrefetchThreads = var3_3;
        } else {
            this.numWorkerThreads = var3_3;
        }
        return var3_3;
    }

    Vector getWorkers(boolean bl) {
        return bl ? this.workers : this.prefetchWorkers;
    }

    LinkedList getQueue(boolean bl) {
        return bl ? this.prefetchQueue : this.queue;
    }

    private void addJob(Object object, boolean bl) {
        LinkedList linkedList;
        if (object == null || object != WorkerThread.TERMINATE && !(object instanceof Job)) {
            throw new IllegalArgumentException();
        }
        LinkedList linkedList2 = linkedList = this.getQueue(bl);
        synchronized (linkedList2) {
            if (bl || linkedList.isEmpty() || object instanceof RequestJob) {
                linkedList.addLast(object);
            } else {
                boolean bl2 = false;
                int n = linkedList.size() - 1;
                while (n >= 0) {
                    if (linkedList.get(n) instanceof TileJob) {
                        linkedList.add(n + 1, object);
                        bl2 = true;
                        break;
                    }
                    --n;
                }
                if (!bl2) {
                    linkedList.addFirst(object);
                }
            }
            linkedList.notify();
        }
    }

    protected void finalize() throws Throwable {
        this.terminateAll(false);
        this.terminateAll(true);
        super.finalize();
    }

    private void terminateAll(boolean bl) {
        Vector vector = this.getWorkers(bl);
        synchronized (vector) {
            int n = bl ? this.numPrefetchThreads : this.numWorkerThreads;
            int n2 = 0;
            while (n2 < n) {
                this.addJob(WorkerThread.TERMINATE, bl);
                if (bl) {
                    --this.numPrefetchThreads;
                } else {
                    --this.numWorkerThreads;
                }
                ++n2;
            }
        }
    }
}

