/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.lang.ref.WeakReference;
import javax.media.jai.CachedTile;

final class SunCachedTile
implements CachedTile {
    Raster tile;
    WeakReference owner;
    int tileX;
    int tileY;
    Object tileCacheMetric;
    long timeStamp;
    Long key;
    long memorySize;
    SunCachedTile previous;
    SunCachedTile next;
    int action = 0;

    SunCachedTile(RenderedImage renderedImage, int n, int n2, Raster raster, Object object) {
        this.owner = new WeakReference<RenderedImage>(renderedImage);
        this.tile = raster;
        this.tileX = n;
        this.tileY = n2;
        this.tileCacheMetric = object;
        this.key = SunCachedTile.hashKey(renderedImage, n, n2);
        DataBuffer dataBuffer = raster.getDataBuffer();
        this.memorySize = (long)DataBuffer.getDataTypeSize(dataBuffer.getDataType()) / 8L * (long)dataBuffer.getSize() * (long)dataBuffer.getNumBanks();
    }

    static Long hashKey(RenderedImage renderedImage, int n, int n2) {
        long l = n2 * renderedImage.getNumXTiles() + n;
        return new Long((long)renderedImage.hashCode() << 32 | (l &= 0xFFFFFFFFL));
    }

    static Long hashKey(int n, int n2) {
        long l = n2;
        return new Long((long)n << 32 | (l &= 0xFFFFFFFFL));
    }

    static long getOwnerHashCode(Long l) {
        return l >>> 32;
    }

    public String toString() {
        RenderedImage renderedImage = this.getOwner();
        String string = renderedImage == null ? "null" : renderedImage.toString();
        Raster raster = this.getTile();
        String string2 = raster == null ? "null" : raster.toString();
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": owner = " + string + " tileX = " + Integer.toString(this.tileX) + " tileY = " + Integer.toString(this.tileY) + " tile = " + string2 + " key = " + Long.toHexString(this.key) + " memorySize = " + Long.toString(this.memorySize) + " timeStamp = " + Long.toString(this.timeStamp);
    }

    public Raster getTile() {
        return this.tile;
    }

    public RenderedImage getOwner() {
        return (RenderedImage)this.owner.get();
    }

    public long getTileTimeStamp() {
        return this.timeStamp;
    }

    public Object getTileCacheMetric() {
        return this.tileCacheMetric;
    }

    public long getTileSize() {
        return this.memorySize;
    }

    public int getAction() {
        return this.action;
    }
}

