/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.runtime.Hashtable;
import org.apache.xalan.xsltc.runtime.output.StreamOutput;

public class StreamHTMLOutput
extends StreamOutput {
    private static final String HREF_STR = "href";
    private static final String CITE_STR = "cite";
    private static final String SRC_STR = "src";
    private static final Hashtable _emptyElements = new Hashtable();
    private static final String[] tags = new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};
    private boolean _headTagOpen = false;
    private boolean _inStyleScript = false;
    private String _mediaType = "text/html";

    public StreamHTMLOutput(StreamOutput output) {
        super(output);
        this.setIndent(true);
    }

    public StreamHTMLOutput(Writer writer, String encoding) {
        super(writer, encoding);
        this.setIndent(true);
    }

    public StreamHTMLOutput(OutputStream out, String encoding) throws IOException {
        super(out, encoding);
        this.setIndent(true);
    }

    public void startDocument() throws TransletException {
    }

    public void endDocument() throws TransletException {
        this.outputBuffer();
    }

    public void startElement(String elementName) throws TransletException {
        if (this._startTagOpen) {
            this.closeStartTag();
        }
        if (this._firstElement) {
            if (this._doctypeSystem != null || this._doctypePublic != null) {
                this.appendDTD(elementName);
            }
            this._firstElement = false;
        }
        if (this._indent) {
            if (!_emptyElements.containsKey(elementName.toLowerCase())) {
                this.indent(this._lineFeedNextStartTag);
                this._lineFeedNextStartTag = true;
                this._indentNextEndTag = false;
            }
            ++this._indentLevel;
        }
        this._buffer.append('<').append(elementName);
        this._startTagOpen = true;
        this._indentNextEndTag = false;
        if (elementName.equalsIgnoreCase("head")) {
            this._headTagOpen = true;
        } else if (elementName.equalsIgnoreCase("style") || elementName.equalsIgnoreCase("script")) {
            this._inStyleScript = true;
        }
    }

    public void endElement(String elementName) throws TransletException {
        if (this._inStyleScript && (elementName.equalsIgnoreCase("style") || elementName.equalsIgnoreCase("script"))) {
            this._inStyleScript = false;
        }
        if (this._startTagOpen) {
            this.appendAttributes();
            if (_emptyElements.containsKey(elementName.toLowerCase())) {
                this._buffer.append('>');
            } else {
                this.closeStartTag();
                this._buffer.append("</").append(elementName).append('>');
            }
            this._startTagOpen = false;
            if (this._indent) {
                --this._indentLevel;
                this._indentNextEndTag = true;
            }
        } else {
            if (this._indent) {
                --this._indentLevel;
                if (this._indentNextEndTag) {
                    this.indent(this._indentNextEndTag);
                    this._indentNextEndTag = true;
                    this._lineFeedNextStartTag = true;
                }
            }
            this._buffer.append("</").append(elementName).append('>');
            this._indentNextEndTag = true;
        }
    }

    public void characters(String characters) throws TransletException {
        if (this._startTagOpen) {
            this.closeStartTag();
        }
        if (this._escaping && !this._inStyleScript) {
            this.escapeCharacters(characters.toCharArray(), 0, characters.length());
        } else {
            this._buffer.append(characters);
        }
    }

    public void characters(char[] characters, int offset, int length) throws TransletException {
        if (this._startTagOpen) {
            this.closeStartTag();
        }
        if (this._escaping && !this._inStyleScript) {
            this.escapeCharacters(characters, offset, length);
        } else {
            this._buffer.append(characters, offset, length);
        }
    }

    public void attribute(String name, String value) throws TransletException {
        if (this._startTagOpen) {
            StreamOutput.Attribute attr = name.equalsIgnoreCase(HREF_STR) || name.equalsIgnoreCase(SRC_STR) || name.equals(CITE_STR) ? new StreamOutput.Attribute(name, this.escapeURL(value)) : new StreamOutput.Attribute(name, this.escapeNonURL(value));
            int k = this._attributes.indexOf(attr);
            if (k >= 0) {
                this._attributes.setElementAt(attr, k);
            } else {
                this._attributes.add(attr);
            }
        }
    }

    public void comment(String comment) throws TransletException {
        if (this._startTagOpen) {
            this.closeStartTag();
        }
        this.appendComment(comment);
    }

    public void processingInstruction(String target, String data) throws TransletException {
        if (this._startTagOpen) {
            this.closeStartTag();
        }
        if (this._firstElement) {
            if (this._doctypeSystem != null || this._doctypePublic != null) {
                this.appendDTD("html");
            }
            this._firstElement = false;
        }
        this._buffer.append("<?").append(target).append(' ').append(data).append('>');
    }

    public boolean setEscaping(boolean escape) throws TransletException {
        boolean temp = this._escaping;
        this._escaping = escape;
        return temp;
    }

    public void close() {
        try {
            this._writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void namespace(String prefix, String uri) throws TransletException {
    }

    public void setCdataElements(Hashtable elements) {
    }

    public void setType(int type) {
    }

    public void setMediaType(String mediaType) {
        this._mediaType = mediaType;
    }

    private String escapeNonURL(String base) {
        int length = base.length();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < length) {
            char ch = base.charAt(i);
            if (ch >= '\u007f' && ch < '\u00a0' || this._is8859Encoded && ch > '\u00ff') {
                result.append("&#").append(Integer.toString(ch)).append(';');
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    private String escapeURL(String base) {
        char[] chs = base.toCharArray();
        StringBuffer result = new StringBuffer();
        int length = chs.length;
        int i = 0;
        while (i < length) {
            char ch = chs[i];
            if (ch <= ' ') {
                result.append('%').append(this.makeHHString(ch));
            } else if (ch > '\u007f') {
                result.append('%').append(this.makeHHString(ch >> 6 | 0xC0)).append('%').append(this.makeHHString(ch & 0x3F | 0x80));
            } else {
                switch (ch) {
                    case '\t': 
                    case ' ': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': 
                    case '\u007f': {
                        result.append('%').append(Integer.toHexString(ch));
                        break;
                    }
                    case '\"': {
                        result.append("%22");
                        break;
                    }
                    default: {
                        result.append(ch);
                    }
                }
            }
            ++i;
        }
        return result.toString();
    }

    private String makeHHString(int i) {
        String s = Integer.toHexString(i).toUpperCase();
        return s.length() == 1 ? "0" + s : s;
    }

    private void appendHeader() {
        this._buffer.append("<meta http-equiv=\"Content-Type\" content=\"").append(this._mediaType).append("; charset=").append(this._encoding).append("\">");
    }

    protected void closeStartTag() throws TransletException {
        super.closeStartTag();
        if (this._headTagOpen) {
            this.appendHeader();
            this._headTagOpen = false;
        }
    }

    protected void escapeCharacters(char[] ch, int off, int len) {
        int limit = off + len;
        int offset = off;
        if (limit > ch.length) {
            limit = ch.length;
        }
        int i = off;
        while (i < limit) {
            char current = ch[i];
            switch (current) {
                case '&': {
                    this._buffer.append(ch, offset, i - offset).append("&amp;");
                    offset = i + 1;
                    break;
                }
                case '<': {
                    this._buffer.append(ch, offset, i - offset).append("&lt;");
                    offset = i + 1;
                    break;
                }
                case '>': {
                    this._buffer.append(ch, offset, i - offset).append("&gt;");
                    offset = i + 1;
                    break;
                }
                case '\u00a0': {
                    this._buffer.append(ch, offset, i - offset).append("&nbsp;");
                    offset = i + 1;
                    break;
                }
                default: {
                    if ((current < '\u007f' || current >= '\u00a0') && (!this._is8859Encoded || current <= '\u00ff')) break;
                    this._buffer.append(ch, offset, i - offset).append("&#").append(Integer.toString(ch[i])).append(';');
                    offset = i + 1;
                }
            }
            ++i;
        }
        if (offset < limit) {
            this._buffer.append(ch, offset, limit - offset);
        }
    }

    static {
        int i = 0;
        while (i < tags.length) {
            _emptyElements.put(tags[i], "");
            ++i;
        }
    }
}

