/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.FilePathField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import queryAnalyzer.DbaFileFilter;
import queryAnalyzer.HelpButton;
import queryAnalyzer.QueryFrame;

public class SaveCommandDlg
extends JDialog {
    private DBAResourceBundle res = new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    private Object[] encObj = new Object[]{"Default", "UnicodeLittle", "UnicodeBig"};
    private SteppedComboBox encBox = new SteppedComboBox(this.encObj);
    private FilePathField outputFile = null;
    private File output = null;

    public SaveCommandDlg(Frame frame, boolean model) {
        super(frame, "", true);
        this.jbInit();
        this.pack();
        this.setResizable(false);
        GuiUt.setCenterLocation(QueryFrame.frame, this);
        this.show();
    }

    public void jbInit() {
        this.setTitle(this.res.getString("Save_Command"));
        HelpButton helpButton = new HelpButton(new Dimension(130, 20));
        JPanel containPane = new JPanel(new BorderLayout(4, 4));
        JLabel label1 = new JLabel(this.res.getString("save_command_to"));
        JLabel label2 = new JLabel(this.res.getString("Choose_encoding_method"));
        label1.setPreferredSize(new Dimension(200, 20));
        label2.setPreferredSize(new Dimension(200, 20));
        this.encBox.setPreferredSize(new Dimension(200, 25));
        this.encBox.setBorder(BorderFactory.createLoweredBevelBorder());
        DbaFileFilter filter = new DbaFileFilter("txt");
        this.outputFile = new FilePathField((Component)this, System.getProperty("user.dir"), this.res.getString("save_as"), false, false, filter);
        this.outputFile.setPreferredSize(new Dimension(250, 25));
        this.outputFile.setBorder(BorderFactory.createLoweredBevelBorder());
        DbaButton okButton = new DbaButton(new Dimension(130, 20), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbaut/dbautimages/ok.gif"), new ReflectionAction(this, "okButton_actionPerformed"));
        DbaButton cancelButton = new DbaButton(new Dimension(130, 20), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbaut/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButton_actionPerformed"));
        JPanel buttonPane = new JPanel(new FlowLayout(1, 5, 20));
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        buttonPane.add(helpButton);
        JPanel centerPane = new JPanel(new GridLayout(2, 1, 5, 10));
        JPanel pane1 = new JPanel(new FlowLayout(0, 5, 0));
        pane1.add(label1);
        pane1.add(this.outputFile);
        JPanel pane2 = new JPanel(new FlowLayout(0, 5, 0));
        pane2.add(label2);
        pane2.add(this.encBox);
        centerPane.add(pane1);
        centerPane.add(pane2);
        containPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        containPane.add((Component)centerPane, "Center");
        containPane.add((Component)buttonPane, "South");
        this.getContentPane().add(containPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent l) {
                SaveCommandDlg.this.cancelButton_actionPerformed(null);
            }
        });
        QueryFrame.frame.enableDialogHelp(this.getRootPane(), helpButton, "SaveCommandDlg", null);
    }

    public void okButton_actionPerformed(ActionEvent e) {
        if (this.outputFile.getText().trim().length() <= 0) {
            GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("Please_specify_an_output_file_name"));
            return;
        }
        String filterName = this.outputFile.getFileFilter();
        String s = QueryFrame.frame.getSqlText();
        File file = new File(this.outputFile.getText());
        String enc = this.encBox.getSelectedItem().toString();
        if (filterName != null && filterName.equalsIgnoreCase("*.txt") && file.getPath().indexOf(".") < 0) {
            file = new File(file.getPath() + ".txt");
        }
        String fileName = null;
        String parentPath = null;
        String path = null;
        File tempFile = null;
        try {
            QueryFrame.frame.setMessageField(this.res.getString("Save_Command"));
            if (file.exists()) {
                fileName = file.getName();
                parentPath = file.getParent();
                path = file.getPath();
                if (!file.canWrite()) {
                    String s1 = this.res.getString("file_cannot_be_written");
                    String s2 = GuiUt.mapStringForProperty(s1, file.toString());
                    GuiUt.showWarningDlg(this, this.res.getString("Warning"), s2);
                    return;
                }
                String s1 = this.res.getString("file_cannot_is_existed");
                String s2 = GuiUt.mapStringForProperty(s1, file.toString());
                int answer = GuiUt.showOptionDlg(this, this.res.getString("Warning"), s2);
                if (answer == 0) {
                    tempFile = new File(parentPath + QueryFrame.frame.file_separator + "temptemp111222temptemp.txt");
                    file.renameTo(tempFile);
                } else {
                    return;
                }
            }
            if (!file.createNewFile()) {
                GuiUt.showErrorDlg(this, this.res.getString("Save_file_fail"), "");
                tempFile.renameTo(file);
                tempFile.delete();
                return;
            }
            OutputStreamWriter writer = null;
            writer = !enc.equalsIgnoreCase("DEFAULT") ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), enc) : new OutputStreamWriter(new FileOutputStream(file));
            writer.write(s);
            writer.flush();
            writer.close();
            GuiUt.showInformationDlg(this, this.res.getString("Save_file_successful"));
        }
        catch (IOException ee) {
            QueryFrame.frame.setMessageField(this.res.getString("Save_Fail"));
            GuiUt.showWarningDlg(this, this.res.getString("Warning"), ee.getMessage());
            return;
        }
        this.dispose();
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

