/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.alarm.Alarm2;
import dbaut.alarm.Sleeper;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.editorPanel.SQLTextPane;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.resource.HelpResourceBundle;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import preferences.PreferencesXml;
import queryAnalyzer.AsJsql;
import queryAnalyzer.AsOutputStream;
import queryAnalyzer.AsQueryPane;
import queryAnalyzer.AsQueryPaneInterface;
import queryAnalyzer.AsSQLResultPane;
import queryAnalyzer.AsTableModel;
import queryAnalyzer.DatabaseConnection;
import queryAnalyzer.QueryMenuBar;
import queryAnalyzer.QueryToolBar;
import queryAnalyzer.TabbedPanePopupMenu;
import queryAnalyzer.TableToolBar;
import sqlparser.SQLParser;
import tableCell.BlobEditor;
import tableCell.BlobEditorButton;
import tableCell.BlobEditorButtonInterface;
import tableCell.BlobEditorNoJAIButton;

public class QueryFrame
extends JFrame
implements Sleeper {
    static DBAResourceBundle res = new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    public static QueryFrame frame = null;
    private JSplitPane containPane = new JSplitPane(0);
    private TabbedPanePopupMenu popupMenu = null;
    public PreferencesXml px = PreferencesXml.getPreferencesXml();
    public boolean isWindows = true;
    public JTabbedPane tabbedPane = null;
    public SQLTextPane sqlTextArea = null;
    public SteppedComboBox historyComboBox = new SteppedComboBox();
    public static HelpResourceBundle helpres = null;
    private JLabel messageLabel = new JLabel();
    private JLabel dbLabel = new JLabel();
    private JLabel queryTimeLabel = new JLabel();
    private JLabel rowPositionLabel = new JLabel();
    private JLabel systemTimeLabel = new JLabel();
    private JTextArea nonQueryTextArea = new JTextArea();
    private String helpsetName = "JSQL.hs";
    public QueryMenuBar menubar = new QueryMenuBar();
    public TableToolBar tableToolBar = null;
    public QueryToolBar queryToolbar = new QueryToolBar();
    private boolean[] buttonStatus = new boolean[]{false, false, false, false, false};
    static AsJsql asJSql = null;
    public SQLParser parser = null;
    private Cursor wait_cursor = new Cursor(3);
    private Cursor defCursor = new Cursor(0);
    public HelpSet mainHS = null;
    public DefaultHelpBroker mainHB = null;
    public Point centerLocation = null;
    public DatabaseConnection conn = null;
    public boolean isConnect = false;
    public boolean isLocalHost = true;
    public boolean isDBA = true;
    public boolean isResource = true;
    public String file_separator = System.getProperty("file.separator");
    Alarm2 alarm = new Alarm2();

    public QueryFrame() {
        frame = this;
        frame.setTitle("JSQL");
        this.setSize(new Dimension(640, 480));
        this.tableToolBar = new TableToolBar();
        this.alarm.setAlarm(this, 1L);
        this.setIconImage(DBAImageResource.getResource(this.getClass(), "/images/jsql.gif").getImage());
        JPanel upPane = new JPanel(new BorderLayout());
        JPanel downPane = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane(3);
        this.sqlTextArea = new SQLTextPane();
        JScrollPane sqlScrollPane = new JScrollPane(this.sqlTextArea);
        this.nonQueryTextArea.setEditable(false);
        AsSQLResultPane nonQueryScrollPane = new AsSQLResultPane(this.nonQueryTextArea, this.buttonStatus);
        sqlScrollPane.setPreferredSize(new Dimension(600, 100));
        this.tabbedPane.setPreferredSize(new Dimension(400, 300));
        this.tabbedPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.initHelpSet(true);
        JPanel infoPane = new JPanel(new FlowLayout(0, 1, 1));
        infoPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.messageLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.messageLabel.setPreferredSize(new Dimension(220, 18));
        this.dbLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.dbLabel.setPreferredSize(new Dimension(130, 18));
        this.queryTimeLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.queryTimeLabel.setPreferredSize(new Dimension(100, 18));
        this.rowPositionLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.rowPositionLabel.setPreferredSize(new Dimension(130, 18));
        this.systemTimeLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.systemTimeLabel.setPreferredSize(new Dimension(150, 18));
        infoPane.add(this.messageLabel);
        infoPane.add(this.dbLabel);
        infoPane.add(this.queryTimeLabel);
        infoPane.add(this.rowPositionLabel);
        infoPane.add(this.systemTimeLabel);
        this.queryToolbar.setOrientation(0);
        this.historyComboBox.setMaximumRowCount(10);
        this.historyComboBox.setBackground(Color.white);
        this.historyComboBox.setPreferredSize(new Dimension(250, 15));
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)this.queryToolbar, "West");
        toolbarPanel.add((Component)this.historyComboBox, "East");
        this.tabbedPane.add(res.getString("SQL_Result"), nonQueryScrollPane);
        upPane.add((Component)toolbarPanel, "North");
        upPane.add((Component)sqlScrollPane, "Center");
        downPane.add((Component)this.tabbedPane, "Center");
        downPane.add((Component)infoPane, "South");
        downPane.add((Component)this.tableToolBar, "East");
        this.containPane.add((Component)upPane, "top");
        this.containPane.add((Component)downPane, "bottom");
        if (this.px.getDividerLocation() != 0) {
            this.containPane.setDividerLocation(this.px.getDividerLocation());
        }
        this.setJMenuBar(this.menubar);
        this.setContentPane(this.containPane);
        this.isWindows = this.isWindows();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.exitApplication();
            }
        });
        this.historyComboBox.addActionListener(new ReflectionAction(this, "historyComboBox_actionPerformed"));
        this.sqlTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    QueryFrame.this.sqlTextPane_keyRelease(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                QueryFrame.this.sqlTextPane_keyRelease(e);
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                QueryFrame.this.tabbedPane.getSelectedComponent().requestFocus();
                Component focusComp = QueryFrame.this.tabbedPane.getSelectedComponent();
                if (me.getModifiers() == 4) {
                    Point p = me.getPoint();
                    int count = QueryFrame.this.tabbedPane.getTabCount();
                    QueryFrame.this.popupMenu = new TabbedPanePopupMenu(p, count, focusComp);
                }
                if (me.getModifiers() == 16 && QueryFrame.this.popupMenu != null) {
                    QueryFrame.this.popupMenu.setVisible(false);
                    QueryFrame.this.popupMenu = null;
                }
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                QueryFrame.this.tabbed_actionPerformed(e);
            }
        });
        this.sqlTextArea.setFont(new Font("SansSerif", 0, 12));
        this.nonQueryTextArea.setFont(new Font("MonoSpaced", 0, 12));
    }

    public void enableHelpKey(Component comp, String id) {
        if (this.mainHB == null) {
            return;
        }
        this.mainHB.enableHelpKey(comp, id, null);
    }

    public void setHelpID(Component comp, String id) {
        if (this.mainHB == null || helpres == null) {
            return;
        }
        String mapped = helpres.getString(id);
        CSH.setHelpIDString((Component)comp, (String)mapped);
        this.setHelpMenuitem(mapped);
    }

    public void setHelpMenuitem(String id) {
        if (this.mainHB == null) {
            return;
        }
        this.mainHB.enableHelp((Component)this.menubar.helpMenuItem, id, null);
    }

    public void enableDialogHelp(Component comp, JButton button, String id, HelpSet hs) {
        if (this.mainHB == null) {
            return;
        }
        String helpid = helpres.getString(id);
        if (comp != null) {
            this.mainHB.enableHelpKey(comp, helpid, hs);
        }
        if (button != null) {
            this.mainHB.enableHelpOnButton((Component)button, helpid, hs);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            try {
                this.px.save();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            this.exitApplication();
        }
    }

    public void exitApplication() {
        try {
            int reply = GuiUt.showOptionDlg(this, res.getString("JSQL_Exit"), res.getString("Do_you_want_to_quit"));
            if (reply == 0) {
                this.px.save();
                this.menubar.disconnectItem_actionPerformed(null);
                this.setVisible(false);
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getHelpSetName() {
        String s = "JSQL.hs";
        switch (LocaleManager.getHelpFileLanguage()) {
            default: 
        }
        s = "JSQL.hs";
        return s;
    }

    private void initHelpSet(boolean first) {
        try {
            this.mainHS = null;
            this.mainHB = null;
            helpres = new HelpResourceBundle("jsqlproperties.help");
            ClassLoader cl = QueryFrame.class.getClassLoader();
            this.helpsetName = this.getHelpSetName();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)this.helpsetName);
            this.mainHS = new HelpSet(cl, url);
            this.mainHB = (DefaultHelpBroker)this.mainHS.createHelpBroker();
            this.mainHB.enableHelpKey((Component)this.getRootPane(), helpres.getString("home"), null);
        }
        catch (Exception ex) {
            System.out.println("Help Set " + this.helpsetName + res.getString("not_found"));
            ex.printStackTrace();
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println(res.getString("initialization_error_"));
            ex.getException().printStackTrace();
        }
        if (this.menubar != null) {
            this.menubar.helpMenuItem.setEnabled(true);
            this.menubar.helpMenuItem.setEnabled(true);
            if (first) {
                this.menubar.setHelpButton(true);
            } else {
                this.menubar.setHelpButton(false);
            }
        }
    }

    public int getDividerLocation() {
        return this.containPane.getDividerLocation();
    }

    public void ExecuteCommand() {
        this.mySetCursor(true);
        String s = this.sqlTextArea.getText().trim();
        if (s.length() == 0) {
            GuiUt.showErrorDlg(frame, res.getString("No_SQL_command_"), "");
            this.mySetCursor(false);
            return;
        }
        this.clearResultPane();
        this.messageLabel.setText(res.getString("In_Process"));
        String sqlStatement = this.sqlTextArea.getText();
        if (sqlStatement.equalsIgnoreCase("")) {
            return;
        }
        try {
            this.nonQueryTextArea.setText("");
            ByteArrayInputStream in = new ByteArrayInputStream(sqlStatement.getBytes("UTF8"));
            asJSql = new AsJsql(new InputStreamReader((InputStream)in, "UTF8"), new AsOutputStream(this.nonQueryTextArea), "UTF8", this.conn.getDbConnection());
            if (this.parser == null) {
                this.parser = QueryFrame.asJSql.parser;
            }
            asJSql.displayTime(QueryFrame.asJSql.totalTime);
            this.convertHistory(QueryFrame.asJSql.queryVector);
            try {
                if (this.conn != null) {
                    if (!this.conn.getDbConnection().isClosed()) {
                        this.menubar.disconnectItem.setEnabled(true);
                        this.menubar.executeItem.setEnabled(true);
                        this.menubar.executeBatchItem.setEnabled(true);
                        this.menubar.saveItem.setEnabled(true);
                        this.menubar.loadItem.setEnabled(true);
                        this.queryToolbar.runCommandButton.setEnabled(true);
                        this.queryToolbar.loadCommandButton.setEnabled(true);
                        this.queryToolbar.saveCommandButton.setEnabled(true);
                        this.queryToolbar.clearCommandButton.setEnabled(true);
                        QueryFrame.frame.sqlTextArea.setEnabled(true);
                    } else {
                        this.menubar.disconnectItem.setEnabled(false);
                        this.menubar.executeItem.setEnabled(false);
                        this.menubar.executeBatchItem.setEnabled(false);
                        this.menubar.saveItem.setEnabled(false);
                        this.menubar.loadItem.setEnabled(false);
                        this.queryToolbar.runCommandButton.setEnabled(false);
                        this.queryToolbar.loadCommandButton.setEnabled(false);
                        this.queryToolbar.saveCommandButton.setEnabled(false);
                        this.queryToolbar.clearCommandButton.setEnabled(false);
                        QueryFrame.frame.sqlTextArea.setEnabled(false);
                        this.rowPositionLabel.setText("");
                        this.sqlTextArea.setText("");
                        this.nonQueryTextArea.setText("");
                        this.historyComboBox.removeAllItems();
                        this.queryTimeLabel.setText("");
                    }
                    this.messageLabel.setText(res.getString("Process_done"));
                } else {
                    this.messageLabel.setText(res.getString("No_connection"));
                    this.menubar.disconnectItem.setEnabled(false);
                    this.menubar.executeItem.setEnabled(false);
                    this.menubar.executeBatchItem.setEnabled(false);
                    this.menubar.saveItem.setEnabled(false);
                    this.menubar.loadItem.setEnabled(false);
                    this.queryToolbar.runCommandButton.setEnabled(false);
                    this.queryToolbar.loadCommandButton.setEnabled(false);
                    this.queryToolbar.saveCommandButton.setEnabled(false);
                    this.queryToolbar.clearCommandButton.setEnabled(false);
                    QueryFrame.frame.sqlTextArea.setEnabled(false);
                    this.sqlTextArea.setText("");
                    this.nonQueryTextArea.setText("");
                    this.historyComboBox.removeAllItems();
                    this.rowPositionLabel.setText("");
                    this.queryTimeLabel.setText("");
                }
                if (QueryFrame.frame.px.getDisplayTableModel() && this.conn != null) {
                    Vector queryStrVector = QueryFrame.asJSql.selectQueryVector;
                    Vector tableName = QueryFrame.asJSql.queryTableName;
                    Object rs = null;
                    Object stmt = null;
                    int size = queryStrVector.size();
                    for (int i = 0; i < size; ++i) {
                        this.ExecuteSql(queryStrVector.get(i).toString(), tableName.get(i).toString());
                        this.tabbedPane.setToolTipTextAt(i + 1, queryStrVector.get(i).toString());
                    }
                }
                this.tableToolBar.lastPageDbaButton.setEnabled(false);
                this.tableToolBar.pageDownDbaButton.setEnabled(false);
                this.tableToolBar.saveTableDbaButton.setEnabled(false);
            }
            catch (Exception e1) {
                this.mySetCursor(false);
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            this.mySetCursor(false);
            e.printStackTrace();
            this.messageLabel.setText(res.getString("Process_fail"));
        }
        this.mySetCursor(false);
        this.tabbedPane.setSelectedComponent(this.tabbedPane.getComponentAt(0));
    }

    private void ExecuteSql(String sqlStatement, String tableName) {
        ResultSet rsMax = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = this.conn.getDbConnection().createStatement(1004, 1007);
            if (stmt == null) {
                System.out.println("error, this is happened in jsql QueryFrame.java->ExecuteSal..");
                return;
            }
            int max = 0;
            if (tableName != null && tableName.length() > 0) {
                String[] tables = tableName.split(",");
                if (tables != null && tables.length > 0) {
                    long multiCounter = 0L;
                    for (int i = 0; i < tables.length; ++i) {
                        if (tables[i].length() <= 0) continue;
                        rsMax = stmt.executeQuery("SELECT COUNT(*) FROM " + tables[i]);
                        if (rsMax == null) {
                            System.out.println("error,rs is null,this is happend in jsql QueryFrame.java->ExecuteSql.");
                            return;
                        }
                        rsMax.next();
                        if (multiCounter == 0L) {
                            multiCounter = rsMax.getInt(1);
                        } else if (rsMax.getInt(1) > 0) {
                            multiCounter *= (long)rsMax.getInt(1);
                        }
                        rsMax.close();
                    }
                    max = multiCounter > Integer.MAX_VALUE || multiCounter < Integer.MIN_VALUE ? Integer.MAX_VALUE : (int)multiCounter;
                } else {
                    rsMax = stmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
                    if (rsMax == null) {
                        System.out.println("error,rs is null,this is happend in jsql QueryFrame.java->ExecuteSql.");
                        return;
                    }
                    rsMax.next();
                    max = rsMax.getInt(1);
                    rsMax.close();
                }
            }
            int start = 0;
            int jump = QueryFrame.frame.px.getNumRecord();
            int end = max < jump ? max : jump;
            int[] info = new int[]{start, end, max, jump, 0};
            boolean[] enable = new boolean[]{false, false, max > jump, max > jump, true};
            rs = stmt.executeQuery(sqlStatement + "limit " + start + ", " + (end - start));
            if (rs == null) {
                System.out.println("error,rs is null,this is happend in jsql QueryFrame.java->ExecuteSql.");
                return;
            }
            ResultSetMetaData meta = rs.getMetaData();
            ArrayList<String> nameRecord = new ArrayList<String>();
            ArrayList<String> dataTypeRecord = new ArrayList<String>();
            int numOfColumn = meta.getColumnCount();
            for (int i = 0; i < numOfColumn; ++i) {
                nameRecord.add(meta.getColumnName(i + 1));
                dataTypeRecord.add(meta.getColumnTypeName(i + 1));
            }
            rs.close();
            stmt.close();
            AsTableModel tableModel = new AsTableModel(nameRecord, dataTypeRecord);
            JTable resultTable = new JTable(tableModel);
            resultTable.setAutoResizeMode(0);
            AsQueryPane resultScrollPane = new AsQueryPane(this.conn, info, enable, sqlStatement, tableModel, resultTable, nameRecord, dataTypeRecord);
            this.tabbedPane.add(tableName, resultScrollPane);
            for (int col = 0; col < numOfColumn; ++col) {
                if (!this.isBlobType(dataTypeRecord.get(col).toString())) continue;
                this.setUpBlobEditor(resultTable, tableModel, col);
            }
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (SQLException e) {
            this.mySetCursor(false);
            DbaObject.close(rsMax);
            DbaObject.close(rs);
            DbaObject.close(stmt);
            e.printStackTrace();
        }
    }

    public void executeBatch(File batchFile, File resultFile, String encode) {
        this.mySetCursor(true);
        this.messageLabel.setText(res.getString("Running_batch_file"));
        try {
            FileInputStream in = new FileInputStream(batchFile);
            InputStreamReader reader = null;
            reader = encode != null ? new InputStreamReader((InputStream)in, encode) : new InputStreamReader(in);
            OutputStreamWriter writer = null;
            if (resultFile != null) {
                writer = encode != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(resultFile), encode) : new OutputStreamWriter(new FileOutputStream(resultFile));
            }
            this.nonQueryTextArea.setText("");
            asJSql = new AsJsql(reader, new AsOutputStream(this.nonQueryTextArea, writer), encode, this.conn.getDbConnection());
            if (this.parser == null) {
                this.parser = QueryFrame.asJSql.parser;
            }
            this.tabbedPane.setSelectedComponent(this.tabbedPane.getComponentAt(0));
            if (this.conn != null) {
                if (!this.conn.getDbConnection().isClosed()) {
                    this.menubar.disconnectItem.setEnabled(true);
                    this.menubar.executeItem.setEnabled(true);
                    this.menubar.executeBatchItem.setEnabled(true);
                    this.menubar.saveItem.setEnabled(true);
                    this.menubar.loadItem.setEnabled(true);
                    this.queryToolbar.runCommandButton.setEnabled(true);
                    this.queryToolbar.loadCommandButton.setEnabled(true);
                    this.queryToolbar.saveCommandButton.setEnabled(true);
                    this.queryToolbar.clearCommandButton.setEnabled(true);
                    QueryFrame.frame.sqlTextArea.setEnabled(true);
                } else {
                    this.menubar.disconnectItem.setEnabled(false);
                    this.menubar.executeItem.setEnabled(false);
                    this.menubar.executeBatchItem.setEnabled(false);
                    this.menubar.saveItem.setEnabled(false);
                    this.menubar.loadItem.setEnabled(false);
                    this.queryToolbar.runCommandButton.setEnabled(false);
                    this.queryToolbar.loadCommandButton.setEnabled(false);
                    this.queryToolbar.saveCommandButton.setEnabled(false);
                    this.queryToolbar.clearCommandButton.setEnabled(false);
                    QueryFrame.frame.sqlTextArea.setEnabled(false);
                }
            } else {
                this.menubar.disconnectItem.setEnabled(false);
                this.menubar.executeItem.setEnabled(false);
                this.menubar.executeBatchItem.setEnabled(false);
                this.menubar.saveItem.setEnabled(false);
                this.menubar.loadItem.setEnabled(false);
                this.queryToolbar.runCommandButton.setEnabled(false);
                this.queryToolbar.loadCommandButton.setEnabled(false);
                this.queryToolbar.saveCommandButton.setEnabled(false);
                this.queryToolbar.clearCommandButton.setEnabled(false);
                QueryFrame.frame.sqlTextArea.setEnabled(false);
            }
        }
        catch (SQLException e1) {
            this.mySetCursor(false);
            e1.printStackTrace();
        }
        catch (IOException e2) {
            this.mySetCursor(false);
            e2.printStackTrace();
        }
        this.mySetCursor(false);
    }

    public void historyComboBox_actionPerformed(ActionEvent e) {
        Object obj = this.historyComboBox.getSelectedItem();
        if (obj != null) {
            this.sqlTextArea.setText(obj.toString());
            if (obj.toString().trim().length() > 0) {
                this.historyComboBox.setToolTipText(this.historyComboBox.getSelectedItem().toString());
            } else {
                this.historyComboBox.setToolTipText(null);
            }
        }
    }

    public boolean isWindows() {
        String fileseparator = System.getProperty("file.separator");
        return fileseparator.equals("\\");
    }

    public void setUpBlobEditor(JTable table, AsTableModel tableModel, int index) {
        Class<?> jaicls = null;
        try {
            jaicls = Class.forName("javax.media.jai.widget.ScrollingImagePanel");
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.getMessage());
        }
        JButton field = jaicls == null ? new BlobEditorNoJAIButton() : new BlobEditorButton();
        BlobEditor editor = new BlobEditor((BlobEditorButtonInterface)((Object)field), table, tableModel);
        TableColumn column = table.getColumnModel().getColumn(index);
        column.setCellEditor(editor);
    }

    public boolean isBlobType(String type) {
        return type.equalsIgnoreCase("LONGVARBINARY") || type.equalsIgnoreCase("LONGVARCHAR") || type.equalsIgnoreCase("FILE") || type.equalsIgnoreCase("BLOB") || type.equalsIgnoreCase("CLOB") || type.equalsIgnoreCase("NCLOB") || type.equalsIgnoreCase("LONG VARBINARY") || type.equalsIgnoreCase("LONG VARCHAR");
    }

    public void convertHistory(Vector v) {
        String originalString = this.sqlTextArea.getText();
        int newSize = v.size();
        int hisSize = QueryFrame.frame.px.getNumHistoryCmd();
        int oriSize = this.historyComboBox.getItemCount();
        Vector temp = new Vector();
        if (newSize >= hisSize) {
            this.historyComboBox.removeAllItems();
            for (int i = newSize; i > newSize - hisSize; --i) {
                temp.add(v.get(i - 1));
            }
            this.historyComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel(temp));
        } else {
            int loseSize = hisSize - newSize;
            if (loseSize >= oriSize) {
                loseSize = oriSize;
            }
            for (int i = newSize; i > 0; --i) {
                temp.add(v.get(i - 1));
            }
            for (int j = 0; j < loseSize; ++j) {
                temp.add(this.historyComboBox.getItemAt(j));
            }
            this.historyComboBox.removeAllItems();
            this.historyComboBox.setModel((ComboBoxModel)new DefaultComboBoxModel(temp));
        }
        this.sqlTextArea.setText(originalString);
    }

    public void sqlTextPane_keyRelease(KeyEvent e) {
        if (this.sqlTextArea.getText().equalsIgnoreCase("")) {
            this.queryToolbar.clearCommandButton.setEnabled(false);
        } else if (e.getKeyCode() == 116) {
            this.ExecuteCommand();
        } else if (e.getKeyCode() == 115) {
            this.sqlTextArea.setText("");
            this.queryToolbar.clearCommandButton.setEnabled(false);
        } else {
            this.queryToolbar.clearCommandButton.setEnabled(true);
        }
    }

    public void tabbed_actionPerformed(ChangeEvent e) {
        Component comp = this.tabbedPane.getSelectedComponent();
        if (comp == null) {
            return;
        }
        AsQueryPaneInterface mycomp = (AsQueryPaneInterface)((Object)comp);
        mycomp.ButtonAction(null);
    }

    public AsQueryPane getSelectedQueryPanel() {
        AsQueryPaneInterface myPane = (AsQueryPaneInterface)((Object)this.tabbedPane.getSelectedComponent());
        if (myPane instanceof AsQueryPane) {
            return (AsQueryPane)myPane;
        }
        return null;
    }

    public void setMessageField(String info) {
        this.messageLabel.setText(info);
        this.messageLabel.setToolTipText(info);
    }

    public void setDBField(String dbInfo) {
        this.dbLabel.setText(dbInfo);
        this.dbLabel.setToolTipText(dbInfo);
    }

    public void setQueryTimeField(long time) {
        if (time >= 0L) {
            this.queryTimeLabel.setText(res.getString("Total_") + time + "ms");
            this.queryTimeLabel.setToolTipText(res.getString("Total_") + time + "ms");
        } else {
            this.queryTimeLabel.setText("");
            this.queryTimeLabel.setToolTipText("");
        }
    }

    public void setRowField(String row, int start, int end, int max) {
        if (max > 0) {
            this.rowPositionLabel.setToolTipText(res.getString("MAX_Row_") + max);
        } else {
            this.rowPositionLabel.setToolTipText("");
        }
        if (start != 0) {
            this.rowPositionLabel.setText("Row# :" + row + "(" + start + " - " + end + ")");
        } else {
            this.rowPositionLabel.setText("");
        }
    }

    public void clearQueryPane() {
        this.sqlTextArea.setText("");
    }

    public void clearNonQueryPane() {
        this.nonQueryTextArea.setText("");
    }

    public void clearButtonStatus(boolean enable) {
        this.queryToolbar.clearCommandButton.setEnabled(enable);
    }

    private void mySetCursor(boolean b) {
        if (b) {
            frame.setCursor(this.wait_cursor);
            this.sqlTextArea.setCursor(this.wait_cursor);
            this.nonQueryTextArea.setCursor(this.wait_cursor);
        } else {
            frame.setCursor(this.defCursor);
            this.sqlTextArea.setCursor(this.defCursor);
            this.nonQueryTextArea.setCursor(this.defCursor);
        }
    }

    public void clearResultPane() {
        if (this.tabbedPane.getTabCount() > 1) {
            AsQueryPane mypane = null;
            try {
                int count;
                for (int i = count = this.tabbedPane.getTabCount() - 1; i > 0; --i) {
                    mypane = (AsQueryPane)this.tabbedPane.getComponentAt(i);
                    mypane.closeResultSet();
                    this.tabbedPane.remove(i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clearATab() {
        this.tabbedPane.remove(this.tabbedPane.getSelectedIndex());
    }

    public void setToolbarStatus(boolean[] enable) {
        this.tableToolBar.firstPageDbaButton.setEnabled(enable[0]);
        this.tableToolBar.pageUpDbaButton.setEnabled(enable[1]);
        this.tableToolBar.lastPageDbaButton.setEnabled(enable[2]);
        this.tableToolBar.pageDownDbaButton.setEnabled(enable[3]);
        this.tableToolBar.saveTableDbaButton.setEnabled(enable[4]);
    }

    public void killHistory() {
        this.historyComboBox.removeAllItems();
    }

    public void askFocus() {
        this.sqlTextArea.requestFocus();
    }

    public String getSqlText() {
        return this.sqlTextArea.getText();
    }

    public Point getDefaultCenterLocation() {
        return this.centerLocation;
    }

    public void setDefaultCenterLocation(Point p) {
        this.centerLocation = p;
    }

    public void copyFile(File sFile, File dFile) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            dFile.createNewFile();
            in = new FileInputStream(sFile.getAbsolutePath());
            out = new FileOutputStream(dFile.getAbsolutePath());
            byte[] buff = new byte[1024];
            int read = in.read(buff);
            while (read >= 0) {
                out.write(buff, 0, read);
                read = in.read(buff);
            }
            in.close();
            out.close();
            sFile.delete();
            sFile.createNewFile();
        }
        catch (IOException ioe) {
            GuiUt.showErrorDlg(this, ioe.getMessage(), null);
        }
    }

    @Override
    public void wakeUp() {
        this.alarm.cancelAlarm(this);
        Date date = new Date(System.currentTimeMillis());
        DateFormat df = DateFormat.getDateTimeInstance(3, 2, LocaleManager.getLocale());
        this.systemTimeLabel.setText(df.format(date).toString());
        this.systemTimeLabel.paintComponents(this.systemTimeLabel.getGraphics());
        this.systemTimeLabel.revalidate();
        this.systemTimeLabel.repaint();
        this.alarm.setAlarm(this, 1L);
    }

    public void localeChanged(LocaleChangeEvent e) {
        res = e == null ? new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale()) : new DBAResourceBundle("resource.jsqltool", e.getLocale());
        this.menubar.localeChanged(e);
        this.tableToolBar.localeChanged(e);
        this.queryToolbar.localeChanged(e);
        this.tabbedPane.setTitleAt(0, res.getString("SQL_Result"));
        if (!this.isConnect) {
            this.setTitle("JSQL - " + res.getString("No_connection"));
            this.setMessageField(res.getString("No_connection"));
        } else {
            this.setMessageField(res.getString("Database_connected"));
        }
        this.validate();
    }
}

