/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbaut.GuiUt;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.util.JdbcUtil;
import dbmaker.sql.JdbcOdbcConnection;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Vector;
import queryAnalyzer.QueryFrame;
import queryAnalyzer.Stopwatch;
import sqlparser.JSQLParserHandler;
import sqlparser.SQLParser;

public class AsJsql
implements JSQLParserHandler {
    private DBAResourceBundle res = new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    public Vector queryVector = new Vector();
    public Vector selectQueryVector = new Vector();
    public Vector queryTableName = new Vector();
    final String dblogin = "jdbc:dbmaker:";
    final String driver = "dbmaker.sql.JdbcOdbcDriver";
    static String LINEFEED = null;
    static String SPACE = " ";
    static String TAB = "\t";
    private Reader in = null;
    private Writer out = null;
    private String encoding = null;
    private ResultSet resultSet = null;
    public SQLParser parser = null;
    public Connection dbconn = null;
    public Stopwatch watch = null;
    public long totalTime = 0L;
    private StringBuffer sb = new StringBuffer();

    public AsJsql(InputStreamReader in, Writer out, String enc, Connection dbconn) throws UnsupportedEncodingException {
        this.in = in;
        this.out = out;
        this.encoding = enc;
        this.dbconn = dbconn;
        this.process();
    }

    public AsJsql(InputStreamReader in, OutputStreamWriter out, String enc, Connection dbconn) {
        this.in = in;
        this.out = out;
        this.encoding = enc;
        this.dbconn = dbconn;
        this.process();
    }

    public AsJsql(InputStreamReader in, OutputStreamWriter out, Connection dbconn) {
        this(in, out, null, dbconn);
    }

    public AsJsql(OutputStreamWriter out, ResultSet resultSet) {
        this.out = out;
        this.resultSet = resultSet;
    }

    private void process() {
        this.totalTime = 0L;
        LINEFEED = this.isWindows() ? "\r\n" : "\n";
        if (QueryFrame.frame.parser == null) {
            this.parser = new SQLParser(this.in);
        } else {
            SQLParser.ReInit(this.in);
        }
        SQLParser.setHandle(this);
        this.watch = new Stopwatch();
        try {
            AsJsql asJsql = this;
            asJsql.parser.ExpressionList();
            this.out.write(this.res.getString("Execution_Complete"));
            this.out.flush();
            this.out.close();
        }
        catch (Exception e) {
            GuiUt.showErrorDlg(QueryFrame.frame, this.res.getString("syntax_error_not_valid_sql_command"), "");
            e.printStackTrace();
        }
    }

    @Override
    public void SQLConnect(String[] ts) {
        if (ts != null) {
            int size = 0;
            size = ts[4] != null ? ts.length : ts.length - 1;
            String s = ts[0] + " ";
            for (int i = 1; i < size; ++i) {
                s = s + ts[i];
                if (i >= size - 1) continue;
                s = s + " ";
            }
            this.queryVector.add(s + ";");
        }
        try {
            Class.forName(this.driver);
        }
        catch (Exception e) {
            this.queryVector.remove(this.queryVector.lastElement());
            try {
                this.out.write(e.getMessage());
                this.out.write(LINEFEED + LINEFEED);
                this.out.flush();
            }
            catch (IOException ee) {
                ee.printStackTrace();
            }
        }
        try {
            if (this.dbconn != null && !this.dbconn.isClosed()) {
                this.dbconn.close();
            }
            String errlcode = LocaleManager.getErrlcode();
            String conStr = "jdbc:dbmaker:" + ts[2] + ";errlcode=" + errlcode;
            Connection conn = DriverManager.getConnection(conStr, ts[3], ts[4]);
            ((JdbcOdbcConnection)this.dbconn).setOption(1126, 2);
            this.dbconn = conn;
            this.out.write("SQL> ");
            for (int i = 0; i < ts.length && ts[i] != null; ++i) {
                this.out.write(ts[i]);
                this.out.write(SPACE);
            }
            this.out.write(LINEFEED + LINEFEED);
            this.out.flush();
            QueryFrame.frame.setDBField(ts[2] + "/" + ts[3]);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception ee) {
            GuiUt.showErrorDlg(QueryFrame.frame, ee.getMessage(), "");
            this.queryVector.remove(this.queryVector.lastElement());
            try {
                this.out.write(ee.getMessage());
                this.out.write(LINEFEED + LINEFEED);
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void SQLDisconnect(String s) {
        try {
            this.out.write("SQL> ");
            this.out.write(s);
            this.out.write(LINEFEED);
            if (this.dbconn != null) {
                try {
                    if (!this.dbconn.isClosed()) {
                        this.dbconn.close();
                    }
                    this.dbconn = null;
                }
                catch (Exception e) {
                    this.queryVector.remove(this.queryVector.lastElement());
                    try {
                        this.out.write(e.getMessage());
                        this.out.write(LINEFEED + LINEFEED);
                        this.out.flush();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                QueryFrame.frame.setDBField("");
            } else {
                this.out.write(this.res.getString("no_connection"));
                this.out.write(LINEFEED);
            }
            this.queryVector.add(s + ";");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void saveQueryResult(Writer out) {
        try {
            out.write(this.sb.toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void SQLStatement(String query) {
        this.queryVector.add(query + ";");
        try {
            this.sb.delete(0, this.sb.length());
            this.sb.append("SQL> ");
            this.sb.append(query);
            this.sb.append(LINEFEED);
            if (this.dbconn == null) {
                this.sb.append(this.res.getString("no_connection"));
                this.sb.append(LINEFEED + LINEFEED);
                return;
            }
            Statement stmt = this.dbconn.createStatement(1004, 1007);
            this.watch.start();
            long execution_time = 0L;
            if (stmt.execute(query)) {
                int a;
                int i;
                this.selectQueryVector.add(query);
                ResultSet rs = stmt.getResultSet();
                ResultSetMetaData rsMetaData = rs.getMetaData();
                String tableName = rsMetaData.getTableName(1);
                String schemaName = rsMetaData.getSchemaName(1);
                int columnCount = rsMetaData.getColumnCount();
                String tables = schemaName + "." + tableName;
                for (int idx = 1; idx < columnCount; ++idx) {
                    String temp = rsMetaData.getTableName(idx + 1);
                    if (tables.indexOf(temp) >= 0) continue;
                    tables = tables + "," + schemaName + "." + temp;
                }
                this.queryTableName.add(tables);
                int rowCount = 0;
                String data = null;
                columnCount = rsMetaData.getColumnCount();
                int spaceSize = 0;
                int columnSize = 0;
                String columnName = null;
                int columnType = -1;
                for (i = 0; i < columnCount; ++i) {
                    columnSize = rsMetaData.getColumnDisplaySize(i + 1);
                    columnName = rsMetaData.getColumnName(i + 1);
                    columnType = rsMetaData.getColumnType(i + 1);
                    this.sb.append(columnName);
                    if (columnName.getBytes().length > columnSize) {
                        columnSize = columnName.getBytes().length;
                    } else if (columnType == 2004 || columnType == 2005 || columnType == -4 || columnType == -1 || columnType == -10 || columnType == 301) {
                        columnSize = 20;
                    }
                    spaceSize = columnSize - columnName.getBytes().length;
                    for (a = 0; a < spaceSize; ++a) {
                        this.sb.append(SPACE);
                    }
                    this.sb.append(TAB);
                }
                this.sb.append(LINEFEED);
                for (i = 0; i < columnCount; ++i) {
                    columnSize = rsMetaData.getColumnDisplaySize(i + 1);
                    columnName = rsMetaData.getColumnName(i + 1);
                    columnType = rsMetaData.getColumnType(i + 1);
                    if (columnName.getBytes().length > columnSize) {
                        columnSize = columnName.getBytes().length;
                    } else if (columnType == 2004 || columnType == 2005 || columnType == -4 || columnType == -1 || columnType == -10 || columnType == 301) {
                        columnSize = 20;
                    }
                    for (a = 0; a < columnSize; ++a) {
                        this.sb.append("=");
                    }
                    this.sb.append(TAB);
                }
                this.sb.append(LINEFEED);
                int columnSpace = 0;
                while (rs.next()) {
                    columnSize = 0;
                    columnSpace = 0;
                    ++rowCount;
                    for (int j = 0; j < columnCount; ++j) {
                        columnType = rsMetaData.getColumnType(j + 1);
                        long length = 0L;
                        Object obj = null;
                        String s = null;
                        switch (columnType) {
                            case 0: {
                                data = "NULL";
                                break;
                            }
                            case -7: 
                            case -2: {
                                s = rs.getString(j + 1);
                                if (s != null) {
                                    if (s.length() > 0) {
                                        data = s;
                                        break;
                                    }
                                    data = "NULL";
                                    break;
                                }
                                data = "NULL";
                                break;
                            }
                            case -10: 
                            case -4: 
                            case 301: 
                            case 2004: {
                                Blob blob = rs.getBlob(j + 1);
                                length = blob.length();
                                String string = data = rs.wasNull() ? "NULL" : new String("<BLOB>" + length);
                                if (rs.wasNull()) break;
                                JdbcUtil.free(blob);
                                break;
                            }
                            case -1: 
                            case 2005: {
                                Clob clob = rs.getClob(j + 1);
                                length = clob.length();
                                String string = data = rs.wasNull() ? "NULL" : new String("<CLOB>" + length);
                                if (rs.wasNull()) break;
                                JdbcUtil.free(clob);
                                break;
                            }
                            case 12: {
                                obj = rs.getObject(j + 1);
                                if (obj != null) {
                                    if (obj.toString().length() > 0) {
                                        data = obj.toString();
                                        break;
                                    }
                                    data = "";
                                    break;
                                }
                                data = "NULL";
                                break;
                            }
                            default: {
                                obj = rs.getString(j + 1);
                                if (obj != null) {
                                    if (obj.toString().length() > 0) {
                                        data = obj.toString();
                                        break;
                                    }
                                    data = "";
                                    break;
                                }
                                data = "NULL";
                            }
                        }
                        columnSize = columnType == 2004 || columnType == 2005 || columnType == -4 || columnType == -1 || columnType == -10 || columnType == 301 ? 20 : rsMetaData.getColumnDisplaySize(j + 1);
                        if (rsMetaData.getColumnName(j + 1).getBytes().length > columnSize) {
                            columnSize = rsMetaData.getColumnName(j + 1).getBytes().length;
                        }
                        if (columnSize >= data.trim().getBytes().length) {
                            columnSpace = columnSize - data.trim().getBytes().length;
                        } else if (columnSize < data.trim().getBytes().length) {
                            columnSpace = 0;
                            byte[] by = data.trim().getBytes("UTF-8");
                            byte[] by2 = Arrays.copyOf(by, columnSize - 3);
                            String str = new String(by2, "UTF-8");
                            data = str + "...";
                        }
                        this.sb.append(data.trim());
                        for (int i2 = 0; i2 < columnSpace; ++i2) {
                            this.sb.append(SPACE);
                        }
                        this.sb.append(TAB);
                    }
                    this.sb.append(LINEFEED);
                }
                this.watch.stop();
                this.totalTime += this.watch.getElapsedTime();
                execution_time += this.watch.getElapsedTime();
                rs.close();
                stmt.close();
                Integer row = new Integer(rowCount);
                this.sb.append(LINEFEED);
                this.sb.append(row.toString() + " " + this.res.getString("rows_selected"));
                this.sb.append(LINEFEED + LINEFEED);
                this.sb.append(this.res.getString("execution_time") + execution_time + " ms");
                this.sb.append(LINEFEED + LINEFEED);
                this.out.write(this.sb.toString());
                this.out.flush();
            } else {
                int count = stmt.getUpdateCount();
                String act = query.substring(0, query.indexOf(" "));
                if (count >= 0) {
                    if (act.equalsIgnoreCase("insert")) {
                        this.sb.append(count + " " + this.res.getString("rows_inserted"));
                    } else if (act.equalsIgnoreCase("delete")) {
                        this.sb.append(count + " " + this.res.getString("rows_deleted"));
                    } else if (act.equalsIgnoreCase("update")) {
                        this.sb.append(count + " " + this.res.getString("row_updated"));
                    } else {
                        this.sb.append(count + " " + this.res.getString("rows_effected"));
                    }
                }
                this.watch.stop();
                this.totalTime += this.watch.getElapsedTime();
                this.sb.append(LINEFEED + LINEFEED);
                this.sb.append(this.res.getString("execution_time") + (execution_time += this.watch.getElapsedTime()) + " ms");
                this.sb.append(LINEFEED + LINEFEED);
                stmt.close();
                stmt = null;
                this.out.write(this.sb.toString());
                this.out.flush();
            }
        }
        catch (SQLException sqle) {
            this.queryVector.remove(this.queryVector.lastElement());
            try {
                this.sb.append(this.res.getString("error") + " (" + sqle.getErrorCode() + "): " + sqle.getMessage());
                this.sb.append(LINEFEED + LINEFEED);
                this.out.write(this.sb.toString());
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public boolean isWindows() {
        String fileseparator = System.getProperty("file.separator");
        return fileseparator.equals("\\");
    }

    public void displayTime(long time) {
        QueryFrame.frame.setQueryTimeField(time);
    }
}

