/*
 * Decompiled with CFR 0.152.
 */
package preferences;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.LocaleComboBox;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.IntegerRangeField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import preferences.PreferencesXml;
import queryAnalyzer.HelpButton;
import queryAnalyzer.QueryFrame;

public class PreferencesDlg
extends JDialog {
    private DBAResourceBundle res = new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    private JTabbedPane tabbedpane1 = new JTabbedPane();
    private IntegerRangeField Num_hisCommand = new IntegerRangeField(50, 1);
    private IntegerRangeField Num_Record = new IntegerRangeField(5000, 1);
    private JCheckBox Show_Result = new JCheckBox(this.res.getString("Show_query_result_table"));
    private DbaButton OK_Button = new DbaButton(new Dimension(130, 20), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbaut/dbautimages/ok.gif"), new ReflectionAction(this, "OK_Button_actionPerformed"));
    private LocaleComboBox languageComboBox = new LocaleComboBox();
    private HelpButton helpButton = new HelpButton(new Dimension(130, 20));

    public PreferencesDlg(Frame frame) {
        super(frame);
        this.setModal(true);
        try {
            this.setTitle(this.res.getString("Setup_preferences"));
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PreferencesDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.setTitle(title);
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(this.res.getString("Setup_preferences"));
        DbaButton Cancel_Button = new DbaButton(new Dimension(130, 20), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbaut/dbautimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        JPanel jPanel7 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JPanel jPanel10 = new JPanel(new GridLayout(2, 2, 5, 5));
        JLabel jLabel2 = new JLabel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel12 = new JPanel();
        JPanel languagePanel = new JPanel(new GridLayout(1, 1, 5, 5));
        JLabel languageLabel = new JLabel(this.res.getString("Language_choice"));
        languagePanel.add(languageLabel);
        languagePanel.add(this.languageComboBox);
        jPanel7.setLayout((LayoutManager)new VerticalFlowLayout());
        jLabel1.setText(this.res.getString("Max_history_command"));
        jLabel1.setForeground(Color.black);
        jPanel3.setLayout((LayoutManager)new VerticalFlowLayout());
        jPanel11.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel11.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jLabel2.setText(this.res.getString("Max_number_of_Records"));
        jLabel2.setForeground(Color.black);
        this.Num_Record.setValue(QueryFrame.frame.px.getNumRecord());
        this.Num_hisCommand.setValue(QueryFrame.frame.px.getNumHistoryCmd());
        if (QueryFrame.frame.px.getDisplayTableModel()) {
            this.Show_Result.setSelected(true);
        } else {
            this.Show_Result.setSelected(false);
        }
        languagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel10.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.tabbedpane1.add((Component)jPanel7, this.res.getString("General"));
        this.tabbedpane1.add((Component)jPanel3, this.res.getString("Table"));
        jPanel7.add(languagePanel);
        jPanel7.add(jPanel10);
        jPanel10.add((Component)jLabel1, null);
        jPanel10.add((Component)this.Num_hisCommand, null);
        jPanel10.add(this.Show_Result);
        jPanel3.add((Component)jPanel11, null);
        jPanel11.add((Component)jLabel2, null);
        jPanel11.add((Component)this.Num_Record, null);
        jPanel12.add(this.OK_Button);
        jPanel12.add(Cancel_Button);
        jPanel12.add(this.helpButton);
        jPanel6.setLayout((LayoutManager)new XYLayout());
        jPanel6.add((Component)this.tabbedpane1, new XYConstraints(0, 0, 550, 160));
        jPanel6.add((Component)jPanel12, new XYConstraints(0, 162, 450, 30));
        this.getContentPane().add(jPanel6);
        QueryFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "PreferencesDlg", null);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        Integer num_record = this.Num_Record.getValue();
        if (num_record == null) {
            GuiUt.showErrorDlg(QueryFrame.frame, this.res.getString("Invalid_number_of_record"), null);
            return;
        }
        Integer num_hiscommand = this.Num_hisCommand.getValue();
        if (num_hiscommand == null) {
            GuiUt.showErrorDlg(QueryFrame.frame, this.res.getString("Invalid_number_of_history_command"), null);
            return;
        }
        PreferencesXml cfr_ignored_0 = QueryFrame.frame.px;
        QueryFrame.frame.px.updateVariables(0, num_record.toString());
        PreferencesXml cfr_ignored_1 = QueryFrame.frame.px;
        QueryFrame.frame.px.updateVariables(3, num_hiscommand.toString());
        PreferencesXml cfr_ignored_2 = QueryFrame.frame.px;
        QueryFrame.frame.px.updateVariables(4, Boolean.toString(this.Show_Result.isSelected()));
        short new_language = this.languageComboBox.getSelectedLanguageChoice();
        if (new_language != LocaleManager.getLanguageChoice()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            LocaleChangeEvent lce = null;
            switch (new_language) {
                case 0: {
                    lce = new LocaleChangeEvent(this, Locale.US);
                    break;
                }
                case 1: {
                    lce = new LocaleChangeEvent(this, Locale.TAIWAN);
                    break;
                }
                case 2: {
                    lce = new LocaleChangeEvent(this, Locale.JAPAN);
                    break;
                }
                case 3: {
                    lce = new LocaleChangeEvent(this, Locale.CHINA);
                }
            }
            LocaleManager.getLocaleManager().localeChanged(lce);
            QueryFrame.frame.localeChanged(lce);
            PreferencesXml cfr_ignored_3 = QueryFrame.frame.px;
            PreferencesXml.setLanguageChoice(new_language);
            this.setCursor(Cursor.getDefaultCursor());
        }
        QueryFrame.frame.px.save();
        this.setVisible(false);
        this.dispose();
    }
}

