/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.client;

import com.caucho.hessian.client.HessianConnectionFactory;
import com.caucho.hessian.client.HessianMetaInfoAPI;
import com.caucho.hessian.client.HessianProxy;
import com.caucho.hessian.client.HessianProxyResolver;
import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.client.HessianURLConnectionFactory;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianRemoteObject;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.services.client.ServiceProxyFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class HessianProxyFactory
implements ServiceProxyFactory {
    protected static Logger log = Logger.getLogger(HessianProxyFactory.class.getName());
    private final ClassLoader _loader;
    private SerializerFactory _serializerFactory;
    private HessianConnectionFactory _connFactory;
    private HessianRemoteResolver _resolver;
    private String _user;
    private String _password;
    private String _basicAuth;
    private boolean _isOverloadEnabled = false;
    private boolean _isHessian2Reply = true;
    private boolean _isHessian2Request = false;
    private boolean _isChunkedPost = true;
    private boolean _isDebug = false;
    private long _readTimeout = -1L;
    private long _connectTimeout = -1L;

    public HessianProxyFactory() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public HessianProxyFactory(ClassLoader classLoader) {
        this._loader = classLoader;
        this._resolver = new HessianProxyResolver(this);
    }

    public void setUser(String string) {
        this._user = string;
        this._basicAuth = null;
    }

    public void setPassword(String string) {
        this._password = string;
        this._basicAuth = null;
    }

    public String getBasicAuth() {
        if (this._basicAuth != null) {
            return this._basicAuth;
        }
        if (this._user != null && this._password != null) {
            return "Basic " + this.base64(this._user + ":" + this._password);
        }
        return null;
    }

    public void setConnectionFactory(HessianConnectionFactory hessianConnectionFactory) {
        this._connFactory = hessianConnectionFactory;
    }

    public HessianConnectionFactory getConnectionFactory() {
        if (this._connFactory == null) {
            this._connFactory = this.createHessianConnectionFactory();
            this._connFactory.setHessianProxyFactory(this);
        }
        return this._connFactory;
    }

    public void setDebug(boolean bl) {
        this._isDebug = bl;
    }

    public boolean isDebug() {
        return this._isDebug;
    }

    public boolean isOverloadEnabled() {
        return this._isOverloadEnabled;
    }

    public void setOverloadEnabled(boolean bl) {
        this._isOverloadEnabled = bl;
    }

    public void setChunkedPost(boolean bl) {
        this._isChunkedPost = bl;
    }

    public boolean isChunkedPost() {
        return this._isChunkedPost;
    }

    public long getReadTimeout() {
        return this._readTimeout;
    }

    public void setReadTimeout(long l) {
        this._readTimeout = l;
    }

    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long l) {
        this._connectTimeout = l;
    }

    public void setHessian2Reply(boolean bl) {
        this._isHessian2Reply = bl;
    }

    public void setHessian2Request(boolean bl) {
        this._isHessian2Request = bl;
        if (bl) {
            this._isHessian2Reply = true;
        }
    }

    public HessianRemoteResolver getRemoteResolver() {
        return this._resolver;
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
    }

    public SerializerFactory getSerializerFactory() {
        if (this._serializerFactory == null) {
            this._serializerFactory = new SerializerFactory(this._loader);
        }
        return this._serializerFactory;
    }

    protected HessianConnectionFactory createHessianConnectionFactory() {
        String string = System.getProperty(HessianConnectionFactory.class.getName());
        HessianConnectionFactory hessianConnectionFactory = null;
        try {
            if (string != null) {
                Class<?> clazz = Class.forName(string, false, this._loader);
                hessianConnectionFactory = (HessianConnectionFactory)clazz.newInstance();
                return hessianConnectionFactory;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return new HessianURLConnectionFactory();
    }

    public Object create(String string) throws MalformedURLException, ClassNotFoundException {
        HessianMetaInfoAPI hessianMetaInfoAPI = (HessianMetaInfoAPI)this.create(HessianMetaInfoAPI.class, string);
        String string2 = (String)hessianMetaInfoAPI._hessian_getAttribute("java.api.class");
        if (string2 == null) {
            throw new HessianRuntimeException(string + " has an unknown api.");
        }
        Class<?> clazz = Class.forName(string2, false, this._loader);
        return this.create(clazz, string);
    }

    @Override
    public Object create(Class clazz, String string) throws MalformedURLException {
        return this.create(clazz, string, this._loader);
    }

    public Object create(Class<?> clazz, String string, ClassLoader classLoader) throws MalformedURLException {
        URL uRL = new URL(string);
        return this.create(clazz, uRL, classLoader);
    }

    public Object create(Class<?> clazz, URL uRL, ClassLoader classLoader) {
        if (clazz == null) {
            throw new NullPointerException("api must not be null for HessianProxyFactory.create()");
        }
        HessianProxy hessianProxy = null;
        hessianProxy = new HessianProxy(uRL, this, clazz);
        return Proxy.newProxyInstance(classLoader, new Class[]{clazz, HessianRemoteObject.class}, (InvocationHandler)hessianProxy);
    }

    public AbstractHessianInput getHessianInput(InputStream inputStream) {
        return this.getHessian2Input(inputStream);
    }

    public AbstractHessianInput getHessian1Input(InputStream inputStream) {
        if (this._isDebug) {
            inputStream = new HessianDebugInputStream(inputStream, new PrintWriter(System.out));
        }
        HessianInput hessianInput = new HessianInput(inputStream);
        hessianInput.setRemoteResolver(this.getRemoteResolver());
        ((AbstractHessianInput)hessianInput).setSerializerFactory(this.getSerializerFactory());
        return hessianInput;
    }

    public AbstractHessianInput getHessian2Input(InputStream inputStream) {
        if (this._isDebug) {
            inputStream = new HessianDebugInputStream(inputStream, new PrintWriter(System.out));
        }
        Hessian2Input hessian2Input = new Hessian2Input(inputStream);
        hessian2Input.setRemoteResolver(this.getRemoteResolver());
        ((AbstractHessianInput)hessian2Input).setSerializerFactory(this.getSerializerFactory());
        return hessian2Input;
    }

    public AbstractHessianOutput getHessianOutput(OutputStream outputStream) {
        AbstractHessianOutput abstractHessianOutput;
        if (this._isHessian2Request) {
            abstractHessianOutput = new Hessian2Output(outputStream);
        } else {
            HessianOutput hessianOutput = new HessianOutput(outputStream);
            abstractHessianOutput = hessianOutput;
            if (this._isHessian2Reply) {
                hessianOutput.setVersion(2);
            }
        }
        abstractHessianOutput.setSerializerFactory(this.getSerializerFactory());
        return abstractHessianOutput;
    }

    private String base64(String string) {
        long l;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        n = 0;
        while (n + 2 < string.length()) {
            l = string.charAt(n);
            l = (l << 8) + (long)string.charAt(n + 1);
            l = (l << 8) + (long)string.charAt(n + 2);
            stringBuffer.append(HessianProxyFactory.encode(l >> 18));
            stringBuffer.append(HessianProxyFactory.encode(l >> 12));
            stringBuffer.append(HessianProxyFactory.encode(l >> 6));
            stringBuffer.append(HessianProxyFactory.encode(l));
            n += 3;
        }
        if (n + 1 < string.length()) {
            l = string.charAt(n);
            l = (l << 8) + (long)string.charAt(n + 1);
            stringBuffer.append(HessianProxyFactory.encode((l <<= 8) >> 18));
            stringBuffer.append(HessianProxyFactory.encode(l >> 12));
            stringBuffer.append(HessianProxyFactory.encode(l >> 6));
            stringBuffer.append('=');
        } else if (n < string.length()) {
            l = string.charAt(n);
            stringBuffer.append(HessianProxyFactory.encode((l <<= 16) >> 18));
            stringBuffer.append(HessianProxyFactory.encode(l >> 12));
            stringBuffer.append('=');
            stringBuffer.append('=');
        }
        return stringBuffer.toString();
    }

    public static char encode(long l) {
        if ((l &= 0x3FL) < 26L) {
            return (char)(l + 65L);
        }
        if (l < 52L) {
            return (char)(l + 97L - 26L);
        }
        if (l < 62L) {
            return (char)(l + 48L - 52L);
        }
        if (l == 62L) {
            return '+';
        }
        return '/';
    }
}

