/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.sql;

import dbmaster.sql.JdbcOdbc;
import dbmaster.sql.JdbcOdbcAPI;
import dbmaster.sql.JdbcOdbcCallableStatement;
import dbmaster.sql.JdbcOdbcDatabaseMetaData;
import dbmaster.sql.JdbcOdbcDatabaseMetaData2;
import dbmaster.sql.JdbcOdbcDriver;
import dbmaster.sql.JdbcOdbcPreparedStatement;
import dbmaster.sql.JdbcOdbcStatement;
import dbmaster.sql.LargeObjectAbstract;
import dbmaster.sql.ODBCDef;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class JdbcOdbcConnection
extends JdbcOdbc
implements Connection {
    protected JdbcOdbcAPI ODBCOBJ;
    private long hDBC;
    private boolean isClose = false;
    protected SQLWarning lastWarning;
    protected JdbcOdbcDriver.Driver myDriver;
    protected String URL;
    private HashSet statementList = new HashSet();
    private HashSet lobList = new HashSet();
    private boolean InternalUse = false;
    protected boolean fgJavaSP = false;
    private String clilcode = null;
    private boolean isU8 = false;
    private SimpleDateFormat sdf = null;
    private SimpleDateFormat stf = null;
    private SimpleDateFormat sitf = null;
    private SimpleDateFormat stsf = null;

    public long getEnv() {
        return this.myDriver.hENV;
    }

    protected JdbcOdbcConnection() {
    }

    public JdbcOdbcConnection(String string, Properties properties, JdbcOdbcDriver.Driver driver) throws SQLException {
        if (this.needTrace) {
            this.trace("new a Connection object");
        }
        String string2 = properties.getProperty("user", "");
        String string3 = properties.getProperty("password", "");
        this.initialize(string, string2, string3, driver);
    }

    public JdbcOdbcConnection(String string, String string2, String string3, JdbcOdbcDriver.Driver driver) throws SQLException {
        if (this.needTrace) {
            this.trace("new a Connection object");
        }
        this.initialize(string, string2, string3, driver);
    }

    public JdbcOdbcConnection(long l) throws SQLException {
        this(l, null);
    }

    public JdbcOdbcConnection(long l, JdbcOdbcDriver.Driver driver) throws SQLException {
        if (this.needTrace) {
            this.trace("new a Connection object only by HDBC " + l);
        }
        this.hDBC = l;
        boolean bl = this.fgJavaSP = driver != null;
        if (driver == null) {
            JdbcOdbcDriver.ConnInfo connInfo = new JdbcOdbcDriver.ConnInfo();
            connInfo.fgJavaSP = true;
            driver = new JdbcOdbcDriver().getDriver(connInfo);
        }
        this.myDriver = driver;
        this.ODBCOBJ = driver.ODBCOBJ;
        this.InternalUse = true;
    }

    protected void initialize(String string, String string2, String string3, JdbcOdbcDriver.Driver driver) throws SQLException {
        this.myDriver = driver;
        this.ODBCOBJ = this.myDriver.ODBCOBJ;
        this.hDBC = 0L;
        this.isClose = true;
        this.URL = null;
        this.lastWarning = null;
        try {
            this.hDBC = this.myDriver.allocConn();
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        String string4 = null;
        string4 = System.getProperty("DM_CONNECT_MODE");
        int n = DriverManager.getLoginTimeout();
        if (n > 0) {
            this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 103, n);
        }
        if (string4 != null && string4.compareTo("CREATE_DB") == 0) {
            this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 1402, 2);
        } else if (string4 != null && string4.compareTo("START_DB") == 0) {
            this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 1402, 1);
        } else {
            this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 1402, 0);
        }
        this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 1431, 1);
        try {
            this.ODBCOBJ.jdbcConnect(this.hDBC, string, string2, string3);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.myDriver.freeConn(this.hDBC);
            this.hDBC = 0L;
            throw this.JDBCError("JERR_CONN_FAIL", null, sQLException);
        }
        if (this.myDriver.fgODBC) {
            this.isClose = false;
            return;
        }
        this.gbDbCase = this.ODBCOBJ.jdbcGetInfoShort(this.hDBC, 28);
        this.isClose = false;
        this.clilcode = this.getClilcode();
        String string5 = this.getErrlcode();
        this.ODBCOBJ.getResourceBundle(string5);
        this.initDateTimeFormat();
    }

    protected void initDateTimeFormat() throws SQLException {
        int n = this.getOptionInt(1111);
        if (0 > n || n >= ODBCDef.DATE_OUTPUT_FORMATS.length) {
            n = 7;
        }
        this.sdf = new SimpleDateFormat(ODBCDef.DATE_OUTPUT_FORMATS[n], Locale.US);
        int n2 = this.getOptionInt(1113);
        if (0 > n2 || n2 >= ODBCDef.TIME_OUTPUT_FORMATS.length) {
            n2 = 1;
        }
        this.stf = new SimpleDateFormat(ODBCDef.TIME_OUTPUT_FORMATS[n2], Locale.US);
        int n3 = this.getOptionInt(1112);
        if (0 > n3 || n3 >= ODBCDef.TIME_OUTPUT_FORMATS.length) {
            n3 = 12;
        }
        if (n3 == 12) {
            n3 = 0;
        }
        this.sitf = new SimpleDateFormat(ODBCDef.TIME_OUTPUT_FORMATS[n3], Locale.US);
        this.stsf = new SimpleDateFormat(ODBCDef.DATE_OUTPUT_FORMATS[n] + " " + ODBCDef.TIME_OUTPUT_FORMATS[n2], Locale.US);
    }

    protected Time getTime(String string) throws ParseException {
        return new Time(this.stf.parse(string).getTime());
    }

    protected Date getDate(String string) throws ParseException {
        return new Date(this.sdf.parse(string).getTime());
    }

    protected Timestamp getTimestamp(int n, String string) throws ParseException {
        switch (n) {
            case 92: {
                return new Timestamp(this.stf.parse(string).getTime());
            }
            case 91: {
                return new Timestamp(this.sdf.parse(string).getTime());
            }
        }
        return new Timestamp(this.stsf.parse(string).getTime());
    }

    protected String getStringfromTime(Time time) {
        return this.sitf.format(time);
    }

    protected void finalize() {
        this.trace("Connection.finalize()");
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Statement createStatement() throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.createStatement()");
        }
        this.checkClosed(this.isClose);
        JdbcOdbcStatement jdbcOdbcStatement = new JdbcOdbcStatement(this);
        return jdbcOdbcStatement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.createStatement(" + n + ", " + n2 + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            JdbcOdbcStatement jdbcOdbcStatement;
            this.checkClosed(this.isClose);
            long l = this.setCursorProperty(this.hDBC, n, n2);
            JdbcOdbcStatement jdbcOdbcStatement2 = jdbcOdbcStatement = new JdbcOdbcStatement(this, l);
            return jdbcOdbcStatement2;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.preparedStatement (" + string + ")");
        }
        if (string == null) {
            this.JDBCError("JERR_CANNOT_NULL_STRING", null);
        } else if (string.length() == 0) {
            this.JDBCError("JERR_CANNOT_EMPTY_STRING", null);
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement;
            this.checkClosed(this.isClose);
            long l = this.preStatement(this.hDBC, string);
            JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement2 = jdbcOdbcPreparedStatement = new JdbcOdbcPreparedStatement(this, l, string);
            return jdbcOdbcPreparedStatement2;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.preparedStatement (" + string + ", " + n + ", " + n2 + ")");
        }
        if (string == null) {
            this.JDBCError("JERR_CANNOT_NULL_STRING", null);
        } else if (string.length() == 0) {
            this.JDBCError("JERR_CANNOT_EMPTY_STRING", null);
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement;
            this.checkClosed(this.isClose);
            long l = this.preStatement(this.hDBC, string, n, n2);
            JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement2 = jdbcOdbcPreparedStatement = new JdbcOdbcPreparedStatement(this, l, string);
            return jdbcOdbcPreparedStatement2;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        long l = 0L;
        if (this.needTrace) {
            this.trace("Connection.prepareCall (" + string + ")");
        }
        if (string == null) {
            this.JDBCError("JERR_CANNOT_NULL_STRING", null);
        } else if (string.length() == 0) {
            this.JDBCError("JERR_CANNOT_EMPTY_STRING", null);
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            JdbcOdbcCallableStatement jdbcOdbcCallableStatement;
            this.checkClosed(this.isClose);
            l = this.preStatement(this.hDBC, string);
            JdbcOdbcCallableStatement jdbcOdbcCallableStatement2 = jdbcOdbcCallableStatement = new JdbcOdbcCallableStatement(this, l, string);
            return jdbcOdbcCallableStatement2;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        long l = 0L;
        if (this.needTrace) {
            this.trace("Connection.preparedCall (" + string + ", " + n + ", " + n2 + ")");
        }
        if (string == null) {
            this.JDBCError("JERR_CANNOT_NULL_STRING", null);
        } else if (string.length() == 0) {
            this.JDBCError("JERR_CANNOT_EMPTY_STRING", null);
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            JdbcOdbcCallableStatement jdbcOdbcCallableStatement;
            this.checkClosed(this.isClose);
            l = this.preStatement(this.hDBC, string, n, n2);
            JdbcOdbcCallableStatement jdbcOdbcCallableStatement2 = jdbcOdbcCallableStatement = new JdbcOdbcCallableStatement(this, l, string);
            return jdbcOdbcCallableStatement2;
        }
    }

    public void commit() throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.commit");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                this.ODBCOBJ.jdbcTransact(this.myDriver.hENV, this.hDBC, 0);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        this.closeBCList(true);
    }

    public void rollback() throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.rollback");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            this.resetAllStmt();
            try {
                this.ODBCOBJ.jdbcTransact(this.myDriver.hENV, this.hDBC, 1);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        this.closeBCList(true);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.setAutoCommit (" + bl + ")");
        }
        int n = !bl ? 0 : 1;
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 102, n);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
    }

    public boolean getAutoCommit() throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("Connection.getAutoCommit");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                n = this.ODBCOBJ.jdbcGetConnectAttrInt(this.hDBC, 102);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return n == 1;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.setTransactionIsolation (" + n + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                switch (n) {
                    case 0: {
                        this.setAutoCommit(true);
                        break;
                    }
                    case 1: {
                        this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 108, 1);
                        break;
                    }
                    case 2: {
                        this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 108, 2);
                        break;
                    }
                    case 4: {
                        this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 108, 4);
                        break;
                    }
                    case 8: {
                        this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 108, 8);
                        break;
                    }
                    default: {
                        this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 108, n);
                        break;
                    }
                }
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
    }

    public int getTransactionIsolation() throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("Connection.getTransactionIsolation");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                n = this.ODBCOBJ.jdbcGetConnectAttrInt(this.hDBC, 108);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        return n;
    }

    public String getCatalog() throws SQLException {
        String string = null;
        if (this.needTrace) {
            this.trace("Connection.getCatalog");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                string = this.ODBCOBJ.jdbcGetConnectAttrString(this.hDBC, 109);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return string;
    }

    public void close() throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.close");
        }
        if (this.isClose) {
            throw new SQLWarning("Connection has been close");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            if (!this.InternalUse) {
                if (!this.myDriver.fgODBC) {
                    String string = null;
                    string = System.getProperty("DM_DISCONNECT_MODE");
                    if (string != null && string.compareTo("TERMINATE_DB") == 0) {
                        this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 1403, 1);
                    } else {
                        this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, 1403, 0);
                    }
                }
                this.closeAllStmt();
                this.myDriver.disConn(this.hDBC);
                this.myDriver.freeConn(this.hDBC);
            }
            this.closeBCList(true);
            this.InternalUse = false;
            this.hDBC = 0L;
            this.isClose = true;
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.isClosed");
        }
        return this.isClose || this.hDBC == 0L;
    }

    public boolean isReadOnly() throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("Connection.isReadOnly");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                n = this.ODBCOBJ.jdbcGetConnectAttrInt(this.hDBC, 101);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return n == 1;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.DatabaseMetaData");
        }
        this.checkClosed(this.isClose);
        JdbcOdbcDatabaseMetaData jdbcOdbcDatabaseMetaData = null;
        jdbcOdbcDatabaseMetaData = this.myDriver.fgODBC ? new JdbcOdbcDatabaseMetaData2(this.ODBCOBJ, this) : new JdbcOdbcDatabaseMetaData(this.ODBCOBJ, this);
        return jdbcOdbcDatabaseMetaData;
    }

    public void clearWarnings() throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.clearWarning");
        }
        this.lastWarning = null;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.getWarning");
        }
        return this.lastWarning;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.setReadOnly");
        }
    }

    public void setCatalog(String string) throws SQLException {
        if (this.needTrace) {
            this.trace("Connection.setCatalog");
        }
    }

    public String nativeSQL(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Connection.nativeSQL(String)", null);
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Connection.setTypeMap(java.util.Map)", null);
    }

    private long preStatement(long l, String string) throws SQLException {
        long l2 = 0L;
        if (this.needTrace) {
            this.trace("preStatement");
        }
        try {
            l2 = this.ODBCOBJ.jdbcAllocStmt(l);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        try {
            this.ODBCOBJ.jdbcPrepare(l2, string);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.ODBCOBJ.jdbcFreeStmt(l2, 1);
            throw sQLException;
        }
        return l2;
    }

    private long preStatement(long l, String string, int n, int n2) throws SQLException {
        long l2 = 0L;
        if (this.needTrace) {
            this.trace("preStatement (" + n + ", " + n2 + ")");
        }
        l2 = this.setCursorProperty(l, n, n2);
        try {
            this.ODBCOBJ.jdbcPrepare(l2, string);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.ODBCOBJ.jdbcFreeStmt(l2, 1);
            throw sQLException;
        }
        return l2;
    }

    private long setCursorProperty(long l, int n, int n2) throws SQLException {
        long l2 = 0L;
        int n3 = 0;
        int n4 = 0;
        if (this.needTrace) {
            this.trace("setCursorProperty (" + n + ", " + n2 + ")");
        }
        try {
            l2 = this.ODBCOBJ.jdbcAllocStmt(l);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        switch (n) {
            case 1003: {
                n3 = 0;
                break;
            }
            case 1004: {
                n3 = 3;
                break;
            }
            case 1005: {
                n3 = 2;
                break;
            }
            default: {
                this.JDBCError("JERR_INV_RS_TYPE", "TYPE_FORWARD_ONLY, TYPE_SCROLL_INSENSITIVE, or TYPE_SCROLL_SENSITIVE");
            }
        }
        switch (n2) {
            case 1007: {
                n4 = 1;
                break;
            }
            case 1008: {
                n4 = 2;
                break;
            }
            default: {
                this.JDBCError("JERR_INV_RS_CONCUR", "CONCUR_READ_ONLY or CONCUR_UPDATABLE");
            }
        }
        try {
            this.ODBCOBJ.jdbcSetStmtAttrInt(l2, 6, n3);
            this.ODBCOBJ.jdbcSetStmtAttrInt(l2, 7, n4);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        return l2;
    }

    public long getHDBC() throws SQLException {
        this.checkClosed(this.isClosed());
        return this.hDBC;
    }

    public void setURL(String string) {
        this.URL = string;
    }

    public String getURL() {
        return this.URL;
    }

    public int getMajorVer() {
        return 1;
    }

    public int getMinorVer() {
        return 0;
    }

    public void registerStmt(JdbcOdbcStatement jdbcOdbcStatement) {
        this.statementList.add(jdbcOdbcStatement);
    }

    public void deregisterStmt(Statement statement) {
        this.statementList.remove(statement);
    }

    public void closeAllStmt() throws SQLException {
        Object[] objectArray = ((AbstractCollection)this.statementList).toArray();
        int n = 0;
        while (n < objectArray.length) {
            ((JdbcOdbcStatement)objectArray[n]).close();
            ++n;
        }
    }

    public void resetAllStmt() throws SQLException {
        Iterator iterator = this.statementList.iterator();
        while (iterator.hasNext()) {
            ((JdbcOdbcStatement)iterator.next()).resetSTMT();
        }
    }

    protected void registerLargeObject(LargeObjectAbstract largeObjectAbstract) {
        this.lobList.add(largeObjectAbstract);
    }

    protected void unregisterLargeObject(LargeObjectAbstract largeObjectAbstract) {
        this.lobList.remove(largeObjectAbstract);
    }

    void closeBCList(boolean bl) throws SQLException {
        Iterator iterator = this.lobList.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                ((LargeObjectAbstract)iterator.next()).isClose = true;
                continue;
            }
            ((LargeObjectAbstract)iterator.next()).close();
        }
        this.lobList.clear();
    }

    public String getOptionStr(int n) throws SQLException {
        String string = null;
        if (this.needTrace) {
            this.trace("getOptionStr(" + n + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                string = this.ODBCOBJ.jdbcGetConnectAttrString(this.hDBC, n);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return string;
    }

    public int getOptionInt(int n) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("getOptionInt(" + n + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                n2 = this.ODBCOBJ.jdbcGetConnectAttrInt(this.hDBC, n);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return n2;
    }

    public int getOptionInt(int n, int[] nArray) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("getOptionInt(" + n + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                n2 = this.ODBCOBJ.jdbcGetConnectAttrInt(this.hDBC, n, nArray);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return n2;
    }

    public byte[] getOptionBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.needTrace) {
            this.trace("getOptionBytes(" + n + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                byArray = this.ODBCOBJ.jdbcGetConnectAttrBytes(this.hDBC, n);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return byArray;
    }

    public void setOption(int n, String string) throws SQLException {
        if (this.needTrace) {
            this.trace("setOptionStr(" + n + "," + string + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                this.ODBCOBJ.jdbcSetConnectAttrString(this.hDBC, n, string);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        if (n == 1145) {
            String string2 = this.getErrlcode();
            this.ODBCOBJ.getResourceBundle(string2);
        }
    }

    public void setOption(int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("setOptionStr(" + n + "," + n2 + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, n, n2);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        if (n == 1111 || n == 1113 || n == 1112) {
            this.initDateTimeFormat();
        }
    }

    public void setOption(int n, int n2, int n3) throws SQLException {
        if (this.needTrace) {
            this.trace("setOptionStr(" + n + "," + n2 + "," + n3 + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                this.ODBCOBJ.jdbcSetConnectAttrInt(this.hDBC, n, n2, n3);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
    }

    public void setOption(int n, byte[] byArray) throws SQLException {
        if (this.needTrace) {
            this.trace("setOptionStr(" + n + "," + byArray + ")");
        }
        JdbcOdbcConnection jdbcOdbcConnection = this;
        synchronized (jdbcOdbcConnection) {
            this.checkClosed(this.isClose);
            try {
                this.ODBCOBJ.jdbcSetConnectAttrBytes(this.hDBC, n, byArray);
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
    }

    protected boolean isU8() {
        return this.isU8;
    }

    public String getClilcode() {
        if (this.clilcode == null) {
            this.clilcode = "ASCII";
            try {
                Statement statement = this.createStatement();
                ResultSet resultSet = statement.executeQuery("select getsysinfo('CLILCODE')");
                if (resultSet.next()) {
                    this.clilcode = resultSet.getString(1);
                    if (!resultSet.wasNull()) {
                        this.clilcode = this.clilcode.trim();
                    }
                }
                resultSet.close();
                resultSet = statement.executeQuery("select getsysinfo('LCODE')");
                if (resultSet.next()) {
                    String string = resultSet.getString(1);
                    if (!resultSet.wasNull() && Integer.parseInt(string = string.trim()) == 10) {
                        this.isU8 = true;
                    }
                }
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.clilcode;
    }

    public String getErrlcode() {
        String string = "en";
        try {
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery("select getsysinfo('ERRLCODE')");
            if (resultSet.next()) {
                string = resultSet.getString(1);
                if (!resultSet.wasNull()) {
                    string = string.trim();
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    protected ResourceBundle getResourceBundle() {
        return this.ODBCOBJ.getResourceBundle();
    }
}

