/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.unpacker;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.MessagePack;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Unconverter;
import org.msgpack.type.Value;
import org.msgpack.type.ValueType;
import org.msgpack.unpacker.AbstractUnpacker;
import org.msgpack.unpacker.UnpackerStack;

public class Converter
extends AbstractUnpacker {
    private final UnpackerStack a = new UnpackerStack();
    private Object[] b = new Object[128];
    protected Value value;

    /*
     * WARNING - void declaration
     */
    public Converter(Value value) {
        this(new MessagePack(), (Value)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Converter(MessagePack msgpack, Value value) {
        super((MessagePack)var1_1);
        void var2_2;
        void var1_1;
        this.value = var2_2;
    }

    protected Value nextValue() throws IOException {
        throw new EOFException();
    }

    private void a() throws IOException {
        if (this.value == null) {
            this.value = this.nextValue();
        }
    }

    @Override
    public boolean tryReadNil() throws IOException {
        this.a.checkCount();
        if (this.b().isNilValue()) {
            this.a.reduceCount();
            if (this.a.getDepth() == 0) {
                this.value = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean trySkipNil() throws IOException {
        this.a();
        if (this.a.getDepth() > 0 && this.a.getTopCount() <= 0) {
            return true;
        }
        if (this.b().isNilValue()) {
            this.a.reduceCount();
            if (this.a.getDepth() == 0) {
                this.value = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public void readNil() throws IOException {
        if (!this.b().isNilValue()) {
            throw new MessageTypeException("Expected nil but got not nil value");
        }
        this.a.reduceCount();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean bl = this.b().asBooleanValue().getBoolean();
        this.a.reduceCount();
        return bl;
    }

    @Override
    public byte readByte() throws IOException {
        byte by = this.b().asIntegerValue().getByte();
        this.a.reduceCount();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
        return by;
    }

    @Override
    public short readShort() throws IOException {
        short s2 = this.b().asIntegerValue().getShort();
        this.a.reduceCount();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
        return s2;
    }

    @Override
    public int readInt() throws IOException {
        int n2 = this.b().asIntegerValue().getInt();
        this.a.reduceCount();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
        return n2;
    }

    @Override
    public long readLong() throws IOException {
        long l2 = this.b().asIntegerValue().getLong();
        this.a.reduceCount();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
        return l2;
    }

    @Override
    public BigInteger readBigInteger() throws IOException {
        BigInteger bigInteger = this.b().asIntegerValue().getBigInteger();
        this.a.reduceCount();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
        return bigInteger;
    }

    @Override
    public float readFloat() throws IOException {
        float f2 = this.b().asFloatValue().getFloat();
        this.a.reduceCount();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
        return f2;
    }

    @Override
    public double readDouble() throws IOException {
        double d2 = this.b().asFloatValue().getDouble();
        this.a.reduceCount();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
        return d2;
    }

    @Override
    public byte[] readByteArray() throws IOException {
        byte[] byArray = this.b().asRawValue().getByteArray();
        this.a.reduceCount();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
        return byArray;
    }

    @Override
    public String readString() throws IOException {
        String string = this.b().asRawValue().getString();
        this.a.reduceCount();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
        return string;
    }

    @Override
    public int readArrayBegin() throws IOException {
        Value value = this.b();
        if (!value.isArrayValue()) {
            throw new MessageTypeException("Expected array but got not array value");
        }
        value = value.asArrayValue();
        this.a.reduceCount();
        this.a.pushArray(value.size());
        this.b[this.a.getDepth()] = value.getElementArray();
        return value.size();
    }

    @Override
    public void readArrayEnd(boolean check) throws IOException {
        if (!this.a.topIsArray()) {
            throw new MessageTypeException("readArrayEnd() is called but readArrayBegin() is not called");
        }
        int n2 = this.a.getTopCount();
        if (n2 > 0) {
            int n3;
            if (n3 != 0) {
                throw new MessageTypeException("readArrayEnd(check=true) is called but the array is not end");
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.skip();
            }
        }
        this.a.pop();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
    }

    @Override
    public int readMapBegin() throws IOException {
        Value value = this.b();
        if (!value.isMapValue()) {
            throw new MessageTypeException("Expected map but got not map value");
        }
        value = value.asMapValue();
        this.a.reduceCount();
        this.a.pushMap(value.size());
        this.b[this.a.getDepth()] = value.getKeyValueArray();
        return value.size();
    }

    @Override
    public void readMapEnd(boolean check) throws IOException {
        if (!this.a.topIsMap()) {
            throw new MessageTypeException("readMapEnd() is called but readMapBegin() is not called");
        }
        int n2 = this.a.getTopCount();
        if (n2 > 0) {
            int n3;
            if (n3 != 0) {
                throw new MessageTypeException("readMapEnd(check=true) is called but the map is not end");
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.skip();
            }
        }
        this.a.pop();
        if (this.a.getDepth() == 0) {
            this.value = null;
        }
    }

    private Value b() throws IOException {
        this.a();
        this.a.checkCount();
        if (this.a.getDepth() == 0) {
            return this.value;
        }
        Value[] valueArray = (Value[])this.b[this.a.getDepth()];
        return valueArray[valueArray.length - this.a.getTopCount()];
    }

    @Override
    public Value readValue() throws IOException {
        if (this.a.getDepth() == 0) {
            if (this.value == null) {
                return this.nextValue();
            }
            Value value = this.value;
            this.value = null;
            return value;
        }
        return super.readValue();
    }

    @Override
    protected void readValue(Unconverter uc) throws IOException {
        if (uc.getResult() != null) {
            uc.resetResult();
        }
        this.a.checkCount();
        Value value = this.b();
        if (!value.isArrayValue() && !value.isMapValue()) {
            uc.write(value);
            this.a.reduceCount();
            if (this.a.getDepth() == 0) {
                this.value = null;
            }
            if (uc.getResult() != null) {
                return;
            }
        }
        while (true) {
            if (this.a.getDepth() != 0 && this.a.getTopCount() == 0) {
                if (this.a.topIsArray()) {
                    uc.writeArrayEnd(true);
                    this.a.pop();
                } else if (this.a.topIsMap()) {
                    uc.writeMapEnd(true);
                    this.a.pop();
                } else {
                    throw new RuntimeException("invalid stack");
                }
                if (this.a.getDepth() == 0) {
                    this.value = null;
                }
                if (uc.getResult() == null) continue;
                return;
            }
            this.a.checkCount();
            value = this.b();
            if (value.isArrayValue()) {
                value = value.asArrayValue();
                uc.writeArrayBegin(value.size());
                this.a.reduceCount();
                this.a.pushArray(value.size());
                this.b[this.a.getDepth()] = value.getElementArray();
                continue;
            }
            if (value.isMapValue()) {
                value = value.asMapValue();
                uc.writeMapBegin(value.size());
                this.a.reduceCount();
                this.a.pushMap(value.size());
                this.b[this.a.getDepth()] = value.getKeyValueArray();
                continue;
            }
            uc.write(value);
            this.a.reduceCount();
        }
    }

    @Override
    public void skip() throws IOException {
        this.a.checkCount();
        Value value = this.b();
        if (!value.isArrayValue() && !value.isMapValue()) {
            this.a.reduceCount();
            if (this.a.getDepth() == 0) {
                this.value = null;
            }
            return;
        }
        int n2 = this.a.getDepth();
        while (true) {
            if (this.a.getTopCount() == 0) {
                this.a.pop();
                if (this.a.getDepth() == 0) {
                    this.value = null;
                }
                if (this.a.getDepth() > n2) continue;
                return;
            }
            this.a.checkCount();
            value = this.b();
            if (value.isArrayValue()) {
                value = value.asArrayValue();
                this.a.reduceCount();
                this.a.pushArray(value.size());
                this.b[this.a.getDepth()] = value.getElementArray();
                continue;
            }
            if (value.isMapValue()) {
                value = value.asMapValue();
                this.a.reduceCount();
                this.a.pushMap(value.size());
                this.b[this.a.getDepth()] = value.getKeyValueArray();
                continue;
            }
            this.a.reduceCount();
        }
    }

    @Override
    public ValueType getNextType() throws IOException {
        return this.b().getType();
    }

    public void reset() {
        this.a.clear();
        this.value = null;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int getReadByteCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void setRawSizeLimit(int size) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void setArraySizeLimit(int size) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void setMapSizeLimit(int size) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

