/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.sql.type4.xa;

import dbmaster.sql.type4.Connection;
import dbmaster.sql.type4.JdbcCommon;
import dbmaster.sql.type4.xa.Connection2;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;

public class PooledConnection
extends JdbcCommon
implements javax.sql.PooledConnection {
    protected Connection physicalConn;
    protected java.sql.Connection logicalConn;
    protected boolean isClose;
    protected Hashtable EventListenerS = null;
    protected int CONN_CLOSE = 1;
    protected int CONN_ERROR = 2;

    public PooledConnection(Connection connection) throws SQLException {
        super(connection);
        logger.finer("new a PooledConnection object");
        this.physicalConn = connection;
        this.isClose = false;
        this.EventListenerS = new Hashtable(12);
    }

    protected void finalize() {
        logger.finer("PooledConnection.finalize()");
        try {
            this.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        logger.finer("PooledConnection.getConnection()");
        PooledConnection pooledConnection = this;
        pooledConnection.checkClosed(pooledConnection.isClose);
        if (this.logicalConn == null) {
            PooledConnection pooledConnection2 = this;
            this.logicalConn = new Connection2(pooledConnection2, pooledConnection2.physicalConn);
        }
        return this.logicalConn;
    }

    @Override
    public void close() throws SQLException {
        logger.finer("PooledConnection.close()");
        PooledConnection pooledConnection = this;
        pooledConnection.checkClosed(pooledConnection.isClose);
        this.physicalConn.close();
        SQLException sQLException = new SQLException("physical connection had been closed");
        PooledConnection pooledConnection2 = this;
        pooledConnection2.callListener(pooledConnection2.CONN_ERROR, sQLException);
        this.isClose = true;
    }

    public void logicalClose() throws SQLException {
        logger.finer("PooledConnection.logicalClose()");
        PooledConnection pooledConnection = this;
        pooledConnection.checkClosed(pooledConnection.isClose);
        PooledConnection pooledConnection2 = this;
        pooledConnection2.callListener(pooledConnection2.CONN_CLOSE, null);
    }

    public void callListener(int n2, SQLException serializable) {
        Enumeration enumeration = this.EventListenerS.keys();
        serializable = new ConnectionEvent(this, (SQLException)serializable);
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            connectionEventListener = (ConnectionEventListener)this.EventListenerS.get(connectionEventListener);
            if (n2 == this.CONN_CLOSE) {
                connectionEventListener.connectionClosed((ConnectionEvent)serializable);
                continue;
            }
            connectionEventListener.connectionErrorOccurred((ConnectionEvent)serializable);
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        logger.finer("PooledConnection.addConnectionEventListener(ConnectionEventListener listener)");
        ConnectionEventListener connectionEventListener2 = connectionEventListener;
        this.EventListenerS.put(connectionEventListener2, connectionEventListener2);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        logger.finer("PooledConnection.removeConnectionEventListener(ConnectionEventListener listener)");
        this.EventListenerS.remove(connectionEventListener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
    }
}

