/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtt.console;

import com.syscom.datatransfer.XTTDatatransfer;
import com.syscom.importxsddtd.ImportPartXSDDTDDlg;
import com.syscom.importxsddtd.XSDDTDDisabledTreeNode;
import com.syscom.importxsddtd.XSDDTDTree;
import com.syscom.importxsddtd.xsd.XSDParser;
import com.syscom.misc.DTDHandler;
import com.syscom.misc.XMLImageResource;
import com.syscom.misc.XTTTabbedPane;
import com.syscom.misc.XTTUt;
import com.syscom.preferences.PreferencesDlg;
import com.syscom.preferences.PreferencesXml;
import com.syscom.preferences.TreeOperationOptionDlg;
import com.syscom.sqleditor.SQLTextPane;
import com.syscom.treetable.JTreeTable;
import com.syscom.treetable.XTTTableModel;
import com.syscom.undo.DeleteNodeUndoEdit;
import com.syscom.undo.InsertNodeEdit;
import com.syscom.undo.XTTUndoManager;
import com.syscom.ut.AboutBox;
import com.syscom.ut.DatabaseConnection;
import com.syscom.ut.GuiUt;
import com.syscom.ut.WebBrowser;
import com.syscom.ut.comp.DbaButton;
import com.syscom.ut.comp.DbaFileFilter;
import com.syscom.ut.comp.XTTFileChooser;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.HelpResourceBundle;
import com.syscom.xml.node.Attribute;
import com.syscom.xml.node.QueryElement;
import com.syscom.xml.node.Template;
import com.syscom.xml.node.display.AbstractDisplayPanel;
import com.syscom.xml.node.display.AttributeMainPanel;
import com.syscom.xml.node.display.ElementMainPanel;
import com.syscom.xml.xtt.console.DesignViewport;
import com.syscom.xml.xtt.console.QueryBackgroupTableCellRenderer;
import com.syscom.xml.xtt.console.XTTMenuBar;
import com.syscom.xml.xtt.console.XTTToolBar;
import com.syscom.xml.xtt.dlg.ErrorLogDlg;
import com.syscom.xml.xtt.dlg.LoginDlg;
import com.syscom.xml.xtt.dlg.ParameterDlg;
import com.syscom.xml.xtt.dlg.ValidationInvalidPanel;
import com.syscom.xml.xtt.dlg.ValidationResultDlg;
import com.syscom.xml.xtt.tree.TableSchemaViewerTree;
import com.syscom.xml.xtt.tree.XTTTree;
import com.syscom.xml.xtt.xttobjects.DocumentInfoObject;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import dbmaker.sql.JdbcOdbcConnection;
import dbmaker.xml.XTT;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XTTFrame
extends JFrame
implements LocaleChangeListener {
    private ResourceBundle res = null;
    private JPanel contentPane;
    private JPanel topPanel = new JPanel(new BorderLayout());
    private JPanel bottomPanel = new JPanel(new BorderLayout());
    private JLabel statusBar = new JLabel();
    private JScrollPane rightTopScrollPane = new JScrollPane();
    private JPanel leftPanel = new JPanel(new BorderLayout());
    private JPanel rightPanel = new JPanel(new BorderLayout());
    private JSplitPane verticalSplitPane = new JSplitPane();
    private JSplitPane horizontalSplitPane = new JSplitPane();
    private JTabbedPane xttpanels = new JTabbedPane();
    public static XTTFrame frame = null;
    public Template root = null;
    private QueryElement importedRoot = null;
    public TableSchemaViewerTree tree1 = null;
    public XTTToolBar xttToolBar = null;
    public XTTMenuBar menubar = null;
    DefaultComboBoxModel xtt_cbm = new DefaultComboBoxModel();
    public DatabaseConnection conn = null;
    private JPanel designPanel = new JPanel(new BorderLayout());
    private JPanel sourcePanel = new JPanel(new BorderLayout());
    private JTreeTable treeTable = null;
    private JPanel toolBarPanel = new JPanel(new BorderLayout());
    private JScrollPane sourceScroll = new JScrollPane();
    public XTTTableModel treeTableModel = null;
    private JScrollPane designScroll = new JScrollPane();
    public boolean isConnect = false;
    private Vector emptyXTTVector = new Vector();
    private final String untitle = "untitle";
    private int untitle_serial = 0;
    private int xtt_selected_index = -1;
    private XTTTreeNodeInterface transferXTT = null;
    private TreePath copyTreePath = null;
    private TreePath pasteTreePath = null;
    private DefaultMutableTreeNode copy_dmtn = null;
    private DefaultMutableTreeNode paste_dmtn = null;
    private int query_serial = 0;
    private int space_count = 0;
    private String system_encoding;
    private Vector tmpVector = new Vector();
    private String schema_uri = null;
    private JComponent nextComp = null;
    public XTTUndoManager undoManager = null;
    public UndoableEditSupport undoSupport = null;
    public UndoAdapter undoAdapter = null;
    public int from = -1;
    public PreferencesXml px = PreferencesXml.getPreferencesXml();
    private HelpSet mainHS = null;
    DefaultHelpBroker mainHB = null;
    private HelpResourceBundle helpres = null;
    private ActionListener cshListener_menuitem = null;
    private JLabel dbLabel = null;

    public XTTFrame() {
        this.enableEvents(64L);
        try {
            frame = this;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        try {
            this.res = ResourceBundle.getBundle("com.syscom.xml.xtt.console.resource.Res", LocaleManager.getLocale());
        }
        catch (MissingResourceException mre) {
            LocaleManager.getLocaleManager().resetLocale(LocaleManager.getDefaultSystemLanguage());
            this.res = ResourceBundle.getBundle("com.syscom.xml.xtt.console.resource.Res", LocaleManager.getLocale());
            PreferencesXml cfr_ignored_0 = XTTFrame.frame.px;
            PreferencesXml.setLanguageChoice((short)0);
        }
        this.dbLabel = new JLabel(this.res.getString("Database") + ":");
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
        this.menubar = new XTTMenuBar();
        this.xttToolBar = new XTTToolBar();
        this.setIconImage(XMLImageResource.getResource(this.getClass(), "/xmlimages/toolicon.gif").getImage());
        this.contentPane = (JPanel)this.getContentPane();
        this.rightTopScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.contentPane.setLayout(new BorderLayout());
        this.setSize(new Dimension(this.px.getFrameWidth(), this.px.getFrameHeight()));
        this.setTitle("XML Transfer Template");
        this.statusBar.setText(this.res.getString("No_database_connect"));
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setJMenuBar(this.menubar);
        this.verticalSplitPane.setLeftComponent(this.leftPanel);
        this.verticalSplitPane.setRightComponent(this.rightPanel);
        this.verticalSplitPane.setDividerLocation(this.px.getVerticalDividerLocation());
        this.topPanel.add((Component)this.verticalSplitPane, "Center");
        this.rightPanel.add((Component)this.dbLabel, "North");
        this.rightPanel.add((Component)this.rightTopScrollPane, "Center");
        this.horizontalSplitPane.setDividerLocation(this.px.getHorizontalDividerLocation());
        this.horizontalSplitPane.setOrientation(0);
        this.horizontalSplitPane.setTopComponent(this.topPanel);
        this.horizontalSplitPane.setBottomComponent(this.bottomPanel);
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.add((Component)this.horizontalSplitPane, "Center");
        this.leftPanel.add(this.xttpanels);
        this.initHelpSet();
        this.xttToolBar.xttComboBox.setModel((ComboBoxModel)this.xtt_cbm);
        this.toolBarPanel.add((Component)this.xttToolBar, "Center");
        this.contentPane.add((Component)this.toolBarPanel, "North");
        this.xttpanels.add(this.res.getString("Design"), this.designPanel);
        this.xttpanels.add(this.res.getString("Source"), this.sourcePanel);
        this.xttpanels.setEnabledAt(1, false);
        this.xttpanels.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                XTTFrame.this.xttpanels_stateChanged(e);
            }
        });
        this.setToggleButtonStatus();
        this.setSystemEncoding();
        this.xttToolBar.closeToolButton.setEnabled(false);
        this.xttToolBar.saveToolButton.setEnabled(false);
        this.xttToolBar.runToolButton.setEnabled(false);
        this.menubar.Disconnect_MenuItem.setEnabled(false);
        this.menubar.Validation_MenuItem.setEnabled(false);
        this.xttToolBar.attributeToolButton.setEnabled(false);
        this.xttToolBar.elementToolButton.setEnabled(false);
        this.xttToolBar.upToolButton.setEnabled(false);
        this.xttToolBar.downToolButton.setEnabled(false);
        this.menubar.Close_MenuItem.setEnabled(false);
        this.menubar.Save_MenuItem.setEnabled(false);
        this.menubar.SaveAs_MenuItem.setEnabled(false);
        this.menubar.Generate_DTD_MenuItem.setEnabled(false);
        this.menubar.Generate_XSD_MenuItem.setEnabled(false);
        this.menubar.Undo_MenuItem.setEnabled(false);
        this.menubar.Run_MenuItem.setEnabled(false);
        this.menubar.Insert_Menu.setEnabled(false);
        this.menubar.Element_MenuItem.setEnabled(false);
        this.menubar.Attribute_MenuItem.setEnabled(false);
        this.menubar.Copy_MenuItem.setEnabled(false);
        this.menubar.Cut_MenuItem.setEnabled(false);
        this.menubar.Paste_MenuItem.setEnabled(false);
        this.menubar.Remove_MenuItem.setEnabled(false);
        this.xttToolBar.removeToolButton.setEnabled(false);
        this.xttToolBar.elementToggleButton.setEnabled(false);
        this.xttToolBar.attributeToggleButton.setEnabled(false);
        this.xttToolBar.addToggleButton.setEnabled(false);
        this.xttToolBar.replaceToggleButton.setEnabled(false);
        this.xttToolBar.showAgainToggleButton.setEnabled(false);
        this.designScroll.setViewport(new DesignViewport());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                XTTFrame.this.resetToolBar();
            }
        });
    }

    private void resetToolBar() {
        int width = this.getWidth();
        if (width < 881) {
            this.toolBarPanel.setMinimumSize(new Dimension(1000, 56));
            this.toolBarPanel.setPreferredSize(new Dimension(1000, 56));
        } else {
            this.toolBarPanel.setMinimumSize(new Dimension(1000, 30));
            this.toolBarPanel.setPreferredSize(new Dimension(1000, 30));
        }
        this.toolBarPanel.revalidate();
        this.toolBarPanel.repaint();
        this.contentPane.revalidate();
        this.contentPane.repaint();
    }

    private static String getHelpSetName() {
        String s = "JXML.hs";
        switch (LocaleManager.getHelpFileLanguage()) {
            default: 
        }
        s = "JXML.hs";
        return s;
    }

    private void initHelpSet() {
        String helpsetName = XTTFrame.getHelpSetName();
        JMenuItem helpMenuItem = this.menubar.getHelpButton();
        DbaButton helpToolButton = this.xttToolBar.getHelpButton();
        try {
            this.mainHS = null;
            this.mainHB = null;
            this.helpres = new HelpResourceBundle("com.syscom.xml.xtt.console.resource.help");
            String helpid = this.helpres.getString("home");
            ClassLoader cl = XTTFrame.class.getClassLoader();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)helpsetName);
            this.mainHS = new HelpSet(cl, url);
            this.mainHB = (DefaultHelpBroker)this.mainHS.createHelpBroker();
            this.mainHB.enableHelpKey((Component)this.getRootPane(), helpid, null);
            this.cshListener_menuitem = new CSH.DisplayHelpFromSource((HelpBroker)this.mainHB);
            helpMenuItem.addActionListener(this.cshListener_menuitem);
            helpMenuItem.setEnabled(true);
            helpToolButton.addActionListener(this.cshListener_menuitem);
            helpToolButton.setEnabled(true);
            CSH.setHelpIDString((Component)this, (String)helpid);
            this.mainHB.enableHelpKey((Component)helpMenuItem, helpid, null);
        }
        catch (Exception ex) {
            System.out.println("Help Set " + helpsetName + " not found");
            ex.printStackTrace();
            helpMenuItem.setEnabled(false);
            helpToolButton.setEnabled(false);
        }
    }

    public void enableDialogHelp(Component comp, JButton button, String id) {
        if (this.mainHB == null) {
            return;
        }
        String helpid = this.helpres.getString(id);
        if (comp != null) {
            this.mainHB.enableHelpKey(comp, helpid, this.mainHS);
        }
        if (button != null) {
            this.mainHB.enableHelpOnButton((Component)button, helpid, this.mainHS);
        }
    }

    private void setSystemEncoding() {
        String jvm_version = System.getProperty("java.specification.version");
        float fv = Float.parseFloat(jvm_version);
        String region = null;
        region = (double)fv > 1.3 ? System.getProperty("user.country") : System.getProperty("user.region");
        String language = System.getProperty("user.language");
        String endorsed = System.getProperty("java.endorsed.dirs");
        String home = System.getProperty("java.home");
        this.system_encoding = region.equals("TW") && language.equals("zh") ? "BIG5" : (region.equals("CN") && language.equals("zh") ? "GB2312" : (region.equals("JP") && language.equals("ja") ? "Shift_JIS" : "US-ASCII"));
    }

    public void setAfterActionTreePath(DefaultMutableTreeNode inNode, XTTTreeNodeInterface xtt2) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        DefaultMutableTreeNode node = null;
        XTTTreeNodeInterface xttObject = null;
        int count = inNode.getChildCount();
        int row = 0;
        TreePath path = null;
        for (int i = 0; i < count; ++i) {
            node = (DefaultMutableTreeNode)inNode.getChildAt(i);
            xttObject = (XTTTreeNodeInterface)node.getUserObject();
            if (!xtt2.equals(xttObject)) continue;
            path = new TreePath(node.getPath());
            this.treeTable.getTree().makeVisible(path);
            row = this.treeTable.getTree().getRowForPath(path);
            this.treeTable.getSelectionModel().setSelectionInterval(row, row);
            this.treeTable.getTree().scrollPathToVisible(path);
            break;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void reloadTreeStatus(DefaultMutableTreeNode node) {
        int children_size;
        XTTTreeNodeInterface selfXTT = (XTTTreeNodeInterface)node.getUserObject();
        if (selfXTT.isExpand()) {
            TreePath tp = new TreePath(node.getPath());
            this.treeTable.getTree().expandPath(tp);
        }
        if ((children_size = node.getChildCount()) > 0) {
            DefaultMutableTreeNode childNode = null;
            Object xtt2 = null;
            for (int i = 0; i < children_size; ++i) {
                childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                if (childNode == null) continue;
                this.reloadTreeStatus(childNode);
            }
        }
    }

    public void refreshTree(DefaultMutableTreeNode node, DefaultMutableTreeNode parentNode) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        DefaultTreeModel model = (DefaultTreeModel)this.treeTable.getTree().getModel();
        model.reload(node);
        if (parentNode != null) {
            model.reload(parentNode);
        }
        if (parentNode != null) {
            this.reloadTreeStatus(parentNode);
        } else {
            this.reloadTreeStatus(node);
        }
        this.refreshXTT();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void refreshToolButton_actionPerformed(ActionEvent e) {
        this.rightTopScrollPane.getViewport().removeAll();
        this.tree1 = new TableSchemaViewerTree();
        this.rightTopScrollPane.getViewport().add(this.tree1);
    }

    private DefaultMutableTreeNode getInvalidDefaultMutableTreeNode(DefaultMutableTreeNode fromNode, XTTTreeNodeInterface xtt2) {
        DefaultMutableTreeNode node = null;
        XTTTreeNodeInterface xttObj = null;
        int i = 0;
        int childCount = fromNode.getChildCount();
        if (i < childCount) {
            node = (DefaultMutableTreeNode)fromNode.getChildAt(i);
            xttObj = (XTTTreeNodeInterface)node.getUserObject();
            if (xtt2.equals(xttObj)) {
                return node;
            }
            return this.getInvalidDefaultMutableTreeNode(node, xtt2);
        }
        return fromNode;
    }

    public void Undo_MenuItem_actionPerformed(ActionEvent e) {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
        if (this.undoManager != null && this.undoManager.canUndo()) {
            this.menubar.Undo_MenuItem.setEnabled(true);
        } else {
            this.menubar.Undo_MenuItem.setEnabled(false);
        }
    }

    public void Find_MenuItem_actionPerformed(ActionEvent e) {
    }

    public void upToolButton_actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.treeTable.getTree().getSelectionPath().getLastPathComponent();
        XTTTreeNodeInterface xtt2 = (XTTTreeNodeInterface)dmtn.getUserObject();
        DefaultMutableTreeNode p_dmtn = dmtn.getPreviousSibling();
        XTTTreeNodeInterface p_xtt = (XTTTreeNodeInterface)p_dmtn.getUserObject();
        XTTTreeNodeInterface parentXTT = xtt2.getParent();
        p_dmtn.removeFromParent();
        int pos = parentXTT.getChildren().indexOf(p_xtt);
        ((QueryElement)parentXTT).remove(p_xtt);
        ((QueryElement)parentXTT).addChildAt(p_xtt, pos + 1);
        int index = ((DefaultMutableTreeNode)dmtn.getParent()).getIndex(dmtn);
        ((DefaultTreeModel)this.treeTable.getTree().getModel()).insertNodeInto(p_dmtn, (DefaultMutableTreeNode)dmtn.getParent(), index + 1);
        this.refreshTree((DefaultMutableTreeNode)dmtn.getParent(), null);
        TreePath p = new TreePath(dmtn.getPath());
        this.treeTable.getTree().makeVisible(p);
        int row = this.treeTable.getTree().getRowForPath(p);
        this.treeTable.getSelectionModel().setSelectionInterval(row, row);
        ((AbstractTableModel)this.treeTable.getModel()).fireTableChanged(new TableModelEvent(this.treeTable.getModel()));
        this.refreshXTT();
        ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).setModified(true);
        this.refresh_XTTCombo();
    }

    public void downToolButton_actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.treeTable.getTree().getSelectionPath().getLastPathComponent();
        XTTTreeNodeInterface xtt2 = (XTTTreeNodeInterface)dmtn.getUserObject();
        DefaultMutableTreeNode n_dmtn = dmtn.getNextSibling();
        XTTTreeNodeInterface n_xtt = (XTTTreeNodeInterface)n_dmtn.getUserObject();
        XTTTreeNodeInterface parentXTT = xtt2.getParent();
        dmtn.removeFromParent();
        int pos = parentXTT.getChildren().indexOf(xtt2);
        ((QueryElement)parentXTT).remove(xtt2);
        ((QueryElement)parentXTT).addChildAt(xtt2, pos + 1);
        int index = ((DefaultMutableTreeNode)n_dmtn.getParent()).getIndex(n_dmtn);
        ((DefaultTreeModel)this.treeTable.getTree().getModel()).insertNodeInto(dmtn, (DefaultMutableTreeNode)n_dmtn.getParent(), index + 1);
        this.refreshTree((DefaultMutableTreeNode)n_dmtn.getParent(), null);
        TreePath p = new TreePath(dmtn.getPath());
        this.treeTable.getTree().makeVisible(p);
        int row = this.treeTable.getTree().getRowForPath(p);
        this.treeTable.getSelectionModel().setSelectionInterval(row, row);
        ((AbstractTableModel)this.treeTable.getModel()).fireTableChanged(new TableModelEvent(this.treeTable.getModel()));
        this.refreshXTT();
        ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).setModified(true);
        this.refresh_XTTCombo();
    }

    public void openRecentFile(String ss) {
        int i;
        File f = new File(ss);
        if (!f.exists()) {
            String s1 = this.res.getString("not_exist_");
            String s2 = GuiUt.mapStringForProperty(s1, f.getAbsolutePath());
            GuiUt.showErrorDlg(this, s2, null);
            return;
        }
        String s = f.getAbsolutePath();
        XTTFileInfoObject file_info = null;
        int combo_size = this.xttToolBar.xttComboBox.getItemCount();
        boolean b = false;
        for (i = 0; i < combo_size; ++i) {
            file_info = (XTTFileInfoObject)this.xttToolBar.xttComboBox.getItemAt(i);
            if (!s.equals(file_info.getContent())) continue;
            b = true;
            break;
        }
        if (b) {
            this.xttToolBar.xttComboBox.setSelectedIndex(i);
            return;
        }
        String sx = f.getPath();
        sx = sx.substring(0, sx.indexOf(f.getName()));
        this.px.updateVariables(5, sx);
        this.tmpVector.removeAllElements();
        this.importFromXTT(f.getAbsolutePath());
        this.initTree(false, f.getAbsolutePath(), "");
    }

    private boolean validationXTT(boolean fromRun) {
        if (this.xttToolBar.xttComboBox.getItemCount() <= 0) {
            GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("No_any_xtt_file_be"));
            return false;
        }
        ((AbstractDisplayPanel)((JTabbedPane)this.getBottomPanel()).getSelectedComponent()).stopEditing();
        this.setCursor(Cursor.getPredefinedCursor(3));
        DefaultMutableTreeNode root_dmtn = (DefaultMutableTreeNode)this.treeTable.getTree().getPathForRow(0).getLastPathComponent();
        Template template = (Template)root_dmtn.getUserObject();
        Vector errorVector = new Vector();
        template.findInvalidNode(errorVector);
        if (errorVector.size() <= 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (!fromRun) {
                GuiUt.showInformationDlg(this, this.res.getString("Validation_success_"));
            }
            return true;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        ValidationInvalidPanel panel = new ValidationInvalidPanel(errorVector);
        ValidationResultDlg vrDlg = new ValidationResultDlg(panel);
        GuiUt.setCenterLocation(frame, vrDlg);
        vrDlg.setSize(500, 220);
        vrDlg.show();
        return false;
    }

    public void Generate_DTD_MenuItem_actionPerformed(ActionEvent e) {
        Vector<String> v = new Vector<String>();
        v.add("UTF-8");
        v.add("UTF-16LE");
        v.add("UTF-16BE");
        v.add("Local Code");
        XTTFileChooser chooser = null;
        chooser = this.px.getSelectedDirectory() != null && this.px.getSelectedDirectory().length() > 0 ? new XTTFileChooser(this.px.getSelectedDirectory(), v) : new XTTFileChooser(this.px.user_dir, v);
        chooser.addChoosableFileFilter(new DbaFileFilter("dtd", "XML Document Type Definition Files (*.dtd)"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(false);
        int state = chooser.showDialog(this, this.res.getString("Generate_DTD"));
        File file = chooser.getSelectedFile();
        String fileFilter_desc = chooser.getEncodingItem();
        if (fileFilter_desc.equalsIgnoreCase("Local Code")) {
            fileFilter_desc = this.system_encoding;
        }
        String xsdContent = "<?xml version=\"1.0\" encoding=\"";
        int exist = fileFilter_desc.indexOf("UTF-16");
        xsdContent = exist < 0 ? xsdContent + fileFilter_desc + "\"?>\n" : xsdContent + "UTF-16\"?>\n";
        if (file == null || state != 0) {
            return;
        }
        String filename = file.getAbsolutePath();
        if (filename.indexOf(".dtd") < 0) {
            filename = filename + ".dtd";
        }
        if ((file = new File(filename)).exists()) {
            String s1 = this.res.getString("Do_you_want_to");
            String s2 = GuiUt.mapStringForProperty(s1, file.getAbsoluteFile().toString());
            int reply = GuiUt.showOptionDlg(this, this.res.getString("Question"), s2);
            if (reply != 0) {
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        String sx = file.getPath();
        sx = sx.substring(0, sx.indexOf(file.getName()));
        this.px.updateVariables(5, sx);
        String s = "";
        Vector documentV = new Vector();
        this.root.scanTree4Generate(documentV);
        int size = documentV.size();
        DocumentInfoObject dio = null;
        for (int i = 0; i < size; ++i) {
            dio = (DocumentInfoObject)documentV.elementAt(i);
            s = s + dio.writeDuplicate(false);
        }
        xsdContent = xsdContent + s;
        short rc = XTTUt.writeXTTFileContent(file, fileFilter_desc, xsdContent);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (rc == 0) {
            GuiUt.showInformationDlg(this, GuiUt.mapStringForProperty(this.res.getString("xsddtd_generation_successful"), filename));
        }
    }

    public void Generate_XSD_MenuItem_actionPerformed(ActionEvent e) {
        Vector<String> v = new Vector<String>();
        v.add("UTF-8");
        v.add("UTF-16LE");
        v.add("UTF-16BE");
        v.add("Local Code");
        XTTFileChooser chooser = null;
        chooser = this.px.getSelectedDirectory() != null && this.px.getSelectedDirectory().length() > 0 ? new XTTFileChooser(this.px.getSelectedDirectory(), v) : new XTTFileChooser(this.px.user_dir, v);
        chooser.addChoosableFileFilter(new DbaFileFilter("xsd", "XML Schema Files (*.xsd)"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(false);
        int state = chooser.showDialog(this, this.res.getString("Generate_XSD"));
        File file = chooser.getSelectedFile();
        String fileFilter_desc = chooser.getEncodingItem();
        if (fileFilter_desc.equalsIgnoreCase("Local Code")) {
            fileFilter_desc = this.system_encoding;
        }
        String xsdContent = "<?xml version=\"1.0\" encoding=\"";
        int exist = fileFilter_desc.indexOf("UTF-16");
        xsdContent = exist < 0 ? xsdContent + fileFilter_desc + "\"?>\n" : xsdContent + "UTF-16\"?>\n";
        xsdContent = xsdContent + "<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n";
        if (file == null || state != 0) {
            return;
        }
        String filename = file.getAbsolutePath();
        if (filename.indexOf(".xsd") < 0) {
            filename = filename + ".xsd";
        }
        if ((file = new File(filename)).exists()) {
            String s1 = this.res.getString("Do_you_want_to");
            String s2 = GuiUt.mapStringForProperty(s1, file.getAbsoluteFile().toString());
            int reply = GuiUt.showOptionDlg(this, this.res.getString("Question"), s2);
            if (reply != 0) {
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        String sx = file.getPath();
        sx = sx.substring(0, sx.indexOf(file.getName()));
        this.px.updateVariables(5, sx);
        String s = "";
        Vector documentV = new Vector();
        this.root.scanTree4Generate(documentV);
        int size = documentV.size();
        DocumentInfoObject dio = null;
        for (int i = 0; i < size; ++i) {
            dio = (DocumentInfoObject)documentV.elementAt(i);
            s = s + dio.writeDuplicate(true);
        }
        xsdContent = xsdContent + s + "</xsd:schema>\n";
        short rc = XTTUt.writeXTTFileContent(file, fileFilter_desc, xsdContent);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (rc == 0) {
            GuiUt.showInformationDlg(this, GuiUt.mapStringForProperty(this.res.getString("xsddtd_generation_successful"), filename));
        }
    }

    public void DTD_Imported_MenuItem_actionPerformed(ActionEvent e) {
        JFileChooser chooser = null;
        chooser = this.px.getSelectedDirectory() != null && this.px.getSelectedDirectory().length() > 0 ? new JFileChooser(this.px.getSelectedDirectory()) : new JFileChooser(this.px.user_dir);
        chooser.setFileFilter(new DbaFileFilter("dtd", "XML Document Type Definition Files (*.dtd)"));
        int state = chooser.showDialog(this, this.res.getString("Import_from_DTD"));
        if (0 != state) {
            return;
        }
        File f = chooser.getSelectedFile();
        String s = f.getAbsolutePath();
        this.setCursor(Cursor.getPredefinedCursor(3));
        String sx = f.getPath();
        sx = sx.substring(0, sx.indexOf(f.getName()));
        this.px.updateVariables(5, sx);
        DTDHandler handler = new DTDHandler();
        handler.setRoot(new QueryElement());
        XSDDTDDisabledTreeNode xdtn = handler.getTreeNode(f.getAbsolutePath());
        if (xdtn != null) {
            XSDDTDTree xsdTree = new XSDDTDTree(xdtn);
            ImportPartXSDDTDDlg dlg = null;
            dlg = new ImportPartXSDDTDDlg((Frame)frame, xsdTree, this.res.getString("Choose_a_DTD_dom_tree"), true);
            GuiUt.setCenterLocation(this, dlg);
            dlg.show();
            if (dlg.getResult() == null) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.root = new Template();
            this.root.addChild(dlg.getResult());
            String emptyStr = this.getNextNewEditingFileName();
            dlg.setVisible(false);
            dlg.dispose();
            dlg = null;
            this.tmpVector.removeAllElements();
            this.initTree(false, emptyStr, f.getAbsolutePath());
            this.xttToolBar.replaceToggleButton_actionPerformed(null);
            this.xttToolBar.addToggleButton_actionPerformed(null);
        }
    }

    public void XSD_Imported_MenuItem_actionPerformed(ActionEvent e) {
        JFileChooser chooser = null;
        chooser = this.px.getSelectedDirectory() != null && this.px.getSelectedDirectory().length() > 0 ? new JFileChooser(this.px.getSelectedDirectory()) : new JFileChooser(this.px.user_dir);
        chooser.setFileFilter(new DbaFileFilter("xsd", "XML Transfer Template Files (*.xsd)"));
        int state = chooser.showDialog(this, this.res.getString("Import_from_XSD"));
        if (0 != state) {
            return;
        }
        File f = chooser.getSelectedFile();
        this.setCursor(Cursor.getPredefinedCursor(3));
        String sx = f.getPath();
        sx = sx.substring(0, sx.indexOf(f.getName()));
        this.px.updateVariables(5, sx);
        QueryElement qe = this.loadTemplateFromXSD(f.getAbsolutePath());
        if (qe != null) {
            XSDDTDDisabledTreeNode xdtn = XTTTree.getXSDTree(qe);
            XSDDTDTree xsdTree = new XSDDTDTree(xdtn);
            ImportPartXSDDTDDlg dlg = null;
            dlg = new ImportPartXSDDTDDlg((Frame)frame, xsdTree, this.res.getString("Choose_a_XSD_dom_tree"), false);
            GuiUt.setCenterLocation(this, dlg);
            dlg.show();
            if (dlg.getResult() == null) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.root = new Template();
            this.root.addChild(dlg.getResult());
            dlg.dispose();
            String trueFileName = f.getAbsolutePath();
            String s = this.getNextNewEditingFileName();
            this.tmpVector.removeAllElements();
            this.initTree(false, s, trueFileName);
            this.xttToolBar.replaceToggleButton_actionPerformed(null);
            this.xttToolBar.addToggleButton_actionPerformed(null);
        }
    }

    public void Validation_MenuItem_actionPerformed(ActionEvent e) {
        this.validationXTT(false);
    }

    public void Website_MenuItem_actionPerformed(ActionEvent e) {
        if (LocaleManager.getLanguageChoice() == 1) {
            WebBrowser.displayURL(this, "http://www.dbmaker.com.tw");
        } else if (LocaleManager.getLanguageChoice() == 0 || LocaleManager.getLanguageChoice() == 3) {
            WebBrowser.displayURL(this, "http://www.dbmaker.com");
        } else {
            WebBrowser.displayURL(this, "http://www.dbmaker.co.jp");
        }
    }

    public void Run_MenuItem_actionPerformed(ActionEvent e) {
        if (this.validationXTT(true)) {
            if (this.xttToolBar.xttComboBox.getItemCount() <= 0) {
                GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("No_any_xtt_file_be"));
                return;
            }
            XTTFileInfoObject file_info = (XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem();
            if (file_info.getContent().startsWith("untitle")) {
                this.SaveAs_MenuItem_actionPerformed(null);
            } else if (file_info.isModified()) {
                this.Save_MenuItem_actionPerformed(null);
            }
            if (((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).getContent().startsWith("untitle") && ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).isModified()) {
                return;
            }
            String parameter = "";
            if (this.root.isParameters()) {
                ParameterDlg dlg = null;
                dlg = new ParameterDlg((Frame)frame, this.root);
                GuiUt.setCenterLocation(this, dlg);
                dlg.setModal(true);
                dlg.setSize(350, 350);
                dlg.show();
                dlg.dtm.setCellEditable(true);
                dlg.dtm.addEmptyRow();
                parameter = dlg.getResult();
                dlg.dispose();
            }
            XTT xmlTransfer = new XTT();
            String tmpFileAbsolutePath = null;
            File out = null;
            try {
                if (((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).getContent().startsWith("untitle") && ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).isModified()) {
                    return;
                }
                xmlTransfer.setXtt(((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).getContent());
                out = File.createTempFile(Long.toString(new Date().getTime()), ".xml");
                tmpFileAbsolutePath = out.getAbsolutePath();
                xmlTransfer.setOutputXml(tmpFileAbsolutePath);
                xmlTransfer.setParameters(parameter);
                xmlTransfer.setDatabaseConnection((JdbcOdbcConnection)this.conn.dbconn);
                int reply = xmlTransfer.run();
                System.out.println("reply = " + reply);
                if (reply == 0) {
                    if (this.px.getViewRunningResultForBoolean()) {
                        WebBrowser.displayURL(this, out.getAbsolutePath());
                    } else {
                        WebBrowser.displayNotepad(this, out.getAbsolutePath());
                    }
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    ErrorLogDlg dlg = null;
                    dlg = new ErrorLogDlg((Frame)frame, Integer.toString(reply) + " : " + xmlTransfer.getError());
                    GuiUt.setCenterLocation(this, dlg);
                    dlg.setModal(true);
                    dlg.setSize(500, 350);
                    dlg.show();
                }
            }
            catch (Exception ioe) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                GuiUt.showErrorDlg(this, ioe.getMessage(), null);
                return;
            }
        }
    }

    public void Close_MenuItem_actionPerformed(ActionEvent e) {
        XTTFileInfoObject file_info = (XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem();
        int isEmpty = this.emptyXTTVector.indexOf(file_info.getContent());
        if (file_info.isModified()) {
            String s1 = this.res.getString("Save_changed_to");
            String s2 = GuiUt.mapStringForProperty(s1, file_info.getContent());
            int reply = GuiUt.showOption3Dlg(this, "XML Transfer Template", s2);
            if (isEmpty >= 0) {
                if (reply == 0) {
                    this.SaveAs_MenuItem_actionPerformed(null);
                } else if (reply != 1 && reply == 2) {
                    return;
                }
            } else if (reply == 0) {
                this.Save_MenuItem_actionPerformed(null);
            } else if (reply != 1 && reply == 2) {
                return;
            }
        }
        int index = this.xttToolBar.xttComboBox.getSelectedIndex();
        this.xtt_cbm.removeElementAt(index);
        this.xttToolBar.xttComboBox.revalidate();
        this.xttToolBar.xttComboBox.repaint();
        this.repaint();
        if (this.xttToolBar.xttComboBox.getItemCount() > 0) {
            this.xttToolBar.xttComboBox.setSelectedIndex(0);
        } else {
            this.setTitle("XML Transfer Template");
            this.xttToolBar.saveToolButton.setEnabled(false);
            this.menubar.Save_MenuItem.setEnabled(false);
            this.menubar.SaveAs_MenuItem.setEnabled(false);
            this.menubar.Generate_DTD_MenuItem.setEnabled(false);
            this.menubar.Generate_XSD_MenuItem.setEnabled(false);
            this.menubar.Close_MenuItem.setEnabled(false);
            this.menubar.Undo_MenuItem.setEnabled(false);
            this.xttToolBar.closeToolButton.setEnabled(false);
            this.xttToolBar.runToolButton.setEnabled(false);
            if (!this.isConnect) {
                this.menubar.Disconnect_MenuItem.setEnabled(false);
            } else {
                this.menubar.Disconnect_MenuItem.setEnabled(true);
            }
            this.menubar.Validation_MenuItem.setEnabled(false);
            this.menubar.Run_MenuItem.setEnabled(false);
            this.xttToolBar.elementToolButton.setEnabled(false);
            this.xttToolBar.attributeToolButton.setEnabled(false);
            this.xttToolBar.upToolButton.setEnabled(false);
            this.xttToolBar.downToolButton.setEnabled(false);
            this.menubar.Insert_Menu.setEnabled(false);
            this.menubar.Copy_MenuItem.setEnabled(false);
            this.menubar.Cut_MenuItem.setEnabled(false);
            this.menubar.Paste_MenuItem.setEnabled(false);
            this.menubar.Remove_MenuItem.setEnabled(false);
            this.xttToolBar.removeToolButton.setEnabled(false);
            this.menubar.Element_MenuItem.setEnabled(false);
            this.menubar.Attribute_MenuItem.setEnabled(false);
            this.xttpanels.setSelectedIndex(0);
            this.xttpanels.setEnabledAt(1, false);
            this.bottomPanel.removeAll();
            this.bottomPanel.revalidate();
            this.bottomPanel.repaint();
            this.designPanel.removeAll();
        }
    }

    public void Copy_MenuItem_actionPerformed(ActionEvent e) {
        this.copyTreePath = this.treeTable.getTree().getPathForRow(this.treeTable.getSelectedRow());
        if (this.copyTreePath == null) {
            GuiUt.showErrorDlg(this, this.res.getString("Please_select_a_tree"), null);
            return;
        }
        this.copy_dmtn = (DefaultMutableTreeNode)this.copyTreePath.getLastPathComponent();
        if (this.copy_dmtn.isRoot()) {
            GuiUt.showErrorDlg(this, this.res.getString("Tree_root_node_cannot"), null);
            this.copy_dmtn = null;
            return;
        }
        this.transferXTT = ((XTTTreeNodeInterface)this.copy_dmtn.getUserObject()).duplicateSelf();
        if (((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).isModified()) {
            return;
        }
        ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).setModified(false);
        this.refresh_XTTCombo();
    }

    public void Cut_MenuItem_actionPerformed(ActionEvent e) {
        this.copyTreePath = this.treeTable.getTree().getPathForRow(this.treeTable.getSelectedRow());
        if (this.copyTreePath == null) {
            GuiUt.showErrorDlg(this, this.res.getString("Please_select_a_tree"), null);
            return;
        }
        this.copy_dmtn = (DefaultMutableTreeNode)this.copyTreePath.getLastPathComponent();
        if (this.copy_dmtn.isRoot()) {
            GuiUt.showErrorDlg(this, this.res.getString("Tree_root_node_cannot"), null);
            this.copy_dmtn = null;
            return;
        }
        this.transferXTT = (XTTTreeNodeInterface)this.copy_dmtn.getUserObject();
        XTTTreeNodeInterface parentXTT = this.transferXTT.getParent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.copy_dmtn.getParent();
        DefaultMutableTreeNode sibling_dmtn = null;
        if (this.copy_dmtn.getSiblingCount() > 0 && (sibling_dmtn = this.copy_dmtn.getNextSibling()) == null) {
            sibling_dmtn = this.copy_dmtn.getPreviousSibling();
        }
        int dmtn_pos = parentNode.getIndex(this.copy_dmtn);
        int xtt_pos = parentXTT.getChildren().indexOf(this.transferXTT);
        parentNode.remove(this.copy_dmtn);
        parentXTT.remove(this.transferXTT);
        this.refreshTree(this.copy_dmtn, parentNode);
        TreePath path = null;
        path = sibling_dmtn != null ? new TreePath(sibling_dmtn.getPath()) : new TreePath(parentNode.getPath());
        this.treeTable.getTree().makeVisible(path);
        this.treeTable.getTree().setSelectionRow(this.treeTable.getTree().getRowForPath(path));
        this.treeTable.getTree().scrollPathToVisible(path);
        ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).setModified(true);
        frame.refresh_XTTCombo();
        DeleteNodeUndoEdit edit = new DeleteNodeUndoEdit(this.treeTable, this.transferXTT, parentXTT, dmtn_pos, xtt_pos);
        this.undoSupport.postEdit(edit);
        this.menubar.Undo_MenuItem.setEnabled(true);
        this.from = this.undoManager.getUndoQueueSize();
    }

    public void Save_MenuItem_actionPerformed(ActionEvent e) {
        XTTFileInfoObject file_info = (XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem();
        int isEmpty = this.emptyXTTVector.indexOf(file_info.getContent());
        if (file_info.getEncoding().length() <= 0) {
            file_info.setEncoding(this.system_encoding);
        }
        String xttContent = this.root.write(0);
        xttContent = file_info.getEncoding().indexOf("UTF-16") < 0 ? "<?xml version=\"1.0\" encoding=\"" + file_info.getEncoding() + "\"?>\n" + xttContent : "<?xml version=\"1.0\" encoding=\"UTF-16\"?>\n" + xttContent;
        if (isEmpty >= 0) {
            if (file_info.isModified()) {
                this.SaveAs_MenuItem_actionPerformed(null);
            }
        } else if (file_info.isModified()) {
            XTTUt.writeXTTFileContent(new File(file_info.getContent()), file_info.getEncoding(), xttContent);
            file_info.setModified(false);
            this.refresh_XTTCombo();
        }
    }

    public void SaveAs_MenuItem_actionPerformed(ActionEvent e) {
        XTTFileInfoObject file_info = (XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem();
        XTTFileChooser chooser = null;
        Vector<String> v = new Vector<String>();
        v.add("UTF-8");
        v.add("UTF-16LE");
        v.add("UTF-16BE");
        v.add("Local Code");
        if (this.emptyXTTVector.indexOf(file_info.getContent()) >= 0) {
            chooser = new XTTFileChooser(this.px.getSelectedDirectory(), v);
        } else {
            chooser = new XTTFileChooser(file_info.getContent(), v);
            File f = new File(file_info.getContent());
            chooser.setSelectedFile(f.getAbsoluteFile());
        }
        chooser.addChoosableFileFilter(new DbaFileFilter("xtt", "XML Transfer Template Files (*.xtt)"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(false);
        int state = chooser.showDialog(this, this.res.getString("Save_As_"));
        File file = chooser.getSelectedFile();
        String fileFilter_desc = chooser.getEncodingItem();
        if (fileFilter_desc.equalsIgnoreCase("UTF-8")) {
            file_info.setEncoding("UTF-8");
        } else if (fileFilter_desc.equalsIgnoreCase("UTF-16LE")) {
            file_info.setEncoding("UTF-16LE");
        } else if (fileFilter_desc.equalsIgnoreCase("UTF-16BE")) {
            file_info.setEncoding("UTF-16BE");
        } else {
            file_info.setEncoding(this.system_encoding);
        }
        String xttContent = this.root.write(0);
        xttContent = file_info.getEncoding().indexOf("UTF-16") < 0 ? "<?xml version=\"1.0\" encoding=\"" + file_info.getEncoding() + "\"?>\n" + xttContent : "<?xml version=\"1.0\" encoding=\"UTF-16\"?>\n" + xttContent;
        if (file != null && state == 0) {
            String filename = file.getAbsolutePath();
            if (filename.indexOf(".") < 0) {
                filename = filename + ".xtt";
            }
            if (!(file = new File(filename)).exists()) {
                XTTUt.writeXTTFileContent(file, file_info.getEncoding(), xttContent);
                file_info.setContent(file.getAbsolutePath());
                file_info.setModified(false);
                this.refresh_XTTCombo();
                String sx = file_info.getContent();
                sx = sx.substring(0, sx.indexOf(file.getName()));
                this.px.updateVariables(5, sx);
                this.menubar.insertPreviousOpenFile(file_info.getContent());
            } else {
                String s1 = this.res.getString("Do_you_want_to");
                String s2 = GuiUt.mapStringForProperty(s1, file.getName());
                int reply = GuiUt.showOptionDlg(this, this.res.getString("Question"), s2);
                if (reply == 0) {
                    XTTUt.writeXTTFileContent(file, file_info.getEncoding(), xttContent);
                    file_info.setContent(file.getAbsolutePath());
                    file_info.setModified(false);
                    this.refresh_XTTCombo();
                    String sx = file_info.getContent();
                    sx = sx.substring(0, sx.indexOf(file.getName()));
                    this.px.updateVariables(5, sx);
                    this.menubar.insertPreviousOpenFile(file_info.getContent());
                }
            }
        }
    }

    public void Paste_MenuItem_actionPerformed(ActionEvent e) {
        int row = this.treeTable.getSelectedRow();
        this.pasteTreePath = this.treeTable.getTree().getPathForRow(row);
        if (this.pasteTreePath == null) {
            GuiUt.showErrorDlg(this, this.res.getString("Please_select_a_tree1"), null);
            return;
        }
        this.paste_dmtn = (DefaultMutableTreeNode)this.pasteTreePath.getLastPathComponent();
        XTTTreeNodeInterface pasteXTT = (XTTTreeNodeInterface)this.paste_dmtn.getUserObject();
        int pasteNodeLevel = this.paste_dmtn.getLevel();
        if (pasteNodeLevel == 0) {
            if (pasteXTT.getChildren() != null && pasteXTT.getChildren().size() == 1) {
                if (this.px.getNodeAsChildSettingForBoolean()) {
                    GuiUt.showErrorDlg(this, this.res.getString("XTT_template_node"), null);
                    return;
                }
                GuiUt.showErrorDlg(this, this.res.getString("XTT_template_node1"), null);
                return;
            }
            if (!this.px.getNodeAsChildSettingForBoolean()) {
                GuiUt.showErrorDlg(this, this.res.getString("XTT_template_node1"), null);
                return;
            }
        }
        if (pasteNodeLevel == 1 && !this.px.getNodeAsChildSettingForBoolean()) {
            GuiUt.showErrorDlg(this, this.res.getString("XTT_template_root"), null);
            return;
        }
        if (pasteXTT instanceof Attribute && this.px.getNodeAsChildSettingForBoolean()) {
            GuiUt.showErrorDlg(this, this.res.getString("Tree_ATTRIBUTE_node"), null);
            return;
        }
        if (this.transferXTT == null) {
            GuiUt.showErrorDlg(this, this.res.getString("Please_do_a_COPY"), null);
            return;
        }
        XTTTreeNodeInterface tempTransferXTT = this.transferXTT.duplicateSelf();
        DefaultMutableTreeNode transfer_dmtn = XTTTree.getShortTree(tempTransferXTT);
        tempTransferXTT.setDefaultMutableTreeNode(transfer_dmtn);
        if (this.px.getNodeAsChildSettingForBoolean()) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.paste_dmtn.getParent();
            XTTTreeNodeInterface parentXTT = null;
            if (parentNode != null) {
                parentXTT = (XTTTreeNodeInterface)parentNode.getUserObject();
            }
            int break_line = 0;
            int child_size = 0;
            if (pasteXTT.getChildren() != null) {
                break_line = child_size = pasteXTT.getChildren().size();
            }
            if (tempTransferXTT instanceof Attribute) {
                for (int i = 0; i < child_size; ++i) {
                    if (!(pasteXTT.getChildren().elementAt(i) instanceof QueryElement)) continue;
                    break_line = i;
                    break;
                }
                Attribute att = (Attribute)tempTransferXTT;
                if (this.px.getNodeAsChildSettingForBoolean()) {
                    if (XTTUt.isDuplicateAttributeNameInDropAction(att.getName(), pasteXTT)) {
                        GuiUt.showErrorDlg(this, this.res.getString("This_attribute_name"), null);
                        return;
                    }
                } else {
                    if (pasteXTT.getParent() == null) {
                        pasteXTT.setParent(parentXTT);
                    }
                    if (XTTUt.isDuplicateAttributeNameInDropAction(att.getName(), pasteXTT)) {
                        GuiUt.showErrorDlg(this, this.res.getString("This_attribute_name"), null);
                        return;
                    }
                }
            }
            QueryElement qe = null;
            Template template = null;
            if (pasteXTT instanceof Template) {
                template = (Template)pasteXTT;
                template.addChild(tempTransferXTT);
            } else {
                qe = (QueryElement)pasteXTT;
                qe.addChildAt(tempTransferXTT, break_line);
            }
            ((DefaultTreeModel)this.treeTable.getTree().getModel()).insertNodeInto(transfer_dmtn, this.paste_dmtn, break_line);
            TreePath p = new TreePath(transfer_dmtn.getPath());
            this.treeTable.getTree().makeVisible(p);
            int r = this.treeTable.getTree().getRowForPath(p);
            this.treeTable.getSelectionModel().setSelectionInterval(r, r);
            ((AbstractTableModel)this.treeTable.getModel()).fireTableChanged(new TableModelEvent(this.treeTable.getModel()));
            InsertNodeEdit edit = new InsertNodeEdit(this.treeTable, row, tempTransferXTT);
            this.undoSupport.postEdit(edit);
            this.menubar.Undo_MenuItem.setEnabled(true);
            this.from = this.undoManager.getUndoQueueSize();
        } else {
            Attribute att;
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.paste_dmtn.getParent();
            XTTTreeNodeInterface parentXTT = (XTTTreeNodeInterface)parentNode.getUserObject();
            if (parentXTT instanceof Template && parentXTT.getChildren() != null && parentXTT.getChildren().size() >= 1) {
                GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("Template_node_just"));
                return;
            }
            if (tempTransferXTT instanceof Attribute && XTTUt.isDuplicateAttributeNameInDropAction((att = (Attribute)tempTransferXTT).getName(), parentXTT)) {
                GuiUt.showErrorDlg(this, this.res.getString("This_attribute_name"), null);
                return;
            }
            if (pasteXTT.getParent() == null) {
                pasteXTT.setParent(parentXTT);
            }
            pasteXTT.addNextSibling(tempTransferXTT);
            int item_pos = parentXTT.getChildren().indexOf(tempTransferXTT);
            ((DefaultTreeModel)this.treeTable.getTree().getModel()).insertNodeInto(transfer_dmtn, parentNode, item_pos);
            TreePath p = new TreePath(transfer_dmtn.getPath());
            this.treeTable.getTree().makeVisible(p);
            int r = this.treeTable.getTree().getRowForPath(p);
            this.treeTable.getSelectionModel().setSelectionInterval(r, r);
            ((AbstractTableModel)this.treeTable.getModel()).fireTableChanged(new TableModelEvent(this.treeTable.getModel()));
            InsertNodeEdit edit = new InsertNodeEdit(this.treeTable, row, tempTransferXTT);
            this.undoSupport.postEdit(edit);
            this.menubar.Undo_MenuItem.setEnabled(true);
            this.from = this.undoManager.getUndoQueueSize();
        }
        ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).setModified(true);
        this.refresh_XTTCombo();
    }

    private void setButtonStatus4UpDown(XTTTreeNodeInterface xtt2) {
        DefaultMutableTreeNode dmtn = xtt2.getDefaultMutableTreeNode();
        DefaultMutableTreeNode sibling_dmtn = dmtn.getPreviousSibling();
        XTTTreeNodeInterface sibling_xtt = null;
        if (sibling_dmtn != null) {
            sibling_xtt = (XTTTreeNodeInterface)sibling_dmtn.getUserObject();
            if (xtt2 instanceof QueryElement) {
                if (sibling_xtt instanceof QueryElement) {
                    this.xttToolBar.upToolButton.setEnabled(true);
                } else if (sibling_xtt instanceof Attribute) {
                    this.xttToolBar.upToolButton.setEnabled(false);
                }
            } else if (xtt2 instanceof Attribute) {
                if (sibling_xtt instanceof QueryElement) {
                    this.xttToolBar.upToolButton.setEnabled(false);
                } else if (sibling_xtt instanceof Attribute) {
                    this.xttToolBar.upToolButton.setEnabled(true);
                }
            }
        } else {
            this.xttToolBar.upToolButton.setEnabled(false);
        }
        sibling_dmtn = dmtn.getNextSibling();
        if (sibling_dmtn != null) {
            sibling_xtt = (XTTTreeNodeInterface)sibling_dmtn.getUserObject();
            if (xtt2 instanceof QueryElement) {
                if (sibling_xtt instanceof QueryElement) {
                    this.xttToolBar.downToolButton.setEnabled(true);
                } else if (sibling_xtt instanceof Attribute) {
                    this.xttToolBar.downToolButton.setEnabled(false);
                }
            } else if (xtt2 instanceof Attribute) {
                if (sibling_xtt instanceof QueryElement) {
                    this.xttToolBar.downToolButton.setEnabled(false);
                } else if (sibling_xtt instanceof Attribute) {
                    this.xttToolBar.downToolButton.setEnabled(true);
                }
            }
        } else {
            this.xttToolBar.downToolButton.setEnabled(false);
        }
    }

    public void setButtonStatus(XTTTreeNodeInterface xtt2) {
        if (xtt2 instanceof Template) {
            if (xtt2.getChildren() == null || xtt2.getChildren().size() <= 0) {
                this.xttToolBar.elementToolButton.setEnabled(true);
                this.xttToolBar.attributeToolButton.setEnabled(false);
                this.menubar.Element_MenuItem.setEnabled(true);
                this.menubar.Attribute_MenuItem.setEnabled(false);
                if (this.px.getNodeAsChildSettingForBoolean()) {
                    this.menubar.Paste_MenuItem.setEnabled(true);
                } else {
                    this.menubar.Paste_MenuItem.setEnabled(false);
                }
            } else if (xtt2.getChildren().size() < 1) {
                this.xttToolBar.elementToolButton.setEnabled(true);
                this.xttToolBar.attributeToolButton.setEnabled(true);
                this.menubar.Element_MenuItem.setEnabled(true);
                this.menubar.Attribute_MenuItem.setEnabled(true);
                if (this.px.getNodeAsChildSettingForBoolean()) {
                    this.menubar.Paste_MenuItem.setEnabled(true);
                } else {
                    this.menubar.Paste_MenuItem.setEnabled(false);
                }
            } else {
                this.xttToolBar.elementToolButton.setEnabled(false);
                this.xttToolBar.attributeToolButton.setEnabled(false);
                this.menubar.Element_MenuItem.setEnabled(false);
                this.menubar.Attribute_MenuItem.setEnabled(false);
                this.menubar.Paste_MenuItem.setEnabled(false);
            }
            this.menubar.Remove_MenuItem.setEnabled(false);
            this.xttToolBar.removeToolButton.setEnabled(false);
            this.menubar.Insert_Menu.setEnabled(false);
            this.menubar.Copy_MenuItem.setEnabled(false);
            this.menubar.Cut_MenuItem.setEnabled(false);
            this.xttToolBar.upToolButton.setEnabled(false);
            this.xttToolBar.downToolButton.setEnabled(false);
        } else if (xtt2 instanceof QueryElement) {
            if (xtt2.getParent() instanceof Template) {
                if (!this.px.getNodeAsChildSettingForBoolean()) {
                    this.xttToolBar.elementToolButton.setEnabled(false);
                    this.xttToolBar.attributeToolButton.setEnabled(false);
                    this.menubar.Element_MenuItem.setEnabled(false);
                    this.menubar.Attribute_MenuItem.setEnabled(false);
                } else {
                    this.xttToolBar.elementToolButton.setEnabled(true);
                    this.xttToolBar.attributeToolButton.setEnabled(true);
                    this.menubar.Element_MenuItem.setEnabled(true);
                    this.menubar.Attribute_MenuItem.setEnabled(true);
                }
                this.xttToolBar.upToolButton.setEnabled(false);
                this.xttToolBar.downToolButton.setEnabled(false);
            } else {
                this.xttToolBar.elementToolButton.setEnabled(true);
                this.xttToolBar.attributeToolButton.setEnabled(true);
                this.menubar.Element_MenuItem.setEnabled(true);
                this.menubar.Attribute_MenuItem.setEnabled(true);
            }
            this.menubar.Remove_MenuItem.setEnabled(true);
            this.xttToolBar.removeToolButton.setEnabled(true);
            this.menubar.Insert_Menu.setEnabled(true);
            this.menubar.Copy_MenuItem.setEnabled(true);
            this.menubar.Cut_MenuItem.setEnabled(true);
            this.menubar.Paste_MenuItem.setEnabled(true);
            this.setButtonStatus4UpDown(xtt2);
        } else if (xtt2 instanceof Attribute) {
            if (!this.px.getNodeAsChildSettingForBoolean()) {
                this.xttToolBar.elementToolButton.setEnabled(true);
                this.xttToolBar.attributeToolButton.setEnabled(true);
                this.menubar.Element_MenuItem.setEnabled(true);
                this.menubar.Attribute_MenuItem.setEnabled(true);
            } else {
                this.xttToolBar.elementToolButton.setEnabled(false);
                this.xttToolBar.attributeToolButton.setEnabled(false);
                this.menubar.Element_MenuItem.setEnabled(false);
                this.menubar.Attribute_MenuItem.setEnabled(false);
            }
            this.menubar.Remove_MenuItem.setEnabled(true);
            this.xttToolBar.removeToolButton.setEnabled(true);
            this.menubar.Insert_Menu.setEnabled(true);
            this.menubar.Copy_MenuItem.setEnabled(true);
            this.menubar.Cut_MenuItem.setEnabled(true);
            this.menubar.Paste_MenuItem.setEnabled(true);
            this.setButtonStatus4UpDown(xtt2);
        } else {
            this.xttToolBar.elementToolButton.setEnabled(false);
            this.xttToolBar.attributeToolButton.setEnabled(false);
            this.menubar.Remove_MenuItem.setEnabled(false);
            this.xttToolBar.removeToolButton.setEnabled(false);
            this.menubar.Element_MenuItem.setEnabled(false);
            this.menubar.Attribute_MenuItem.setEnabled(false);
            this.menubar.Insert_Menu.setEnabled(true);
            this.menubar.Copy_MenuItem.setEnabled(true);
            this.menubar.Cut_MenuItem.setEnabled(true);
            this.menubar.Paste_MenuItem.setEnabled(true);
            this.setButtonStatus4UpDown(xtt2);
        }
        if (this.undoManager != null && this.undoManager.canUndo()) {
            this.menubar.Undo_MenuItem.setEnabled(true);
        } else {
            this.menubar.Undo_MenuItem.setEnabled(false);
        }
    }

    public void addObjectInTreeTable(XTTTreeNodeInterface addingXTTObject, DefaultMutableTreeNode selectedNode) {
        DefaultMutableTreeNode child_dmtn = new DefaultMutableTreeNode(addingXTTObject);
        addingXTTObject.setDefaultMutableTreeNode(child_dmtn);
        XTTTreeNodeInterface xtt2 = (XTTTreeNodeInterface)selectedNode.getUserObject();
        if (xtt2 instanceof Template && xtt2.getChildren() != null && xtt2.getChildren().size() >= 1) {
            GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("Template_node_just"));
            return;
        }
        if (this.px.getNodeAsChildSettingForBoolean()) {
            int break_line = 0;
            int child_size = 0;
            if (xtt2.getChildren() != null) {
                break_line = child_size = xtt2.getChildren().size();
            }
            if (addingXTTObject instanceof Attribute) {
                for (int i = 0; i < child_size; ++i) {
                    if (!(xtt2.getChildren().elementAt(i) instanceof QueryElement)) continue;
                    break_line = i;
                    break;
                }
            }
            if (xtt2 instanceof QueryElement) {
                QueryElement qe = (QueryElement)xtt2;
                qe.addChildAt(addingXTTObject, break_line);
            } else if (xtt2 instanceof Template) {
                Template template = (Template)xtt2;
                template.addChild(addingXTTObject);
            }
            ((DefaultTreeModel)this.treeTable.getTree().getModel()).insertNodeInto(child_dmtn, selectedNode, break_line);
            TreePath p = new TreePath(child_dmtn.getPath());
            this.treeTable.getTree().makeVisible(p);
            int row = this.treeTable.getTree().getRowForPath(p);
            this.treeTable.getSelectionModel().setSelectionInterval(row, row);
            ((AbstractTableModel)this.treeTable.getModel()).fireTableChanged(new TableModelEvent(this.treeTable.getModel()));
        } else {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selectedNode.getParent();
            XTTTreeNodeInterface parentXTT = (XTTTreeNodeInterface)parentNode.getUserObject();
            if (parentXTT instanceof Template && parentXTT.getChildren() != null && parentXTT.getChildren().size() >= 1) {
                GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("Template_node_just1"));
                return;
            }
            if (xtt2.getParent() == null) {
                xtt2.setParent(parentXTT);
            }
            addingXTTObject.setParent(parentXTT);
            xtt2.addNextSibling(addingXTTObject);
            int item_pos = parentXTT.getChildren().indexOf(addingXTTObject);
            ((DefaultTreeModel)this.treeTable.getTree().getModel()).insertNodeInto(child_dmtn, parentNode, item_pos);
            TreePath p = new TreePath(child_dmtn.getPath());
            this.treeTable.getTree().makeVisible(p);
            int row = this.treeTable.getTree().getRowForPath(p);
            this.treeTable.getSelectionModel().setSelectionInterval(row, row);
            ((AbstractTableModel)this.treeTable.getModel()).fireTableChanged(new TableModelEvent(this.treeTable.getModel()));
        }
        if (addingXTTObject instanceof QueryElement) {
            ((JTabbedPane)this.bottomPanel.getComponent(0)).setSelectedIndex(0);
            ((ElementMainPanel)((JTabbedPane)this.bottomPanel.getComponent((int)0)).getComponentAt((int)0)).elementNameTextField.grabFocus();
        } else {
            ((JTabbedPane)this.bottomPanel.getComponent(0)).setSelectedIndex(0);
            ((AttributeMainPanel)((JTabbedPane)this.bottomPanel.getComponent((int)0)).getComponentAt((int)0)).attributeNameTextField.grabFocus();
        }
    }

    public void Remove_MenuItem_actionPerformed(ActionEvent e) {
        int row = this.treeTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.treeTable.getValueAt(row, 0);
        if (dmtn == null) {
            return;
        }
        XTTTreeNodeInterface selfXTT = (XTTTreeNodeInterface)dmtn.getUserObject();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)dmtn.getParent();
        XTTTreeNodeInterface parentXTT = (XTTTreeNodeInterface)parentNode.getUserObject();
        DefaultMutableTreeNode sibling_dmtn = null;
        if (dmtn.getSiblingCount() > 0 && (sibling_dmtn = dmtn.getNextSibling()) == null) {
            sibling_dmtn = dmtn.getPreviousSibling();
        }
        int dmtn_pos = parentNode.getIndex(dmtn);
        int xtt_pos = parentXTT.getChildren().indexOf(selfXTT);
        parentNode.remove(dmtn);
        parentXTT.remove(selfXTT);
        this.refreshTree(parentNode, null);
        TreePath path = null;
        path = sibling_dmtn != null ? new TreePath(sibling_dmtn.getPath()) : new TreePath(parentNode.getPath());
        this.treeTable.getTree().expandPath(path);
        row = this.treeTable.getTree().getRowForPath(path);
        this.treeTable.getSelectionModel().setSelectionInterval(row, row);
        this.treeTable.setResetTree(true);
        this.treeTable.getTree().setSelectionPath(path);
        this.treeTable.setResetTree(false);
        ((AbstractTableModel)this.treeTable.getModel()).fireTableChanged(new TableModelEvent(this.treeTable.getModel()));
        this.refreshXTT();
        ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).setModified(true);
        frame.refresh_XTTCombo();
        DeleteNodeUndoEdit edit = new DeleteNodeUndoEdit(this.treeTable, selfXTT, parentXTT, dmtn_pos, xtt_pos);
        this.undoSupport.postEdit(edit);
        this.menubar.Undo_MenuItem.setEnabled(true);
        this.from = this.undoManager.getUndoQueueSize();
    }

    public void elementToolButton_actionPerformed(ActionEvent e) {
        int row = this.treeTable.getSelectedRow();
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.treeTable.getValueAt(row, 0);
        XTTTreeNodeInterface xtt2 = (XTTTreeNodeInterface)dmtn.getUserObject();
        if (xtt2 instanceof Template && !this.px.getNodeAsChildSettingForBoolean()) {
            GuiUt.showErrorDlg(this, this.res.getString("Template_node_must_be"), null);
            return;
        }
        QueryElement newQueryElement = new QueryElement();
        this.addObjectInTreeTable(newQueryElement, dmtn);
        ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).setModified(true);
        this.refresh_XTTCombo();
        InsertNodeEdit edit = new InsertNodeEdit(this.treeTable, row, newQueryElement);
        this.undoSupport.postEdit(edit);
        this.menubar.Undo_MenuItem.setEnabled(true);
        this.from = this.undoManager.getUndoQueueSize();
    }

    public void attributeToolButton_actionPerformed(ActionEvent e) {
        int row = this.treeTable.getSelectedRow();
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)this.treeTable.getValueAt(row, 0);
        Attribute att = new Attribute();
        this.addObjectInTreeTable(att, dmtn);
        ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).setModified(true);
        this.refresh_XTTCombo();
        InsertNodeEdit edit = new InsertNodeEdit(this.treeTable, row, att);
        this.undoSupport.postEdit(edit);
        this.menubar.Undo_MenuItem.setEnabled(true);
        this.from = this.undoManager.getUndoQueueSize();
    }

    public void xttComboBox_actionPerformed(ActionEvent e) {
        this.designPanel.removeAll();
        this.sourcePanel.removeAll();
        this.xttpanels.setSelectedIndex(0);
        this.designScroll.getViewport().removeAll();
        if (this.xtt_cbm.getSize() < 0) {
            this.xttpanels.setEnabledAt(1, false);
            this.xttToolBar.saveToolButton.setEnabled(false);
            this.menubar.Save_MenuItem.setEnabled(false);
            this.menubar.SaveAs_MenuItem.setEnabled(false);
            this.menubar.Generate_DTD_MenuItem.setEnabled(false);
            this.menubar.Generate_XSD_MenuItem.setEnabled(false);
            this.menubar.Run_MenuItem.setEnabled(false);
            this.xttToolBar.runToolButton.setEnabled(false);
            if (!this.isConnect) {
                this.menubar.Disconnect_MenuItem.setEnabled(false);
            } else {
                this.menubar.Disconnect_MenuItem.setEnabled(true);
            }
            this.menubar.Validation_MenuItem.setEnabled(false);
            this.menubar.Close_MenuItem.setEnabled(false);
            this.menubar.Undo_MenuItem.setEnabled(false);
            this.xttToolBar.closeToolButton.setEnabled(false);
            this.menubar.Element_MenuItem.setEnabled(false);
            this.menubar.Attribute_MenuItem.setEnabled(false);
            this.menubar.Insert_Menu.setEnabled(false);
            this.menubar.Copy_MenuItem.setEnabled(false);
            this.menubar.Cut_MenuItem.setEnabled(false);
            this.menubar.Paste_MenuItem.setEnabled(false);
            this.menubar.Remove_MenuItem.setEnabled(false);
            this.xttToolBar.removeToolButton.setEnabled(false);
            this.xttToolBar.elementToolButton.setEnabled(false);
            this.xttToolBar.attributeToolButton.setEnabled(false);
            this.xttToolBar.upToolButton.setEnabled(false);
            this.xttToolBar.downToolButton.setEnabled(false);
            return;
        }
        this.menubar.SaveAs_MenuItem.setEnabled(true);
        this.menubar.Generate_DTD_MenuItem.setEnabled(true);
        this.menubar.Generate_XSD_MenuItem.setEnabled(true);
        this.menubar.Close_MenuItem.setEnabled(true);
        this.xttToolBar.closeToolButton.setEnabled(true);
        if (this.isConnect) {
            this.menubar.Run_MenuItem.setEnabled(true);
            this.xttToolBar.runToolButton.setEnabled(true);
            this.menubar.Disconnect_MenuItem.setEnabled(true);
            this.menubar.Validation_MenuItem.setEnabled(true);
            this.menubar.Refresh_MenuItem.setEnabled(true);
            this.xttToolBar.elementToggleButton.setEnabled(true);
            this.xttToolBar.attributeToggleButton.setEnabled(true);
            this.xttToolBar.addToggleButton.setEnabled(true);
            this.xttToolBar.replaceToggleButton.setEnabled(true);
            this.xttToolBar.showAgainToggleButton.setEnabled(true);
        } else {
            this.menubar.Run_MenuItem.setEnabled(false);
            this.xttToolBar.runToolButton.setEnabled(false);
            this.menubar.Disconnect_MenuItem.setEnabled(false);
            this.menubar.Validation_MenuItem.setEnabled(false);
            this.menubar.Refresh_MenuItem.setEnabled(false);
            this.xttToolBar.elementToggleButton.setEnabled(false);
            this.xttToolBar.attributeToggleButton.setEnabled(false);
            this.xttToolBar.addToggleButton.setEnabled(false);
            this.xttToolBar.replaceToggleButton.setEnabled(false);
            this.xttToolBar.showAgainToggleButton.setEnabled(false);
        }
        if (this.xttToolBar.xttComboBox.getSelectedIndex() >= 0) {
            this.treeTable = ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).getTreeTable();
            this.undoManager = ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).getUndoManager();
            this.undoSupport = ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).getUndoSupport();
            this.treeTableModel = this.treeTable.treeTableModel;
            this.root = (Template)((DefaultMutableTreeNode)this.treeTable.getTree().getPathForRow(0).getLastPathComponent()).getUserObject();
            this.designScroll.getViewport().add(this.treeTable);
            this.designPanel.add(this.designScroll);
            this.treeTable.getTree().clearSelection();
            this.treeTable.getTree().setSelectionPath(this.treeTable.getTree().getPathForRow(0));
            this.setButtonStatus((XTTTreeNodeInterface)((DefaultMutableTreeNode)this.treeTable.getTree().getPathForRow(this.treeTable.getSelectedRow()).getLastPathComponent()).getUserObject());
            this.setTitle("XML Transfer Template - [" + this.xttToolBar.xttComboBox.getSelectedItem() + "]");
            if (((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).isModified()) {
                this.xttToolBar.saveToolButton.setEnabled(true);
                this.menubar.Save_MenuItem.setEnabled(true);
            } else {
                this.xttToolBar.saveToolButton.setEnabled(false);
                this.menubar.Save_MenuItem.setEnabled(false);
            }
            if (this.undoManager != null && this.undoManager.canUndo()) {
                this.menubar.Undo_MenuItem.setEnabled(true);
            } else {
                this.menubar.Undo_MenuItem.setEnabled(false);
            }
        }
    }

    public void refresh_XTTCombo() {
        this.xttToolBar.xttComboBox.revalidate();
        this.xttToolBar.xttComboBox.repaint();
        this.repaint();
        if (this.xttToolBar.xttComboBox.getItemCount() > 0) {
            this.setTitle("XML Transfer Template - [" + this.xttToolBar.xttComboBox.getSelectedItem() + "]");
            if (((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).isModified()) {
                this.xttToolBar.saveToolButton.setEnabled(true);
                this.menubar.Save_MenuItem.setEnabled(true);
            } else {
                this.xttToolBar.saveToolButton.setEnabled(false);
                this.menubar.Save_MenuItem.setEnabled(false);
            }
            this.menubar.Close_MenuItem.setEnabled(true);
            this.xttToolBar.closeToolButton.setEnabled(true);
            if (this.undoManager != null && this.undoManager.canUndo()) {
                this.menubar.Undo_MenuItem.setEnabled(true);
            } else {
                this.menubar.Undo_MenuItem.setEnabled(false);
            }
        } else {
            this.setTitle("XML Transfer Template");
            this.xttToolBar.saveToolButton.setEnabled(false);
            this.menubar.Save_MenuItem.setEnabled(false);
            this.menubar.SaveAs_MenuItem.setEnabled(false);
            this.menubar.Generate_DTD_MenuItem.setEnabled(false);
            this.menubar.Generate_XSD_MenuItem.setEnabled(false);
            this.menubar.Close_MenuItem.setEnabled(false);
            this.menubar.Undo_MenuItem.setEnabled(false);
            this.xttToolBar.closeToolButton.setEnabled(false);
            this.menubar.Element_MenuItem.setEnabled(false);
            this.menubar.Attribute_MenuItem.setEnabled(false);
            this.menubar.Insert_Menu.setEnabled(false);
            this.menubar.Copy_MenuItem.setEnabled(false);
            this.menubar.Cut_MenuItem.setEnabled(false);
            this.menubar.Paste_MenuItem.setEnabled(false);
            this.menubar.Remove_MenuItem.setEnabled(false);
            this.xttToolBar.removeToolButton.setEnabled(false);
            this.xttToolBar.runToolButton.setEnabled(false);
            if (!this.isConnect) {
                this.menubar.Disconnect_MenuItem.setEnabled(false);
            } else {
                this.menubar.Disconnect_MenuItem.setEnabled(true);
            }
            this.menubar.Validation_MenuItem.setEnabled(false);
            this.menubar.Run_MenuItem.setEnabled(false);
            this.xttToolBar.attributeToolButton.setEnabled(false);
            this.xttToolBar.elementToolButton.setEnabled(false);
            this.xttToolBar.upToolButton.setEnabled(false);
            this.xttToolBar.downToolButton.setEnabled(false);
        }
    }

    public String isExistQueryObjectName(String s) {
        String qs = s + this.query_serial;
        int pos = this.treeTable.getQueryObjectVector().indexOf(qs);
        if (pos < 0) {
            this.query_serial = 0;
            return qs;
        }
        ++this.query_serial;
        return this.isExistQueryObjectName(s);
    }

    private String getNextNewEditingFileName() {
        String s = this.untitle + this.untitle_serial;
        while (true) {
            if (this.emptyXTTVector.indexOf(s) < 0) {
                this.emptyXTTVector.add(s);
                ++this.untitle_serial;
                break;
            }
            ++this.untitle_serial;
            s = this.untitle + this.untitle_serial;
        }
        return s;
    }

    void Disconnect_MenuItem_actionPerformed(ActionEvent e) {
        this.dbLabel.setText(this.res.getString("Database") + ":");
        this.rightTopScrollPane.getViewport().removeAll();
        if (this.conn.dbconn != null) {
            this.conn.disconnect();
            this.conn = null;
        }
        this.isConnect = false;
        this.xttToolBar.runToolButton.setEnabled(false);
        this.menubar.Disconnect_MenuItem.setEnabled(false);
        this.menubar.Validation_MenuItem.setEnabled(false);
        this.menubar.Run_MenuItem.setEnabled(false);
        this.menubar.Refresh_MenuItem.setEnabled(false);
        this.xttToolBar.elementToggleButton.setEnabled(false);
        this.xttToolBar.attributeToggleButton.setEnabled(false);
        this.xttToolBar.addToggleButton.setEnabled(false);
        this.xttToolBar.replaceToggleButton.setEnabled(false);
        this.xttToolBar.showAgainToggleButton.setEnabled(false);
        this.setStatusBarDisc(this.res.getString("No_database_connect"));
        System.gc();
        this.repaint();
    }

    public void connectMenuitem_actionPerformed(ActionEvent e) {
        try {
            LoginDlg dlg = new LoginDlg(this);
            GuiUt.setCenterLocation(this, dlg);
            dlg.show();
            dlg = null;
            if (!this.isConnect) {
                this.xttToolBar.runToolButton.setEnabled(false);
                this.menubar.Disconnect_MenuItem.setEnabled(false);
                this.menubar.Validation_MenuItem.setEnabled(false);
                this.menubar.Run_MenuItem.setEnabled(false);
                this.menubar.Refresh_MenuItem.setEnabled(false);
                this.xttToolBar.elementToggleButton.setEnabled(false);
                this.xttToolBar.attributeToggleButton.setEnabled(false);
                this.xttToolBar.addToggleButton.setEnabled(false);
                this.xttToolBar.replaceToggleButton.setEnabled(false);
                this.xttToolBar.showAgainToggleButton.setEnabled(false);
                return;
            }
            this.xttToolBar.runToolButton.setEnabled(true);
            this.menubar.Disconnect_MenuItem.setEnabled(true);
            this.menubar.Validation_MenuItem.setEnabled(true);
            this.menubar.Run_MenuItem.setEnabled(true);
            this.menubar.Refresh_MenuItem.setEnabled(true);
            this.xttToolBar.elementToggleButton.setEnabled(true);
            this.xttToolBar.attributeToggleButton.setEnabled(true);
            this.xttToolBar.addToggleButton.setEnabled(true);
            this.xttToolBar.replaceToggleButton.setEnabled(true);
            this.xttToolBar.showAgainToggleButton.setEnabled(true);
            System.gc();
            this.setStatusBarDisc(this.res.getString("Login_database"));
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setStatusBarDisc(String s) {
        this.statusBar.setText(s);
    }

    void preferenceMenuItemMenuItem_actionPerformed(ActionEvent e) {
        PreferencesDlg dlg = null;
        dlg = new PreferencesDlg(frame);
        GuiUt.setCenterLocation(this, dlg);
        dlg.setModal(true);
        dlg.show();
    }

    void treeOperationOptionMenuItemMenuItem_actionPerformed(ActionEvent e) {
        TreeOperationOptionDlg dlg = null;
        dlg = new TreeOperationOptionDlg(frame);
        GuiUt.setCenterLocation(this, dlg);
        dlg.setModal(true);
        dlg.show();
    }

    public void showAgainToggleButton_actionPerformed(ActionEvent e) {
        if (this.xttToolBar.showAgainToggleButton.isSelected()) {
            this.px.updateVariables(4, "1");
        } else {
            this.px.updateVariables(4, "0");
        }
        try {
            this.px.save();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void insertAsNextToggleButton_actionPerformed(ActionEvent e) {
        TreePath tp;
        if (this.xttToolBar.insertAsNextToggleButton.isSelected()) {
            this.px.updateVariables(1, "0");
        } else {
            this.px.updateVariables(1, "1");
        }
        if (this.treeTable != null && (tp = this.treeTable.getTree().getPathForRow(this.treeTable.getSelectedRow())) != null) {
            XTTTreeNodeInterface xtt2 = (XTTTreeNodeInterface)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            this.setButtonStatus(xtt2);
        }
        try {
            this.px.save();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void insertAsChildToggleButton_actionPerformed(ActionEvent e) {
        TreePath tp;
        if (this.xttToolBar.insertAsChildToggleButton.isSelected()) {
            this.px.updateVariables(1, "1");
        } else {
            this.px.updateVariables(1, "0");
        }
        if (this.treeTable != null && (tp = this.treeTable.getTree().getPathForRow(this.treeTable.getSelectedRow())) != null) {
            XTTTreeNodeInterface xtt2 = (XTTTreeNodeInterface)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            this.setButtonStatus(xtt2);
        }
        try {
            this.px.save();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void attributeToggleButton_actionPerformed(ActionEvent e) {
        if (this.xttToolBar.attributeToggleButton.isSelected()) {
            this.px.updateVariables(2, "0");
        } else {
            this.px.updateVariables(2, "1");
        }
        try {
            this.px.save();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void elementToggleButton_actionPerformed(ActionEvent e) {
        if (this.xttToolBar.elementToggleButton.isSelected()) {
            this.px.updateVariables(2, "1");
        } else {
            this.px.updateVariables(2, "0");
        }
        try {
            this.px.save();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void replaceToggleButton_actionPerformed(ActionEvent e) {
        if (this.xttToolBar.replaceToggleButton.isSelected()) {
            this.px.updateVariables(0, "0");
        } else {
            this.px.updateVariables(0, "1");
        }
        try {
            this.px.save();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void addToggleButton_actionPerformed(ActionEvent e) {
        if (this.xttToolBar.addToggleButton.isSelected()) {
            this.px.updateVariables(0, "1");
        } else {
            this.px.updateVariables(0, "0");
        }
        try {
            this.px.save();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void setToggleButtonStatus() {
        if (this.px.getShowCustomizedNodeForBoolean()) {
            this.xttToolBar.showAgainToggleButton.setSelected(true);
        } else {
            this.xttToolBar.showAgainToggleButton.setSelected(false);
        }
        if (this.px.getAddModeSettingForBoolean()) {
            this.xttToolBar.addToggleButton.setSelected(true);
            this.xttToolBar.replaceToggleButton.setSelected(false);
        } else {
            this.xttToolBar.addToggleButton.setSelected(false);
            this.xttToolBar.replaceToggleButton.setSelected(true);
        }
        if (this.px.getNodeAsChildSettingForBoolean()) {
            this.xttToolBar.insertAsChildToggleButton.setSelected(true);
            this.xttToolBar.insertAsNextToggleButton.setSelected(false);
        } else {
            this.xttToolBar.insertAsChildToggleButton.setSelected(false);
            this.xttToolBar.insertAsNextToggleButton.setSelected(true);
        }
        if (this.px.getDndAsElementSettingForBoolean()) {
            this.xttToolBar.elementToggleButton.setSelected(true);
            this.xttToolBar.attributeToggleButton.setSelected(false);
        } else {
            this.xttToolBar.elementToggleButton.setSelected(false);
            this.xttToolBar.attributeToggleButton.setSelected(true);
        }
    }

    public void xttpanels_stateChanged(ChangeEvent e) {
        ((AbstractDisplayPanel)((JTabbedPane)this.getBottomPanel()).getSelectedComponent()).stopEditing();
        int index = this.xttpanels.getSelectedIndex();
        switch (index) {
            case 0: {
                this.sourcePanel.removeAll();
                break;
            }
            case 1: {
                this.sourcePanel.removeAll();
                this.initFileContent();
                break;
            }
            default: {
                this.sourcePanel.removeAll();
            }
        }
    }

    void parameterMenuItem_actionPerformed(ActionEvent e) {
        ParameterDlg dlg = null;
        dlg = new ParameterDlg((Frame)frame, this.root);
        GuiUt.setCenterLocation(this, dlg);
        dlg.setModal(true);
        dlg.setSize(350, 350);
        dlg.show();
    }

    private void getTemplateData4XML(XTTTreeNodeInterface parent, Node e) {
        QueryElement child = null;
        NodeList list = e.getChildNodes();
        Node node = null;
        Object temp = null;
        int size = list.getLength();
        String localName = null;
        Object queryName = null;
        Object queryCommand = null;
        NamedNodeMap map = e.getAttributes();
        for (int i = 0; i < size; ++i) {
            boolean b;
            node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element ele = (Element)node;
            localName = node.getLocalName();
            if (localName == null) continue;
            if (!node.hasAttributes()) {
                QueryElement qe = child = new QueryElement(node);
                qe.setTextValue("");
                qe.setQueryName("");
                qe.setCommand("");
                b = false;
                if (this.xttToolBar.xttComboBox.getSelectedItem() != null) {
                    b = ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).isModified();
                }
                parent.addChild(child);
            } else {
                QueryElement qee = child = new QueryElement(node);
                qee.setTextValue("");
                qee.setQueryName("");
                qee.setCommand("");
                b = false;
                if (this.xttToolBar.xttComboBox.getSelectedItem() != null) {
                    b = ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).isModified();
                }
                parent.addChild(child);
                NamedNodeMap nnm = node.getAttributes();
                Node att_node = null;
                int nnm_len = nnm.getLength();
                Attribute att = null;
                if (nnm_len > 0) {
                    for (int j = 0; j < nnm_len; ++j) {
                        att_node = nnm.item(j);
                        att = new Attribute(att_node.getNodeName(), att_node.getNodeValue());
                        att.setAttributeValue("");
                        child.addChild(att);
                    }
                } else {
                    QueryElement qe = child = new QueryElement(node);
                    qe.setTextValue("");
                    qe.setQueryName("");
                    qe.setCommand("");
                    parent.addChild(child);
                }
            }
            this.getTemplateData4XML(child, node);
        }
    }

    private void getTemplateData(XTTTreeNodeInterface parent, Node e) {
        XTTDatatransfer child = null;
        NodeList list = e.getChildNodes();
        Node node = null;
        Object temp = null;
        int size = list.getLength();
        String prefix = null;
        String localName = null;
        Object queryName = null;
        Object queryCommand = null;
        NamedNodeMap map = e.getAttributes();
        for (int i = 0; i < size; ++i) {
            boolean b;
            String textValue;
            node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element ele = (Element)node;
            prefix = node.getPrefix();
            localName = node.getLocalName();
            if (prefix == null && localName == null) continue;
            if (prefix != null && prefix.equals("xtt")) {
                if (localName.equals("parameter")) {
                    if (parent instanceof Template) {
                        String parameterName = PreferencesXml.getAttributeValue(ele, "name");
                        String parameterDefault = PreferencesXml.getAttributeValue(ele, "default");
                        if (parameterName.length() > 0) {
                            ((Template)parent).addParameterObject(parameterName, parameterDefault);
                        }
                    }
                } else if (localName.equals("header")) {
                    String header = this.getNodeValue(ele).trim();
                    if (parent instanceof Template && header != null && header.length() > 0) {
                        ((Template)parent).header = header;
                    }
                } else if (localName.equals("attribute")) {
                    child = new Attribute(node);
                    parent.addChild((XTTTreeNodeInterface)((Object)child));
                } else if (localName.equals("query")) {
                    child = new QueryElement(node);
                    parent.addChild((XTTTreeNodeInterface)((Object)child));
                }
                this.getTemplateData((XTTTreeNodeInterface)((Object)child), node);
                continue;
            }
            if (!node.hasAttributes()) {
                child = new QueryElement(node);
                XTTDatatransfer qe = child;
                if (qe.getQueryName() != null && qe.getQueryName().length() != 0) {
                    this.tmpVector.add(qe.getQueryName());
                }
                textValue = this.getNodeValue(node);
                b = false;
                if (this.xttToolBar.xttComboBox.getSelectedItem() != null) {
                    b = ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).isModified();
                }
                if (textValue != null && textValue.trim().length() > 0) {
                    qe.setTextValue(textValue);
                    XTTFrame.setXTTModified(b);
                }
                parent.addChild((XTTTreeNodeInterface)((Object)child));
            } else {
                child = new QueryElement(node);
                XTTDatatransfer qee = child;
                if (qee.getQueryName() != null && qee.getQueryName().length() != 0) {
                    this.tmpVector.add(qee.getQueryName());
                }
                textValue = this.getNodeValue(node);
                b = false;
                if (this.xttToolBar.xttComboBox.getSelectedItem() != null) {
                    b = ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).isModified();
                }
                if (textValue != null && textValue.trim().length() > 0) {
                    qee.setTextValue(textValue.trim());
                    XTTFrame.setXTTModified(b);
                }
                parent.addChild((XTTTreeNodeInterface)((Object)child));
                NamedNodeMap nnm = node.getAttributes();
                Node att_node = null;
                int nnm_len = nnm.getLength();
                Attribute att = null;
                if (nnm_len > 0) {
                    for (int j = 0; j < nnm_len; ++j) {
                        att_node = nnm.item(j);
                        if (att_node.getPrefix() != null && att_node.getPrefix().equalsIgnoreCase("xtt")) continue;
                        att = new Attribute(att_node.getNodeName(), att_node.getNodeValue());
                        child.addChild(att);
                    }
                } else {
                    String value;
                    child = new QueryElement(node);
                    XTTDatatransfer qe = child;
                    if (((QueryElement)qe).getQueryName() != null && ((QueryElement)qe).getQueryName().length() != 0) {
                        this.tmpVector.add(((QueryElement)qe).getQueryName());
                    }
                    if ((value = this.getNodeValue(node)) != null && value.trim().length() > 0) {
                        ((QueryElement)qe).setTextValue(value);
                    }
                    parent.addChild((XTTTreeNodeInterface)((Object)child));
                }
            }
            this.getTemplateData((XTTTreeNodeInterface)((Object)child), node);
        }
    }

    private QueryElement loadTemplateFromXSD(String fileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(fileName));
            Element e = document.getDocumentElement();
            this.schema_uri = e.getNamespaceURI();
            if (this.schema_uri == null || this.schema_uri == null || !this.schema_uri.equalsIgnoreCase("http://www.w3.org/2001/XMLSchema")) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                GuiUt.showErrorDlg(this, this.res.getString("XTT_just_accept_http"), null);
                return null;
            }
            String localname = e.getLocalName();
            if (localname == null || localname == null || !localname.equalsIgnoreCase("schema")) {
                GuiUt.showErrorDlg(this, this.res.getString("Invalid_localname"), null);
                return null;
            }
            QueryElement qe = new QueryElement(e);
            for (Node node = e.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !node.getNamespaceURI().equalsIgnoreCase(this.schema_uri) || !node.getLocalName().equals("element")) continue;
                XSDParser.getXSDElement(qe, (Element)node, e);
            }
            return qe;
        }
        catch (SAXException sxe) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(this, sxe.getMessage(), null);
            return null;
        }
        catch (ParserConfigurationException pce) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(this, pce.getMessage(), null);
            return null;
        }
        catch (IOException ioe) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(this, ioe.getMessage(), null);
            return null;
        }
    }

    private XTTTreeNodeInterface loadTemplate(String fileName) {
        return this.loadTemplate(false, fileName);
    }

    private XTTTreeNodeInterface loadTemplate(boolean isImported, String fileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(fileName));
            Element e = document.getDocumentElement();
            if (isImported) {
                QueryElement q_importedRoot = new QueryElement(e);
                if (q_importedRoot != null) {
                    this.getTemplateData4XML(q_importedRoot, e);
                }
                return q_importedRoot;
            }
            if (e.getPrefix() == null || !e.getPrefix().equalsIgnoreCase("xtt")) {
                GuiUt.showErrorDlg(this, this.res.getString("Template_element_must"), null);
                return null;
            }
            String uriStr = "urn:schema-dbmaker-com:xml-template";
            if (!LocaleManager.getIsDBMaker()) {
                uriStr = "urn:schema-dbmaster-com:xml-template";
            }
            if (e.getNamespaceURI() == null || !e.getNamespaceURI().equals(uriStr)) {
                int idx;
                String str = this.res.getString("Template_name_space");
                if (!LocaleManager.getIsDBMaker() && (idx = str.indexOf("DBMaker")) >= 0) {
                    String tmp = str.substring(0, idx);
                    tmp = tmp.concat("DBMaster");
                    str = tmp = tmp + str.substring(idx + 7, str.length());
                }
                GuiUt.showErrorDlg(this, str, null);
                return null;
            }
            Template t_root = new Template(e);
            if (t_root != null) {
                if (t_root.get_dtmDefault().getRowCount() <= 1) {
                    if (t_root.get_dtmDefault().getValueAt(0, 0).toString().trim().length() > 0) {
                        t_root.get_dtmDefault().addEmptyRow();
                    }
                } else {
                    t_root.get_dtmDefault().addEmptyRow();
                }
                this.getTemplateData(t_root, e);
            }
            return t_root;
        }
        catch (SAXException sxe) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(this, sxe.getMessage(), null);
            return null;
        }
        catch (ParserConfigurationException pce) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(this, pce.getMessage(), null);
            return null;
        }
        catch (IOException ioe) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(this, ioe.getMessage(), null);
            return null;
        }
    }

    private void initFileContent() {
        JPanel panel = new JPanel(new BorderLayout());
        SQLTextPane textArea = new SQLTextPane();
        textArea.setEditable(false);
        this.sourcePanel.add((Component)this.sourceScroll, "Center");
        this.sourceScroll.getViewport().add(textArea);
        XTTFileInfoObject xttfio = (XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem();
        textArea.setText("<?xml version=\"1.0\" encoding=\"" + ((XTTFileInfoObject)this.xttToolBar.xttComboBox.getSelectedItem()).getEncoding() + "\"?>\n" + this.root.write(0));
    }

    public void initDatabaseTree() {
        if (this.isConnect) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.dbLabel.setText(this.res.getString("Database") + ":" + this.conn.getDatabaseName());
            this.tree1 = new TableSchemaViewerTree();
            this.rightTopScrollPane.getViewport().add((Component)this.tree1, null);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void importFromXTT(String importedXTT) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.tmpVector.removeAllElements();
        XTTTreeNodeInterface xtt2 = this.loadTemplate(false, importedXTT);
        if (xtt2 == null) {
            this.tmpVector.removeAllElements();
            this.root = null;
            return;
        }
        this.root = (Template)xtt2;
        if (this.root.getNode().getPrefix() == null || !this.root.getNode().getPrefix().equalsIgnoreCase("xtt")) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(this, this.res.getString("Template_element_must"), null);
            this.root = null;
            return;
        }
        String urispace = "urn:schema-dbmaker-com:xml-template";
        if (!LocaleManager.getIsDBMaker()) {
            urispace = "urn:schema-dbmaster-com:xml-template";
        }
        if (this.root.getNode().getNamespaceURI() == null || !this.root.getNode().getNamespaceURI().equals(urispace)) {
            int idx;
            this.setCursor(Cursor.getPredefinedCursor(0));
            String str = this.res.getString("Template_name_space1");
            if (!LocaleManager.getIsDBMaker() && (idx = str.indexOf("DBMaker")) >= 0) {
                String tmp = str.substring(0, idx);
                tmp = tmp.concat("DBMaster");
                str = tmp = tmp + str.substring(idx + 7, str.length());
            }
            GuiUt.showErrorDlg(this, str, null);
            this.root = null;
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void importFromXML(String importedXML) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.tmpVector.removeAllElements();
        XTTTreeNodeInterface xtt2 = this.loadTemplate(true, importedXML);
        if (xtt2 != null) {
            this.importedRoot = (QueryElement)xtt2;
        }
        if (this.importedRoot == null) {
            this.tmpVector.removeAllElements();
            return;
        }
        this.root = new Template();
        this.root.addChild(this.importedRoot);
        String import_file_name = this.getNextNewEditingFileName();
        this.initTree(false, import_file_name, importedXML);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void newEmptyXTT() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.root = new Template();
        QueryElement qe = new QueryElement("root");
        this.root.addChild(qe);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void newToolButton_actionPerformed(ActionEvent e) {
        this.tmpVector.removeAllElements();
        this.newEmptyXTT();
        this.initTree(true, this.getNextNewEditingFileName(), "");
    }

    public void setSelectedNode(DefaultMutableTreeNode node) {
        frame.setBottomPanel(null);
        TreePath path = new TreePath(node.getPath());
        int row = this.treeTable.getTree().getRowForPath(path);
        if (row != this.treeTable.getSelectedRow()) {
            this.treeTable.getSelectionModel().setSelectionInterval(row, row);
            this.treeTable.getTree().scrollPathToVisible(path);
        } else {
            XTTTreeNodeInterface obj = (XTTTreeNodeInterface)node.getUserObject();
            this.setButtonStatus(obj);
            AbstractDisplayPanel[] comps = obj.getDisplayComponent();
            XTTTabbedPane t = new XTTTabbedPane(comps);
            frame.setBottomPanel(t);
        }
    }

    public void initTree(boolean isEmptyXTT, String fileName, String trueFileName) {
        int pos;
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.root == null) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        DefaultMutableTreeNode cn = XTTTree.getShortTree(this.root);
        this.treeTableModel = new XTTTableModel(cn);
        this.treeTable = new JTreeTable(this.treeTableModel);
        this.undoManager = new XTTUndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoAdapter = new UndoAdapter();
        this.undoSupport.addUndoableEditListener(this.undoAdapter);
        this.treeTable.getQueryObjectVector().addAll(this.tmpVector);
        this.designScroll.getViewport().add(this.treeTable);
        TableColumn column = null;
        TableColumnModel cmodel = this.treeTable.getColumnModel();
        column = cmodel.getColumn(1);
        column.setCellRenderer(new QueryBackgroupTableCellRenderer());
        this.designPanel.add((Component)this.designScroll, "Center");
        XTTFileInfoObject xtt_file_info_object = new XTTFileInfoObject(fileName);
        if (!isEmptyXTT) {
            xtt_file_info_object.setModified(true);
        }
        if ((pos = this.xtt_cbm.getIndexOf(xtt_file_info_object)) == -1) {
            xtt_file_info_object.setTreeTable(this.treeTable);
            xtt_file_info_object.setUndoManager(this.undoManager);
            xtt_file_info_object.setUndoableEditSupport(this.undoSupport);
            this.xtt_cbm.addElement(xtt_file_info_object);
            this.xttToolBar.xttComboBox.setSelectedIndex(this.xttToolBar.xttComboBox.getItemCount() - 1);
        } else {
            this.xttToolBar.xttComboBox.setSelectedIndex(pos);
        }
        if (trueFileName.length() > 0) {
            XTTFileInfoObject xfio = new XTTFileInfoObject(trueFileName);
            String encode = xfio.getEncoding();
            if (encode != null && encode.length() > 0) {
                xtt_file_info_object.setEncoding(encode);
            }
        } else {
            xtt_file_info_object.setModified(false);
            String encodeStr = xtt_file_info_object.getEncoding();
            if (encodeStr.length() > 0) {
                xtt_file_info_object.setEncoding(encodeStr);
            } else {
                xtt_file_info_object.setEncoding(this.system_encoding);
            }
        }
        this.xttpanels.setEnabledAt(1, true);
        TreePath tp = this.treeTable.getTree().getPathForRow(1);
        this.treeTable.getTree().makeVisible(tp);
        this.treeTable.getTree().setSelectionPath(tp);
        this.treeTable.getTree().scrollPathToVisible(tp);
        ((ElementMainPanel)((JTabbedPane)this.bottomPanel.getComponent((int)0)).getComponentAt((int)0)).elementNameTextField.grabFocus();
        ((ElementMainPanel)((JTabbedPane)this.bottomPanel.getComponent((int)0)).getComponentAt((int)0)).elementNameTextField.selectAll();
        this.refresh_XTTCombo();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void File_Exit_MenuItem_actionPerformed(ActionEvent e) {
        int size = this.xttToolBar.xttComboBox.getItemCount();
        if (size > 0) {
            XTTFileInfoObject file_info = null;
            int isEmpty = 0;
            Vector<XTTFileInfoObject> v = new Vector<XTTFileInfoObject>();
            for (int i = 0; i < size; ++i) {
                file_info = (XTTFileInfoObject)this.xttToolBar.xttComboBox.getItemAt(i);
                isEmpty = this.emptyXTTVector.indexOf(file_info.getContent());
                if (!file_info.isModified()) continue;
                String s1 = this.res.getString("Save_changed_to");
                String s2 = GuiUt.mapStringForProperty(s1, file_info.getContent());
                int reply = GuiUt.showOption3Dlg(this, "XML Transfer Template", s2);
                if (isEmpty >= 0) {
                    if (reply == 0) {
                        this.SaveAs_MenuItem_actionPerformed(null);
                        continue;
                    }
                    if (reply == 1) {
                        v.add(file_info);
                        continue;
                    }
                    if (reply != 2) continue;
                    int v_size = v.size();
                    for (int x = 0; x < v_size; ++x) {
                        this.xttToolBar.xttComboBox.removeItem(v.elementAt(x));
                    }
                    return;
                }
                if (reply == 0) {
                    this.Save_MenuItem_actionPerformed(null);
                    continue;
                }
                if (reply == 1) {
                    v.add(file_info);
                    continue;
                }
                if (reply != 2) continue;
                int v_size = v.size();
                for (int x = 0; x < v_size; ++x) {
                    this.xttToolBar.xttComboBox.removeItem(v.elementAt(x));
                }
                return;
            }
        }
        try {
            this.px.save();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        System.exit(0);
    }

    public int getVerticalDividerLocation() {
        return this.verticalSplitPane.getDividerLocation();
    }

    public int getHorizontalDividerLocation() {
        return this.horizontalSplitPane.getDividerLocation();
    }

    public void About_MenuItem_actionPerformed(ActionEvent e) {
        AboutBox dlg = this.px.isWindows ? new AboutBox((Frame)this, 2) : new AboutBox((Frame)this, "", true, 2);
        GuiUt.setCenterLocation(this, dlg);
        dlg.setModal(true);
        dlg.show();
        dlg = null;
        System.gc();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.File_Exit_MenuItem_actionPerformed(null);
        }
    }

    public JTreeTable getTreeTable() {
        return this.treeTable;
    }

    public void XML_Imported_MenuItem_actionPerformed(ActionEvent e) {
        JFileChooser chooser = null;
        chooser = this.px.getSelectedDirectory() != null && this.px.getSelectedDirectory().length() > 0 ? new JFileChooser(this.px.getSelectedDirectory()) : new JFileChooser(this.px.user_dir);
        chooser.setFileFilter(new DbaFileFilter("xml", "XML Transfer Template Files (*.xml)"));
        int state = chooser.showDialog(this, this.res.getString("Import_from_XML"));
        if (0 != state) {
            return;
        }
        File f = chooser.getSelectedFile();
        String sx = f.getPath();
        sx = sx.substring(0, sx.indexOf(f.getName()));
        this.px.updateVariables(5, sx);
        if (!f.exists()) {
            String s1 = this.res.getString("not_exist_");
            String s2 = GuiUt.mapStringForProperty(s1, f.getAbsolutePath());
            GuiUt.showErrorDlg(this, s2, null);
            return;
        }
        this.importFromXML(f.getAbsolutePath());
        this.xttToolBar.replaceToggleButton.setSelected(true);
        this.xttToolBar.addToggleButton.setSelected(false);
        this.replaceToggleButton_actionPerformed(null);
        this.addToggleButton_actionPerformed(null);
    }

    public void Open_MenuItem_actionPerformed(ActionEvent e) {
        int i;
        JFileChooser chooser = null;
        chooser = this.px.getSelectedDirectory() != null && this.px.getSelectedDirectory().length() > 0 ? new JFileChooser(this.px.getSelectedDirectory()) : new JFileChooser(this.px.user_dir);
        chooser.setFileFilter(new DbaFileFilter("xtt", "XML Transfer Template Files (*.xtt)"));
        int state = chooser.showDialog(this, this.res.getString("open"));
        if (0 != state) {
            return;
        }
        File f = chooser.getSelectedFile();
        if (!f.exists()) {
            String s1 = this.res.getString("not_exist_");
            String s2 = GuiUt.mapStringForProperty(s1, f.getAbsolutePath());
            GuiUt.showErrorDlg(this, s2, null);
            return;
        }
        if (f.isDirectory()) {
            String s1 = this.res.getString("is_not_a_file_");
            String s2 = GuiUt.mapStringForProperty(s1, f.getAbsolutePath());
            GuiUt.showErrorDlg(this, s2, null);
            return;
        }
        String s = f.getAbsolutePath();
        XTTFileInfoObject file_info = null;
        int combo_size = this.xttToolBar.xttComboBox.getItemCount();
        boolean b = false;
        for (i = 0; i < combo_size; ++i) {
            file_info = (XTTFileInfoObject)this.xttToolBar.xttComboBox.getItemAt(i);
            if (!s.equals(file_info.getContent())) continue;
            b = true;
            break;
        }
        if (b) {
            this.xttToolBar.xttComboBox.setSelectedIndex(i);
            return;
        }
        this.menubar.insertPreviousOpenFile(f.getAbsolutePath());
        String sx = f.getPath();
        sx = sx.substring(0, sx.indexOf(f.getName()));
        this.px.updateVariables(5, sx);
        this.importFromXTT(f.getAbsolutePath());
        this.initTree(false, f.getAbsolutePath(), "");
    }

    public void setBottomPanel(JComponent comp) {
        this.bottomPanel.removeAll();
        if (comp != null) {
            this.bottomPanel.add((Component)comp, "Center");
        }
        this.bottomPanel.revalidate();
        this.bottomPanel.repaint();
        this.repaint();
    }

    public Component getBottomPanel() {
        if (this.bottomPanel.getComponentCount() <= 0) {
            return null;
        }
        return this.bottomPanel.getComponent(0);
    }

    public static void setXTTModified(boolean b) {
        Object obj;
        if (frame != null && XTTFrame.frame.xttToolBar.xttComboBox != null && (obj = XTTFrame.frame.xttToolBar.xttComboBox.getSelectedItem()) != null) {
            ((XTTFileInfoObject)obj).setModified(b);
        }
    }

    public static void xttRefresh_xttCombo() {
        if (frame != null) {
            frame.refresh_XTTCombo();
        }
    }

    public static String mapDB2XSD(String type) {
        String xsdStr = "xsd:string";
        xsdStr = type.equalsIgnoreCase("char") || type.equalsIgnoreCase("varchar") ? "xsd:string" : (type.equalsIgnoreCase("integer") ? "xsd:int" : (type.equalsIgnoreCase("bigint") ? "xsd:bigint" : (type.equalsIgnoreCase("short") ? "xsd:short" : (type.equalsIgnoreCase("double") ? "xsd:double" : (type.equalsIgnoreCase("float") ? "xsd:float" : "xsd:string")))));
        return xsdStr;
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = ResourceBundle.getBundle("com.syscom.xml.xtt.console.resource.Res", LocaleManager.getLocale());
        this.menubar.localeChanged(e);
        this.xttToolBar.localeChanged(e);
        if (this.treeTable != null) {
            this.treeTable.localeChanged(e);
        }
        this.xttpanels.setTitleAt(0, this.res.getString("Design"));
        this.xttpanels.setTitleAt(1, this.res.getString("Source"));
        if (this.isConnect) {
            this.dbLabel.setText(this.res.getString("Database") + ":" + this.conn.getDatabaseName());
        } else {
            this.dbLabel.setText(this.res.getString("Database") + ":");
        }
        if (this.isConnect) {
            this.setStatusBarDisc(this.res.getString("Login_database"));
        } else {
            this.setStatusBarDisc(this.res.getString("No_database_connect"));
        }
        if (this.treeTable == null) {
            return;
        }
        TreePath tp = this.treeTable.getTree().getSelectionPath();
        if (tp == null) {
            this.treeTable.getTree().setSelectionRow(0);
            tp = this.treeTable.getTree().getPathForRow(0);
        }
        Object obj = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
        XTTTabbedPane xtp = (XTTTabbedPane)this.getBottomPanel();
        ResourceBundle res1 = ResourceBundle.getBundle("com.syscom.xml.node.display.resource.Res", LocaleManager.getLocale());
        if (obj instanceof Template) {
            xtp.setTitleAt(0, res1.getString("Template"));
            xtp.setTitleAt(1, res1.getString("Parameters"));
            xtp.setTitleAt(2, res1.getString("Display_properties"));
        } else if (obj instanceof QueryElement) {
            xtp.setTitleAt(0, res1.getString("Element"));
            xtp.setTitleAt(1, res1.getString("Query"));
            xtp.setTitleAt(2, res1.getString("Display_properties"));
        } else {
            xtp.setTitleAt(0, res1.getString("Attribute"));
            xtp.setTitleAt(1, res1.getString("Display_properties"));
        }
    }

    private String getNodeValue(Node node) {
        NodeList list = node.getChildNodes();
        int size = list.getLength();
        Object value = null;
        Node childNode = null;
        String s = null;
        for (int i = 0; i < size; ++i) {
            childNode = list.item(i);
            if (childNode.getNodeType() != 3) continue;
            s = childNode.getNodeValue();
        }
        return s;
    }

    public void refreshXTT(XTTTreeNodeInterface obj) {
        this.treeTable.setResetTree(true);
        this.treeTableModel.nodeChanged(obj.getDefaultMutableTreeNode());
        this.treeTable.setResetTree(false);
    }

    public void refreshXTT() {
        if (!this.undoManager.canUndo()) {
            this.menubar.Undo_MenuItem.setEnabled(false);
        } else {
            this.menubar.Undo_MenuItem.setEnabled(true);
        }
        this.treeTable.getTree().revalidate();
        this.treeTable.getTree().repaint();
        this.treeTable.validate();
        this.treeTable.repaint();
        this.repaint();
    }

    public void setNextFocus(JComponent c) {
        this.nextComp = c;
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        if (d.getWidth() < 881.0) {
            this.toolBarPanel.setMinimumSize(new Dimension(1000, 56));
            this.toolBarPanel.setPreferredSize(new Dimension(1000, 56));
        }
    }

    @Override
    public void nextFocus() {
        if (this.nextComp != null) {
            this.nextComp.grabFocus();
            this.nextComp = null;
        }
    }

    private class XTTFileInfoObject {
        private boolean isModified = false;
        private String content = "";
        private String encoding = "";
        private JTreeTable treeTable = null;
        private XTTUndoManager undoManager = null;
        private UndoableEditSupport undoSupport = null;

        public XTTFileInfoObject(String fileName) {
            this.content = fileName;
            File f = new File(fileName);
            if (f.exists() && f.isFile()) {
                try {
                    DataInputStream dns = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
                    byte[] bya = new byte[100];
                    dns.read(bya, 0, 100);
                    String all = null;
                    all = bya[0] == -1 && bya[1] == -2 || bya[0] == -2 && bya[1] == -1 ? new String(bya, "UTF-16") : new String(bya);
                    int index = all.indexOf("encoding");
                    if (index > 0) {
                        String tmpStr = all.substring(index + 8, index + 20);
                        int end = 0;
                        for (int count = 0; (index = tmpStr.indexOf("\"")) >= 0 && count <= 1; ++count) {
                            if (count > 0) {
                                end = index;
                            }
                            if (count != 0) continue;
                            tmpStr = tmpStr.substring(index + 1, tmpStr.length());
                        }
                        this.encoding = tmpStr.substring(0, end);
                        if (!(this.encoding.equals("UTF-8") || this.encoding.equals("UTF-16LE") || this.encoding.equals("BIG5") || this.encoding.equals("GB2312") || this.encoding.equals("UTF-16BE") || this.encoding.equals("Shift_JIS") || this.encoding.equals("US-ASCII") || this.encoding.equals("UTF-16"))) {
                            this.encoding = "";
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public String toString() {
            if (this.isModified) {
                return this.content + "*";
            }
            return this.content;
        }

        public boolean isModified() {
            return this.isModified;
        }

        public void setModified(boolean b) {
            this.isModified = b;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String s) {
            this.content = s;
        }

        public void setEncoding(String s) {
            this.encoding = s;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setTreeTable(JTreeTable treeTable) {
            this.treeTable = treeTable;
        }

        public JTreeTable getTreeTable() {
            return this.treeTable;
        }

        public void setUndoManager(XTTUndoManager undoManager) {
            this.undoManager = undoManager;
        }

        public XTTUndoManager getUndoManager() {
            return this.undoManager;
        }

        public void setUndoableEditSupport(UndoableEditSupport undoSupport) {
            this.undoSupport = undoSupport;
        }

        public UndoableEditSupport getUndoSupport() {
            return this.undoSupport;
        }
    }

    private class UndoAdapter
    implements UndoableEditListener {
        private UndoAdapter() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent evt) {
            UndoableEdit edit = evt.getEdit();
            XTTFrame.this.undoManager.addEdit(edit);
        }
    }
}

