/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.undo;

import com.syscom.xml.node.display.AbstractDisplayPanel;
import com.syscom.xml.xtt.console.XTTFrame;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class DnDDocumentUndoEdit
extends AbstractUndoableEdit {
    private String data = null;
    private XTTTreeNodeInterface xtt = null;
    private String method = null;
    private boolean isInternal = false;

    public DnDDocumentUndoEdit(XTTTreeNodeInterface xtt2, String method, String old, boolean b) {
        this.xtt = xtt2;
        this.data = old;
        this.method = method;
        this.isInternal = b;
    }

    private String getTrueMethodName(String inStr) {
        String name = "set";
        name = name + inStr.substring(0, 1).toUpperCase() + inStr.substring(1, inStr.length());
        return name;
    }

    public void setOldData(String str) {
        this.data = str;
    }

    public void setXTT(XTTTreeNodeInterface xtt2) {
        this.xtt = xtt2;
    }

    @Override
    public void undo() throws CannotUndoException {
        try {
            if (this.xtt == null || this.data == null) {
                return;
            }
            Class<?> cls = this.xtt.getClass();
            Class[] classes = new Class[]{this.data.getClass()};
            Method m = cls.getMethod(this.getTrueMethodName(this.method), classes);
            Object[] objs = new Object[]{this.data};
            m.invoke((Object)this.xtt, objs);
            if (this.isInternal) {
                DefaultMutableTreeNode dmtn = this.xtt.getDefaultMutableTreeNode();
                XTTFrame.frame.setSelectedNode(dmtn);
                ((JTabbedPane)XTTFrame.frame.getBottomPanel()).setSelectedIndex(this.xtt.getTabbedIndex(this.method));
                ((AbstractDisplayPanel)((JTabbedPane)XTTFrame.frame.getBottomPanel()).getSelectedComponent()).grabComponentFocus(this.method);
                XTTFrame.frame.refreshXTT();
            }
        }
        catch (InvocationTargetException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return false;
    }
}

