/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.table;

import com.syscom.ut.textField.IntegerField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class MixedCellEditor
implements TableCellEditor {
    JComponent[] comps = null;
    JComponent editorComponent = null;
    IntegerField text0 = new IntegerField(Integer.MAX_VALUE, true, true);
    protected Object value;
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent = null;
    protected int clickCountToStart = 1;

    public MixedCellEditor(JComponent[] comps) {
        this.comps = comps;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComponent c = null;
        c = row < 0 || row >= this.comps.length ? this.text0 : this.comps[row];
        final JTable t = table;
        if (c instanceof JComboBox) {
            JComboBox combo = (JComboBox)c;
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    t.editingStopped(null);
                }
            });
        }
        if (c instanceof IntegerField) {
            JComponent intField = c;
            ((JTextField)intField).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    t.editingStopped(null);
                }
            });
        }
        this.editorComponent = c;
        return c;
    }

    @Override
    public Object getCellEditorValue() {
        String s = "";
        if (this.editorComponent instanceof JComboBox) {
            s = ((JComboBox)this.editorComponent).getSelectedItem().toString().trim();
        } else if (this.editorComponent instanceof IntegerField) {
            s = ((IntegerField)this.editorComponent).getText().toString().trim();
        }
        return s;
    }

    public void setCellEditorValue(Object value) {
        this.value = value;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    public void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    public void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
        }
    }
}

