/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.preferences;

import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.preference.CorePreferences;
import com.syscom.xml.xtt.console.XTTFrame;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class PreferencesXml
extends CorePreferences {
    private int frame_width = 900;
    private int frame_height = 690;
    private int vertical = 500;
    private int horizontal = 370;
    private Point position = new Point(0, 0);
    private short add_mode = 1;
    private short node_as_child = 1;
    private short dnd_as_element = 1;
    private short view_running_result = 1;
    private short show_customized_node = 1;
    private String selected_directory = null;
    private Element syscom = null;
    public static final short XTT_TEMPLATE = 0;
    public static final short XTT_QUERYELEMENT = 1;
    public static final short XTT_ATTRIBUTE = 2;
    public String orString = null;
    public boolean isWindows = true;
    public String[] editing_xtt = new String[4];
    public String user_dir = null;
    public String file_separator = null;
    public static final int ADD_MODE = 0;
    public static final int NODE_AS_CHILD = 1;
    public static final int DND_AS_ELEMENT = 2;
    public static final int VIEW_RUNNING_RESULT_BY_BROWSER = 3;
    public static final int SHOW_CUSTOMIZED_DLG = 4;
    public static final int SELECTED_DIRECTORY = 5;
    private static PreferencesXml self = null;

    public static void initPreferencesXml() {
        if (self == null) {
            self = new PreferencesXml();
        }
    }

    public static PreferencesXml getPreferencesXml() {
        if (self == null) {
            self = new PreferencesXml();
        }
        return self;
    }

    public PreferencesXml() {
        try {
            this.init();
        }
        catch (Exception e) {
            LocaleManager.getLocaleManager(CorePreferences.getLanguageChoice());
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.file_separator = System.getProperty("file.separator");
        this.user_dir = System.getProperty("user.dir");
        this.isWindows = this.file_separator.equals("\\");
        this.init(CorePreferences.getConfigName());
    }

    private void init(String fileName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new File(fileName));
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        String temp = null;
        Node node = null;
        this.resetDOM(doc);
        node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/xtt");
        if (node != null && node.getNodeType() == 1 && (temp = ((Element)node).getAttribute("selected_directory")) != null && temp.length() > 0) {
            this.selected_directory = temp;
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/xtt/frame")) != null && node.getNodeType() == 1) {
            Element elm = (Element)node;
            temp = elm.getAttribute("width");
            if (temp != null && temp.length() > 0) {
                this.frame_width = Integer.parseInt(temp);
                if (this.frame_width < 0) {
                    this.frame_width = 900;
                }
            }
            if ((temp = elm.getAttribute("height")) != null && temp.length() > 0) {
                this.frame_height = Integer.parseInt(temp);
                if (this.frame_height < 0) {
                    this.frame_height = 690;
                }
            }
            if ((temp = elm.getAttribute("vertical")) != null && temp.length() > 0) {
                this.vertical = Integer.parseInt(temp);
                if (this.vertical < 0) {
                    this.vertical = 500;
                }
            }
            if ((temp = elm.getAttribute("horizontal")) != null && temp.length() > 0) {
                this.horizontal = Integer.parseInt(temp);
                if (this.horizontal < 0) {
                    this.horizontal = 370;
                }
            }
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int xpos = 0;
            int ypos = 0;
            temp = elm.getAttribute("xpos");
            if (temp != null && temp.length() > 0 && ((xpos = Integer.parseInt(temp)) < 0 || (double)xpos > screenSize.getWidth())) {
                xpos = 0;
            }
            if ((temp = elm.getAttribute("ypos")) != null && temp.length() > 0 && ((ypos = Integer.parseInt(temp)) < 0 || (double)ypos > screenSize.getHeight())) {
                ypos = 0;
            }
            this.position = new Point(xpos, ypos);
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/xtt/options")) != null && node.getNodeType() == 1) {
            temp = ((Element)node).getAttribute("add_mode");
            if (temp != null && temp.length() > 0) {
                this.add_mode = Short.parseShort(temp);
            }
            if ((temp = ((Element)node).getAttribute("node_as_child")) != null && temp.length() > 0) {
                this.node_as_child = Short.parseShort(temp);
            }
            if ((temp = ((Element)node).getAttribute("dnd_as_element")) != null && temp.length() > 0) {
                this.dnd_as_element = Short.parseShort(temp);
            }
            if ((temp = ((Element)node).getAttribute("view_running_result_by_browser")) != null && temp.length() > 0) {
                this.view_running_result = Short.parseShort(temp);
            }
            if ((temp = ((Element)node).getAttribute("show_customized_dlg")) != null && temp.length() > 0) {
                this.show_customized_node = Short.parseShort(temp);
            }
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/xtt/recents")) != null && node.getNodeType() == 1) {
            for (int i = 0; i < 4; ++i) {
                temp = ((Element)node).getAttribute("recent_file" + Integer.toString(i + 1));
                if (temp == null || temp.length() <= 0) continue;
                this.editing_xtt[i] = temp;
            }
        }
    }

    public void updateVariables(int options, String value) {
        switch (options) {
            case 0: {
                this.add_mode = Short.parseShort(value);
                break;
            }
            case 1: {
                this.node_as_child = Short.parseShort(value);
                break;
            }
            case 2: {
                this.dnd_as_element = Short.parseShort(value);
                break;
            }
            case 3: {
                this.view_running_result = Short.parseShort(value);
                break;
            }
            case 4: {
                this.show_customized_node = Short.parseShort(value);
                break;
            }
            case 5: {
                this.selected_directory = value;
            }
        }
    }

    public String[] getRecents() {
        return this.editing_xtt;
    }

    public Point getLocation() {
        return this.position;
    }

    public int getFrameWidth() {
        return this.frame_width;
    }

    public int getFrameHeight() {
        return this.frame_height;
    }

    public int getVerticalDividerLocation() {
        return this.vertical;
    }

    public int getHorizontalDividerLocation() {
        return this.horizontal;
    }

    public short getAddModeSetting() {
        return this.add_mode;
    }

    public boolean getAddModeSettingForBoolean() {
        boolean b = true;
        b = this.add_mode == 1;
        return b;
    }

    public short getNodeAsChildSetting() {
        return this.node_as_child;
    }

    public boolean getNodeAsChildSettingForBoolean() {
        boolean b = true;
        b = this.node_as_child == 1;
        return b;
    }

    public short getDndAsElementSetting() {
        return this.dnd_as_element;
    }

    public boolean getDndAsElementSettingForBoolean() {
        boolean b = true;
        b = this.dnd_as_element == 1;
        return b;
    }

    public short getViewRunningResult() {
        return this.view_running_result;
    }

    public boolean getViewRunningResultForBoolean() {
        boolean b = true;
        b = this.view_running_result == 1;
        return b;
    }

    public short getShowCustomizedNode() {
        return this.show_customized_node;
    }

    public boolean getShowCustomizedNodeForBoolean() {
        boolean b = true;
        b = this.show_customized_node == 1;
        return b;
    }

    public String getSelectedDirectory() {
        return this.selected_directory;
    }

    @Override
    public void save() {
        this.save(PreferencesXml.getConfigName());
    }

    private void save(String fileName) {
        this.frame_width = XTTFrame.frame.getWidth();
        this.frame_height = XTTFrame.frame.getHeight();
        this.vertical = XTTFrame.frame.getVerticalDividerLocation();
        this.horizontal = XTTFrame.frame.getHorizontalDividerLocation();
        this.position = XTTFrame.frame.getLocationOnScreen();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Document doc = null;
        Element xtt2 = null;
        File file = new File(fileName);
        if (file.exists()) {
            try {
                doc = builder.parse(new File(fileName));
            }
            catch (Exception pe) {
                doc = builder.newDocument();
            }
        } else {
            doc = builder.newDocument();
        }
        this.setDOM(doc);
        this.syscom = doc.getDocumentElement();
        if (this.syscom == null) {
            System.out.println("CorePreferences fails to save <syscom>");
        }
        xtt2 = doc.createElement("xtt");
        if (this.selected_directory != null && this.selected_directory.length() > 0) {
            xtt2.setAttribute("selected_directory", this.selected_directory);
        }
        Element frame = doc.createElement("frame");
        frame.setAttribute("width", Integer.toString(this.frame_width));
        frame.setAttribute("height", Integer.toString(this.frame_height));
        frame.setAttribute("vertical", Integer.toString(this.vertical));
        frame.setAttribute("horizontal", Integer.toString(this.horizontal));
        frame.setAttribute("xpos", Integer.toString((int)this.position.getX()));
        frame.setAttribute("ypos", Integer.toString((int)this.position.getY()));
        Element options = doc.createElement("options");
        options.setAttribute("add_mode", Short.toString(this.add_mode));
        options.setAttribute("node_as_child", Short.toString(this.node_as_child));
        options.setAttribute("dnd_as_element", Short.toString(this.dnd_as_element));
        options.setAttribute("view_running_result_by_browser", Short.toString(this.view_running_result));
        options.setAttribute("show_customized_dlg", Short.toString(this.show_customized_node));
        xtt2.appendChild(frame);
        xtt2.appendChild(options);
        Element recents = doc.createElement("recents");
        int size = this.editing_xtt.length;
        if (size > 0) {
            size = size > 4 ? 4 : size;
            for (int i = 0; i < size; ++i) {
                if (this.editing_xtt[i] == null || this.editing_xtt[i].length() <= 0) continue;
                recents.setAttribute("recent_file" + Integer.toString(i + 1), this.editing_xtt[i]);
            }
            xtt2.appendChild(recents);
        }
        Node orig = null;
        try {
            orig = XPathAPI.selectSingleNode((Node)this.syscom, (String)"xtt");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (orig != null && orig.getNodeType() == 1) {
            this.syscom.replaceChild(xtt2, orig);
        } else {
            this.syscom.appendChild(xtt2);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            DefaultSAXOutputHandler handler = new DefaultSAXOutputHandler((OutputStream)out, "UTF-8");
            TreeWalker tw = new TreeWalker((ContentHandler)handler);
            tw.traverse((Node)doc);
            out.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static String getAttributeValue(Element element, String itemName) {
        String attributeValue = null;
        attributeValue = element.getAttribute(itemName);
        if (attributeValue == null || attributeValue.length() == 0) {
            attributeValue = element.getAttribute("xtt:" + itemName);
        }
        return attributeValue;
    }

    public static String getAttributeValue(Element element, String prefix, String attributeName) {
        String attributeValue = null;
        attributeValue = element.getAttribute(attributeName);
        if (attributeValue == null || attributeValue.length() == 0) {
            attributeValue = element.getAttribute(prefix + ":" + attributeName);
        }
        return attributeValue;
    }
}

