/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.misc;

import com.syscom.importxsddtd.XSDDTDDisabledTreeNode;
import com.syscom.xml.xttinterface.TreeNodeInterface;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class XMLTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Color background = null;
    private Color foreground = null;
    private Color selectionBackground = null;
    private Color selectionForeground = null;
    private JPanel comp = new JPanel(new BorderLayout(2, 2));
    private JPanel tcomp = new JPanel(new BorderLayout());
    private JLabel text = new JLabel();
    private JLabel icon = new JLabel();
    private int length = 0;
    private boolean isXSD = false;

    public XMLTreeCellRenderer() {
        this(false);
    }

    public XMLTreeCellRenderer(boolean isXSD) {
        this.isXSD = isXSD;
        JTable temp = new JTable();
        this.background = temp.getBackground();
        this.foreground = temp.getForeground();
        this.selectionBackground = temp.getSelectionBackground();
        this.selectionForeground = temp.getSelectionForeground();
        this.tcomp.add((Component)this.text, "Center");
        this.comp.setBackground(Color.white);
        this.comp.add((Component)this.icon, "West");
        this.comp.add((Component)this.tcomp, "Center");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!this.isXSD) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            TreeNodeInterface object = (TreeNodeInterface)node.getUserObject();
            boolean isFreeze = false;
            if (object != null) {
                this.icon.setIcon(object.getImageIcon());
                isFreeze = object.isFreeze();
            }
            this.text.setText(" " + value.toString() + " ");
            this.text.setHorizontalAlignment(2);
            this.text.setBorder(null);
            if (sel) {
                this.tcomp.setBackground(this.selectionBackground);
                this.text.setForeground(this.selectionForeground);
            } else {
                this.tcomp.setBackground(this.background);
                if (isFreeze) {
                    this.text.setForeground(Color.gray);
                } else {
                    this.text.setForeground(this.foreground);
                }
            }
            this.length = this.text.getText().length();
            if (this.length > this.comp.getWidth()) {
                this.comp.setSize(this.length, this.comp.getHeight());
            }
            this.comp.revalidate();
            this.comp.repaint();
        } else {
            XSDDTDDisabledTreeNode node = (XSDDTDDisabledTreeNode)value;
            if (node.getLevel() == 1) {
                node.setEnabled(true);
            } else {
                node.setEnabled(false);
            }
            XTTTreeNodeInterface object = (XTTTreeNodeInterface)node.getUserObject();
            boolean isFreeze = false;
            if (object != null) {
                if (node.isEnabled()) {
                    this.icon.setIcon(object.getImageIcon());
                    isFreeze = false;
                } else {
                    this.icon.setIcon(object.getDisabledImageIcon());
                    isFreeze = true;
                }
            }
            this.text.setText(" " + value.toString() + " ");
            this.text.setHorizontalAlignment(2);
            this.text.setBorder(null);
            if (isFreeze) {
                this.tcomp.setBackground(this.background);
                this.text.setForeground(Color.gray);
            } else if (sel) {
                this.tcomp.setBackground(this.selectionBackground);
                this.text.setForeground(this.selectionForeground);
            } else {
                this.text.setForeground(this.selectionForeground);
                this.tcomp.setBackground(this.background);
            }
            this.length = this.text.getText().length();
            if (this.length > this.comp.getWidth()) {
                this.comp.setSize(this.length, this.comp.getHeight());
            }
            this.comp.revalidate();
            this.comp.repaint();
        }
        return this.comp;
    }
}

