/*
 * Decompiled with CFR 0.152.
 */
package wizard.task;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbatool.LoginDlg;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.comp.WizardTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.text.EditorPane;
import dbaut.textField.CharField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import wizard.WizardPanel;

public class CreateTaskDlg
extends JDialog {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.wizard.ResWizard", LocaleManager.getLocale());
    private CharField task_Name_TextField = new CharField(128, true);
    private JComboBox type_ComboBox = new JComboBox();
    private SteppedComboBox schemaComboBox = new SteppedComboBox();
    private JEditorPane task_Statement_Editor = new EditorPane();
    private HelpButton help_Button = new HelpButton();

    public CreateTaskDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CreateTaskDlg(Frame frame) {
        super(frame);
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setName("TaskDialogWizard");
        DbaButton Cancel_Button = new DbaButton();
        Cancel_Button.setName("CancelButton");
        DbaButton OK_Button = new DbaButton();
        JPanel panel1 = new JPanel(new BorderLayout());
        DbFrame.frame.enableDialogHelp(this.getRootPane(), this.help_Button, "CreateTaskDlgHelpIDInformation", null);
        this.setTitle(this.res.getString("Create_Task_settitle"));
        panel1.setPreferredSize(new Dimension(640, 500));
        JPanel panel12 = new JPanel(new BorderLayout());
        panel12.add((Component)new JLabel(DBAImageResource.getResource(this.getClass(), "/jdbaimages/taskwizard.gif")), "North");
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add((Component)new WizardTextPane(18, 14, Color.WHITE, this.res.getString("Create_Task") + "\n" + this.res.getString("It_is_possible_to_create_a_task")), null);
        panel12.add((Component)jScrollPane1, "Center");
        panel1.add((Component)panel12, "West");
        panel12 = new JPanel(new BorderLayout());
        panel12.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel panel14 = new JPanel(new GridLayout(4, 2, 4, 4));
        panel14.add(new JLabel(this.res.getString("Owner_Name")));
        panel14.add(this.schemaComboBox);
        panel14.add(new JLabel(this.res.getString("Task_Name")));
        panel14.add(this.task_Name_TextField);
        panel12.add((Component)panel14, "North");
        panel14.add(new JLabel(this.res.getString("Task_Type")));
        panel14.add(this.type_ComboBox);
        panel14.add(new JLabel(this.res.getString("Actions")));
        panel12.add((Component)panel14, "North");
        jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add((Component)this.task_Statement_Editor, null);
        panel12.add((Component)jScrollPane1, "Center");
        JTextArea textArea = new JTextArea(this.res.getString("For_example_n").trim() + "\n" + "    INSERT INTO t1 VALUES(1,2)\n");
        textArea.setEditable(false);
        textArea.setOpaque(true);
        textArea.setBackground(WizardPanel.sysColor);
        textArea.setBorder(null);
        panel12.add((Component)textArea, "South");
        panel1.add((Component)panel12, "Center");
        panel12 = new JPanel(new FlowLayout(2));
        panel12.add(OK_Button);
        panel12.add(Cancel_Button);
        panel12.add(this.help_Button);
        panel1.add((Component)panel12, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel1, "Center");
        Cancel_Button.setText(this.res.getString("Cancel"));
        Cancel_Button.setMnemonic('C');
        Cancel_Button.addActionListener(new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        OK_Button.setText(this.res.getString("Ok"));
        OK_Button.setMnemonic('O');
        OK_Button.addActionListener(new ReflectionAction(this, "OK_Button_actionPerformed"));
        this.task_Statement_Editor.setBorder(null);
        OK_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        Cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        this.help_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/help.gif"));
        this.task_Name_TextField.setName("TaskNameField");
        this.task_Statement_Editor.setName("TaskScriptsEditorPanel");
        OK_Button.setName("OKButton");
        this.getSchemaNames(this.schemaComboBox);
        this.schemaComboBox.setSelectedItem(LoginDlg.loginUserName);
        this.getTypeName();
        this.type_ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String stmt;
                JComboBox comboBox = (JComboBox)e.getSource();
                String selected = (String)comboBox.getSelectedItem();
                if (selected.compareTo("STORE_PROCEDURE") == 0 && ((stmt = CreateTaskDlg.this.task_Statement_Editor.getText()) == null || stmt.length() == 0)) {
                    CreateTaskDlg.this.task_Statement_Editor.setText("CALL ProcName");
                }
            }
        });
    }

    private void getSchemaNames(JComboBox combo) {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> v = new Vector<String>();
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery("select SCHEMA_NAME from SYSSCHEMA where SCHEMA_OWNER != 'SYSTEM' order by SCHEMA_NAME");
            String s = null;
            while (rs.next()) {
                s = rs.getString(1);
                if (GuiUt.rightTrim(s).length() > 0) {
                    s = GuiUt.rightTrim(s);
                }
                v.add(s);
            }
            DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
            combo.setModel(cbm);
            rs.close();
            stmt.close();
        }
        catch (SQLException qune) {
            GuiUt.showSQLException(this, null, qune);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
    }

    private void getTypeName() {
        String[] types = new String[]{"SQL_STATEMENT", "STORE_PROCEDURE", "EXECUTABLE"};
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>(types);
        this.type_ComboBox.setModel(cbm);
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        String owner = GuiUt.getIDString(this.schemaComboBox.getSelectedItem().toString().trim());
        String name = GuiUt.getIDString(this.task_Name_TextField.getText());
        String type = this.type_ComboBox.getSelectedItem().toString();
        String stmt = this.task_Statement_Editor.getText();
        if (name.length() == 0 || stmt.length() == 0) {
            GuiUt.showErrorDlg(this, this.res.getString("Task_name_and_statement_are_both_required"), null);
            return;
        }
        String query = null;
        stmt = stmt.replace("'", "''");
        query = "{call TASK_CREATE( '" + owner + "." + name + "','" + type + "','" + stmt + "')}";
        boolean result = DatabaseConnection.executeSQL(this, query);
        if (!result) {
            return;
        }
        GuiUt.showInformationDlg(DbFrame.frame, this.res.getString("Task_is_created_successful"));
        this.Cancel_Button_actionPerformed(null);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

