/*
 * Decompiled with CFR 0.152.
 */
package wizard.acl;

import dbatool.DbFrame;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaTable;
import dbaut.comp.WizardTextPane;
import dbaut.resource.DBAImageResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import wizard.AbstractWizardPanel2;
import wizard.acl.CreateAclRowInfo;
import wizard.acl.CreateAclTableCols;
import wizard.acl.CreateAclWizardDlg;
import wizard.acl.CreateAclWizardPanel3;

public class CreateAclWizardPanel2
extends AbstractWizardPanel2 {
    private static final long serialVersionUID = 381947710764901605L;
    private CreateAclTableCols createAclTableCols = new CreateAclTableCols();
    private DbaTable userTable = new DbaTable(this.createAclTableCols);

    public CreateAclWizardPanel2(CreateAclWizardDlg dlg, AbstractWizardPanel2 previous) {
        super(1, previous);
        try {
            this.parentDlg = dlg;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.title = this.res.getString("Create_Acl_Step2_title");
        this.setName("AllowUsersPanel");
        this.userTable.setName("AllowUsersTable");
        this.setTextPanel(new WizardTextPane(18, 14, Color.WHITE, this.res.getString("Create_Acl_Step2_Description")));
        this.setImage(DBAImageResource.getResource(this.getClass(), "/jdbaimages/aclwizard-2.gif"));
        JScrollPane userScrollPane = new JScrollPane();
        this.setColumnWidth();
        this.getUserList();
        userScrollPane.getViewport().add(this.userTable);
        JPanel panel0 = this.createContentPanel();
        panel0.add((Component)userScrollPane, "Center");
        this.Next_Button.setEnabled(false);
        DbFrame.frame.enableDialogHelp(this, this.help_Button, "wizard.create.acl", null);
        this.userTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                CreateAclWizardPanel2.this.userTable_mouseReleased(e);
            }
        });
    }

    private void setColumnWidth() {
        TableColumn colName = this.userTable.getColumn(this.res.getString("User"));
        TableColumn desc = this.userTable.getColumn(this.res.getString("Allow"));
        TableColumn desc2 = this.userTable.getColumn(this.res.getString("Block"));
        colName.setPreferredWidth(196);
        desc.setPreferredWidth(50);
        desc2.setPreferredWidth(50);
    }

    private void getUserList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery("select USER_NAME from SYSAUTHUSER");
            CreateAclRowInfo rowInfo = null;
            while (rs.next()) {
                rowInfo = new CreateAclRowInfo(rs.getString(1));
                this.createAclTableCols.addValue(rowInfo);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.parentDlg, null, sqle);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
    }

    @Override
    public void Next_Button_actionPerformed(ActionEvent e) {
        if (this.next == null) {
            this.next = new CreateAclWizardPanel3((CreateAclWizardDlg)this.parentDlg, (AbstractWizardPanel2)this);
        }
        this.buildUserList();
        ((CreateAclWizardDlg)this.parentDlg).Next(this.next);
    }

    @Override
    public void Previous_Button_actionPerformed(ActionEvent e) {
        ((CreateAclWizardDlg)this.parentDlg).Next(this.previous);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    void userTable_mouseReleased(MouseEvent e) {
        int rowCount = this.userTable.getRowCount();
        Boolean allow = null;
        Boolean block = null;
        for (int i = 0; i < rowCount; ++i) {
            allow = (Boolean)this.userTable.getValueAt(i, 1);
            block = (Boolean)this.userTable.getValueAt(i, 2);
            if (allow.booleanValue() || block.booleanValue()) break;
        }
        this.Next_Button.setEnabled(allow != false || block != false);
    }

    void buildUserList() {
        int rowCount = this.userTable.getRowCount();
        Boolean allow = null;
        Boolean block = null;
        ((CreateAclWizardDlg)this.parentDlg).allowUserlist = "";
        ((CreateAclWizardDlg)this.parentDlg).blockUserlist = "";
        for (int i = 0; i < rowCount; ++i) {
            allow = (Boolean)this.userTable.getValueAt(i, 1);
            block = (Boolean)this.userTable.getValueAt(i, 2);
            if (allow.booleanValue()) {
                ((CreateAclWizardDlg)this.parentDlg).allowUserlist = ((CreateAclWizardDlg)this.parentDlg).allowUserlist + GuiUt.getIDString(this.userTable.getValueAt(i, 0).toString().trim()) + ",";
            }
            if (!block.booleanValue()) continue;
            ((CreateAclWizardDlg)this.parentDlg).blockUserlist = ((CreateAclWizardDlg)this.parentDlg).blockUserlist + GuiUt.getIDString(this.userTable.getValueAt(i, 0).toString().trim()) + ",";
        }
        if (((CreateAclWizardDlg)this.parentDlg).allowUserlist.endsWith(",")) {
            ((CreateAclWizardDlg)this.parentDlg).allowUserlist = ((CreateAclWizardDlg)this.parentDlg).allowUserlist.substring(0, ((CreateAclWizardDlg)this.parentDlg).allowUserlist.length() - 1);
        }
        if (((CreateAclWizardDlg)this.parentDlg).blockUserlist.endsWith(",")) {
            ((CreateAclWizardDlg)this.parentDlg).blockUserlist = ((CreateAclWizardDlg)this.parentDlg).blockUserlist.substring(0, ((CreateAclWizardDlg)this.parentDlg).blockUserlist.length() - 1);
        }
    }
}

