/*
 * Decompiled with CFR 0.152.
 */
package ui;

import dbaut.preference.CorePreferences;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import ui.JsqlUI;
import ui.gui.JsqlGUI;

public class Jsql2Preferences
extends CorePreferences {
    public static final int DEF_WIDTH = 650;
    public static final int DEF_HEIGHT = 450;
    private static Jsql2Preferences self = null;
    private Point position = new Point(100, 100);
    private int frameWidth = 650;
    private int frameHeight = 450;
    private JsqlUI ui = null;

    public static Jsql2Preferences getPreferencesXml(JsqlUI gui) {
        if (self == null) {
            self = new Jsql2Preferences(gui);
        }
        return self;
    }

    public Jsql2Preferences(JsqlUI gui) {
        this.ui = gui;
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.init(Jsql2Preferences.getConfigName());
    }

    private void init(String fileName) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(fileName);
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        String temp = null;
        Node node = null;
        this.resetDOM(doc);
        if (this.ui instanceof JsqlGUI && (node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jsql2/frame")) != null && node.getNodeType() == 1) {
            Element elm = (Element)node;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int xpos = 0;
            int ypos = 0;
            temp = elm.getAttribute("xpos");
            if (temp != null && temp.length() > 0 && ((xpos = Integer.parseInt(temp)) < 0 || (double)xpos > screenSize.getWidth())) {
                xpos = 0;
            }
            if ((temp = elm.getAttribute("ypos")) != null && temp.length() > 0 && ((ypos = Integer.parseInt(temp)) < 0 || (double)ypos > screenSize.getHeight())) {
                ypos = 0;
            }
            this.position = new Point(xpos, ypos);
            temp = elm.getAttribute("width");
            if (temp != null && temp.length() > 0) {
                this.frameWidth = Integer.parseInt(temp);
                if (this.frameWidth < 0) {
                    this.frameWidth = 650;
                }
            }
            if ((temp = elm.getAttribute("height")) != null && temp.length() > 0) {
                this.frameHeight = Integer.parseInt(temp);
                if (this.frameHeight < 0) {
                    this.frameHeight = 450;
                }
            }
        }
    }

    public void setPreferences() throws Exception {
        String fileName = Jsql2Preferences.getConfigName();
        File f = new File(fileName);
        if (!f.exists()) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(fileName);
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        String temp = null;
        Node node = null;
        this.resetDOM(doc);
        node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jsql2/set");
        if (node != null && node.getNodeType() == 1) {
            temp = ((Element)node).getAttribute("env");
            if (temp != null && temp.length() > 0) {
                this.ui.setIsqlStatus(1, temp);
            }
            if ((temp = ((Element)node).getAttribute("ienc")) != null && temp.length() > 0) {
                this.ui.setIsqlStatus(2, temp);
            }
            if ((temp = ((Element)node).getAttribute("printto")) != null && temp.length() > 0) {
                this.ui.setIsqlStatus(3, temp);
            }
            if ((temp = ((Element)node).getAttribute("oenc")) != null && temp.length() > 0) {
                this.ui.setIsqlStatus(4, temp);
            }
            if ((temp = ((Element)node).getAttribute("show_time")) != null && temp.length() > 0) {
                this.ui.setIsqlStatus(5, temp);
            }
            if ((temp = ((Element)node).getAttribute("work_dir")) != null && temp.length() > 0) {
                this.ui.setIsqlStatus(6, temp);
            }
            if ((temp = ((Element)node).getAttribute("login_timeout")) != null && temp.length() > 0) {
                this.ui.setIsqlStatus(7, temp);
            }
            if ((temp = ((Element)node).getAttribute("line_width")) != null && temp.length() > 0) {
                this.ui.setIsqlStatus(8, temp);
            }
            if ((temp = ((Element)node).getAttribute("blob_show")) != null && temp.length() > 0) {
                this.ui.setIsqlStatus(9, temp);
            }
            if ((temp = ((Element)node).getAttribute("blob_pref")) != null && temp.length() > 0) {
                this.ui.setIsqlStatus(10, temp);
            }
            if ((temp = ((Element)node).getAttribute("blob_width")) != null && temp.length() > 0) {
                this.ui.setIsqlStatus(11, temp);
            }
        }
    }

    public Dimension getSize() {
        return new Dimension(this.frameWidth, this.frameHeight);
    }

    public Point getLocation() {
        return this.position;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    @Override
    public void save() {
        this.save(Jsql2Preferences.getConfigName());
    }

    private void save(String fileName) {
        if (this.ui instanceof JsqlGUI) {
            this.frameWidth = ((JsqlGUI)this.ui).getFrame().getWidth();
            this.frameHeight = ((JsqlGUI)this.ui).getFrame().getHeight();
            this.position = ((JsqlGUI)this.ui).getFrame().getLocation();
            System.out.println(this.position);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Document doc = null;
        Element jsql2 = null;
        File file = new File(fileName);
        if (file.exists()) {
            try {
                doc = builder.parse(fileName);
            }
            catch (Exception pe) {
                doc = builder.newDocument();
            }
        } else {
            doc = builder.newDocument();
        }
        this.setDOM(doc);
        Element syscom = doc.getDocumentElement();
        if (syscom == null) {
            System.out.println("CorePreferences fails to save <syscom>");
        }
        jsql2 = doc.createElement("jsql2");
        if (this.ui instanceof JsqlGUI) {
            Element frame = doc.createElement("frame");
            frame.setAttribute("width", Integer.toString(this.frameWidth));
            frame.setAttribute("height", Integer.toString(this.frameHeight));
            frame.setAttribute("xpos", Integer.toString((int)this.position.getX()));
            frame.setAttribute("ypos", Integer.toString((int)this.position.getY()));
            jsql2.appendChild(frame);
        }
        Element set = doc.createElement("set");
        set.setAttribute("env", this.ui.getIsqlStatus(1));
        set.setAttribute("ienc", this.ui.getIsqlStatus(2));
        set.setAttribute("printto", this.ui.getIsqlStatus(3));
        set.setAttribute("oenc", this.ui.getIsqlStatus(4));
        set.setAttribute("show_time", this.ui.getIsqlStatus(5));
        set.setAttribute("work_dir", this.ui.getIsqlStatus(6));
        set.setAttribute("login_timeout", this.ui.getIsqlStatus(7));
        set.setAttribute("line_width", this.ui.getIsqlStatus(8));
        set.setAttribute("blob_show", this.ui.getIsqlStatus(9));
        set.setAttribute("blob_pref", this.ui.getIsqlStatus(10));
        set.setAttribute("blob_width", this.ui.getIsqlStatus(11));
        jsql2.appendChild(set);
        Node orig = null;
        try {
            orig = XPathAPI.selectSingleNode((Node)syscom, (String)"jsql2");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (orig != null && orig.getNodeType() == 1) {
            syscom.replaceChild(jsql2, orig);
        } else {
            syscom.appendChild(jsql2);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            DefaultSAXOutputHandler handler = new DefaultSAXOutputHandler((OutputStream)out, "UTF-8");
            TreeWalker tw = new TreeWalker((ContentHandler)handler);
            tw.traverse((Node)doc);
            out.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

