/*
 * Decompiled with CFR 0.152.
 */
package tableCell;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import dbatool.DbFrame;
import dbatool.tableCell.JSONJTextPane;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.WebBrowser;
import dbaut.comp.DbaMenu;
import dbaut.comp.DbaMenuItem;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.text.TextArea;
import dbaut.util.JdbcUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.widget.ScrollingImagePanel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import queryAnalyzer.AsTableModel;
import tableCell.BlobCellObject;
import tableCell.BlobEditor;
import tableCell.BlobEditorButtonInterface;

public class BlobEditorButton
extends JButton
implements BlobEditorButtonInterface {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    private BlobCellObject object = null;
    private BlobEditor editor = null;
    private JTable table = null;
    private AsTableModel model = null;
    private static int displayClobMaxSize = 10240;
    private static int bufferSize = 1024;
    private static int displayBlobMaxSize = 0x300000;
    private Object[] images = new Object[]{new String[]{"BMP", "bmp image", "BMP"}, new String[]{"JPG", "jpg image", "JPEG"}, new String[]{"GIF", "gif image", "GIF"}, new String[]{"TIF", "tif image", "TIFF"}};
    private Object[] tmpfiles = new Object[]{new String[]{"html", "H", "html"}, new String[]{"word document", "W", "DOC"}, new String[]{"pdf document", "P", "PDF"}, new String[]{"rtf document", "R", "RTF"}, new String[]{"wav audio", "U", "WAV"}, new String[]{"avi vedio", "V", "AVI"}};

    public BlobEditorButton() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setTableAndModel(JTable table, AsTableModel model) {
        this.table = table;
        this.model = model;
    }

    @Override
    public void setEditor(BlobEditor editor) {
        this.editor = editor;
    }

    @Override
    public BlobCellObject getValue() {
        return this.object;
    }

    @Override
    public void setValue(BlobCellObject object) {
        this.object = object;
        if (object != null) {
            this.setText(object.toString());
        }
    }

    private void jbInit() throws Exception {
        this.setBorder(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BlobEditorButton.this.this_mouseClicked(e);
            }
        });
    }

    void this_mouseClicked(MouseEvent e) {
        int i;
        JPopupMenu menu = new JPopupMenu();
        DbaMenu viewer_menu = new DbaMenu("view", 'v');
        DbaMenuItem text = new DbaMenuItem("text", 't', new ReflectionAction(this, "text_actionPerformed"));
        Object tmp = null;
        String[] t = null;
        for (i = 0; i < this.images.length; ++i) {
            t = (String[])this.images[i];
            viewer_menu.add(new DbaMenuItem(t[1], t[1].charAt(0), new ReflectionAction(this, "image_actionPerformed")));
        }
        viewer_menu.addSeparator();
        viewer_menu.add(text);
        if (DbFrame.isWindows) {
            for (i = 0; i < this.tmpfiles.length; ++i) {
                t = (String[])this.tmpfiles[i];
                viewer_menu.add(new DbaMenuItem(t[0], t[1].charAt(0), new ReflectionAction(this, "tmpfile_actionPerformed")));
            }
        }
        if (!this.object.isNull) {
            viewer_menu.setEnabled(true);
        } else {
            viewer_menu.setEnabled(false);
        }
        menu.add(viewer_menu);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void text_actionPerformed(ActionEvent e) {
        String total;
        byte[] ba;
        String title;
        block25: {
            if (this.object == null) {
                return;
            }
            title = this.object.column_name;
            InputStream in = null;
            ba = null;
            total = null;
            Reader reader = null;
            long len = -1L;
            ResultSet vResultSet = null;
            try {
                vResultSet = this.object.getResultSet();
                int rowNum = this.object.getRowNum();
                int colNum = this.object.getColNum();
                if (vResultSet != null && vResultSet.absolute(rowNum)) {
                    Clob c;
                    if (this.object.type.equalsIgnoreCase("long varchar") || this.object.type.equalsIgnoreCase("clob") || this.object.type.equalsIgnoreCase("longvarchar")) {
                        c = vResultSet.getClob(colNum);
                        len = c.length();
                        JdbcUtil.free(c);
                        in = vResultSet.getAsciiStream(colNum);
                    } else if (this.object.type.equalsIgnoreCase("nclob")) {
                        c = vResultSet.getClob(colNum);
                        len = c.length();
                        JdbcUtil.free(c);
                        reader = vResultSet.getCharacterStream(colNum);
                    } else {
                        Blob b = vResultSet.getBlob(colNum);
                        len = b.length();
                        JdbcUtil.free(b);
                        in = vResultSet.getBinaryStream(colNum);
                    }
                }
                if (in != null) {
                    int i = in.available();
                    ba = new byte[i];
                    in.read(ba);
                    total = new String(ba).trim();
                }
                if (reader != null) {
                    char[] cbuf = new char[(int)len / 2];
                    reader.read(cbuf);
                    total = new String(cbuf);
                }
                DbaObject.close(in);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                GuiUt.showErrorDlg(DbFrame.frame, ex.getMessage(), null);
                break block25;
            }
            DbaObject.close(reader);
            try {
                vResultSet.first();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            break block25;
            finally {
                DbaObject.close(in);
                DbaObject.close(reader);
                try {
                    vResultSet.first();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (total.length() == 0 && ba.length > 0) {
            String s1 = this.res.getString("Cannot_show_as_text_file_format");
            String s2 = GuiUt.mapStringForProperty(s1, title);
            GuiUt.showErrorDlg(DbFrame.frame, s2, null);
            return;
        }
        JComponent panel0 = null;
        JScrollPane jsoncolsPanel = null;
        if (total.startsWith("{") && total.endsWith("}") || total.startsWith("[") && total.endsWith("]")) {
            try {
                JsonElement root = new JsonParser().parse(total);
                jsoncolsPanel = new JScrollPane(new JSONJTextPane(root));
            }
            catch (Exception root) {
                // empty catch block
            }
        }
        JScrollPane textPanel = new JScrollPane();
        TextArea area = new TextArea(total);
        area.setName("TextAreaContents");
        area.setEditable(false);
        textPanel.getViewport().add(area);
        if (jsoncolsPanel != null) {
            JTabbedPane tabbedPanel = new JTabbedPane();
            tabbedPanel.addTab("Text", textPanel);
            tabbedPanel.addTab("Json", jsoncolsPanel);
            panel0 = tabbedPanel;
        } else {
            panel0 = textPanel;
        }
        JDialog dlg = new JDialog();
        dlg.setName("TextContentsDialog");
        dlg.getContentPane().add(panel0);
        dlg.setPreferredSize(new Dimension(400, 300));
        dlg.setSize(400, 300);
        dlg.setModal(true);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.setVisible(true);
        dlg.dispose();
    }

    public void image_actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        String[] t = null;
        for (int i = 0; i < this.images.length; ++i) {
            t = (String[])this.images[i];
            if (!s.equals(t[1])) continue;
            this.showImage(t[2]);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void showImage(String type) {
        block19: {
            ResultSet vResultSet;
            InputStream in;
            RenderedOp img;
            block18: {
                if (this.object == null) {
                    return;
                }
                String title = this.object.column_name;
                img = null;
                in = null;
                vResultSet = null;
                vResultSet = this.object.getResultSet();
                int rowNum = this.object.getRowNum();
                int colNum = this.object.getColNum();
                if (vResultSet != null && vResultSet.absolute(rowNum)) {
                    in = vResultSet.getBinaryStream(colNum);
                }
                if (in != null) {
                    int len = in.available();
                    if (len > displayBlobMaxSize) {
                        String str1 = this.res.getString("The_length_of_blob");
                        String str2 = this.res.getString("bytes");
                        String str3 = this.res.getString("Suggest_to_export");
                        String str = str1 + len + str2 + str3;
                        GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), str);
                    } else {
                        byte[] ba = new byte[in.available()];
                        in.mark(0);
                        in.read(ba);
                        ByteArraySeekableStream bass = new ByteArraySeekableStream(ba);
                        img = JAI.create((String)type, (Object)bass);
                        in.reset();
                    }
                }
                if (img != null) break block18;
                DbaObject.close(in);
                try {
                    vResultSet.first();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return;
            }
            ScrollingImagePanel display = new ScrollingImagePanel(img, 400, 300);
            final JDialog dlg = new JDialog();
            dlg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    dlg.dispose();
                    System.gc();
                }
            });
            dlg.getContentPane().add((Component)display);
            dlg.setSize(400, 300);
            dlg.setModal(true);
            GuiUt.setCenterLocation(DbFrame.frame, dlg);
            dlg.setVisible(true);
            dlg.dispose();
            DbaObject.close(in);
            try {
                vResultSet.first();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            break block19;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    GuiUt.showErrorDlg(DbFrame.frame, this.res.getString("Fail_to_show_as") + " " + type + " " + this.res.getString("Fail_image"), null);
                }
                catch (Throwable throwable) {
                    DbaObject.close(in);
                    try {
                        vResultSet.first();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                DbaObject.close(in);
                try {
                    vResultSet.first();
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    public void tmpfile_actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        String[] t = null;
        for (int i = 0; i < this.tmpfiles.length; ++i) {
            t = (String[])this.tmpfiles[i];
            if (!s.equals(t[0])) continue;
            this.showTempFile(t[2]);
            return;
        }
    }

    private void showTempFile(String ext) {
        if (!this.object.isNull) {
            try {
                File f = File.createTempFile(this.object.column_name + "_temp", "." + ext);
                System.out.println("save as temp file " + f.getPath());
                WebBrowser.displayURL(DbFrame.frame, f.getPath());
            }
            catch (Exception e) {
                GuiUt.showErrorDlg(DbFrame.frame, e.getMessage(), null);
            }
        }
    }
}

