/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.restore;

import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.DbaUtDef;
import dbaut.FullBackupFile;
import dbaut.JBackupHistory;
import dbaut.JRestore;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaTable;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.comp.TableColumnSelectionListener;
import dbaut.comp.WizardTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import svrmgrwizard.restore.CreateHistoryFailedException;
import svrmgrwizard.restore.FullBackupRowInfo;
import svrmgrwizard.restore.FullBackupTableCols;
import svrmgrwizard.restore.PanelRestoreIncJNL;
import svrmgrwizard.restore.PanelRestoreOnlineSummary;
import svrmgrwizard.restore.RestoreDlg;

public class PanelRestoreOnlineFullBackup
extends AbstractWizardPanel {
    private static final long serialVersionUID = -4317451713858330421L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.ResWizard", LocaleManager.getLocale());
    private RestoreDlg parentDlg = null;
    private AbstractWizardPanel previousPanel = null;
    private String title = null;
    private AbstractWizardPanel next = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton nextButton = new DbaButton(new Dimension(100, 24), this.res.getString("Next_"), 'N', DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"), new ReflectionAction(this, "nextButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(100, 24), this.res.getString("_Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private FullBackupTableCols jFullBackupTableCols = new FullBackupTableCols();
    private JList backupHistoryList = new JList();
    private DbaTable table = new DbaTable(this.jFullBackupTableCols);
    private Vector fullInfoVector = new Vector();
    private String configFileFullPath = null;
    private String restoreDBName = null;
    private String historyFileFullPath = null;
    private String realHistoryFullPath = null;
    private String fOHistoryFileFullPath = null;
    private String spHistoryFileFullPath = null;
    private JCheckBox systemFoCheckBox = new JCheckBox();
    private JCheckBox userFoCheckBox = new JCheckBox();
    private JCheckBox spCheckBox = new JCheckBox();
    private boolean isLastDiff = false;
    private int oldSelectIndex = -1;
    private String rTime = null;
    private int fgFull = -1;
    private int pos = -1;

    public PanelRestoreOnlineFullBackup(RestoreDlg parentDlg, AbstractWizardPanel previousPanel, String configFileFullPath, String restoreDBName, String historyFileFullPath, String fOHistoryFileFullPath, String spHistoryFileFullPath) throws CreateHistoryFailedException {
        this.parentDlg = parentDlg;
        this.previousPanel = previousPanel;
        this.configFileFullPath = configFileFullPath;
        this.restoreDBName = restoreDBName;
        this.historyFileFullPath = historyFileFullPath;
        this.fOHistoryFileFullPath = fOHistoryFileFullPath;
        this.spHistoryFileFullPath = spHistoryFileFullPath;
        this.init();
        this.validate();
    }

    private void init() throws CreateHistoryFailedException {
        JPanel mainPanel = new JPanel(new BorderLayout());
        ImageIcon imgWizard = DBAImageResource.getResource(this.getClass(), "/svrmgrimages/restorewizard-1.gif");
        JLabel imgLabel = new JLabel();
        imgLabel.setBorder(BorderFactory.createEtchedBorder());
        imgLabel.setIcon(new ImageIcon(imgWizard.getImage().getScaledInstance(150, 450, 4)));
        mainPanel.add((Component)imgLabel, "West");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new XYLayout(500, 465));
        panel.setPreferredSize(new Dimension(500, 465));
        WizardTextPane jTextPane1 = new WizardTextPane(20, 14);
        jTextPane1.setText(this.res.getString("Restore_full_backup_files"));
        jTextPane1.setBackground(Color.WHITE);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add((Component)jTextPane1, null);
        panel.add((Component)jScrollPane1, new XYConstraints(0, 0, 490, 125));
        JSplitPane jSplitPane1 = new JSplitPane();
        jSplitPane1.setOrientation(0);
        jSplitPane1.setDividerSize(2);
        jSplitPane1.setDividerLocation(100);
        JScrollPane jScrollPane2 = new JScrollPane();
        this.backupHistoryList.setSelectionMode(0);
        this.backupHistoryList.addListSelectionListener(new ReflectionListSelection(this, "backupHistoryList_valueChanged"));
        jScrollPane2.getViewport().add((Component)this.backupHistoryList, null);
        jSplitPane1.add((Component)jScrollPane2, "left");
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.getViewport().add((Component)this.table, null);
        jSplitPane1.add((Component)jScrollPane3, "right");
        JPanel jPanel1 = new JPanel();
        jPanel1.setLayout((LayoutManager)new XYLayout());
        JLabel restoreLabel = new JLabel();
        restoreLabel.setText(this.res.getString("Restore_full_backup"));
        jPanel1.add((Component)restoreLabel, new XYConstraints(10, 5, -1, -1));
        jPanel1.add((Component)jSplitPane1, new XYConstraints(0, 25, 490, 250));
        panel.add((Component)jPanel1, new XYConstraints(0, 125, 500, 275));
        this.systemFoCheckBox.setText(this.res.getString("Restore_system_fileobj"));
        this.systemFoCheckBox.setToolTipText(this.res.getString("Restore_system_fileobj"));
        this.systemFoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelRestoreOnlineFullBackup.this.foActionPerformed(e);
            }
        });
        this.userFoCheckBox.setText(this.res.getString("Restore_user_fileobj"));
        this.userFoCheckBox.setToolTipText(this.res.getString("Restore_user_fileobj"));
        this.userFoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelRestoreOnlineFullBackup.this.foActionPerformed(e);
            }
        });
        this.spCheckBox.setText(this.res.getString("Restore_stored_procedure"));
        this.spCheckBox.setToolTipText(this.res.getString("Restore_stored_procedure"));
        this.spCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelRestoreOnlineFullBackup.this.spActionPerformed(e);
            }
        });
        JPanel foPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        foPanel.add(this.systemFoCheckBox);
        foPanel.add(this.userFoCheckBox);
        foPanel.add(this.spCheckBox);
        panel.add((Component)foPanel, new XYConstraints(0, 400, 490, 50));
        this.initColumnSizes(this.table);
        this.table.addColumnSelectionListener(new TableColumnSelectionListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                if (PanelRestoreOnlineFullBackup.this.table.getSelectedColumn() == 1 && !e.getValueIsAdjusting()) {
                    PanelRestoreOnlineFullBackup.this.TableSelectionChanged(e);
                }
            }
        });
        this.table.addRowSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PanelRestoreOnlineFullBackup.this.table.getSelectedColumn() == 1 && !e.getValueIsAdjusting()) {
                    PanelRestoreOnlineFullBackup.this.TableSelectionChanged(e);
                }
            }
        });
        mainPanel.add((Component)panel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.nextButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Wizard_restore_online_backup", null);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        this.add((Component)mainPanel, "Center");
        this.setButtonBar(buttonPanel);
        this.nextButton.setEnabled(false);
        this.initFullBackupList();
        this.initFOCheckBoxStatus();
        this.initSPCheckBoxStatus();
    }

    private void initFOCheckBoxStatus() {
        if (this.fOHistoryFileFullPath == null || this.fOHistoryFileFullPath.length() < 1 || this.fOHistoryFileFullPath.equals("")) {
            this.systemFoCheckBox.setSelected(false);
            this.systemFoCheckBox.setEnabled(false);
            this.userFoCheckBox.setSelected(false);
            this.userFoCheckBox.setEnabled(false);
        } else {
            this.systemFoCheckBox.setSelected(true);
            this.systemFoCheckBox.setEnabled(true);
            this.userFoCheckBox.setSelected(true);
            this.userFoCheckBox.setEnabled(true);
        }
        this.foActionPerformed(null);
    }

    private void foActionPerformed(ActionEvent e) {
        RestoreDlg.restoreFOType = this.systemFoCheckBox.isSelected() && this.userFoCheckBox.isSelected() ? 3 : (this.systemFoCheckBox.isSelected() && !this.userFoCheckBox.isSelected() ? 1 : (!this.systemFoCheckBox.isSelected() && this.userFoCheckBox.isSelected() ? 2 : 0));
    }

    private void initSPCheckBoxStatus() {
        if (this.spHistoryFileFullPath == null || this.spHistoryFileFullPath.length() < 1 || this.spHistoryFileFullPath.equals("")) {
            this.spCheckBox.setSelected(false);
            this.spCheckBox.setEnabled(false);
        } else {
            this.spCheckBox.setSelected(true);
            this.spCheckBox.setEnabled(true);
        }
        this.spActionPerformed(null);
    }

    private void spActionPerformed(ActionEvent e) {
        RestoreDlg.restoreSPType = this.spCheckBox.isSelected() ? 1 : 0;
    }

    public void nextButtonActionPerformed(ActionEvent e) {
        if (this.hasIncJNL()) {
            if (this.oldSelectIndex != this.backupHistoryList.getSelectedIndex()) {
                this.next = new PanelRestoreIncJNL(this.parentDlg, this, this.configFileFullPath, this.restoreDBName, this.historyFileFullPath, this.realHistoryFullPath, this.fOHistoryFileFullPath, this.spHistoryFileFullPath, this.isLastDiff, this.rTime, this.pos, this.fgFull);
            }
        } else if (this.oldSelectIndex != this.backupHistoryList.getSelectedIndex()) {
            this.next = new PanelRestoreOnlineSummary(this.parentDlg, this, this.configFileFullPath, this.restoreDBName, this.historyFileFullPath, this.realHistoryFullPath, this.fOHistoryFileFullPath, this.spHistoryFileFullPath, this.rTime);
        }
        this.parentDlg.Next(this.next);
        this.oldSelectIndex = this.backupHistoryList.getSelectedIndex();
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        this.parentDlg.Next(this.previousPanel);
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.parentDlg.dispose();
    }

    @Override
    public String getTitle() {
        this.title = "Restore_Online_Full_Backup_Files";
        return this.title;
    }

    public void backupHistoryList_valueChanged(ListSelectionEvent e) {
        String baseTime;
        int size = this.backupHistoryList.getModel().getSize();
        int index = this.backupHistoryList.getSelectedIndex();
        this.isLastDiff = index + 1 == size;
        String listValue = this.backupHistoryList.getSelectedValue().toString().trim();
        this.spCheckBox.setEnabled(listValue.contains("full") && listValue.contains("online"));
        this.rTime = baseTime = this.getFullBackupTime(listValue);
        Vector tableVector = (Vector)this.fullInfoVector.elementAt(index);
        if (tableVector != null && tableVector.size() > 0) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
        this.setTable(tableVector);
        this.table.revalidate();
        this.table.repaint();
    }

    private boolean hasIncJNL() {
        int size = this.backupHistoryList.getModel().getSize();
        ArrayList<String> fullList = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String item = (String)this.backupHistoryList.getModel().getElementAt(i);
            if (item.indexOf("full") <= 0) continue;
            fullList.add(item);
        }
        int fSize = fullList.size();
        int index = this.backupHistoryList.getSelectedIndex();
        String item = (String)this.backupHistoryList.getSelectedValue();
        if (item.indexOf("full") > 0) {
            this.fgFull = 1;
            this.pos = index + 1;
            JRestore restore = new JRestore(SmFrame.frame);
            Vector incBackupInfo = restore.getIncBackupInfo(this.restoreDBName, this.realHistoryFullPath, this.pos, this.fgFull);
            return incBackupInfo != null && incBackupInfo.size() > 0;
        }
        if (item.indexOf("diff") > 0) {
            this.fgFull = 0;
            this.pos = index + 1 - fSize;
            JRestore restore = new JRestore(SmFrame.frame);
            Vector incBackupInfo = restore.getIncBackupInfo(this.restoreDBName, this.realHistoryFullPath, this.pos, this.fgFull);
            return incBackupInfo != null && incBackupInfo.size() > 0;
        }
        System.out.println("error for getting inc info.");
        return false;
    }

    private String getFullBackupTime(String inStr) {
        String s = "";
        int index = 0;
        index = inStr.indexOf(":");
        if (index > 0) {
            s = inStr.substring(index + 1, inStr.length());
        }
        if ((index = s.indexOf("   ")) > 0) {
            s = s.substring(0, index);
        }
        s = s.trim();
        return s;
    }

    private void setTable(Vector paraVector) {
        this.jFullBackupTableCols.removeAll();
        FullBackupRowInfo newRow = null;
        FullBackupFile myFullBackupFile = null;
        String physicalFile = null;
        for (int i = 0; i < paraVector.size(); ++i) {
            myFullBackupFile = (FullBackupFile)paraVector.elementAt(i);
            String backupFile = myFullBackupFile.getBackupFile();
            physicalFile = myFullBackupFile.getPhysicalFile();
            String logicalFile = myFullBackupFile.getLogicalFile();
            if (backupFile.equals("FILEOBJ")) continue;
            newRow = new FullBackupRowInfo(logicalFile, backupFile, physicalFile);
            this.jFullBackupTableCols.addValue(newRow);
        }
    }

    private void initFullBackupList() throws CreateHistoryFailedException {
        int i;
        JRestore restore = new JRestore(SmFrame.frame);
        String historyPath = restore.getHistoryFilePath(this.historyFileFullPath);
        this.realHistoryFullPath = historyPath + "dmBackup.his.real";
        this.createRealHistoryFile(restore, this.configFileFullPath, this.restoreDBName, this.historyFileFullPath, this.realHistoryFullPath);
        JBackupHistory historyFile = new JBackupHistory(SmFrame.frame);
        int rc = historyFile.FileOpen(this.restoreDBName, this.realHistoryFullPath, "0");
        if (rc != DbaUtDef.RTN_OK) {
            return;
        }
        Vector fullBackupListVector = historyFile.getFullBackupList();
        Vector diffBackupListVector = historyFile.getDiffBackupList();
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (i = 0; i < fullBackupListVector.size(); ++i) {
            listModel.addElement(fullBackupListVector.elementAt(i).toString().trim());
            this.fullInfoVector.addElement(historyFile.getFullBackupInfo(i + 1));
        }
        for (i = 0; i < diffBackupListVector.size(); ++i) {
            listModel.addElement(diffBackupListVector.elementAt(i).toString().trim());
            this.fullInfoVector.addElement(historyFile.getDiffBackupInfo(i + 1));
        }
        historyFile.FileClose();
        this.backupHistoryList.setModel(listModel);
        if (listModel.getSize() > 0) {
            this.backupHistoryList.setSelectedIndex(listModel.getSize() - 1);
        }
        if (fullBackupListVector.size() <= 0) {
            this.table.setEnabled(false);
            this.backupHistoryList.setEnabled(false);
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
    }

    private void createRealHistoryFile(JRestore restore, String dmconfigFullPath, String dbName, String historyFullPath, String realHistoryName) throws CreateHistoryFailedException {
        int rc;
        if (restore != null && (rc = restore.createRealHistoryFile(dmconfigFullPath, dbName, historyFullPath, realHistoryName)) != 0) {
            throw new CreateHistoryFailedException();
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(220);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(220);
    }

    private void TableSelectionChanged(ListSelectionEvent e) {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (row < 0 || col < 0) {
            return;
        }
        if (row >= this.table.getRowCount() || col >= this.table.getColumnCount()) {
            return;
        }
        this.table.editCellAt(row, col);
    }
}

