/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import com.borland.jbcl.control.GroupBox;
import com.borland.jbcl.layout.VerticalFlowLayout;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.FilePathField;
import dbaut.textField.IntegerRangeField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import monitor.HelpButton;
import monitor.MonitorFrame;
import monitor.PreferencesXml;

public class PreferencesDlg
extends JDialog {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", LocaleManager.getLocale());
    private FilePathField logDirFilePathField = new FilePathField(this, true);
    private IntegerRangeField breakByRowDataIntegerRangeField = new IntegerRangeField(25, 200, 10);
    private IntegerRangeField breakByDayDataIntegerRangeField = new IntegerRangeField(2, 30, 1);
    private JRadioButton rowViewRadioButton = new JRadioButton(this.res.getString("Row_view"), true);
    private JRadioButton columnViewRadioButton = new JRadioButton(this.res.getString("Column_view"), false);
    private JRadioButton breakByRowRadioButton = new JRadioButton(this.res.getString("Break_by_row"), true);
    private JRadioButton breakByDayRadioButton = new JRadioButton(this.res.getString("Break_by_day"), false);
    private JCheckBox export2ExternalFileCheckBox = new JCheckBox(this.res.getString("Enable_export_to_external_file_function"), false);
    private HelpButton helpButton = new HelpButton();
    private DbaButton cancelButton;
    private DbaButton okButton;
    private JLabel logDirLabel;
    private JLabel breakByRowDataLabel;
    private JLabel breakByDayDataLabel;
    private GroupBox outputFormatGroupBox;
    private GroupBox breakLineCaptionGroupBox;
    private boolean oriIsColumnViewFileFormat;
    private boolean oriRepaintCaptionByRow;
    private short oriDay;
    private short oriRow;
    private short oriFileCount;
    private short oriFileSize;
    private GroupBox outputFileSettingGroupBox;
    private IntegerRangeField fileCountIntegerRangeField;
    private IntegerRangeField fileSizeIntegerRangeField;
    private JLabel fileSizeUnitLabel;
    private JLabel fileCountLabel;
    private JLabel fileSizeLabel;
    String oriSelectedDir;

    public PreferencesDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.cancelButton = new DbaButton(MonitorFrame.frame.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancelButton_actionPerformed"));
        this.okButton = new DbaButton(MonitorFrame.frame.res.getString("OK"), 'O', new ReflectionAction(this, "okButton_actionPerformed"));
        this.logDirLabel = new JLabel(this.res.getString("Log_directory"));
        this.breakByRowDataLabel = new JLabel(this.res.getString("Repaint_caption_every_rows"));
        this.breakByDayDataLabel = new JLabel(this.res.getString("Repaint_caption_every_days"));
        this.outputFormatGroupBox = new GroupBox(this.res.getString("Output_format_setting"));
        this.breakLineCaptionGroupBox = new GroupBox(this.res.getString("Break_line_caption_setting"));
        this.oriIsColumnViewFileFormat = true;
        this.oriRepaintCaptionByRow = true;
        this.oriDay = 0;
        this.oriRow = 0;
        this.oriFileCount = 0;
        this.oriFileSize = 0;
        this.outputFileSettingGroupBox = new GroupBox(this.res.getString("Output_file_setting"));
        this.fileCountIntegerRangeField = new IntegerRangeField(10, 20, 10);
        this.fileSizeIntegerRangeField = new IntegerRangeField(1, 10, 1);
        this.fileSizeUnitLabel = new JLabel("(M)");
        this.fileCountLabel = new JLabel(this.res.getString("File_count"));
        this.fileSizeLabel = new JLabel(this.res.getString("File_size"));
        this.oriSelectedDir = null;
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PreferencesDlg(Frame frame) {
        super(frame);
        this.cancelButton = new DbaButton(MonitorFrame.frame.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancelButton_actionPerformed"));
        this.okButton = new DbaButton(MonitorFrame.frame.res.getString("OK"), 'O', new ReflectionAction(this, "okButton_actionPerformed"));
        this.logDirLabel = new JLabel(this.res.getString("Log_directory"));
        this.breakByRowDataLabel = new JLabel(this.res.getString("Repaint_caption_every_rows"));
        this.breakByDayDataLabel = new JLabel(this.res.getString("Repaint_caption_every_days"));
        this.outputFormatGroupBox = new GroupBox(this.res.getString("Output_format_setting"));
        this.breakLineCaptionGroupBox = new GroupBox(this.res.getString("Break_line_caption_setting"));
        this.oriIsColumnViewFileFormat = true;
        this.oriRepaintCaptionByRow = true;
        this.oriDay = 0;
        this.oriRow = 0;
        this.oriFileCount = 0;
        this.oriFileSize = 0;
        this.outputFileSettingGroupBox = new GroupBox(this.res.getString("Output_file_setting"));
        this.fileCountIntegerRangeField = new IntegerRangeField(10, 20, 10);
        this.fileSizeIntegerRangeField = new IntegerRangeField(1, 10, 1);
        this.fileSizeUnitLabel = new JLabel("(M)");
        this.fileCountLabel = new JLabel(this.res.getString("File_count"));
        this.fileSizeLabel = new JLabel(this.res.getString("File_size"));
        this.oriSelectedDir = null;
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PreferencesDlg() {
        this((Frame)null, "", false);
    }

    private void jbInit() throws Exception {
        this.setSize(400, 550);
        this.setTitle(this.res.getString("Preferences"));
        this.okButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        this.cancelButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        this.export2ExternalFileCheckBox.addActionListener(new ReflectionAction(this, "export2ExternalFileCheckBox_actionPerformed"));
        this.breakByDayRadioButton.addActionListener(new ReflectionAction(this, "breakByDayRadioButton_actionPerformed"));
        this.breakByRowRadioButton.addActionListener(new ReflectionAction(this, "breakByRowRadioButton_actionPerformed"));
        this.logDirFilePathField.setSize(new Dimension(180, 22));
        this.logDirFilePathField.setPreferredSize(new Dimension(180, 22));
        this.logDirFilePathField.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel logPanel = new JPanel(new FlowLayout(0));
        JPanel buttonPanel = new JPanel();
        JPanel contentPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel breakByRowDataPanel = new JPanel();
        JPanel breakByDayDataPanel = new JPanel();
        breakByRowDataPanel.add(this.breakByRowDataLabel);
        breakByRowDataPanel.add(this.breakByRowDataIntegerRangeField);
        breakByDayDataPanel.add(this.breakByDayDataLabel);
        breakByDayDataPanel.add(this.breakByDayDataIntegerRangeField);
        logPanel.add(this.logDirLabel);
        logPanel.add(this.logDirFilePathField);
        this.breakLineCaptionGroupBox.setLayout((LayoutManager)new VerticalFlowLayout());
        this.breakLineCaptionGroupBox.add((Component)this.breakByRowRadioButton);
        this.breakLineCaptionGroupBox.add((Component)breakByRowDataPanel);
        this.breakLineCaptionGroupBox.add((Component)this.breakByDayRadioButton);
        this.breakLineCaptionGroupBox.add((Component)breakByDayDataPanel);
        ButtonGroup outputFormatButtonGroup = new ButtonGroup();
        this.outputFormatGroupBox.setLayout((LayoutManager)new VerticalFlowLayout());
        ButtonGroup breakLineCaptionButtonGroup = new ButtonGroup();
        breakLineCaptionButtonGroup.add(this.breakByRowRadioButton);
        breakLineCaptionButtonGroup.add(this.breakByDayRadioButton);
        outputFormatButtonGroup.add(this.rowViewRadioButton);
        outputFormatButtonGroup.add(this.columnViewRadioButton);
        this.outputFormatGroupBox.add((Component)this.rowViewRadioButton);
        this.outputFormatGroupBox.add((Component)this.columnViewRadioButton);
        this.outputFileSettingGroupBox.setLayout((LayoutManager)new VerticalFlowLayout());
        JPanel fileSizePanel = new JPanel(new FlowLayout(0));
        JPanel fileCountPanel = new JPanel(new FlowLayout(0));
        fileSizePanel.add(this.fileSizeLabel);
        fileSizePanel.add(this.fileSizeIntegerRangeField);
        fileSizePanel.add(this.fileSizeUnitLabel);
        fileCountPanel.add(this.fileCountLabel);
        fileCountPanel.add(this.fileCountIntegerRangeField);
        this.outputFileSettingGroupBox.add((Component)fileSizePanel);
        this.outputFileSettingGroupBox.add((Component)fileCountPanel);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        contentPanel.add(this.export2ExternalFileCheckBox);
        contentPanel.add(logPanel);
        contentPanel.add((Component)this.outputFormatGroupBox);
        contentPanel.add((Component)this.outputFileSettingGroupBox);
        contentPanel.add((Component)this.breakLineCaptionGroupBox);
        mainPanel.add((Component)buttonPanel, "South");
        mainPanel.add((Component)contentPanel, "Center");
        this.getContentPane().add(mainPanel);
        this.getPreviousSetting();
        MonitorFrame.frame.enableHelpAction(this.getRootPane(), this.helpButton, "monitor_PreferencesDlg", null);
    }

    private void moveFile(String s) {
        File sFile = null;
        File dFile = null;
        MonitorFrame.frame.isDataRefresh = true;
        if (MonitorFrame.frame.px.outputFileCount > 0) {
            int fileCount;
            for (int i = fileCount = MonitorFrame.frame.px.outputFileCount; i >= 0; --i) {
                if (i > 0) {
                    sFile = new File(s + "Message" + (i - 1) + ".log");
                    dFile = new File(s + "Message" + i + ".log");
                } else {
                    sFile = new File(s + "Message.log");
                    dFile = new File(s + "Message" + i + ".log");
                }
                MonitorFrame.frame.copyFile(sFile, dFile);
                sFile = null;
                dFile = null;
            }
        } else {
            sFile = new File(s + "Message.log");
            dFile = new File(s + "Message0.log");
            if (!sFile.exists()) {
                return;
            }
            MonitorFrame.frame.copyFile(sFile, dFile);
            sFile = null;
            dFile = null;
        }
        if (MonitorFrame.frame.px.outputFileCount < MonitorFrame.frame.px.getFileCount()) {
            MonitorFrame.frame.px.outputFileCount = (short)(MonitorFrame.frame.px.outputFileCount + 1);
        }
    }

    private void checkOutputFlow() {
        if (MonitorFrame.frame.px.getSelectedDirectory() == null) {
            PreferencesXml cfr_ignored_0 = MonitorFrame.frame.px;
            MonitorFrame.frame.px.updateVariables(3, System.getProperty("user.dir"));
            MonitorFrame.frame.px.save();
        }
        String s = MonitorFrame.frame.px.getSelectedDirectory();
        if (this.oriSelectedDir != null && !this.oriSelectedDir.equals(s)) {
            MonitorFrame.frame.px.dataRowCount = 0;
            MonitorFrame.frame.px.first_item_time = 0;
            MonitorFrame.frame.px.outputFileCount = 0;
            if (!s.endsWith(MonitorFrame.frame.px.file_separator)) {
                s = s + MonitorFrame.frame.px.file_separator;
            }
            this.moveFile(s);
        }
        if (!s.endsWith(MonitorFrame.frame.px.file_separator)) {
            s = s + MonitorFrame.frame.px.file_separator;
        }
        if (MonitorFrame.frame.px.getExportMonitorItem2ExternalFile()) {
            if (MonitorFrame.frame.px.getViewFormat() != this.oriIsColumnViewFileFormat) {
                this.moveFile(s);
            }
            if (MonitorFrame.frame.px.getRepaintCaptionByRow() != this.oriRepaintCaptionByRow) {
                this.moveFile(s);
            }
            if (this.oriRepaintCaptionByRow && this.oriRepaintCaptionByRow == MonitorFrame.frame.px.getRepaintCaptionByRow()) {
                if (this.oriRow != MonitorFrame.frame.px.getRepaintCaptionEveryRow()) {
                    MonitorFrame.frame.px.dataRowCount = 0;
                    this.moveFile(s);
                }
            } else if (!this.oriRepaintCaptionByRow && !this.oriRepaintCaptionByRow == !MonitorFrame.frame.px.getRepaintCaptionByRow() && this.oriDay != MonitorFrame.frame.px.getRepaintCaptionEveryDay()) {
                MonitorFrame.frame.px.first_item_time = 0;
                this.moveFile(s);
            }
            if (this.oriFileCount != MonitorFrame.frame.px.getFileCount()) {
                MonitorFrame.frame.px.outputFileCount = 0;
                this.moveFile(s);
            }
            if (this.oriFileSize != MonitorFrame.frame.px.getFileSize()) {
                this.moveFile(s);
            }
        }
    }

    public void okButton_actionPerformed(ActionEvent e) {
        String selected_directory;
        boolean isSelected = this.export2ExternalFileCheckBox.isSelected();
        String s = isSelected ? "true" : "false";
        MonitorFrame.frame.px.updateVariables(4, s);
        isSelected = this.breakByDayRadioButton.isSelected();
        s = isSelected ? "false" : "true";
        MonitorFrame.frame.px.updateVariables(5, s);
        isSelected = this.rowViewRadioButton.isSelected();
        s = isSelected ? "false" : "true";
        MonitorFrame.frame.px.updateVariables(0, s);
        s = this.breakByRowDataIntegerRangeField.getStringValue();
        if (s != null && s.length() > 0) {
            MonitorFrame.frame.px.updateVariables(1, s);
        }
        if ((s = this.breakByDayDataIntegerRangeField.getStringValue()) != null && s.length() > 0) {
            MonitorFrame.frame.px.updateVariables(2, s);
        }
        if ((s = this.fileCountIntegerRangeField.getStringValue()) != null && s.length() > 0) {
            MonitorFrame.frame.px.updateVariables(7, s);
        }
        if ((s = this.fileSizeIntegerRangeField.getStringValue()) != null && s.length() > 0) {
            MonitorFrame.frame.px.updateVariables(6, s);
        }
        if ((selected_directory = this.logDirFilePathField.getText().trim()).length() == 0 || selected_directory == null) {
            selected_directory = System.getProperty("user.dir");
        }
        MonitorFrame.frame.px.updateVariables(3, selected_directory);
        MonitorFrame.frame.px.save();
        this.checkOutputFlow();
        this.setVisible(false);
        this.dispose();
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    private void setStatus(boolean status) {
        this.logDirFilePathField.setEnabled(status);
        this.breakByRowDataIntegerRangeField.setEnabled(status);
        this.breakByDayDataIntegerRangeField.setEnabled(status);
        this.rowViewRadioButton.setEnabled(status);
        this.columnViewRadioButton.setEnabled(status);
        this.breakByRowRadioButton.setEnabled(status);
        this.breakByDayRadioButton.setEnabled(status);
        this.logDirLabel.setEnabled(status);
        this.breakByRowDataLabel.setEnabled(status);
        this.breakByDayDataLabel.setEnabled(status);
        this.outputFormatGroupBox.setEnabled(status);
        this.breakLineCaptionGroupBox.setEnabled(status);
        this.fileCountLabel.setEnabled(status);
        this.fileCountIntegerRangeField.setEnabled(status);
        this.fileSizeLabel.setEnabled(status);
        this.fileSizeIntegerRangeField.setEnabled(status);
        this.fileSizeUnitLabel.setEnabled(status);
    }

    private void getPreviousSetting() {
        boolean viewFormat = MonitorFrame.frame.px.getExportMonitorItem2ExternalFile();
        if (viewFormat) {
            this.export2ExternalFileCheckBox.setSelected(true);
            this.setStatus(true);
        } else {
            this.export2ExternalFileCheckBox.setSelected(false);
            this.setStatus(false);
        }
        this.oriIsColumnViewFileFormat = MonitorFrame.frame.px.getViewFormat();
        if (this.oriIsColumnViewFileFormat) {
            this.columnViewRadioButton.setSelected(true);
            this.rowViewRadioButton.setSelected(false);
        } else {
            this.columnViewRadioButton.setSelected(false);
            this.rowViewRadioButton.setSelected(true);
        }
        this.oriRepaintCaptionByRow = MonitorFrame.frame.px.getRepaintCaptionByRow();
        if (this.oriRepaintCaptionByRow) {
            this.breakByRowRadioButton.setSelected(true);
            this.breakByDayRadioButton.setSelected(false);
            this.breakByDayDataIntegerRangeField.setEnabled(false);
            this.breakByDayDataLabel.setEnabled(false);
        } else {
            this.breakByRowRadioButton.setSelected(false);
            this.breakByRowDataIntegerRangeField.setEnabled(false);
            this.breakByRowDataLabel.setEnabled(false);
            this.breakByDayRadioButton.setSelected(true);
        }
        this.oriRow = MonitorFrame.frame.px.getRepaintCaptionEveryRow();
        this.breakByRowDataIntegerRangeField.setValue(this.oriRow);
        this.oriDay = MonitorFrame.frame.px.getRepaintCaptionEveryDay();
        this.breakByDayDataIntegerRangeField.setValue(this.oriDay);
        this.oriFileCount = MonitorFrame.frame.px.getFileCount();
        this.fileCountIntegerRangeField.setValue(this.oriFileCount);
        this.oriFileSize = MonitorFrame.frame.px.getFileSize();
        this.fileSizeIntegerRangeField.setValue(this.oriFileSize);
        this.oriSelectedDir = MonitorFrame.frame.px.getSelectedDirectory();
        if (this.oriSelectedDir == null) {
            this.oriSelectedDir = System.getProperty("user.dir");
        }
        this.logDirFilePathField.setText(this.oriSelectedDir);
    }

    public void export2ExternalFileCheckBox_actionPerformed(ActionEvent e) {
        if (this.export2ExternalFileCheckBox.isSelected()) {
            this.setStatus(true);
        } else {
            this.setStatus(false);
        }
    }

    private void setStatus4BreakCaptionIssue(boolean status) {
        this.breakByRowDataLabel.setEnabled(status);
        this.breakByRowDataIntegerRangeField.setEnabled(status);
        this.breakByDayDataLabel.setEnabled(!status);
        this.breakByDayDataIntegerRangeField.setEnabled(!status);
    }

    public void breakByRowRadioButton_actionPerformed(ActionEvent e) {
        if (this.breakByRowRadioButton.isSelected()) {
            this.setStatus4BreakCaptionIssue(true);
        } else {
            this.setStatus4BreakCaptionIssue(false);
        }
    }

    public void breakByDayRadioButton_actionPerformed(ActionEvent e) {
        if (this.breakByDayRadioButton.isSelected()) {
            this.setStatus4BreakCaptionIssue(false);
        } else {
            this.setStatus4BreakCaptionIssue(true);
        }
    }
}

