/*
 * Decompiled with CFR 0.152.
 */
package framework;

import dbaut.DbaObject;
import dbaut.JdmConfig;
import dbaut.String_array;
import dbaut.locale.LocaleManager;
import dbaut.winlib;
import dbmaker.sql.JdbcOdbcConnection;
import framework.DMConfigManager;
import framework.DatabaseConnector;
import framework.SystemUt;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DatabaseManager {
    public static final String driverName = "dbmaker.sql.JdbcOdbcDriver";
    public static final String url = "jdbc:dbmaker:";
    public static final String userName = "SYSADM";
    public static final String password = "";

    public static void main(String[] args) {
        String dbName = "TESTDB";
        DatabaseManager.shutdownDatabase(dbName);
        SystemUt.sleep(5);
        DatabaseManager.deleteDatabase(dbName);
    }

    public static void changeDatabase(String dbName) {
        Connection con = DatabaseConnector.connectDatabase(dbName);
        try {
            Statement stmt = con.createStatement();
            stmt.executeUpdate("create table t1(c1 int, c2 char(100))");
            stmt.executeUpdate("insert into t1 values(1, 'Kris')");
            stmt.executeUpdate("insert into t1 values(2, 'Eva')");
            stmt.close();
            con.close();
            System.out.println("change something for database!");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insertBigDatasToDatabase(String dbName) {
        System.out.println("insert many records into db begin.");
        Connection con = DatabaseConnector.connectDatabase(dbName);
        try {
            Statement stmt = con.createStatement();
            stmt.executeUpdate("create table tb1(c1 serial, c2 int, c3 varchar(1000))");
            stmt.executeUpdate("insert into tb1 select null,rand(),char(mod(rand(),26)+65)||'-'||repeat(cast(rand() as char(4)),mod(rand(),249)) from SYSTEM.SYSCOLUMN d");
            stmt.executeUpdate("create index idx1 on tb1(c3)");
            stmt.executeUpdate("create table tb2(c1 serial, c2 int, c3 varchar(1000))");
            stmt.executeUpdate("insert into tb2 select null,rand(),char(mod(rand(),26)+65)||'-'||repeat(cast(rand() as char(4)),mod(rand(),249)) from SYSTEM.SYSCOLUMN d");
            stmt.executeUpdate("create index idx2 on tb2(c3)");
            for (int j = 0; j < 4; ++j) {
                stmt.executeUpdate("select * from tb1 into tb2");
                stmt.executeUpdate("select * from tb2 into tb1");
            }
            con.commit();
            stmt.close();
            con.close();
            System.out.println("insert many records into db finished.");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteBigDatas(String dbName) {
        Connection con = DatabaseConnector.connectDatabase(dbName);
        try {
            Statement stmt = con.createStatement();
            stmt.executeUpdate("drop table tb1");
            con.commit();
            stmt.executeUpdate("drop table tb2");
            con.commit();
            stmt.close();
            con.close();
            System.out.println("change something for database!");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void createRemoteDatabase(String dbName) {
        DMConfigManager.writeRemoteDmConfig(dbName, SystemUt.getTestDBHome());
        try {
            Class.forName(driverName);
            System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
            System.setProperty("DM_CONNECT_MODE", "CREATE_DB");
            String errlcode = LocaleManager.getErrlcode();
            String conStr = url + dbName + ";errlcode=" + errlcode;
            Connection con = DriverManager.getConnection(conStr, userName, password);
            System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
            if (con != null) {
                System.out.println("create database " + dbName + " successfully!");
                con.close();
            } else {
                System.out.println("create database " + dbName + " failed!");
            }
            System.setProperty("DM_DISCONNECT_MODE", "DISCONNECT_DB");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void createDatabase(String dbName) {
        String idCap = System.getenv("IDCAP");
        if (idCap.equalsIgnoreCase("1")) {
            DMConfigManager.writeDefaultDmConfig(dbName, SystemUt.getTestDBHome());
        } else if (idCap.equalsIgnoreCase("0")) {
            DMConfigManager.writeIdSensitiveDmConfig(dbName, SystemUt.getTestDBHome());
        }
        try {
            Class.forName(driverName);
            System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
            System.setProperty("DM_CONNECT_MODE", "CREATE_DB");
            String errlcode = LocaleManager.getErrlcode();
            String conStr = url + dbName + ";errlcode=" + errlcode;
            Connection con = DriverManager.getConnection(conStr, userName, password);
            System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
            if (con != null) {
                System.out.println("create database " + dbName + " successfully!");
                con.close();
            } else {
                System.out.println("create database " + dbName + " failed!");
            }
            System.setProperty("DM_DISCONNECT_MODE", "DISCONNECT_DB");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void createDatabase(String dbName, String testHome, int idCap) {
        System.out.println("Test home: " + testHome);
        if (idCap == 1) {
            DMConfigManager.writeDefaultDmConfig(dbName, testHome);
        } else if (idCap == 0) {
            DMConfigManager.writeIdSensitiveDmConfig(dbName, testHome);
        } else {
            System.out.println("Write dmconfig.ini error.");
        }
        try {
            Class.forName(driverName);
            System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
            System.setProperty("DM_CONNECT_MODE", "CREATE_DB");
            String errlcode = LocaleManager.getErrlcode();
            String conStr = url + dbName + ";errlcode=" + errlcode;
            Connection con = DriverManager.getConnection(conStr, userName, password);
            System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
            if (con != null) {
                System.out.println("create database " + dbName + " successfully!");
                con.close();
            } else {
                System.out.println("create database " + dbName + " failed!");
            }
            System.setProperty("DM_DISCONNECT_MODE", "DISCONNECT_DB");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void startDatabase(String dbName) {
        String cmdline = null;
        if (SystemUt.isWindows()) {
            winlib lib = new winlib();
            String result = lib.StartDatabase(dbName, userName, password, null);
            if (result != null && result.length() > 0) {
                System.out.println("Start database " + dbName + " failed!");
            } else {
                System.out.println("Start database " + dbName + " successfully!");
            }
        } else {
            cmdline = "dmserver";
            cmdline = cmdline + " " + dbName;
            System.out.println(cmdline);
            try {
                Process p = Runtime.getRuntime().exec(cmdline);
                int rc = p.waitFor();
                if (rc == 0) {
                    System.out.println("Start database " + dbName + " successfully!");
                } else {
                    System.out.println("Start database " + dbName + " failed!");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void shutdownDatabase(String dbName) {
        try {
            Class.forName(driverName);
            System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
            System.setProperty("DM_CONNECT_MODE", "CONNECT_DB");
            String errlcode = LocaleManager.getErrlcode();
            String conStr = url + dbName + ";errlcode=" + errlcode;
            Connection con = DriverManager.getConnection(conStr, userName, password);
            System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
            if (con != null) {
                con.close();
                System.out.println("shutdown database " + dbName + " successfully!");
            }
            System.setProperty("DM_DISCONNECT_MODE", "DISCONNECT_DB");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void deleteDatabase(String dbName) {
        winlib wlib;
        boolean result;
        JdmConfig config = new JdmConfig();
        boolean isTerminalServer = config.isTerminalServer(dbName);
        config.fileOpen("dmconfig.ini", dbName, "r+");
        if (!isTerminalServer) {
            config.procDelete("DB_SVADR", 0);
            config.procDelete("DB_PTNUM", 0);
        }
        String fodir = (String)config.getPara("DB_FODIR", 4096);
        config.fileClose();
        Connection connection = null;
        try {
            Class.forName(driverName);
            System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
            System.setProperty("DM_CONNECT_MODE", "START_DB");
            String errlcode = LocaleManager.getErrlcode();
            String conStr = url + dbName + ";errlcode=" + errlcode;
            connection = DriverManager.getConnection(conStr, userName, password);
            ((JdbcOdbcConnection)connection).setOption(1126, 2);
            if (connection == null) {
                System.out.println("Start terminal server failed!");
                return;
            }
            ArrayList data = DatabaseManager.getDataInfo(connection, dbName);
            System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
            connection.close();
            System.setProperty("DM_DISCONNECT_MODE", "DISCONNECT_DB");
            String filename = password;
            for (int i = 0; i < data.size(); ++i) {
                filename = (String)data.get(i);
                File file = new File(filename);
                boolean b = file.delete();
                if (b) continue;
                System.out.println("Could not delete file " + file.getAbsolutePath());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        File file = new File(fodir);
        boolean b = file.delete();
        if (!b) {
            System.out.println("Could not delete file " + file.getAbsolutePath());
        }
        DMConfigManager.deleteDefaultDmConfig(dbName);
        if (SystemUt.isWindows() && !(result = (wlib = new winlib()).removeRegistryKey(-2147483646L, dbName))) {
            result = wlib.removeRegistryKey(-2147483647L, dbName);
        }
        System.out.println("Delete database " + dbName + " successfully.");
    }

    private static boolean isServerOn(String dbname, String user, String password) throws SQLException {
        try {
            JdmConfig config = new JdmConfig();
            Integer default_ctimo = null;
            int rc = config.fileOpen("dmconfig.ini", dbname, "r+");
            if (rc == 0) {
                default_ctimo = (Integer)config.getPara("DB_CTIMO", 8192);
                config.insertPara("DB_CTIMO", new Integer(5), 8192);
                config.fileClose();
            }
            System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
            System.setProperty("DM_CONNECT_MODE", "CONNECT_DB");
            Class.forName(driverName);
            String errlcode = LocaleManager.getErrlcode();
            String conStr = url + dbname + ";errlcode=" + errlcode;
            Connection conn = DriverManager.getConnection(conStr, user, password);
            if (default_ctimo != null) {
                config.fileOpen("dmconfig.ini", dbname, "r+");
                config.insertPara("DB_CTIMO", default_ctimo, 8192);
                config.fileClose();
            }
            if (conn != null) {
                conn.close();
                return true;
            }
            System.out.println("conn is null");
            return false;
        }
        catch (SQLException sqle) {
            if (sqle.getSQLState().equals("28000")) {
                throw sqle;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static ArrayList getDataInfo(Connection connection, String dbName) {
        String temp = null;
        String filePath = null;
        Statement stmt = null;
        ArrayList<String> a = new ArrayList<String>();
        try {
            stmt = connection.createStatement();
            String query = "select FILE_NAME, GETFILENAME(FILE_NAME) from SYSTEM.SYSFILE where FILE_NAME != 'SYSJNL'";
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                temp = rs.getString(2);
                filePath = rs.wasNull() ? password : temp.trim();
                a.add(filePath);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            DbaObject.close(stmt);
        }
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", dbName, "r");
        String db_dir = JdmConfig.getDBDir(dbName);
        String_array files = (String_array)config.getPara("DB_JNFIL", 53504);
        config.fileClose();
        String jnlPath = null;
        for (int i = 0; i < files.size(); ++i) {
            String str = files.content[i];
            if (str.length() == 0) continue;
            int g = str.lastIndexOf(SystemUt.getFileSeparator());
            jnlPath = g >= 0 ? str : db_dir + SystemUt.getFileSeparator() + str;
            a.add(jnlPath);
        }
        return a;
    }

    public static void deleteDirs(File f) {
        File[] fs;
        System.out.println("Delete file " + f.getAbsolutePath());
        if (f.isDirectory() && (fs = f.listFiles()) != null && fs.length != 0) {
            for (int i = 0; i < fs.length; ++i) {
                DatabaseManager.deleteDirs(fs[i]);
                fs[i].delete();
            }
        }
        f.delete();
    }

    private void temp() {
        System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
        System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
        System.setProperty("DM_CONNECT_MODE", "CREATE_DB");
        System.setProperty("DM_CONNECT_MODE", "START_DB");
        System.setProperty("DM_CONNECT_MODE", "CONNECT_DB");
        System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
        System.setProperty("DM_DISCONNECT_MODE", "DISCONNECT_DB");
    }
}

