/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importJson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import datatransfer.DataTransferFrame;
import dbaut.GuiUt;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importJson.ImJsonDialog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class JsonTableModel
extends AbstractTableModel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportTextRes", LocaleManager.getLocale());
    private final String[] columns = new String[]{"", this.res.getString("Json_column_name"), this.res.getString("Destination_Col"), this.res.getString("Type"), this.res.getString("Precision"), this.res.getString("Scale"), this.res.getString("Nullable")};
    private ArrayList<Object[]> data = new ArrayList();
    private ImJsonDialog imt = null;

    public JsonTableModel(ImJsonDialog imt) {
        this.imt = imt;
        this.initData();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data.get(rowIndex)[columnIndex];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        this.data.get((int)rowIndex)[columnIndex] = aValue;
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean isEditable = true;
        String type = this.getValueAt(rowIndex, 2).toString().toLowerCase().trim();
        boolean bl = isEditable = columnIndex != 4;
        if (this.getValueAt(rowIndex, 2).toString().equalsIgnoreCase("decimal") && columnIndex == 4) {
            isEditable = true;
        }
        if ((type.equals("smallint") || type.equals("integer") || type.equals("bigint") || type.equals("real") || type.equals("double") || type.equals("date") || type.equals("time") || type.equals("oid") || type.equals("timestamp") || type.equals("file") || type.equals("long varbinary") || type.equals("long varchar") || type.equals("serial") || type.equals("bigserial") || type.equals("nclob") || type.equals("clob") || type.equals("blob") || this.isDomainType(type)) && (columnIndex == 3 || columnIndex == 4)) {
            isEditable = false;
        }
        if (type.equals("char") || type.equals("binary") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar")) {
            if (columnIndex == 3) {
                isEditable = true;
            }
            if (columnIndex == 4) {
                isEditable = false;
            }
        }
        return isEditable;
    }

    public boolean isDomainType(String type) {
        return !type.equalsIgnoreCase("BINARY") && !type.equalsIgnoreCase("CHAR") && !type.equalsIgnoreCase("DATE") && !type.equalsIgnoreCase("DECIMAL") && !type.equalsIgnoreCase("DOUBLE") && !type.equalsIgnoreCase("FILE") && !type.equalsIgnoreCase("REAL") && !type.equalsIgnoreCase("CHAR") && !type.equalsIgnoreCase("INTEGER") && !type.equalsIgnoreCase("BIGINT") && !type.equalsIgnoreCase("FLOAT") && !type.equalsIgnoreCase("LONG VARBINARY") && !type.equalsIgnoreCase("LONG VARCHAR") && !type.equalsIgnoreCase("OID") && !type.equalsIgnoreCase("SERIAL") && !type.equalsIgnoreCase("BIGSERIAL") && !type.equalsIgnoreCase("SMALLINT") && !type.equalsIgnoreCase("TIME") && !type.equalsIgnoreCase("TIMESTAMP") && !type.equalsIgnoreCase("VARCHAR") && !type.equalsIgnoreCase("NCLOB") && !type.equalsIgnoreCase("NCHAR") && !type.equalsIgnoreCase("NVARCHAR") && !type.equalsIgnoreCase("CLOB") && !type.equalsIgnoreCase("BLOB");
    }

    private int searchName(String name) {
        int index = -1;
        int rowCount = this.getRowCount();
        String str = null;
        for (int i = 0; i < rowCount; ++i) {
            str = (String)this.getValueAt(i, 1);
            if (str.compareTo(name) != 0) continue;
            index = i;
            break;
        }
        return index;
    }

    boolean isInteger(JsonElement json) {
        try {
            new Integer(json.getAsString());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public void initData() {
        int initResult = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.imt.sourceFileName));
            Gson gson = new Gson();
            JsonElement root = (JsonElement)gson.fromJson((Reader)bufferedReader, JsonElement.class);
            if (root == null || root.isJsonNull()) {
                initResult = -1;
                GuiUt.showErrorDlg(DataTransferFrame.frame, this.res.getString("Json_node_is_empty"), null);
                return;
            }
            if (!root.isJsonArray()) {
                initResult = -1;
                GuiUt.showErrorDlg(DataTransferFrame.frame, this.res.getString("Json_node_is_not_array"), null);
                return;
            }
            int rowIndex = 0;
            String name = null;
            JsonElement value = null;
            int index = 0;
            for (JsonElement node : root.getAsJsonArray()) {
                if (!node.isJsonObject()) continue;
                for (Map.Entry entry : node.getAsJsonObject().entrySet()) {
                    name = (String)entry.getKey();
                    index = this.searchName(name);
                    if (index >= 0) continue;
                    Object[] rowData = new Object[this.columns.length];
                    rowData[0] = Boolean.TRUE;
                    rowData[1] = name;
                    rowData[2] = name;
                    value = (JsonElement)entry.getValue();
                    if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber()) {
                        rowData[3] = this.isInteger(value) ? "INTEGER" : "FLOAT";
                        rowData[4] = 0;
                    }
                    if (rowData[3] == null) {
                        rowData[3] = "NVARCHAR";
                        rowData[4] = 255;
                    }
                    rowData[5] = "";
                    rowData[6] = Boolean.TRUE;
                    this.data.add(rowData);
                }
                if (++rowIndex != 5) continue;
                break;
            }
            initResult = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            initResult = -1;
            GuiUt.showErrorDlg(DataTransferFrame.frame, e.getMessage(), null);
            return;
        }
    }
}

