/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.text.TextField;
import dbaut.textField.DBAHex;
import dbaut.textField.DbaTextField;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class BinaryField
extends TextField
implements DbaTextField {
    private static final long serialVersionUID = -5200150882597130795L;
    private Toolkit toolkit;

    public BinaryField() {
        this(5);
    }

    public BinaryField(int columns) {
        super(columns);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.toolkit = Toolkit.getDefaultToolkit();
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    public void setValue(Object value) {
        this.setText(value.toString());
    }

    @Override
    protected Document createDefaultModel() {
        return new ByteDocument();
    }

    private void jbInit() throws Exception {
    }

    @Override
    public void setInitValue(String value) {
        throw new UnsupportedOperationException("Method setInitValue() not yet implemented.");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Method isEmpty() not yet implemented.");
    }

    @Override
    public boolean isChanged() {
        throw new UnsupportedOperationException("Method isChanged() not yet implemented.");
    }

    protected class ByteDocument
    extends PlainDocument {
        private static final long serialVersionUID = -8818844948404110195L;

        protected ByteDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int length = str.length();
            for (int i = 0; i < length; ++i) {
                if (DBAHex.isHexDigit(str.charAt(i))) continue;
                BinaryField.this.toolkit.beep();
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

