/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.text.TextField;
import dbaut.textField.DbaTextField;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class BigSerialField
extends TextField
implements DbaTextField {
    private static final long serialVersionUID = 6926480346407440575L;
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);
    private long max_length = 0L;
    private boolean positive = false;
    private boolean length_limited = false;
    public BigSerialField field = this;
    private static String MAX_VALUE = new Long(0x7FFFFFFFFFFFFFFEL).toString();
    private static String MIN_VALUE = new Long(Long.MIN_VALUE).toString();
    private String origValue = null;

    public BigSerialField() {
        this.integerFormatter.setParseIntegerOnly(true);
    }

    public BigSerialField(boolean positive) {
        this();
        this.positive = positive;
    }

    @Override
    public Object getValue() {
        long retVal = 0L;
        try {
            String t = this.getText().trim();
            if (this.isOverFlow(t)) {
                System.out.println(t + " is over flow the long range");
                retVal = t.startsWith("-") ? Long.MIN_VALUE : 0x7FFFFFFFFFFFFFFEL;
            } else {
                retVal = this.integerFormatter.parse(t).longValue();
            }
        }
        catch (ParseException e) {
            return null;
        }
        return new Long(retVal);
    }

    public boolean isOverFlow(String t) {
        if (t.startsWith("-")) {
            if (t.length() > MIN_VALUE.length()) {
                return true;
            }
            if (t.length() < MIN_VALUE.length()) {
                return false;
            }
            int size = t.length();
            for (int i = 0; i < size; ++i) {
                if (t.charAt(i) > MIN_VALUE.charAt(i)) {
                    return true;
                }
                if (t.charAt(i) >= MIN_VALUE.charAt(i)) continue;
                return false;
            }
        } else {
            if (t.length() > MAX_VALUE.length()) {
                return true;
            }
            if (t.length() < MAX_VALUE.length()) {
                return false;
            }
            int size = t.length();
            for (int i = 0; i < size; ++i) {
                if (t.charAt(i) > MAX_VALUE.charAt(i)) {
                    return true;
                }
                if (t.charAt(i) >= MAX_VALUE.charAt(i)) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isChanged() {
        String current = this.getText().trim();
        return this.origValue != null && this.origValue.compareTo(current) != 0 || this.origValue == null && current.length() > 0;
    }

    @Override
    public boolean isEmpty() {
        String txt = this.getText();
        return txt == null || txt.trim().length() <= 0;
    }

    public void setInitValue(long value) {
        this.setValue(value);
        this.origValue = Long.toString(value);
    }

    @Override
    public void setInitValue(String value) {
        this.setValue(value);
        this.origValue = value;
    }

    public void setValue(long value) {
        this.setText(Long.toString(value));
    }

    public void setValue(String value) {
        if (value != null && value.length() > 0) {
            try {
                Long.parseLong(value.trim());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        this.setText(value);
    }

    @Override
    protected Document createDefaultModel() {
        return new LongDocument();
    }

    protected class LongDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1274993087208298307L;

        protected LongDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String temp;
            if (str == null) {
                return;
            }
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            if (BigSerialField.this.length_limited && (long)((temp = BigSerialField.this.field.getText()).length() + source.length) > BigSerialField.this.max_length) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int length = result.length;
            int j = 0;
            for (int i = 0; i < length; ++i) {
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                if (!BigSerialField.this.positive && offs == 0 && i == 0 && source[i] == '-') {
                    result[j++] = source[i];
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

