/*
 * Decompiled with CFR 0.152.
 */
package dbaut.text;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class PasswordField
extends JPasswordField {
    private static final long serialVersionUID = 8694245670730971833L;
    UndoManager undoManager = new UndoManager();
    UndoHandler undoHandler = new UndoHandler();
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    KeyStroke undoKeystroke = KeyStroke.getKeyStroke(90, 2);
    KeyStroke redoKeystroke = KeyStroke.getKeyStroke(89, 2);

    public PasswordField() {
        this.setupUndoRedo();
    }

    public PasswordField(String text) {
        super(text);
        this.setupUndoRedo();
    }

    public PasswordField(int columns) {
        super(columns);
        this.setupUndoRedo();
    }

    public PasswordField(String text, int columns) {
        super(text, columns);
        this.setupUndoRedo();
    }

    public PasswordField(Document doc, String txt, int columns) {
        super(doc, txt, columns);
        this.setupUndoRedo();
    }

    public void setupUndoRedo() {
        this.getInputMap().put(this.undoKeystroke, "undoKeystroke");
        this.getActionMap().put("undoKeystroke", this.undoAction);
        this.getInputMap().put(this.redoKeystroke, "redoKeystroke");
        this.getActionMap().put("redoKeystroke", this.redoAction);
        this.getDocument().addUndoableEditListener(this.undoHandler);
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -731716311693118517L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PasswordField.this.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                ex.printStackTrace();
            }
            this.update();
            PasswordField.this.undoAction.update();
        }

        protected void update() {
            if (PasswordField.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", PasswordField.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 130221570602668519L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PasswordField.this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.update();
            PasswordField.this.redoAction.update();
        }

        protected void update() {
            if (PasswordField.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", PasswordField.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            PasswordField.this.undoManager.addEdit(e.getEdit());
            PasswordField.this.undoAction.update();
            PasswordField.this.redoAction.update();
        }
    }
}

