/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import dbaut.GuiUt;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import javax.swing.JComboBox;

public class LocaleComboBox
extends JComboBox {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
    private String[] strs = new String[]{"English", "Chinese", "Japanese", "China"};

    public LocaleComboBox() {
        short selection = LocaleManager.getLanguageChoice();
        for (short i = 0; i < LocaleManager.language_enable.length; i = (short)((short)(i + 1))) {
            if (!LocaleManager.language_enable[i]) continue;
            this.addItem(new Choice(i, this.res.getString(this.strs[i])));
            if (selection != i) continue;
            if (LocaleManager.getDefaultSystemLanguage() == 2 && i == 2) {
                this.setSelectedIndex(i - 1);
                continue;
            }
            if (LocaleManager.getDefaultSystemLanguage() == 3 && i == 3) {
                this.setSelectedIndex(i - 2);
                continue;
            }
            int itemCount = this.getItemCount();
            if (GuiUt.isWindows()) {
                this.setSelectedIndex(i);
                continue;
            }
            if (itemCount == 2 && i == 2) {
                this.setSelectedIndex(i - 1);
                continue;
            }
            if (itemCount == 2 && i == 3) {
                this.setSelectedIndex(i - 2);
                continue;
            }
            this.setSelectedIndex(i);
        }
    }

    public short getSelectedLanguageChoice() {
        Choice c = (Choice)this.getSelectedItem();
        return c.choice;
    }

    class Choice {
        short choice;
        String text;

        Choice(short choice, String text) {
            this.choice = choice;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

