/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class DbaToggleButton
extends JToggleButton {
    public DbaToggleButton() {
        this.setPreferredSize(new Dimension(110, 24));
        this.setMinimumSize(new Dimension(110, 24));
        this.setMaximumSize(new Dimension(110, 24));
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public DbaToggleButton(String t, ImageIcon icon, boolean showText) {
        if (showText) {
            this.setText(t);
        } else {
            this.setToolTipText(t);
            this.setPreferredSize(new Dimension(20, 24));
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        this.setIcon(icon);
    }

    public DbaToggleButton(String t, char c, ReflectionAction a, ImageIcon icon) {
        this();
        this.setText(t);
        this.setMnemonic(c);
        this.addActionListener(a);
        this.setIcon(icon);
    }

    public DbaToggleButton(String t, ImageIcon icon) {
        this(t, icon, true);
    }

    public DbaToggleButton(String t, char c, ImageIcon icon) {
        this();
        this.setText(t);
        this.setMnemonic(c);
        this.setIcon(icon);
    }

    @Override
    public void setMnemonic(char c) {
        super.setMnemonic(c);
        if (LocaleManager.getLanguageChoice() != 0) {
            String t = this.getText();
            String upper_t = t.toUpperCase();
            String lower_t = t.toLowerCase();
            if (t.length() > 0 && upper_t.indexOf(c) < 0 && lower_t.indexOf(c) < 0) {
                super.setText(t + "(" + c + ")");
            }
        }
    }

    @Override
    public void setText(String t) {
        if (this.getMnemonic() == 0 || LocaleManager.getLanguageChoice() == 0) {
            super.setText(t);
        } else if (LocaleManager.getLanguageChoice() != 0) {
            char c = (char)this.getMnemonic();
            String upper_t = t.toUpperCase();
            String lower_t = t.toLowerCase();
            if (t.length() > 0 && upper_t.indexOf(c) < 0 && lower_t.indexOf(c) < 0) {
                super.setText(t + "(" + c + ")");
            } else if (t.length() > 0) {
                super.setText(t);
            }
        }
    }
}

