/*
 * Decompiled with CFR 0.152.
 */
package dbaut.boundaryValue;

import dbaut.boundaryValue.BoundaryItem;

public class BoundaryLength
extends BoundaryItem {
    private long minValue = 0L;
    private long maxValue = 0L;
    private long defaultValue = 0L;
    private boolean canBeZero = false;

    public BoundaryLength(long minValue, long maxValue, long defaultValue, boolean canBeZero) {
        this.setType(ITEM_TYPE_LENGTH);
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
        this.setDefaultValue(defaultValue);
        this.setCanBeZero(canBeZero);
    }

    @Override
    public boolean checkValue(Object value) {
        boolean x_ret = false;
        try {
            long lvalue = (Long)value;
            if (lvalue != 0L && lvalue <= this.maxValue && lvalue >= this.minValue) {
                x_ret = true;
            } else if (lvalue == 0L && this.canBeZero) {
                x_ret = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return x_ret;
    }

    @Override
    public Object getDefault() {
        return new Long(this.defaultValue);
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isCanBeZero() {
        return this.canBeZero;
    }

    public void setCanBeZero(boolean canBeZero) {
        this.canBeZero = canBeZero;
    }

    @Override
    public String toString() {
        return "max Value: " + this.maxValue + " min Value: " + this.minValue;
    }
}

