/*
 * Decompiled with CFR 0.152.
 */
package dbaut.boundaryValue;

import dbaut.boundaryValue.BoundaryItem;

public class BoundaryGeneric
extends BoundaryItem {
    private long maxValue = 0L;
    private long minValue = 0L;
    private long defaultValue = 0L;
    private boolean canBeZero = false;

    public BoundaryGeneric(long minValue, long maxValue, long defaultValue, boolean canBeZero) {
        this.setType(ITEM_TYPE_GENERIC);
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.defaultValue = defaultValue;
        this.canBeZero = canBeZero;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public boolean isCanBeZero() {
        return this.canBeZero;
    }

    public void setCanBeZero(boolean canBeZero) {
        this.canBeZero = canBeZero;
    }

    public void setDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean checkValue(Object value) {
        boolean x_ret = false;
        try {
            long lonValue = (Long)value;
            if (this.minValue <= lonValue && lonValue <= this.maxValue && lonValue != 0L) {
                x_ret = true;
            } else if (lonValue == 0L && this.canBeZero) {
                x_ret = true;
            }
        }
        catch (Exception e) {
            return x_ret;
        }
        return x_ret;
    }

    @Override
    public Object getDefault() {
        return new Long(this.defaultValue);
    }

    @Override
    public String toString() {
        return "max Value: " + this.maxValue + " min Value: " + this.minValue;
    }
}

