/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class DirectoryChooser
extends JFileChooser {
    public DirectoryChooser(File startDir) {
        super(startDir);
        this.setFileSelectionMode(1);
    }

    public DirectoryChooser(String dir) {
        super(dir);
        this.setFileSelectionMode(1);
    }

    @Override
    public File getSelectedFile() {
        String fileSep;
        File file = super.getSelectedFile();
        if (file == null) {
            return file;
        }
        String dirName = super.getSelectedFile().getAbsolutePath();
        if (dirName.endsWith((fileSep = System.getProperty("file.separator")) + ".")) {
            dirName = dirName.substring(0, dirName.length() - 2);
            file = new File(dirName);
        }
        return file;
    }

    @Override
    public void setCurrentDirectory(File file) {
        super.setCurrentDirectory(file);
        FileChooserUI ui = this.getUI();
        if (ui instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)ui).setFileName(".");
        }
    }
}

