/*
 * Decompiled with CFR 0.152.
 */
package dbatool.tableCell;

import com.google.gson.JsonElement;
import dbatool.DbFrame;
import dbatool.Preferences.PreferencesXml;
import java.awt.Color;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class JSONJTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private Style defStyle = null;
    private Style arrayStyle = null;
    private Style objectStyle = null;
    private Style keyStyle = null;
    private Style valueStringStyle = null;
    private Style valueStyle = null;
    private String indentSpace = "    ";
    private PreferencesXml px;

    public JSONJTextPane(JsonElement root) {
        this.px = DbFrame.frame.px;
        this.defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        this.arrayStyle = this.addStyle("array", this.defStyle);
        this.objectStyle = this.addStyle("object", this.defStyle);
        this.keyStyle = this.addStyle("key", this.defStyle);
        this.valueStyle = this.addStyle("value", this.defStyle);
        this.valueStringStyle = this.addStyle("valueString", this.defStyle);
        StyleConstants.setBold(this.arrayStyle, true);
        StyleConstants.setBold(this.objectStyle, true);
        StyleConstants.setForeground(this.defStyle, Color.BLACK);
        StyleConstants.setForeground(this.arrayStyle, new Color(166, 90, 90));
        StyleConstants.setForeground(this.objectStyle, new Color(128, 90, 166));
        StyleConstants.setForeground(this.keyStyle, new Color(this.px.jsonKeyColor));
        StyleConstants.setForeground(this.valueStringStyle, new Color(this.px.jsonStringValueColor));
        StyleConstants.setForeground(this.valueStyle, new Color(this.px.jsonValueColor));
        if (this.px.jsonIndentSpace > 0) {
            this.indentSpace = "";
            for (int i = 0; i < this.px.jsonIndentSpace; ++i) {
                this.indentSpace = this.indentSpace + " ";
            }
        }
        try {
            this.format("", root, this.getStyledDocument(), false);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.setSelectionStart(0);
        this.setSelectionEnd(0);
    }

    private void format(String indent, JsonElement jsonElement, StyledDocument doc, boolean isValueContent) throws BadLocationException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            doc.insertString(doc.getLength(), indent + "null\n", this.defStyle);
        } else if (jsonElement.isJsonArray()) {
            if (!isValueContent) {
                doc.insertString(doc.getLength(), indent, this.arrayStyle);
            }
            doc.insertString(doc.getLength(), "[", this.arrayStyle);
            Iterator it = jsonElement.getAsJsonArray().iterator();
            if (!it.hasNext()) {
                doc.insertString(doc.getLength(), "]\n", this.arrayStyle);
                return;
            }
            doc.insertString(doc.getLength(), "\n", this.arrayStyle);
            while (it.hasNext()) {
                JsonElement element = (JsonElement)it.next();
                this.format(indent + "  ", element, doc, false);
            }
            doc.insertString(doc.getLength(), indent + "]\n", this.arrayStyle);
        } else if (jsonElement.isJsonObject()) {
            if (!isValueContent) {
                doc.insertString(doc.getLength(), indent, this.objectStyle);
            }
            doc.insertString(doc.getLength(), "{", this.objectStyle);
            Set set = jsonElement.getAsJsonObject().entrySet();
            if (set.isEmpty()) {
                doc.insertString(doc.getLength(), "}\n", this.objectStyle);
                return;
            }
            doc.insertString(doc.getLength(), "\n", this.objectStyle);
            for (Map.Entry entry : set) {
                String indent2 = indent + this.indentSpace;
                doc.insertString(doc.getLength(), indent2 + "\"" + (String)entry.getKey() + "\"", this.keyStyle);
                doc.insertString(doc.getLength(), " : ", this.defStyle);
                this.format(indent2, (JsonElement)entry.getValue(), doc, true);
            }
            doc.insertString(doc.getLength(), indent + "}\n", this.objectStyle);
        } else if (jsonElement.isJsonPrimitive()) {
            if (jsonElement.getAsJsonPrimitive().isString()) {
                if (isValueContent) {
                    doc.insertString(doc.getLength(), jsonElement.toString() + "\n", this.valueStringStyle);
                } else {
                    doc.insertString(doc.getLength(), indent + jsonElement.toString() + "\n", this.valueStringStyle);
                }
            } else if (isValueContent) {
                doc.insertString(doc.getLength(), jsonElement.toString() + "\n", this.valueStyle);
            } else {
                doc.insertString(doc.getLength(), indent + jsonElement.toString() + "\n", this.valueStyle);
            }
        } else {
            throw new IllegalArgumentException("jsonElement is an unknown element type.");
        }
    }
}

