/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Tablespace;

import dbatool.DbFrame;
import dbatool.Tablespace.MoveTableSpaceDialog;
import dbatool.Tablespace.newTransferHandler;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class IndexesPanel
extends DbaPanel {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DbaButton moveButton = new DbaButton(new Dimension(100, 24), this.res.getString("Move"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/edit.gif"), new ReflectionAction(this, "moveButtonActionPerformed"));
    private DbaTableModel model = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private String tsName = null;
    private boolean isReadOnlyTs = false;
    private final int TABLE_OWNER = 0;
    private final int TABLE_NAME = 1;
    private final int INDEX_NAME = 2;
    private final int INDEX_TYPE = 3;
    private final int DISABLE_STATUS = 4;
    private final int COLUMN_NAME = 5;
    private final int INDEX_COLUMN_COUNT = 6;
    private final int INDEX_LEVEL = 7;
    private final int INDEX_PAGE = 8;
    private final int CREATE_TIME = 9;
    private final int COLUMN_COUNT = 10;

    public IndexesPanel(String ts_name, boolean isReadOnlyTs) {
        super(DbFrame.helpres, "index.list");
        this.tsName = ts_name;
        this.isReadOnlyTs = isReadOnlyTs;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setPreferredSize(new Dimension(300, 300));
        String[] columnNames = new String[]{this.res.getString("Schema_Name_Big"), this.res.getString("Table_Name"), this.res.getString("Index"), this.res.getString("Type"), this.res.getString("Disable_Status"), this.res.getString("Column_Names"), this.res.getString("_of_column"), this.res.getString("Level"), this.res.getString("Pages"), this.res.getString("Creation_Time")};
        this.model = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table1 = new JTable(this.absModel);
        JPanel contentPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.table1.setAutoResizeMode(4);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "tableSelectChanged"));
        contentPanel.add(jScrollPane1);
        this.add(contentPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(this.moveButton);
        this.add((Component)buttonPanel, "North");
        this.initColumnSizes(this.table1);
        this.getTableList();
        this.getIndexColumnNames(this.model);
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.moveButton.setEnabled(false);
        if (this.tsName.equals("SYSTABLESPACE") || this.tsName.equals("TMPTABLESPACE")) {
            this.moveButton.setVisible(false);
        }
        this.setName("IndexesPanel");
        this.moveButton.setName("MoveButton");
        this.table1.setName("TSIndexesTable");
        this.table1.setDragEnabled(true);
        this.table1.setTransferHandler(new newTransferHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getIndexColumnNames(DbaTableModel model2) {
        Connection conn = null;
        DatabaseMetaData dbmd = null;
        conn = DbFrame.conn_DatabaseConnection.getDbConnection();
        ResultSet rs = null;
        int rowCount = model2.getRowCount();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rowCount; ++i) {
            String schema = model2.getValueAt(i, 0).toString().trim();
            String tbName = model2.getValueAt(i, 1).toString().trim();
            String idxName = model2.getValueAt(i, 2).toString().trim();
            try {
                dbmd = conn.getMetaData();
                rs = dbmd.getIndexInfo(null, schema, tbName, false, false);
                while (rs.next()) {
                    String indexName = rs.getString("INDEX_NAME");
                    String keyUC = null;
                    if (indexName != null) {
                        keyUC = indexName.trim().toUpperCase();
                    }
                    if (keyUC == null || !keyUC.equalsIgnoreCase(idxName)) continue;
                    String columnName = GuiUt.rightTrim(rs.getString("COLUMN_NAME"));
                    if (rs.getString("ASC_OR_DESC").equals("D")) {
                        columnName = columnName.concat("(desc)");
                    }
                    if (list.contains(columnName)) continue;
                    list.add(columnName);
                }
                StringBuffer keys_String = new StringBuffer();
                for (String element : list) {
                    keys_String.append(element).append(", ");
                }
                keys_String.delete(keys_String.lastIndexOf(", "), keys_String.length());
                model2.setValueAt(keys_String, i, 5);
                this.table1.tableChanged(new TableModelEvent(model2, i, i, 5));
                list.removeAll(list);
                rs.close();
                DbaObject.close(rs);
            }
            catch (SQLException ex) {
                GuiUt.showSQLException(DbFrame.frame, null, ex);
                return;
            }
            finally {
                DbaObject.close(rs);
                rs = null;
            }
            rs = null;
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        DefaultTableCellRenderer renderer = null;
        int RIGHT = 4;
        int LEFT = 2;
        int[] sizes = new int[]{100, 140, 120, 60, 60, 100, 60, 60, 60, 120};
        int[] alignments = new int[]{LEFT, LEFT, LEFT, LEFT, LEFT, RIGHT, RIGHT, RIGHT, RIGHT, LEFT};
        for (int i = 0; i < sizes.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(table.getColumnName(i));
            renderer.setHorizontalAlignment(alignments[i]);
            column.setCellRenderer(renderer);
            column.setPreferredWidth(sizes[i]);
        }
    }

    private void getTableList() {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            conn = DbFrame.conn_DatabaseConnection.getDbConnection();
            stmt = conn.createStatement();
            boolean insystbl = DbFrame.frame.treePanel.getOption("INSYSTBL");
            query = "select TABLE_OWNER, TABLE_NAME, INDEX_NAME, UNIQUE, NUM_COL,NUM_LEVEL, NUM_PAGE, DWTOSTR(CREATE_TIME) ";
            query = insystbl ? query + "from SYSTEM.SYSINDEX " + "where TS_NAME='" + this.tsName + "'" : query + "from SYSTEM.SYSINDEX " + "where TS_NAME='" + this.tsName + "' and TABLE_OWNER!='SYSTEM'";
            String schema = "";
            String tableName = "";
            String indexName = "";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                schema = GuiUt.rightTrim(rs.getString(1));
                tableName = GuiUt.rightTrim(rs.getString(2));
                indexName = GuiUt.rightTrim(rs.getString(3));
                this.model.addValue(new DBARowInfo(this.getRowInfo(schema, tableName, indexName, rs.getInt(4), "placeholder", rs.getInt(5), rs.getInt(6), rs.getInt(7), GuiUt.rightTrim(rs.getString(8)))));
            }
            rs.close();
            stmt.close();
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Number_of_tables") + " " + this.model.getRowCount());
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            sqle.printStackTrace();
        }
    }

    private Object[] getRowInfo(String table_owner, String table_name, String index_name, int type, String column_name, int index_column_count, int level, int page, String create_time) {
        Object[] data = new Object[10];
        data[0] = GuiUt.rightTrim(table_owner);
        data[1] = GuiUt.rightTrim(table_name);
        data[2] = GuiUt.rightTrim(index_name);
        switch (type) {
            case 0: {
                data[3] = new String(DbFrame.frame.res.getString("Not_Unique"));
                data[4] = DbFrame.frame.res.getString("Enabled");
                break;
            }
            case 1: {
                data[3] = new String(DbFrame.frame.res.getString("Unique"));
                data[4] = DbFrame.frame.res.getString("Enabled");
                break;
            }
            case 3: {
                data[3] = new String(DbFrame.frame.res.getString("Primary_Key"));
                data[4] = DbFrame.frame.res.getString("Enabled");
                break;
            }
            case 4: {
                data[3] = new String(DbFrame.frame.res.getString("Auto_Index"));
                data[4] = DbFrame.frame.res.getString("Enabled");
                break;
            }
            case 8: {
                data[3] = new String(DbFrame.frame.res.getString("Not_Unique"));
                data[4] = DbFrame.frame.res.getString("Disabled");
                break;
            }
            case 9: {
                data[3] = new String(DbFrame.frame.res.getString("Unique"));
                data[4] = DbFrame.frame.res.getString("Disabled");
                break;
            }
            case 11: {
                data[3] = new String(DbFrame.frame.res.getString("Primary_Key"));
                data[4] = DbFrame.frame.res.getString("Disabled");
                break;
            }
            case 12: {
                data[3] = new String(DbFrame.frame.res.getString("Auto_Index"));
                data[4] = DbFrame.frame.res.getString("Disabled");
            }
        }
        data[5] = "";
        data[6] = new Integer(index_column_count);
        data[7] = new Integer(level);
        data[8] = new Integer(page);
        data[9] = create_time;
        return data;
    }

    public void tableSelectChanged(ListSelectionEvent e) {
        if (!(this.isReadOnlyTs || this.tsName.equals("TMPTABLESPACE") || this.tsName.equals("SYSTABLESPACE"))) {
            if (this.table1.getSelectedRowCount() < 1) {
                this.moveButton.setEnabled(false);
                this.moveButton.setToolTipText(null);
            } else {
                this.moveButton.setEnabled(true);
                this.moveButton.setToolTipText(this.res.getString("Move_Tips"));
            }
        }
    }

    public void moveButtonActionPerformed(ActionEvent e) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        int[] selected = this.table1.getSelectedRows();
        if (selected.length < 1) {
            return;
        }
        for (int j = 0; j < selected.length; ++j) {
            String[] dataRow = new String[3];
            for (int i = 0; i < 3; ++i) {
                dataRow[i] = this.model.getValueAt(selected[j], i).toString();
            }
            data.add(dataRow);
        }
        new MoveTableSpaceDialog(DbFrame.frame, this.tsName, data, null, true);
        this.model.removeAll();
        this.getTableList();
        this.getIndexColumnNames(this.model);
        this.absModel.fireTableChanged(null);
        this.initColumnSizes(this.table1);
        this.absModel.removeMouseListenerToHeaderInTable(this.table1);
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
    }
}

