/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import dbatool.DbFrame;
import dbatool.Table.ColumnListNode;
import dbatool.Table.ColumnPermissionTableModel;
import dbatool.Table.PermissionRowInfo;
import dbatool.tableModel.ColumnSorting;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.table.AbstractTableModel;

public class PermissionTableModel
extends AbstractTableModel
implements ColumnSorting {
    private String[] columnNames;
    private Vector data;
    public DefaultListModel columnlist;
    public String table_owner;
    public String table_name;
    public boolean isEditable;

    public PermissionTableModel() {
        this.columnNames = new String[]{DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("User_Group"), DbFrame.frame.res.getString("Select"), DbFrame.frame.res.getString("Delete"), DbFrame.frame.res.getString("Insert"), DbFrame.frame.res.getString("Update"), DbFrame.frame.res.getString("Alter"), DbFrame.frame.res.getString("Index"), DbFrame.frame.res.getString("Reference")};
        this.data = new Vector();
        this.columnlist = null;
        this.table_owner = null;
        this.table_name = null;
        this.isEditable = false;
    }

    public PermissionTableModel(DefaultListModel columnList, String table_owner, String table_name) {
        this.columnNames = new String[]{DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("User_Group"), DbFrame.frame.res.getString("Select"), DbFrame.frame.res.getString("Delete"), DbFrame.frame.res.getString("Insert"), DbFrame.frame.res.getString("Update"), DbFrame.frame.res.getString("Alter"), DbFrame.frame.res.getString("Index"), DbFrame.frame.res.getString("Reference")};
        this.data = new Vector();
        this.columnlist = null;
        this.table_owner = null;
        this.table_name = null;
        this.isEditable = false;
        this.columnlist = columnList;
        this.table_owner = table_owner;
        this.table_name = table_name;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        PermissionRowInfo rowData = (PermissionRowInfo)this.data.elementAt(row);
        return rowData.getValueAt(col);
    }

    public Class getColumnClass(int c) {
        PermissionRowInfo rowData = (PermissionRowInfo)this.data.elementAt(0);
        return rowData.getValueAt(c).getClass();
    }

    public void addValue(PermissionRowInfo newData) {
        this.data.addElement(newData);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        PermissionRowInfo rowData = (PermissionRowInfo)this.data.elementAt(row);
        String name = (String)rowData.getValueAt(1);
        if (!this.isEditable) {
            rowData.setValueAt(value, col);
            return;
        }
        if (col == 4 || col == 5 || col == 8) {
            ColumnListNode node = null;
            ColumnPermissionTableModel model = null;
            int count = this.columnlist.size();
            for (int i = 0; i < count; ++i) {
                node = (ColumnListNode)this.columnlist.elementAt(i);
                model = node.model;
                if (model == null) continue;
                if (col == 4) {
                    model.setValueByGrantee(value, name, 2);
                    continue;
                }
                if (col == 5) {
                    model.setValueByGrantee(value, name, 3);
                    continue;
                }
                if (col != 8) continue;
                model.setValueByGrantee(value, name, 4);
            }
        }
        rowData.setValueAt(value, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.isEditable) {
            return false;
        }
        Boolean dba = (Boolean)this.getValueAt(row, 9);
        Boolean resource = (Boolean)this.getValueAt(row, 10);
        String user = (String)this.getValueAt(row, 1);
        if (dba.booleanValue() || resource.booleanValue() && user.equalsIgnoreCase(this.table_owner)) {
            return false;
        }
        return col != 1 && col != 0;
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    public Vector getUpdatingPermission() {
        Vector<String> vector = new Vector<String>();
        PermissionRowInfo aRow = null;
        String grant = null;
        String revoke = null;
        int count = this.data.size();
        for (int i = 0; i < count; ++i) {
            aRow = (PermissionRowInfo)this.data.elementAt(i);
            grant = aRow.getGrantInfo(this.table_owner, this.table_name);
            if (grant.length() > 0) {
                vector.addElement(grant);
            }
            if ((revoke = aRow.getRevokeInfo(this.table_owner, this.table_name)).length() <= 0) continue;
            vector.addElement(revoke);
        }
        return vector;
    }

    public PermissionRowInfo getRowByGrantee(String grantee) {
        String name = null;
        int count = this.data.size();
        for (int i = 0; i < count; ++i) {
            name = (String)this.getValueAt(i, 1);
            if (!name.equals(grantee)) continue;
            return (PermissionRowInfo)this.data.elementAt(i);
        }
        return null;
    }

    public Object getValueByGrantee(String grantee, int col) {
        String name = null;
        int count = this.data.size();
        for (int i = 0; i < count; ++i) {
            name = (String)this.getValueAt(i, 1);
            if (!name.equals(grantee)) continue;
            return this.getValueAt(i, col);
        }
        return null;
    }

    public void setValueByGrantee(Object value, String grantee, int col) {
        String name = null;
        PermissionRowInfo rowData = null;
        int count = this.data.size();
        for (int i = 0; i < count; ++i) {
            name = (String)this.getValueAt(i, 1);
            if (!name.equals(grantee)) continue;
            rowData = (PermissionRowInfo)this.data.elementAt(i);
            rowData.setValueAt(value, col);
            return;
        }
    }

    @Override
    public void switchOrder(int godown, int goup) {
        Object downRow = this.data.elementAt(godown);
        Object upRow = this.data.elementAt(goup);
        this.data.setElementAt(downRow, goup);
        this.data.setElementAt(upRow, godown);
    }
}

