/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TDE;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.dm.dba.sca.DbaAuthority;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbatool.TDE.PasswordDlg;
import dbatool.TDE.PasswordForSettingDlg;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.panel.PanelWithTitle;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class TDEDlg
extends JDialog {
    private static final long serialVersionUID = -2972661830740457063L;
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    JRadioButton tdeOpen_RadioButton = new JRadioButton(this.res.getString("Open"));
    JRadioButton tdeClose_RadioButton = new JRadioButton(this.res.getString("Close"));
    JRadioButton tdeAutoOpen_RadioButton = new JRadioButton(this.res.getString("Open"));
    JRadioButton tdeAutoClose_RadioButton = new JRadioButton(this.res.getString("Close"));
    private boolean isTdeOpen = false;
    private boolean isTdeAuto = false;

    public TDEDlg(Frame frame) {
        super(frame);
        this.setModal(true);
        try {
            this.setTitle(this.res.getString("Manage_TDE"));
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TDEDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.setTitle(this.res.getString("User_preference"));
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        HelpButton Help_Button = new HelpButton();
        JPanel jPanel6 = new JPanel(new BorderLayout());
        JPanel jPanel7 = new JPanel((LayoutManager)new VerticalFlowLayout());
        DbaButton OK_Button = new DbaButton(new Dimension(100, 24), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "OK_Button_actionPerformed"));
        DbaButton Cancel_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        DbaButton Password_Button = new DbaButton(new Dimension(120, 24), this.res.getString("Password"), 'P', null, new ReflectionAction(this, "Password_Button_actionPerformed"));
        jPanel7.add(new JLabel(this.res.getString("TDE_dialog")));
        ButtonGroup group = new ButtonGroup();
        group.add(this.tdeOpen_RadioButton);
        group.add(this.tdeClose_RadioButton);
        group = new ButtonGroup();
        group.add(this.tdeAutoOpen_RadioButton);
        group.add(this.tdeAutoClose_RadioButton);
        PanelWithTitle panel01 = new PanelWithTitle(this.res.getString("TDE_password"));
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)new JLabel(this.res.getString("TDE_initialize_password")), "Center");
        panel1.add((Component)Password_Button, "East");
        ((Container)panel01).add(panel1);
        jPanel7.add(panel01);
        PanelWithTitle panel0 = new PanelWithTitle(this.res.getString("TDE_setting"));
        panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)new JLabel(this.res.getString("TDE_current_status")), "Center");
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this.tdeOpen_RadioButton);
        panel2.add(this.tdeClose_RadioButton);
        panel1.add((Component)panel2, "East");
        ((Container)panel0).add(panel1);
        panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)new JLabel(this.res.getString("TDE_future_status")), "Center");
        panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this.tdeAutoOpen_RadioButton);
        panel2.add(this.tdeAutoClose_RadioButton);
        panel1.add((Component)panel2, "East");
        ((Container)panel0).add(panel1);
        jPanel7.add(panel0);
        panel1 = new JPanel(new FlowLayout(2));
        panel1.add(OK_Button);
        panel1.add(Cancel_Button);
        panel1.add(Help_Button);
        jPanel6.add((Component)panel1, "South");
        jPanel6.add((Component)jPanel7, "North");
        jPanel6.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel6.setPreferredSize(new Dimension(500, 400));
        this.getContentPane().add(jPanel6);
        DbFrame.frame.enableDialogHelp(this.getRootPane(), Help_Button, "TDE", null);
        this.setName("TDEDialog");
        Cancel_Button.setName("CancelButton");
        OK_Button.setName("OKButton");
        if (DbFrame.frame.isConnect) {
            DbaAuthority authority = DbaAuthorityFactory.create(null);
            this.checkUserPrivilege(authority.isAboveDba());
        }
        this.initValue();
    }

    private void initValue() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery("SELECT VALUE FROM SYSINFO WHERE ID = '0725'");
            String tdeOpen = null;
            if (rs.next()) {
                tdeOpen = rs.getString(1).trim();
                if (tdeOpen.compareToIgnoreCase("OPEN") == 0) {
                    this.tdeOpen_RadioButton.setSelected(true);
                    this.isTdeOpen = true;
                } else {
                    this.tdeClose_RadioButton.setSelected(true);
                    this.isTdeOpen = false;
                }
            }
            rs.close();
            rs = stmt.executeQuery("SELECT VALUE FROM SYSINFO WHERE ID = '0726'");
            String tdeAuto = null;
            if (rs.next()) {
                tdeAuto = rs.getString(1).trim();
                if (tdeAuto.compareToIgnoreCase("ON") == 0) {
                    this.tdeAutoOpen_RadioButton.setSelected(true);
                    this.isTdeAuto = true;
                } else {
                    this.tdeAutoClose_RadioButton.setSelected(true);
                    this.isTdeAuto = false;
                }
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, e);
            return;
        }
    }

    private void checkUserPrivilege(boolean isDBA) {
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        boolean toAskForPassword = false;
        if (this.tdeOpen_RadioButton.isSelected() && !this.isTdeOpen || !this.tdeOpen_RadioButton.isSelected() && this.isTdeOpen) {
            toAskForPassword = true;
        }
        if (this.tdeAutoOpen_RadioButton.isSelected() && !this.isTdeAuto || !this.tdeAutoOpen_RadioButton.isSelected() && this.isTdeAuto) {
            toAskForPassword = true;
        }
        if (!toAskForPassword) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        PasswordForSettingDlg dlg = DbFrame.isWindows ? new PasswordForSettingDlg(DbFrame.frame) : new PasswordForSettingDlg(DbFrame.frame, "", true);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.setVisible(true);
        String password = dlg.getPassword();
        if (password == null) {
            GuiUt.showErrorDlg(this, this.res.getString("TDE_password_required"), "");
        } else {
            try {
                Statement stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
                if (this.tdeOpen_RadioButton.isSelected() && !this.isTdeOpen) {
                    stmt.executeUpdate("CALL SETSYSTEMOPTION('TDE_OPEN','" + password + "')");
                } else if (!this.tdeOpen_RadioButton.isSelected() && this.isTdeOpen) {
                    stmt.executeUpdate("CALL SETSYSTEMOPTION('TDE_CLOSE','" + password + "')");
                }
                if (this.tdeAutoOpen_RadioButton.isSelected() && !this.isTdeAuto) {
                    stmt.executeUpdate("CALL SETSYSTEMOPTION('TDE_OPEN_AUTO','" + password + "')");
                } else if (!this.tdeAutoOpen_RadioButton.isSelected() && this.isTdeAuto) {
                    stmt.executeUpdate("CALL SETSYSTEMOPTION('TDE_CLOSE_AUTO','" + password + "')");
                }
                stmt.close();
                GuiUt.showInformationDlg(this, this.res.getString("TDE_setting_is_successfully"));
                this.Cancel_Button_actionPerformed(null);
                return;
            }
            catch (SQLException sqle) {
                GuiUt.showErrorDlg(this, sqle.getMessage(), "");
            }
        }
    }

    public void Password_Button_actionPerformed(ActionEvent e) {
        PasswordDlg dlg = DbFrame.isWindows ? new PasswordDlg(DbFrame.frame) : new PasswordDlg(DbFrame.frame, "", true);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.show();
        dlg = null;
    }
}

