/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Preferences;

import dbatool.DbFrame;
import dbaut.preference.CorePreferences;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ComboBoxModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import queryAnalyzer.QueryFrame;

public class PreferencesXml
extends CorePreferences {
    private Point position = new Point(0, 0);
    private boolean show_system_table = false;
    private boolean treeview_refresh = false;
    private boolean show_sql_script = false;
    private boolean auto_refresh = true;
    private int auto_refresh_time = 10;
    private int num_record = 50;
    private int sp_depth = 8;
    private boolean popup_constraint_editor = true;
    private String blobFilePath = null;
    private int frame_width = 800;
    private int frame_height = 600;
    private int divider_location = 160;
    private boolean show_all_views = false;
    private boolean displayTableModel = true;
    private HistoryCollection history = new HistoryCollection();
    private int num_history_cmd = 50;
    private boolean save_history = true;
    private boolean auto_completion = false;
    public int jsonKeyColor = 0x202020;
    public int jsonStringValueColor = 26112;
    public int jsonValueColor = 255;
    public int jsonIndentSpace = 4;
    private String selected_directory = null;
    private Element syscom = null;
    public String orString = null;
    public boolean isWindows = true;
    public String user_dir = null;
    public String file_separator = null;
    public static final int SHOW_SYSTEM_TABLE = 0;
    public static final int TREEVIEW_REFRESH = 1;
    public static final int SHOW_SQL_SCRIPT = 2;
    public static final int AUTO_REFRESH = 3;
    public static final int AUTO_REFRESH_TIME = 4;
    public static final int NUM_RECORD = 5;
    public static final int POPUP_CONSTRAINT_EDITOR = 6;
    public static final int BLOB_FILE_PATH = 7;
    public static final int SELECTED_DIRECTORY = 8;
    public static final int XML_FILE_PATH = 9;
    public static final int SP_DEPTH = 10;
    public static final int SHOW_ALL_VIEWS = 11;
    private static PreferencesXml self = null;
    private String XMLFilePath = null;

    public static PreferencesXml getPreferencesXml() {
        self = new PreferencesXml();
        return self;
    }

    public PreferencesXml() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.file_separator = System.getProperty("file.separator");
        this.user_dir = System.getProperty("user.dir");
        this.isWindows = this.file_separator.equals("\\");
        this.init(CorePreferences.getConfigName());
    }

    private void init(String fileName) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(fileName);
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        String temp = null;
        Node node = null;
        this.resetDOM(doc);
        node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jdba");
        if (node != null && node.getNodeType() == 1 && (temp = ((Element)node).getAttribute("selected_directory")) != null && temp.length() > 0) {
            this.selected_directory = temp;
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jdba/frame")) != null && node.getNodeType() == 1) {
            Element elm = (Element)node;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int xpos = 0;
            int ypos = 0;
            temp = elm.getAttribute("xpos");
            if (temp != null && temp.length() > 0 && ((xpos = Integer.parseInt(temp)) < 0 || (double)xpos > screenSize.getWidth())) {
                xpos = 0;
            }
            if ((temp = elm.getAttribute("ypos")) != null && temp.length() > 0 && ((ypos = Integer.parseInt(temp)) < 0 || (double)ypos > screenSize.getHeight())) {
                ypos = 0;
            }
            this.position = new Point(xpos, ypos);
            temp = elm.getAttribute("width");
            if (temp != null && temp.length() > 0) {
                this.frame_width = Integer.parseInt(temp);
                if (this.frame_width < 0) {
                    this.frame_width = 800;
                }
            }
            if ((temp = elm.getAttribute("height")) != null && temp.length() > 0) {
                this.frame_height = Integer.parseInt(temp);
                if (this.frame_height < 0) {
                    this.frame_height = 600;
                }
            }
            if ((temp = elm.getAttribute("divider_location")) != null && temp.length() > 0) {
                this.divider_location = Integer.parseInt(temp);
                if (this.divider_location < 0) {
                    this.divider_location = 160;
                }
            }
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jdba/options")) != null && node.getNodeType() == 1) {
            temp = ((Element)node).getAttribute("show_system_table");
            if (temp != null && temp.length() > 0) {
                this.show_system_table = Boolean.parseBoolean(temp);
            }
            if ((temp = ((Element)node).getAttribute("treeview_refresh")) != null && temp.length() > 0) {
                this.treeview_refresh = Boolean.parseBoolean(temp);
            }
            if ((temp = ((Element)node).getAttribute("show_sql_script")) != null && temp.length() > 0) {
                this.show_sql_script = Boolean.parseBoolean(temp);
            }
            if ((temp = ((Element)node).getAttribute("auto_refresh")) != null && temp.length() > 0) {
                this.auto_refresh = Boolean.parseBoolean(temp);
            }
            if ((temp = ((Element)node).getAttribute("auto_refresh_time")) != null && temp.length() > 0) {
                this.auto_refresh_time = Integer.parseInt(temp);
            }
            if ((temp = ((Element)node).getAttribute("num_record")) != null && temp.length() > 0) {
                this.num_record = Integer.parseInt(temp);
            }
            if ((temp = ((Element)node).getAttribute("popup_constraint_editor")) != null && temp.length() > 0) {
                this.popup_constraint_editor = Boolean.parseBoolean(temp);
            }
            if ((temp = ((Element)node).getAttribute("blob_file_path")) != null && temp.length() > 0) {
                this.blobFilePath = temp;
            }
            if ((temp = ((Element)node).getAttribute("xml_file_path")) != null && temp.length() > 0) {
                this.XMLFilePath = temp;
            }
            if ((temp = ((Element)node).getAttribute("sp_depth")) != null && temp.length() > 0) {
                this.sp_depth = Integer.parseInt(temp);
            }
            if ((temp = ((Element)node).getAttribute("show_all_views")) != null && temp.length() > 0) {
                this.show_all_views = Boolean.parseBoolean(temp);
            }
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jsql")) != null && node.getNodeType() == 1) {
            temp = ((Element)node).getAttribute("json_key_color");
            if (temp != null && temp.length() > 0) {
                this.jsonKeyColor = Integer.parseInt(temp, 16);
            }
            if ((temp = ((Element)node).getAttribute("json_stringvalue_color")) != null && temp.length() > 0) {
                this.jsonStringValueColor = Integer.parseInt(temp, 16);
            }
            if ((temp = ((Element)node).getAttribute("json_value_color")) != null && temp.length() > 0) {
                this.jsonValueColor = Integer.parseInt(temp, 16);
            }
            if ((temp = ((Element)node).getAttribute("json_indent_space")) != null && temp.length() > 0) {
                this.jsonIndentSpace = Integer.parseInt(temp);
            }
            this.auto_completion = (temp = ((Element)node).getAttribute("auto_completion")) != null && temp.length() > 0 ? Boolean.valueOf(temp) : false;
        }
        NodeList list = XPathAPI.selectNodeList((Node)doc, (String)"/syscom/jsql/history");
        Node node0 = null;
        if (list != null && list.getLength() > 0) {
            int num_history_cmd = 50;
            boolean save_history = false;
            for (int i = 0; i < list.getLength(); ++i) {
                node = list.item(i);
                String dbname = ((Element)node).getAttribute("dbname");
                String user = ((Element)node).getAttribute("user");
                temp = ((Element)node).getAttribute("num_history_cmd");
                num_history_cmd = temp != null && temp.length() > 0 ? Integer.valueOf(temp) : 50;
                temp = ((Element)node).getAttribute("save_history");
                save_history = temp != null && temp.length() > 0 ? Boolean.valueOf(temp) : false;
                NodeList list0 = XPathAPI.selectNodeList((Node)node, (String)"command");
                ArrayList<String> cmds = new ArrayList<String>();
                for (int j = 0; j < list0.getLength(); ++j) {
                    node0 = list0.item(j);
                    cmds.add(node0.getFirstChild().getNodeValue());
                }
                this.history.add(dbname, user, save_history, num_history_cmd, cmds);
            }
        }
    }

    public void updateVariables(int options, String value) {
        switch (options) {
            case 0: {
                if (value.equals("true")) {
                    this.show_system_table = true;
                    break;
                }
                this.show_system_table = false;
                break;
            }
            case 1: {
                if (value.equals("true")) {
                    this.treeview_refresh = true;
                    break;
                }
                this.treeview_refresh = false;
                break;
            }
            case 2: {
                if (value.equals("true")) {
                    this.show_sql_script = true;
                    break;
                }
                this.show_sql_script = false;
                break;
            }
            case 3: {
                if (value.equals("true")) {
                    this.auto_refresh = true;
                    break;
                }
                this.auto_refresh = false;
                break;
            }
            case 4: {
                this.auto_refresh_time = Integer.parseInt(value);
                break;
            }
            case 5: {
                this.num_record = Integer.parseInt(value);
                break;
            }
            case 6: {
                if (value.equals("true")) {
                    this.popup_constraint_editor = true;
                    break;
                }
                this.popup_constraint_editor = false;
                break;
            }
            case 7: {
                this.blobFilePath = value;
                break;
            }
            case 8: {
                this.selected_directory = value;
                break;
            }
            case 9: {
                this.XMLFilePath = value;
                break;
            }
            case 10: {
                this.sp_depth = Integer.parseInt(value);
                break;
            }
            case 11: {
                this.show_all_views = value.equals("true");
            }
        }
    }

    public Point getLocation() {
        return this.position;
    }

    public boolean getShowSystemTable() {
        return this.show_system_table;
    }

    public boolean getTreeviewRefresh() {
        return this.treeview_refresh;
    }

    public boolean getShowSqlScript() {
        return this.show_sql_script;
    }

    public boolean getAutoRefresh() {
        return this.auto_refresh;
    }

    public int getAutoRefreshTime() {
        return this.auto_refresh_time;
    }

    public int getNumRecord() {
        return this.num_record;
    }

    public int getSpDepth() {
        return this.sp_depth;
    }

    public boolean getPopupConstraintEditor() {
        return this.popup_constraint_editor;
    }

    public String getBlobFilePath() {
        return this.blobFilePath;
    }

    public String getSelectedDirectory() {
        return this.selected_directory;
    }

    public int getFrameWidth() {
        return this.frame_width;
    }

    public int getFrameHeight() {
        return this.frame_height;
    }

    public int getDividerLocation() {
        return this.divider_location;
    }

    public boolean getShowAllViews() {
        return this.show_all_views;
    }

    public boolean getDisplayTableModel() {
        return this.displayTableModel;
    }

    public ArrayList<String> getHistory(String dbname, String user) {
        History h;
        dbname = dbname.toUpperCase();
        if (DbFrame.conn_DatabaseConnection.isIDCAP()) {
            user = user.toUpperCase();
        }
        if ((h = this.history.getHistory(dbname, user)) != null) {
            this.save_history = h.save_history;
            this.num_history_cmd = h.num_history_cmd;
            return h.command;
        }
        this.save_history = false;
        this.num_history_cmd = 50;
        return null;
    }

    public int getNumHistoryCmd() {
        return this.num_history_cmd;
    }

    public boolean getSaveHistory() {
        return this.save_history;
    }

    public void setSaveHistory(boolean b) {
        this.save_history = b;
    }

    public boolean getAutoCompletion() {
        return this.auto_completion;
    }

    public void setAutoCompletion(boolean b) {
        this.auto_completion = b;
    }

    public void setNumHistoryCmd(int i) {
        this.num_history_cmd = i;
    }

    public String getXMLFilePath() {
        return this.XMLFilePath;
    }

    @Override
    public void save() {
        this.save(PreferencesXml.getConfigName());
    }

    private void copyChildNodes(Node orig, Node historyelm) {
        Document targetDoc = historyelm.getOwnerDocument();
        NodeList childNodes = orig.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            Node importedChild = targetDoc.importNode(child, true);
            historyelm.appendChild(importedChild);
        }
    }

    private void save(String fileName) {
        this.frame_width = DbFrame.frame.getWidth();
        this.frame_height = DbFrame.frame.getHeight();
        this.divider_location = DbFrame.frame.getDividerLocation();
        if (this.divider_location != 200) {
            this.divider_location = 200;
        }
        this.position = DbFrame.frame.getLocationOnScreen();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Document doc = null;
        Element jdba2 = null;
        File file = new File(fileName);
        if (file.exists()) {
            try {
                doc = builder.parse(fileName);
            }
            catch (Exception pe) {
                pe.printStackTrace();
                doc = builder.newDocument();
            }
        } else {
            doc = builder.newDocument();
        }
        this.setDOM(doc);
        this.syscom = doc.getDocumentElement();
        if (this.syscom == null) {
            System.out.println("CorePreferences fails to save <syscom>");
        }
        jdba2 = doc.createElement("jdba");
        if (this.selected_directory != null && this.selected_directory.length() > 0) {
            jdba2.setAttribute("selected_directory", this.selected_directory);
        }
        Element frame = doc.createElement("frame");
        frame.setAttribute("width", Integer.toString(this.frame_width));
        frame.setAttribute("height", Integer.toString(this.frame_height));
        frame.setAttribute("divider_location", Integer.toString(this.divider_location));
        frame.setAttribute("xpos", Integer.toString((int)this.position.getX()));
        frame.setAttribute("ypos", Integer.toString((int)this.position.getY()));
        Element options = doc.createElement("options");
        options.setAttribute("show_system_table", this.show_system_table ? "true" : "false");
        options.setAttribute("treeview_refresh", this.treeview_refresh ? "true" : "false");
        options.setAttribute("show_sql_script", this.show_sql_script ? "true" : "false");
        options.setAttribute("auto_refresh", this.auto_refresh ? "true" : "false");
        options.setAttribute("auto_refresh_time", Integer.toString(this.auto_refresh_time));
        options.setAttribute("num_record", Integer.toString(this.num_record));
        options.setAttribute("sp_depth", Integer.toString(this.sp_depth));
        options.setAttribute("popup_constraint_editor", this.popup_constraint_editor ? "true" : "false");
        if (this.blobFilePath != null && this.blobFilePath.length() > 0) {
            options.setAttribute("blob_file_path", this.blobFilePath);
        }
        options.setAttribute("xml_file_path", this.XMLFilePath);
        options.setAttribute("show_all_views", this.show_all_views ? "true" : "false");
        jdba2.appendChild(frame);
        jdba2.appendChild(options);
        Element jsql = null;
        try {
            Node temp = XPathAPI.selectSingleNode((Node)this.syscom, (String)"jsql");
            if (temp != null && temp.getNodeType() == 1) {
                jsql = (Element)temp;
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        if (jsql == null) {
            jsql = doc.createElement("jsql");
            this.syscom.appendChild(jsql);
        }
        jsql.setAttribute("json_key_color", Integer.toHexString(this.jsonKeyColor));
        jsql.setAttribute("json_stringvalue_color", Integer.toHexString(this.jsonStringValueColor));
        jsql.setAttribute("json_value_color", Integer.toHexString(this.jsonValueColor));
        jsql.setAttribute("json_indent_space", Integer.toString(this.jsonIndentSpace));
        jsql.setAttribute("auto_completion", Boolean.toString(this.auto_completion));
        if (DbFrame.conn_DatabaseConnection != null) {
            String dbname = DbFrame.conn_DatabaseConnection.dbname;
            String user = DbFrame.conn_DatabaseConnection.username;
            dbname = dbname.toUpperCase();
            if (DbFrame.conn_DatabaseConnection.isIDCAP()) {
                user = user.toUpperCase();
            }
            if (this.save_history) {
                ComboBoxModel model;
                Element historyelm = doc.createElement("history");
                historyelm.setAttribute("dbname", dbname);
                historyelm.setAttribute("user", user);
                historyelm.setAttribute("num_history_cmd", Integer.toString(this.num_history_cmd));
                historyelm.setAttribute("save_history", Boolean.toString(this.save_history));
                ArrayList<String> data = new ArrayList<String>();
                if (QueryFrame.frame != null && (model = QueryFrame.frame.historyComboBox.getModel()).getSize() > 0) {
                    Element command = null;
                    String s = null;
                    for (int i = 0; i < model.getSize(); ++i) {
                        command = doc.createElement("command");
                        s = model.getElementAt(i).toString();
                        command.appendChild(doc.createTextNode(s));
                        historyelm.appendChild(command);
                        data.add(s);
                    }
                }
                Node orig = null;
                try {
                    String s = "history[@dbname='" + dbname + "' and @user='" + user + "']";
                    orig = XPathAPI.selectSingleNode((Node)jsql, (String)s);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                if (orig != null && orig.getNodeType() == 1) {
                    if (QueryFrame.frame == null) {
                        this.copyChildNodes(orig, historyelm);
                        data = this.getHistory(dbname, user);
                    }
                    jsql.replaceChild(historyelm, orig);
                    this.history.replace(dbname, user, this.save_history, this.num_history_cmd, data);
                } else {
                    jsql.appendChild(historyelm);
                    this.history.add(dbname, user, this.save_history, this.num_history_cmd, data);
                }
            } else {
                Node orig = null;
                try {
                    String s = "history[@dbname='" + dbname + "' and @user='" + user + "']";
                    orig = XPathAPI.selectSingleNode((Node)jsql, (String)s);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                if (orig != null && orig.getNodeType() == 1) {
                    jsql.removeChild(orig);
                }
                this.history.remove(dbname, user);
            }
        }
        Node orig = null;
        try {
            orig = XPathAPI.selectSingleNode((Node)this.syscom, (String)"jdba");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (orig != null && orig.getNodeType() == 1) {
            this.syscom.replaceChild(jdba2, orig);
        } else {
            this.syscom.appendChild(jdba2);
        }
        FileWriter out = null;
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            out = new FileWriter(file);
            tf.transform(new DOMSource(doc), new StreamResult(out));
            out.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    class HistoryCollection {
        HashMap<String, HashMap<String, History>> history = new HashMap();

        HistoryCollection() {
        }

        void add(String key0, String key1, boolean save_history, int num_history_cmd, ArrayList<String> data) {
            HashMap<String, History> col0 = this.history.get(key0);
            if (col0 == null) {
                col0 = new HashMap();
                this.history.put(key0, col0);
            }
            col0.put(key1, new History(save_history, num_history_cmd, data));
        }

        void replace(String key0, String key1, boolean save_history, int num_history_cmd, ArrayList<String> data) {
            HashMap<String, History> col0 = this.history.get(key0);
            if (col0 == null) {
                col0 = new HashMap();
                this.history.put(key0, col0);
            }
            col0.remove(key1);
            col0.put(key1, new History(save_history, num_history_cmd, data));
        }

        History getHistory(String key0, String key1) {
            HashMap<String, History> col0 = this.history.get(key0);
            if (col0 == null) {
                return null;
            }
            History col1 = col0.get(key1);
            if (col1 == null) {
                return null;
            }
            return col1;
        }

        void remove(String key0, String key1) {
            HashMap<String, History> col0 = this.history.get(key0);
            if (col0 != null) {
                col0.remove(key1);
            }
        }
    }

    class History {
        int num_history_cmd = 50;
        boolean save_history = false;
        ArrayList<String> command = null;

        History(boolean save_history, int num_history_cmd, ArrayList<String> command) {
            this.save_history = save_history;
            this.num_history_cmd = num_history_cmd;
            this.command = command;
        }
    }
}

