/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class AffinitySettingDlg
extends JDialog {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DbaButton okButton = new DbaButton(new Dimension(100, 24), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "okButtonActionPerformed"));
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private HelpButton helpButton = new HelpButton();
    private Frame frame = null;
    private String connectionID = null;
    private int cpunumbers = 1;
    private String affinityMask = null;
    private ArrayList<JCheckBox> cpuList = new ArrayList();

    public AffinitySettingDlg(Frame frame, String connectionID, int cpunumbers, String affinityMask) {
        super(frame, true);
        this.frame = frame;
        this.connectionID = connectionID;
        this.cpunumbers = cpunumbers;
        this.affinityMask = affinityMask;
        this.init();
        this.setPreferredSize(new Dimension(400, 200));
        this.pack();
        GuiUt.setCenterLocation(frame, this);
        this.setVisible(true);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.okButton.requestFocus();
        }
    }

    private void init() {
        this.setName("AffinitySettingDialog");
        this.okButton.setName("OKButton");
        this.cancelButton.setName("CancelButton");
        this.setTitle(this.res.getString("Affinity_Setting"));
        this.setDefaultCloseOperation(0);
        WindowAdapter closeListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AffinitySettingDlg.this.cancelButtonActionPerformed(null);
            }
        };
        this.addWindowListener(closeListener);
        DbFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "AffinitySettingDialog", null);
        JPanel contentPanel = new JPanel(new FlowLayout(0));
        contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), "", 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JCheckBox cpuCheckBox = null;
        for (int i = 0; i < this.cpunumbers; ++i) {
            cpuCheckBox = new JCheckBox("cpu" + i);
            cpuCheckBox.setName("CPU" + i);
            cpuCheckBox.setSelected(false);
            contentPanel.add(cpuCheckBox);
            this.cpuList.add(cpuCheckBox);
        }
        Container container = this.getContentPane();
        container.add(contentPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        container.add((Component)buttonPanel, "South");
        this.initAffinityMask();
    }

    private void initAffinityMask() {
        int maskLen;
        String mask = this.affinityMask;
        int len = maskLen = mask.length();
        JCheckBox cpuCheckBox = null;
        for (int i = 0; i < maskLen; ++i) {
            String flag = mask.substring(len - 1);
            mask = mask.substring(0, len - 1);
            --len;
            cpuCheckBox = this.cpuList.get(i);
            if (flag.equals("1")) {
                cpuCheckBox.setSelected(true);
                continue;
            }
            cpuCheckBox.setSelected(false);
        }
    }

    public void okButtonActionPerformed(ActionEvent e) {
        String mask = null;
        StringBuffer buf = new StringBuffer();
        for (int i = this.cpunumbers - 1; i >= 0; --i) {
            if (this.cpuList.get(i).isSelected()) {
                buf.append("1");
                continue;
            }
            buf.append("0");
        }
        mask = buf.toString();
        String sql = "call SETAFFINITY(" + this.connectionID + ", '" + mask + "')";
        boolean isOK = DatabaseConnection.executeSQL(DbFrame.frame, sql);
        if (isOK) {
            GuiUt.showSuccessDlg(this, this.res.getString("Set_CPU_affinity_successfully"), null);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

