/*********************************************************************
** SQLTYPES.H - This file defines the types used in ODBC
**
** (C) Copyright 1995-1996 By Microsoft Corp.
**
**    Created 04/10/95 for 2.50 specification
**    Updated 12/11/95 for 3.00 specification
**
** #001  06/03/99 versace - FreeBSD porting
** #002  06/22/99 versace - FreeBSD porting
** #003  03/15/00 versace -  __FreeBSD__ is predefined by FREEBSD
** #004  03/26/01 clin - MR6059 expand DBMaker decimal to 39
** #005  10/25/01 clin - @6265 no need to expand. besides, the vb dbgrid
**                       still use "16" as the value length.
** #006  06/10/02 phu : @6558 support unicode
** #007  11/30/06 lucky - 64-bit ODBC support
*********************************************************************/

#ifndef __SQLTYPES
#define __SQLTYPES

#ifndef __FreeBSD__           /* #003 */
#include <wchar.h>
#endif

#include <stdlib.h>           /* #002 */

/* if ODBCVER is not defined, assume version 3.00 */
#ifndef ODBCVER
#define ODBCVER 0x0300
#endif  /* ODBCVER */

#ifdef __cplusplus
extern "C" {      /* Assume C declarations for C++   */
#endif  /* __cplusplus */

/* environment specific definitions */
#ifndef EXPORT
#define EXPORT
#endif

#if defined(WIN32) || defined(_WIN64)
#define SQL_API  __stdcall
#else
#define SQL_API
#endif

#ifndef RC_INVOKED

/* API declaration data types */

typedef unsigned char   SQLCHAR;
typedef void *          SQLPOINTER;
typedef short           SQLSMALLINT;
typedef unsigned short  SQLUSMALLINT;

/***********************************************************
 * 64-bit ODBC Support #007
 * According to Microsoft, types SQLROWCOUNT, SQLROWSETSIZE,
 * SQLTRANSID, and SQLROWOFFSET are no longer used in 64-bit
 * ODBC. We still keep them for completeness. SQLROWSETSIZE
 * is defined as SQLUINTEGER for 64-bit as in unixODBC for
 * compatibility consideration.
 ***********************************************************/
#if   defined(_LP64)
typedef int             SQLINTEGER;
typedef unsigned int    SQLUINTEGER;
typedef long            SQLLEN;
typedef unsigned long   SQLULEN;
typedef unsigned long   SQLSETPOSIROW;
typedef SQLULEN         SQLROWCOUNT;
typedef SQLUINTEGER     SQLROWSETSIZE;
typedef SQLULEN         SQLTRANSID;
typedef SQLLEN          SQLROWOFFSET;
#elif defined(_WIN64)
typedef long            SQLINTEGER;
typedef unsigned long   SQLUINTEGER;
typedef __int64          SQLLEN;
typedef unsigned __int64 SQLULEN;
typedef unsigned __int64 SQLSETPOSIROW;
typedef SQLULEN         SQLROWCOUNT;
typedef SQLUINTEGER     SQLROWSETSIZE;
typedef SQLULEN         SQLTRANSID;
typedef SQLLEN          SQLROWOFFSET;
#else
typedef long            SQLINTEGER;
typedef unsigned long   SQLUINTEGER;
#define SQLLEN          SQLINTEGER
#define SQLULEN         SQLUINTEGER
#define SQLSETPOSIROW   SQLUSMALLINT
typedef SQLULEN         SQLROWCOUNT;
typedef SQLULEN         SQLROWSETSIZE;
typedef SQLULEN         SQLTRANSID;
typedef SQLLEN          SQLROWOFFSET;
#endif

#if (ODBCVER >= 0x0300)
typedef signed char     SQLSCHAR;
typedef unsigned char   SQLDATE;
typedef unsigned char   SQLDECIMAL;
typedef double          SQLDOUBLE;
typedef double          SQLFLOAT;
typedef unsigned char   SQLNUMERIC;
typedef float           SQLREAL;
typedef unsigned char   SQLTIME;
typedef unsigned char   SQLTIMESTAMP;
typedef unsigned char   SQLVARCHAR;
#endif

/* function return type */
typedef SQLSMALLINT     SQLRETURN;

/* generic data structures */
#if (ODBCVER >= 0x0300)
#if defined(WIN32) || defined(_WIN64)
typedef void*                   SQLHANDLE;
#else
typedef SQLPOINTER              SQLHANDLE; /* #006 use SQLPOINTER */
#endif  /* defined(WIN32) || defined(_WIN64) */
typedef SQLHANDLE               SQLHENV;
typedef SQLHANDLE               SQLHDBC;
typedef SQLHANDLE               SQLHSTMT;
typedef SQLHANDLE               SQLHDESC;
#else
typedef void*                   SQLHENV;
typedef void*                   SQLHDBC;
typedef void*                   SQLHSTMT;
#endif /* ODBCVER >= 0x0300 */

/* SQL portable types for C */
typedef unsigned char           UCHAR;
typedef signed char             SCHAR;
#ifdef _LP64 /* #007 */
typedef int                     SDWORD;
typedef unsigned int            UDWORD;
#else
typedef long                    SDWORD;
typedef unsigned long           UDWORD;
#endif
typedef short int               SWORD;
typedef unsigned short int      UWORD;

#ifdef _LP64 /* #007 */
typedef signed int              SLONG;
typedef unsigned int            ULONG;
#else
typedef signed long             SLONG;
typedef unsigned long           ULONG;
#endif
typedef signed short            SSHORT;
typedef unsigned short          USHORT;
typedef double                  SDOUBLE;
typedef double                  LDOUBLE;
typedef float                   SFLOAT;

typedef void*                 PTR;

typedef void*                 HENV;
typedef void*                 HDBC;
typedef void*                 HSTMT;

typedef signed short            RETCODE;

#if defined(WIN32) || defined(_WIN64) || defined(OS2)
typedef HWND                    SQLHWND;
#elif defined (UNIX)
typedef Widget                  SQLHWND;
#else
/* placehold for future O/S GUI window handle definition */
typedef SQLPOINTER              SQLHWND;
#endif

#ifndef __SQLDATE
#define __SQLDATE
/* transfer types for DATE, TIME, TIMESTAMP */
typedef struct tagDATE_STRUCT
{
        SQLSMALLINT    year;
        SQLUSMALLINT   month;
        SQLUSMALLINT   day;
} DATE_STRUCT;

#if (ODBCVER >= 0x0300)
typedef DATE_STRUCT SQL_DATE_STRUCT;
#endif  /* ODBCVER >= 0x0300 */

typedef struct tagTIME_STRUCT
{
        SQLUSMALLINT   hour;
        SQLUSMALLINT   minute;
        SQLUSMALLINT   second;
} TIME_STRUCT;

#if (ODBCVER >= 0x0300)
typedef TIME_STRUCT SQL_TIME_STRUCT;
#endif /* ODBCVER >= 0x0300 */

typedef struct tagTIMESTAMP_STRUCT
{
        SQLSMALLINT    year;
        SQLUSMALLINT   month;
        SQLUSMALLINT   day;
        SQLUSMALLINT   hour;
        SQLUSMALLINT   minute;
        SQLUSMALLINT   second;
        SQLUINTEGER    fraction;
} TIMESTAMP_STRUCT;

#if (ODBCVER >= 0x0300)
typedef TIMESTAMP_STRUCT  SQL_TIMESTAMP_STRUCT;
#endif  /* ODBCVER >= 0x0300 */


/*
 * enumerations for DATETIME_INTERVAL_SUBCODE values for interval data types
 * these values are from SQL-92
 */

#if (ODBCVER >= 0x0300)
typedef enum
{
  SQL_IS_YEAR           = 1,
  SQL_IS_MONTH          = 2,
  SQL_IS_DAY            = 3,
  SQL_IS_HOUR           = 4,
  SQL_IS_MINUTE         = 5,
  SQL_IS_SECOND         = 6,
  SQL_IS_YEAR_TO_MONTH      = 7,
  SQL_IS_DAY_TO_HOUR        = 8,
  SQL_IS_DAY_TO_MINUTE      = 9,
  SQL_IS_DAY_TO_SECOND      = 10,
  SQL_IS_HOUR_TO_MINUTE     = 11,
  SQL_IS_HOUR_TO_SECOND     = 12,
  SQL_IS_MINUTE_TO_SECOND   = 13
} SQLINTERVAL;

#endif  /* ODBCVER >= 0x0300 */

#if (ODBCVER >= 0x0300)
typedef struct tagSQL_YEAR_MONTH
{
    SQLUINTEGER   year;
    SQLUINTEGER   month;
} SQL_YEAR_MONTH_STRUCT;

typedef struct tagSQL_DAY_SECOND
{
    SQLUINTEGER   day;
    SQLUINTEGER   hour;
    SQLUINTEGER   minute;
    SQLUINTEGER   second;
    SQLUINTEGER   fraction;
} SQL_DAY_SECOND_STRUCT;

typedef struct tagSQL_INTERVAL_STRUCT
{
  SQLINTERVAL   interval_type;
  SQLSMALLINT   interval_sign;
  union {
    SQL_YEAR_MONTH_STRUCT   year_month;
    SQL_DAY_SECOND_STRUCT   day_second;
  } intval;

} SQL_INTERVAL_STRUCT;

#endif  /* ODBCVER >= 0x0300 */

#endif  /* __SQLDATE  */

/* the ODBC C types for SQL_C_SBIGINT and SQL_C_UBIGINT */
#if (ODBCVER >= 0x0300)
#if defined(WIN32) || defined(_WIN64) /* #007 */
#define ODBCINT64 __int64
#elif defined(_LP64)
#define ODBCINT64 long
#else
#define ODBCINT64 long long
#endif /* WIN32 _WIN64 _LP64 */
typedef ODBCINT64           SQLBIGINT;
typedef unsigned ODBCINT64  SQLUBIGINT;
#endif  /* ODBCVER >= 0x0300 */

/* internal representation of numeric data type */
#if (ODBCVER >= 0x0300)
/* 005: note: for decimal of up to 38 precision, there is still no need to */
/*      expand this number */
#define SQL_MAX_NUMERIC_LEN   16           /* #004 #005 */
typedef struct tagSQL_NUMERIC_STRUCT
{
  SQLCHAR   precision;
  SQLSCHAR  scale;
  SQLCHAR   sign; /* 1 if positive, 0 if negative */
  SQLCHAR   val[SQL_MAX_NUMERIC_LEN];
} SQL_NUMERIC_STRUCT;
#endif  /* ODBCVER >= 0x0300 */

typedef SQLULEN        BOOKMARK;      /* #007 */

#if defined(WIN32) || defined(_WIN64) /* #006 */
typedef wchar_t SQLWCHAR;
#else
typedef unsigned short SQLWCHAR;
#endif

#ifdef UNICODE
typedef SQLWCHAR        SQLTCHAR;
#else
typedef SQLCHAR         SQLTCHAR;
#endif  /* UNICODE */

#endif     /* RC_INVOKED */

#ifdef __cplusplus
}                                    /* End of extern "C" { */
#endif  /* __cplusplus */

#endif /* #ifndef __SQLTYPES */
