#ifndef _LIBUDF_H_
#define _LIBUDF_H_

/****************************************************************************
 * (C) Copyright SYSCOM COMPUTER ENGINEERING CO. 2006.
 *
 * this header is used for user to create external udf only
 * #001 2004/01/06  jonas   : support large file
 * #002 2004/04/23  jonas   : define DM_BBLARGE
 * #003 10/02/06 kaiven: MR7809, 16k page
 * #004 10/05/06 lucky: MR7823 64bit porting
 * #005 09/11/09 jim : MR8415 ,support big integer
 * #006 03/21/14 menny: MR9908 support big integer
 * #007 08/08/14 zheng: MR9947 define of BB_TEMP_FO, BB_TEMP_MEM and BBID
 ****************************************************************************/

#include <stdlib.h> 

typedef unsigned char      i8;              /* 1 byte unsigned */
typedef short              i15;             /* 2 byte signed   */
typedef unsigned short     i16;             /* 2 byte unsigned */
#ifndef _LP64
typedef long               i31;             /* 4 byte signed   */
typedef unsigned long      i32;             /* 4 byte unsigned */
#else
typedef int                i31;             /* 4 byte signed   */
typedef unsigned int       i32;             /* 4 byte unsigned */
#endif
#if defined(WIN32) || defined(_WIN64)
typedef __int64            i63;             /* 8 byte signed   */
typedef unsigned __int64   i64;             /* 8 byte unsigned */
#elif defined(_LP64)
typedef long               i63;             /* 8 byte signed   */
typedef unsigned long      i64;             /* 8 byte unsigned */
#else   /* _ILP32 unix */
typedef long long          i63;             /* 8 byte signed   */
typedef unsigned long long i64;             /* 8 byte unsigned */
#endif
typedef i31 CDLEN;
typedef i31 CD;

#ifndef BBID_SIZE  /* #007 */
#define  BBID_SIZE 48
#endif

#ifndef TRUE
#define  TRUE 1
#define  FALSE 0
#endif

#ifdef DB_PCWIN  /* #007 */
typedef unsigned char      boolean;	
#else
typedef char               boolean;
#endif

#ifndef  BB_TEMP_MEM  /* #007 */
#define BB_TEMP_FO  0x0001           /* create temp BLOB in file     */
#define BB_TEMP_MEM 0x0002           /* create temp BLOB in memory   */
#endif

typedef struct
{
    i8 pre;
    i8 sca;
    i8 dgt[20]; 
    i8 exp; 
	i8 junk;    
} dec_t10;

typedef dec_t10   dec_t;

typedef struct tVAL {
   CD    type;                   /* data type          */
   CDLEN len;                    /* data length        */
   union {
      i31    ival;             /* long integer data  */
      i15    sival;            /* short integer data */
      i63    i63val;           /* big integer data #006 */
      double fval;             /* double data        */
      float  sfval;            /* float data         */
      dec_t  dval;             /* decimal data       */
      char   *xval;            /* pointer to data    */
   } u;
} VAL;

#define BBOBJ_SIZE 48

typedef struct tBBObj {
  char s[BBOBJ_SIZE];
} BBObj;

/****************************************************************************
 * column types   #003  must as same as udf.h
****************************************************************************/
#define BIN_TYP   0x00000000                   /* bit string     data type*/
#define CHAR_TYP  0x01000000                   /* character      data type*/
#define INT_TYP   0x02000000                   /* integer        data type*/
#define FLT_TYP   0x03000000                   /* floating point data type*/
#define OID_TYP   0x04000000                   /* OID            data type*/
#define BLOB_TYP  0x05000000                   /* blob           data type*/
#define DEC_TYP   0x06000000                   /* decimal        data type*/
#define NCHAR_TYP 0x09000000                   /* national char  data type*/
#define BINT_TYP  0x0A000000                   /* biginteger     data type*/ /* #005 */
#define NULL_TYP  0x7F000000                   /* set if column is null   */

/****************************************************************************
 *  seek option 
 ***************************************************************************/
#define SEEK_BB_BEG   0x01
#define SEEK_BB_CUR   0x02
#define SEEK_BB_END   0x04

/****************************************************************************
 * function prototypes
****************************************************************************/
int _UDFAllocMem(VAL *Arg, char **ppt, int nb);
int _RetVal(VAL *Arg, VAL rtn);
int _UDFBbOpen(VAL *Arg, BBObj bbObj, i31 *pHandle);
int _UDFBbRead(VAL *Arg, i31 handle, i31 szBuf, i31 *szRead, char *pBuf);
int _UDFBbSeek(VAL *Arg, i31 handle, i63 offset, i16 ptrname);
int _UDFBbClose(VAL *Arg, i31 handle);
int _UDFBbCreate(VAL *Arg, BBObj *pBbObj, i31 *pHandle, i31 Opt);
int _UDFBbWrite(VAL *Arg, i31 handle, i31 szBuf, char *pBuf);
int _UDFBbCurOffset(VAL *Arg, i31 handle, i31 *pOffset);
int _UDFBbCurOffsetEx(VAL *Arg, i31 handle, i63 *pOffset);
int _UDFBbSize(VAL *Arg, BBObj bbObj, i31 *pLen);
int _UDFBbSizeEx(VAL *Arg, BBObj bbObj, i63 *pLen);
int _UDFBbDrop(VAL *Arg, BBObj bbObj);

#endif /* _LIBUDF_H */
