/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.xml;

import dbmaster.sql.JdbcOdbcConnection;
import dbmaster.xml.XtmErrorListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XTM {
    private String error = null;
    private int rc = 0;
    private Vector parameters = new Vector();
    public static int ERR_XTM_PROCESS = 5642;
    private static SortedMap map = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int spRun(long l, String string, String string2, byte[] byArray, String string3) {
        Object object;
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        System.setProperty("DM_DRIVER_MODE", "SERVER_ODBC");
        XTM xTM = new XTM();
        String string4 = null;
        int n = 0;
        try {
            object = new JdbcOdbcConnection(l);
            xTM.setConnection((Connection)object);
            n = xTM.run(string, string2);
            if (n != 0) {
                string4 = xTM.getError();
            }
            object.close();
        }
        catch (Exception exception) {
            string4 = exception.getMessage();
            n = ERR_XTM_PROCESS;
        }
        if (n == 0) return n;
        if (string4 == null) return n;
        object = null;
        try {
            try {
                object = string4.getBytes((String)map.get(string3));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = string4.getBytes();
                Object var12_11 = null;
                int n4 = ((JdbcOdbcConnection)object).length < byArray.length ? ((JdbcOdbcConnection)object).length : byArray.length;
                System.arraycopy(object, 0, byArray, 0, n4);
                return n;
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            int n2 = ((JdbcOdbcConnection)object).length < byArray.length ? ((JdbcOdbcConnection)object).length : byArray.length;
            System.arraycopy(object, 0, byArray, 0, n2);
            throw throwable;
        }
        int n3 = ((JdbcOdbcConnection)object).length < byArray.length ? ((JdbcOdbcConnection)object).length : byArray.length;
        System.arraycopy(object, 0, byArray, 0, n3);
        return n;
    }

    public void setParameter(String string, Object object) {
        this.parameters.add(new Parameter(string, object));
    }

    public void setConnection(Connection connection) {
        Enumeration enumeration = this.parameters.elements();
        Parameter parameter = null;
        while (enumeration.hasMoreElements()) {
            parameter = (Parameter)enumeration.nextElement();
            if (parameter.key.compareTo("connection") != 0) continue;
            this.parameters.remove(parameter);
            break;
        }
        if (connection != null) {
            this.setParameter("connection", connection);
        }
    }

    public int setConnection(int n) {
        try {
            JdbcOdbcConnection jdbcOdbcConnection = new JdbcOdbcConnection((long)n);
            this.parameters.add(new Parameter("connection", jdbcOdbcConnection));
            return 0;
        }
        catch (Exception exception) {
            this.error = "fail to construct dbmaster.sql.JdbcOdbcConnection with HDBC";
            return ERR_XTM_PROCESS;
        }
    }

    public void setUser(String string) {
        this.parameters.add(new Parameter("user", string));
    }

    public void setPassword(String string) {
        this.parameters.add(new Parameter("password", string));
    }

    public String getError() {
        return this.error;
    }

    public int run(String string, String string2) {
        this.error = null;
        File file = new File(string);
        if (!file.exists()) {
            this.error = string + " is not existing.";
            return ERR_XTM_PROCESS;
        }
        file = new File(string2);
        if (!file.exists()) {
            this.error = string2 + " is not existing.";
            return ERR_XTM_PROCESS;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new File(string)));
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            Enumeration enumeration = this.parameters.elements();
            Parameter parameter = null;
            while (enumeration.hasMoreElements()) {
                parameter = (Parameter)enumeration.nextElement();
                transformer.setParameter(parameter.key, parameter.value);
            }
            transformer.setErrorListener((ErrorListener)((Object)new XtmErrorListener()));
            transformer.transform(new StreamSource(new File(string2)), new StreamResult(byteArrayOutputStream));
            transformer.clearParameters();
            this.parameters.clear();
            return 0;
        }
        catch (TransformerException transformerException) {
            int n = this.getDetailError(transformerException);
            return n;
        }
    }

    private int getDetailError(Throwable throwable) {
        int n = ERR_XTM_PROCESS;
        if (throwable == null) {
            return n;
        }
        Throwable throwable2 = null;
        if (throwable instanceof TransformerException) {
            throwable2 = ((TransformerException)throwable).getCause();
            this.error = throwable.getMessage();
        } else if (throwable instanceof InvocationTargetException) {
            throwable2 = ((InvocationTargetException)throwable).getTargetException();
        } else if (throwable instanceof SQLException) {
            int n2 = ((SQLException)throwable).getErrorCode();
            if (n2 != 0) {
                n = n2;
            }
        } else {
            this.error = throwable.getMessage();
        }
        if (throwable2 != null) {
            return this.getDetailError(throwable2);
        }
        return n;
    }

    static {
        map.put("DBMASTER", "US-ASCII");
        map.put("DBMASTER", "Shift_JIS");
    }

    private class Parameter {
        String key = null;
        Object value = null;

        Parameter(String string, Object object) {
            this.key = string;
            this.value = object;
        }
    }
}

