/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.xml;

import com.syscom.ut.ClassPathHacker;
import com.syscom.ut.TextUt;
import dbaut.dbalib;
import dbmaster.xml.FileClassLoader;
import dbmaster.xml.Preferences;
import dbmaster.xml.XtmPreparedStatement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLTransferMap {
    private ResourceBundle res = null;
    private Stack stmt_stack = new Stack();
    private Hashtable stmt_hash = new Hashtable(11);
    private Connection connection = null;
    boolean isDefaultConnection = false;
    private int xtmConnectCount = 0;

    public XMLTransferMap() {
        dbalib dbalib2 = new dbalib();
        byte[] byArray = new byte[1024];
        String string = "dmxtm";
        int n = dbalib2.utErrTable(byArray, string.getBytes());
        String string2 = new String(byArray).trim();
        String string3 = string2.substring(0, string2.length() - string.length());
        FileClassLoader fileClassLoader = new FileClassLoader(string3);
        this.res = ResourceBundle.getBundle("dmxtm", Locale.getDefault(), fileClassLoader);
    }

    private void addStmt(String string, XtmPreparedStatement xtmPreparedStatement) {
        this.stmt_stack.push(xtmPreparedStatement);
        if (string != null && string.length() > 0) {
            this.stmt_hash.put(string, xtmPreparedStatement);
        }
    }

    private XtmPreparedStatement getStmt(String string) throws Exception {
        XtmPreparedStatement xtmPreparedStatement = null;
        if (this.stmt_stack.size() > 0) {
            xtmPreparedStatement = string != null && string.length() > 0 ? (XtmPreparedStatement)this.stmt_hash.get(string) : (XtmPreparedStatement)this.stmt_stack.peek();
        }
        if (xtmPreparedStatement == null) {
            throw new TransformerException(this.res.getString("no_proper_xtm_preparedStatement"));
        }
        return xtmPreparedStatement;
    }

    private XtmPreparedStatement removeLastStmt() {
        XtmPreparedStatement xtmPreparedStatement = (XtmPreparedStatement)this.stmt_stack.pop();
        String string = xtmPreparedStatement.getName();
        if (string != null && string.length() > 0) {
            this.stmt_hash.remove(string);
        }
        return xtmPreparedStatement;
    }

    public static void loadDriver(String string) throws Exception {
        block4: {
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2 = Preferences.getDriverPath(string);
                if (string2 == null || string2.length() <= 0) break block4;
                ClassPathHacker.addFile(string2);
                Class.forName(string);
            }
        }
    }

    public void connect(XSLProcessorContext xSLProcessorContext, ElemExtensionCall elemExtensionCall) throws TransformerException {
        if (this.xtmConnectCount > 0) {
            throw new TransformerException(this.res.getString("more_than_one_xtm_connect"));
        }
        ++this.xtmConnectCount;
        try {
            String string;
            this.connection = (Connection)xSLProcessorContext.getTransformer().getParameter("connection");
            if (this.connection != null) {
                this.isDefaultConnection = true;
            } else {
                string = elemExtensionCall.getAttribute("driver");
                String string2 = elemExtensionCall.getAttribute("datasource");
                String string3 = (String)xSLProcessorContext.getTransformer().getParameter("user");
                String string4 = (String)xSLProcessorContext.getTransformer().getParameter("password");
                String string5 = elemExtensionCall.getAttribute("autocommit");
                if (string3 == null) {
                    string3 = elemExtensionCall.getAttribute("user");
                }
                if (string4 == null) {
                    string4 = elemExtensionCall.getAttribute("password");
                }
                XMLTransferMap.loadDriver(string);
                this.connection = DriverManager.getConnection(string2, string3, string4);
                if (string5 != null && string5.equals("on")) {
                    this.connection.setAutoCommit(true);
                } else {
                    this.connection.setAutoCommit(false);
                }
            }
            string = xSLProcessorContext.getTransformer();
            string.executeChildTemplates((ElemTemplateElement)elemExtensionCall, true);
            if (!this.isDefaultConnection) {
                this.connection.commit();
            }
            this.connection.setAutoCommit(true);
            if (!this.isDefaultConnection) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (TransformerException transformerException) {
            throw transformerException;
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
    }

    private String getPrefix(Node node) {
        String string = node.getNodeName();
        String string2 = node.getLocalName();
        int n = string.length() - string2.length() - 1;
        return n > 0 ? string.substring(0, n) : "";
    }

    public void table(XSLProcessorContext xSLProcessorContext, ElemExtensionCall elemExtensionCall) throws TransformerException {
        int n;
        String string = elemExtensionCall.getAttribute("owner");
        String string2 = elemExtensionCall.getAttribute("name");
        String string3 = elemExtensionCall.getAttribute("select");
        String string4 = this.getPrefix((Node)elemExtensionCall);
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        if (string != null && string.length() > 0) {
            stringBuffer.append(TextUt.getIDString(string) + "." + TextUt.getIDString(string2));
        } else {
            stringBuffer.append(TextUt.getIDString(string2));
        }
        String string5 = null;
        Node node = null;
        NodeList nodeList = elemExtensionCall.getChildNodes();
        int n2 = 0;
        int n3 = nodeList.getLength();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = 0; n < n3; ++n) {
            node = nodeList.item(n);
            if (node.getNodeType() != 1 || this.getPrefix(node).compareTo(string4) != 0 || node.getLocalName().compareTo("column") != 0 || (string5 = ((Element)node).getAttribute("name")) == null || string5.length() <= 0) continue;
            if (n2 == 0) {
                stringBuffer2.append(TextUt.getIDString(string5));
            } else {
                stringBuffer2.append("," + TextUt.getIDString(string5));
            }
            ++n2;
        }
        if (stringBuffer2.length() == 0) {
            stringBuffer.append(" values ()");
        } else {
            stringBuffer.append("(" + stringBuffer2.toString() + " ) values (?");
            for (n = 1; n < n2; ++n) {
                stringBuffer.append(",?");
            }
            stringBuffer.append(")");
        }
        this.processStatement(xSLProcessorContext, elemExtensionCall, null, stringBuffer.toString(), string3);
    }

    public void column(XSLProcessorContext xSLProcessorContext, ElemExtensionCall elemExtensionCall) throws TransformerException {
        if (elemExtensionCall.getFirstChildElem() != null) {
            throw new TransformerException("<xtm:column> shouldn't have any sub element.");
        }
        Node node = elemExtensionCall.getParentNode();
        if (node.getNodeType() != 1 || node.getLocalName().compareTo("table") != 0) {
            throw new TransformerException("<xtm:column> must be under <xtm:table> element.");
        }
        this.setParameter(xSLProcessorContext, elemExtensionCall);
    }

    public void preparedStatement(XSLProcessorContext xSLProcessorContext, ElemExtensionCall elemExtensionCall) throws TransformerException {
        String string = elemExtensionCall.getAttribute("command");
        String string2 = elemExtensionCall.getAttribute("name");
        String string3 = elemExtensionCall.getAttribute("select");
        this.processStatement(xSLProcessorContext, elemExtensionCall, string2, string, string3);
    }

    private void processStatement(XSLProcessorContext xSLProcessorContext, ElemExtensionCall elemExtensionCall, String string, String string2, String string3) throws TransformerException {
        Statement statement = null;
        try {
            if (this.connection == null) {
                this.connection = (Connection)xSLProcessorContext.getTransformer().getParameter("connection");
                if (this.connection == null) {
                    throw new TransformerException(this.res.getString("no_valid_jdbc_connection"));
                }
                this.isDefaultConnection = true;
            }
            statement = this.connection.prepareStatement(string2);
            XtmPreparedStatement xtmPreparedStatement = new XtmPreparedStatement(string, (PreparedStatement)statement);
            this.addStmt(string, xtmPreparedStatement);
            if (string3 != null) {
                XPathContext xPathContext = xSLProcessorContext.getTransformer().getXPathContext();
                XPath xPath = new XPath(string3, (SourceLocator)elemExtensionCall, xPathContext.getNamespaceContext(), 0);
                XObject xObject = xPath.execute(xPathContext, xSLProcessorContext.getContextNode(), (PrefixResolver)elemExtensionCall);
                if (xObject instanceof XNodeSet) {
                    XNodeSet xNodeSet = (XNodeSet)xObject;
                    NodeList nodeList = xNodeSet.nodelist();
                    int n = nodeList.getLength();
                    TransformerImpl transformerImpl = xSLProcessorContext.getTransformer();
                    for (int i = 0; i < n; ++i) {
                        transformerImpl.executeChildTemplates((ElemTemplateElement)elemExtensionCall, nodeList.item(i), null, transformerImpl.getContentHandler());
                        this.executeUpdate(xSLProcessorContext, elemExtensionCall);
                    }
                }
            } else {
                TransformerImpl transformerImpl = xSLProcessorContext.getTransformer();
                transformerImpl.executeChildTemplates((ElemTemplateElement)elemExtensionCall, true);
            }
            xtmPreparedStatement = this.removeLastStmt();
            statement.close();
            if (!this.isDefaultConnection) {
                this.connection.commit();
            }
        }
        catch (Exception exception) {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (this.connection != null && !this.isDefaultConnection) {
                    this.connection.commit();
                    this.connection.setAutoCommit(true);
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException.getMessage());
                sQLException.printStackTrace();
            }
            if (exception instanceof TransformerException) {
                throw (TransformerException)exception;
            }
            throw new TransformerException(exception);
        }
    }

    public void setParameter(XSLProcessorContext xSLProcessorContext, ElemExtensionCall elemExtensionCall) throws TransformerException {
        try {
            String string = null;
            String string2 = elemExtensionCall.getAttribute("select");
            String string3 = elemExtensionCall.getAttribute("statement");
            XtmPreparedStatement xtmPreparedStatement = this.getStmt(string3);
            PreparedStatement preparedStatement = xtmPreparedStatement.getStatement();
            int n = xtmPreparedStatement.getNextParamIndex();
            if (string2 != null) {
                XPathContext xPathContext = xSLProcessorContext.getTransformer().getXPathContext();
                XPath xPath = new XPath(string2, (SourceLocator)elemExtensionCall, xPathContext.getNamespaceContext(), 0);
                XObject xObject = xPath.execute(xPathContext, xSLProcessorContext.getContextNode(), (PrefixResolver)elemExtensionCall);
                string = xObject.str();
                if (xObject.getType() == 2 && string.compareTo("NaN") == 0) {
                    string = null;
                }
            }
            if (string == null) {
                preparedStatement.setNull(n, 1);
            } else {
                preparedStatement.setString(n, string);
            }
        }
        catch (TransformerException transformerException) {
            throw transformerException;
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
    }

    public void executeUpdate(XSLProcessorContext xSLProcessorContext, ElemExtensionCall elemExtensionCall) throws TransformerException {
        try {
            String string = elemExtensionCall.getAttribute("statement");
            XtmPreparedStatement xtmPreparedStatement = this.getStmt(string);
            xtmPreparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
    }

    public void commit(XSLProcessorContext xSLProcessorContext, ElemExtensionCall elemExtensionCall) throws TransformerException {
        try {
            if (this.connection == null) {
                this.connection = (Connection)xSLProcessorContext.getTransformer().getParameter("connection");
                if (this.connection == null) {
                    throw new TransformerException(this.res.getString("no_valid_jdbc_connection"));
                }
            }
            this.connection.commit();
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
    }

    public static String copyOf(ExpressionContext expressionContext, NodeList nodeList) throws TransformerException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DefaultSAXOutputHandler defaultSAXOutputHandler = new DefaultSAXOutputHandler(byteArrayOutputStream, "UTF-8");
            defaultSAXOutputHandler.omitHeader(true);
            TreeWalker treeWalker = new TreeWalker((ContentHandler)defaultSAXOutputHandler);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                treeWalker.traverse(nodeList.item(i));
            }
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }
}

