/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.undo;

import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.xtm.node.AbstractXtmMutableTreeNode;
import com.syscom.xml.xtm.treetable.XtmTreeTable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;

public class UpdateNodeEdit
extends CompoundEdit {
    static ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.undo.resource.Res", LocaleManager.getLocale());
    private AbstractXtmMutableTreeNode target = null;
    private Object previous = null;
    private Object current = null;
    private String name = null;
    private boolean changeFocus = false;
    private XtmTreeTable treeTable = null;

    public UpdateNodeEdit(XtmTreeTable treeTable, AbstractXtmMutableTreeNode target, Object previous, Object current, String name, boolean changeFocus) {
        this.treeTable = treeTable;
        this.target = target;
        this.previous = previous;
        this.current = current;
        this.name = name;
        this.changeFocus = changeFocus;
    }

    private String getMethodName() {
        String str = "set" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        return str;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.setValue(this.previous);
        this.treeTable.nodeChanged(this.target);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.setValue(this.current);
        this.treeTable.nodeChanged(this.target);
    }

    private void setValue(Object data) {
        try {
            Class<?> cls = this.target.getClass();
            Class[] classes = new Class[]{data.getClass()};
            Method m = cls.getMethod(this.getMethodName(), classes);
            Object[] objs = new Object[]{data};
            m.invoke((Object)this.target, objs);
        }
        catch (InvocationTargetException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        if (this.changeFocus) {
            this.treeTable.setSelectionNode(this.target);
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return res.getString("property_update");
    }

    @Override
    public boolean isSignificant() {
        return true;
    }
}

