/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.treetable;

import com.syscom.tree.AbstractDmTransferableTreeNode;
import com.syscom.tree.MultipleTransferableItems;
import com.syscom.tree.TransferableUpdateListener;
import com.syscom.treetable.JTreeTable;
import com.syscom.treetable.TreeTableModelAdapter;
import com.syscom.xml.xtm.gui.XTMFrame;
import com.syscom.xml.xtm.node.AbstractXtmMutableTreeNode;
import com.syscom.xml.xtm.treetable.XPathTextField;
import com.syscom.xml.xtm.treetable.XtmTreeTableModel;
import com.syscom.xml.xtm.undo.DropEdit;
import com.syscom.xml.xtm.undo.RemoveNodeEdit;
import com.syscom.xml.xtm.undo.UpdateNodeEdit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;

public class XtmTreeTable
extends JTreeTable
implements Autoscroll,
TransferableUpdateListener {
    private DropTarget dropTarget;
    private DropTargetListener dtListener;
    private XtmTreeTable myself = null;
    private XtmTreeTableModel treeTableModel = null;
    private Transferable transferable = null;
    static int autoscrollMargin = 20;
    Insets autoscrollInsets = new Insets(0, 0, 0, 0);

    public XtmTreeTable(XtmTreeTableModel treeTableModel) {
        super(treeTableModel);
        this.treeTableModel = treeTableModel;
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(0);
        this.myself = this;
        this.dtListener = new DTListener();
        this.dropTarget = new DropTarget(this, 3, this.dtListener, true);
        ((DefaultTreeModel)this.tree.getModel()).addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                XTMFrame.frame.getXtmInfo().setDirty(true);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                XTMFrame.frame.getXtmInfo().setDirty(true);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                XTMFrame.frame.getXtmInfo().setDirty(true);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getModifiers() == 4) {
                    int row = XtmTreeTable.this.rowAtPoint(e.getPoint());
                    int col = XtmTreeTable.this.columnAtPoint(e.getPoint());
                    AbstractXtmMutableTreeNode node = (AbstractXtmMutableTreeNode)XtmTreeTable.this.tree.getLastSelectedPathComponent();
                    node.showPopup(e);
                }
            }
        });
        this.getColumnModel().getColumn(1).setCellEditor(new XPathCellEditor(new XPathTextField()));
        this.tree.setToolTipText(null);
        this.setToolTipText(" ");
    }

    public void nodeChanged(TreeNode node) {
        this.treeTableModel.nodeChanged(node);
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int row = this.rowAtPoint(evt.getPoint());
        int col = this.columnAtPoint(evt.getPoint());
        return this.getValueAt(row, col).toString();
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        String orig = (String)this.getValueAt(row, col);
        if (col == 1 && orig.compareTo((String)obj) == 0) {
            return;
        }
        TreeTableModelAdapter model = (TreeTableModelAdapter)super.getModel();
        AbstractXtmMutableTreeNode target = (AbstractXtmMutableTreeNode)model.nodeForRow(row);
        XTMFrame.frame.getXtmInfo().setDirty(true);
        super.setValueAt(obj, row, col);
        UpdateNodeEdit edit = new UpdateNodeEdit(this, target, orig, obj, "XPath", true);
        edit.end();
        this.postEdit(edit);
        XTMFrame.frame.setActionStatus();
    }

    public void insertNodeInto(DefaultMutableTreeNode child, DefaultMutableTreeNode parent, int index, boolean changeFocus) {
        ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(child, parent, index);
        if (changeFocus) {
            TreePath path = new TreePath(child.getPath());
            this.tree.expandPath(path);
            this.setSelectionPath(path);
        }
        this.revalidate();
        this.repaint();
    }

    public AbstractXtmMutableTreeNode getLastSelectedPathComponent() {
        return (AbstractXtmMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    public void removeSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)child.getParent();
        int pos = parent.getIndex(child);
        this.removeNodeFromParent(child, true);
        this.postEdit(new RemoveNodeEdit(this, parent, child, pos, true));
    }

    public void removeNodeFromParent(DefaultMutableTreeNode node, boolean changeFocus) {
        DefaultMutableTreeNode next = null;
        if (changeFocus) {
            next = node.getNextSibling();
            if (next == null) {
                next = node.getPreviousSibling();
            }
            if (next == null) {
                next = (DefaultMutableTreeNode)node.getParent();
            }
        }
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
        this.revalidate();
        this.repaint();
        if (next != null) {
            this.setSelectionNode(next);
        }
    }

    public void setSelectionPath(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    public void setSelectionNode(DefaultMutableTreeNode node) {
        this.setSelectionPath(new TreePath(node.getPath()));
    }

    private void postEdit(UndoableEdit edit) {
        XTMFrame.frame.postEdit(edit);
    }

    @Override
    public void autoscroll(Point location) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        Dimension size = this.getSize();
        Rectangle rect = this.getVisibleRect();
        int bottomEdge = rect.y + rect.height;
        int rightEdge = rect.x + rect.width;
        if (location.y - rect.y <= autoscrollMargin && rect.y > 0) {
            top = autoscrollMargin;
        }
        if (location.x - rect.x <= autoscrollMargin && rect.x > 0) {
            left = autoscrollMargin;
        }
        if (bottomEdge - location.y <= autoscrollMargin && bottomEdge < size.height) {
            bottom = autoscrollMargin;
        }
        if (rightEdge - location.x <= autoscrollMargin && rightEdge < size.width) {
            right = autoscrollMargin;
        }
        rect.x += right - left;
        rect.y += bottom - top;
        this.scrollRectToVisible(rect);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Dimension size = this.getSize();
        Rectangle rect = this.getVisibleRect();
        this.autoscrollInsets.top = rect.y + autoscrollMargin;
        this.autoscrollInsets.left = rect.x + autoscrollMargin;
        this.autoscrollInsets.bottom = size.height - (rect.y + rect.height) + autoscrollMargin;
        this.autoscrollInsets.right = size.width - (rect.x + rect.width) + autoscrollMargin;
        return this.autoscrollInsets;
    }

    @Override
    public void setTransferable(Transferable transferable) {
        this.transferable = transferable;
    }

    @Override
    public Transferable getTransferable() {
        return this.transferable;
    }

    class XtmTableFocusListener
    extends FocusAdapter {
        XtmTableFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            try {
                super.focusLost(e);
                if (XtmTreeTable.this.isEditing()) {
                    Component cmp = XtmTreeTable.this.getComponent(1);
                    if (cmp instanceof JTextField) {
                        ((JTextField)cmp).getDocument().addUndoableEditListener(XTMFrame.frame.getUndoableEditListener());
                        XTMFrame.frame.startDocumentEdit();
                    }
                    cmp.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusLost(FocusEvent e) {
                            try {
                                XtmTreeTable.this.getCellEditor().stopCellEditing();
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    XtmTreeTable.this.editingStopped(null);
                }
                XtmTreeTable.this.revalidate();
                XtmTreeTable.this.repaint();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class XPathCellEditor
    extends DefaultCellEditor {
        XPathCellEditor(JTextField textField) {
            super(textField);
            textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        XtmTreeTable.this.getCellEditor().stopCellEditing();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component cmp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (cmp instanceof JTextField) {
                ((JTextField)this.getComponent()).getDocument().addUndoableEditListener(XTMFrame.frame.getUndoableEditListener());
                XTMFrame.frame.startDocumentEdit();
                final JTextField textField = (JTextField)cmp;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textField.grabFocus();
                    }
                });
            }
            return cmp;
        }

        @Override
        public boolean stopCellEditing() {
            ((JTextField)this.getComponent()).getDocument().removeUndoableEditListener(XTMFrame.frame.getUndoableEditListener());
            XTMFrame.frame.endDocumentEdit();
            return super.stopCellEditing();
        }
    }

    class DTListener
    implements DropTargetListener {
        DTListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            int current = XtmTreeTable.this.getSelectedRow();
            int row = XtmTreeTable.this.rowAtPoint(e.getLocation());
            if (row >= 0 && row < XtmTreeTable.this.getRowCount() && row != current) {
                XtmTreeTable.this.tree.setSelectionInterval(row, row);
            }
            boolean acceptable = true;
            if (XtmTreeTable.this.transferable != null) {
                MultipleTransferableItems items = (MultipleTransferableItems)XtmTreeTable.this.transferable;
                AbstractXtmMutableTreeNode node = (AbstractXtmMutableTreeNode)XtmTreeTable.this.tree.getLastSelectedPathComponent();
                AbstractDmTransferableTreeNode tr = null;
                int size = items.size();
                for (int i = 0; i < size; ++i) {
                    tr = (AbstractDmTransferableTreeNode)items.elementAt(i);
                    if (node.isAcceptable(tr)) continue;
                    acceptable = false;
                    break;
                }
            }
            if (acceptable) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
            XtmTreeTable.this.invalidate();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            e.acceptDrop(2);
            try {
                MultipleTransferableItems items = (MultipleTransferableItems)e.getTransferable().getTransferData(AbstractDmTransferableTreeNode.TREE_NODE_FLAVOR);
                if (!items.isDataFlavorSupported(AbstractDmTransferableTreeNode.TREE_NODE_FLAVOR)) {
                    e.rejectDrop();
                    return;
                }
                AbstractXtmMutableTreeNode node = (AbstractXtmMutableTreeNode)XtmTreeTable.this.tree.getLastSelectedPathComponent();
                AbstractDmTransferableTreeNode tr = null;
                int size = items.size();
                for (int i = 0; i < size; ++i) {
                    tr = (AbstractDmTransferableTreeNode)items.elementAt(i);
                    if (node.isAcceptable(tr)) continue;
                    e.rejectDrop();
                    return;
                }
                DropEdit edit = null;
                edit = new DropEdit();
                XtmTreeTable.this.postEdit(edit);
                for (int i = 0; i < size; ++i) {
                    tr = (AbstractDmTransferableTreeNode)items.elementAt(i);
                    XtmTreeTable.this.postEdit(node.accept(tr, XtmTreeTable.this.myself));
                }
                edit.end();
                e.getDropTargetContext().dropComplete(true);
                XtmTreeTable.this.myself.invalidate();
                XtmTreeTable.this.myself.repaint();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }
}

