/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.node;

import com.syscom.tree.AbstractDmTransferableTreeNode;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.DmMenuItem;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.xml.node.AbstractXmlMutableTreeNode;
import com.syscom.xml.node.ElementNode;
import com.syscom.xml.schema.node.TableNode;
import com.syscom.xml.xtm.Preferences;
import com.syscom.xml.xtm.XtmDef;
import com.syscom.xml.xtm.gui.XTMFrame;
import com.syscom.xml.xtm.gui.XTMMenubar;
import com.syscom.xml.xtm.gui.XtmNodeDlg;
import com.syscom.xml.xtm.node.AbstractXtmMutableTreeNode;
import com.syscom.xml.xtm.node.XtmColumnNode;
import com.syscom.xml.xtm.node.XtmPreparedStatementNode;
import com.syscom.xml.xtm.treetable.XtmTreeTable;
import com.syscom.xml.xtm.undo.UpdateNodeEdit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.undo.UndoableEdit;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XtmTableNode
extends AbstractXtmMutableTreeNode {
    static ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
    private String owner = null;
    private String name = null;
    private String select = null;
    private static ImageIcon icon = null;
    private static String imagefilename = "/images/tree/schema/table.gif";

    public XtmTableNode(String owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    public XtmTableNode(Element elm) throws Exception {
        this.owner = elm.getAttribute("owner");
        this.name = elm.getAttribute("name");
        this.select = elm.getAttribute("select");
        this.getDetail(elm);
    }

    public XtmColumnNode searchChild(String name) {
        if (this.getChildCount() == 0) {
            return null;
        }
        for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
            if (!(child instanceof XtmColumnNode) || child.getText().compareTo(name) != 0) continue;
            return (XtmColumnNode)child;
        }
        return null;
    }

    private void getDetail(Element elm) throws Exception {
        AbstractXtmMutableTreeNode xNode = null;
        for (Node node = elm.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            xNode = null;
            if (node.getNamespaceURI().compareTo(XtmDef.getXTMNAMESPACE()) == 0) {
                String localName = node.getLocalName();
                if (localName.compareTo("column") == 0) {
                    xNode = new XtmColumnNode((Element)node);
                } else if (localName.compareTo("table") == 0) {
                    xNode = new XtmTableNode((Element)node);
                } else if (localName.compareTo("preparedStatement") == 0) {
                    xNode = new XtmPreparedStatementNode((Element)node);
                }
            } else if (node.getNamespaceURI().compareTo(XtmDef.XSL_NAMESPACE) == 0 && node.getLocalName().compareTo("for-each") == 0) {
                this.select = ((Element)node).getAttribute("select");
                this.getDetail((Element)node);
                return;
            }
            if (xNode == null) {
                ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.resource.Res", LocaleManager.getLocale());
                throw new Exception(GuiUt.mapStringForProperty(res.getString("parse_failed_cannot_be_under_xtt_table"), node.getNodeName()));
            }
            this.add(xNode);
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getText() {
        if (this.owner != null && this.owner.length() > 0) {
            return this.owner + "." + this.name;
        }
        return this.name;
    }

    @Override
    public void setText(String str) {
    }

    @Override
    public String getXPath() {
        return this.select != null ? this.select : "";
    }

    @Override
    public void setXPath(String str) {
        this.select = str;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), imagefilename);
        }
        return icon;
    }

    @Override
    public boolean isAcceptable(AbstractDmTransferableTreeNode node) {
        return node instanceof ElementNode || node instanceof TableNode;
    }

    @Override
    public UndoableEdit accept(AbstractDmTransferableTreeNode obj, XtmTreeTable treeTable) {
        if (!this.isAcceptable(obj)) {
            return null;
        }
        if (obj instanceof TableNode) {
            return this.acceptTableNode((TableNode)obj, treeTable);
        }
        if (obj instanceof ElementNode) {
            ElementNode node = (ElementNode)obj;
            UpdateNodeEdit edit = this.initXPath((AbstractXmlMutableTreeNode)obj, treeTable);
            String colname = null;
            AbstractXmlMutableTreeNode match = null;
            XtmColumnNode xtmcol = null;
            String xpath = null;
            for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                if (!(child instanceof XtmColumnNode) || (xtmcol = (XtmColumnNode)child).getXPath().length() > 0 || (match = node.searchChild(colname = xtmcol.getText())) == null) continue;
                xpath = match.getXPath(node);
                if (xtmcol.requireNormalizeSpace()) {
                    xpath = xtmcol.isNumeric() && xtmcol.getType() != -5 ? "number(" + xpath + ")" : "normalize-space(" + xpath + ")";
                }
                xtmcol.setXPath(xpath);
                edit.addEdit(new UpdateNodeEdit(treeTable, xtmcol, "", xpath, "xPath", true));
            }
            edit.end();
            return edit;
        }
        return null;
    }

    @Override
    public void writeXtm(Writer out) throws IOException {
        out.write("<xtm:table");
        if (this.owner != null && this.owner.length() > 0) {
            Preferences.writeXmlAttribute(out, "owner", this.owner);
        }
        if (this.name != null && this.name.length() > 0) {
            Preferences.writeXmlAttribute(out, "name", this.name);
        }
        if (this.select != null && this.select.length() > 0) {
            Preferences.writeXmlAttribute(out, "select", this.select);
        }
        if (this.getChildCount() == 0) {
            out.write("/>\n");
        } else {
            out.write(">\n");
            for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                child.writeXtm(out);
            }
            out.write("</xtm:table>\n");
        }
    }

    @Override
    public void writeScript(Writer out, Node context) throws IOException, TransformerException {
        AbstractXtmMutableTreeNode child;
        int i;
        int count = 0;
        StringBuffer query = new StringBuffer("INSERT INTO " + GuiUt.getIDString(this.owner) + "." + GuiUt.getIDString(this.name) + " (");
        for (AbstractXtmMutableTreeNode child2 = (AbstractXtmMutableTreeNode)this.getFirstChild(); child2 != null; child2 = (AbstractXtmMutableTreeNode)child2.getNextSibling()) {
            if (!(child2 instanceof XtmColumnNode)) continue;
            if (count > 0) {
                query.append(',');
            }
            query.append(child2.getText());
            ++count;
        }
        query.append(") VALUES (?");
        for (int i2 = 1; i2 < count; ++i2) {
            query.append(",?");
        }
        query.append(");\n");
        out.write(query.toString());
        NodeList list = XPathAPI.selectNodeList((Node)context, (String)this.select);
        boolean first = true;
        int size = list.getLength();
        for (i = 0; i < size; ++i) {
            first = true;
            for (child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                if (!(child instanceof XtmColumnNode)) continue;
                if (!first) {
                    out.write(44);
                } else {
                    first = false;
                }
                child.writeScript(out, list.item(i));
            }
            out.write(";\n");
        }
        out.write("end;\n");
        for (i = 0; i < size; ++i) {
            for (child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                if (child instanceof XtmColumnNode) continue;
                child.writeScript(out, list.item(i));
            }
        }
    }

    @Override
    public void showPopup(MouseEvent e) {
        XTMMenubar menubar = XTMFrame.frame.getXTMMenuBar();
        JPopupMenu qe_popupmenu = new JPopupMenu();
        DmMenuItem insertStmtMenuitem = new DmMenuItem(menubar.getAction((short)6));
        DmMenuItem removeMenuitem = new DmMenuItem(menubar.getAction((short)7));
        DmMenuItem propertiesMenuitem = new DmMenuItem(new ReflectionAction(this, "propertiesMenuitem_actionPerformed", res.getString("Properties"), null));
        qe_popupmenu.add(insertStmtMenuitem);
        qe_popupmenu.add(removeMenuitem);
        qe_popupmenu.addSeparator();
        qe_popupmenu.add(propertiesMenuitem);
        qe_popupmenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void propertiesMenuitem_actionPerformed(ActionEvent e) {
        XtmNodeDlg dlg = XtmNodeDlg.createXtmNodeDlg(this);
        dlg.show();
    }

    @Override
    public boolean isRemovabel() {
        return true;
    }

    @Override
    public boolean isAddible() {
        return true;
    }
}

