/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.node;

import com.syscom.tree.AbstractDmTransferableTreeNode;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.DmMenuItem;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.xml.node.AbstractXmlMutableTreeNode;
import com.syscom.xml.node.ElementNode;
import com.syscom.xml.schema.node.TableNode;
import com.syscom.xml.xtm.Preferences;
import com.syscom.xml.xtm.XtmDef;
import com.syscom.xml.xtm.XtmInfo;
import com.syscom.xml.xtm.gui.XTMFrame;
import com.syscom.xml.xtm.gui.XTMMenubar;
import com.syscom.xml.xtm.gui.XtmNodeDlg;
import com.syscom.xml.xtm.jdbc.WrapParameterMetaData;
import com.syscom.xml.xtm.node.AbstractXtmMutableTreeNode;
import com.syscom.xml.xtm.node.XtmSetParameterNode;
import com.syscom.xml.xtm.treetable.XtmTreeTable;
import com.syscom.xml.xtm.undo.AddNodeEdit;
import com.syscom.xml.xtm.undo.RemoveNodeEdit;
import com.syscom.xml.xtm.undo.UpdateNodeEdit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XtmPreparedStatementNode
extends AbstractXtmMutableTreeNode {
    private String name = null;
    private String command = null;
    private String select = null;
    private static ImageIcon icon = null;
    private static String imagefilename = "/images/tree/xtm/preparedStatement.gif";
    public boolean isCatching = false;

    public XtmPreparedStatementNode(String command) {
        this.command = command;
        try {
            XtmInfo info = XTMFrame.frame.getXtmInfo();
            PreparedStatement pstmt = info.conn.prepareStatement(command);
            WrapParameterMetaData pmd = WrapParameterMetaData.getParameterMetaData(pstmt);
            int count = pmd.getParameterCount();
            for (int i = 1; i <= count; ++i) {
                this.add(new XtmSetParameterNode(pmd.getParameterType(i)));
            }
            pstmt.close();
        }
        catch (Exception e) {
            GuiUt.showErrorDlg(XTMFrame.frame, e.getMessage());
            this.isCatching = true;
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public XtmPreparedStatementNode(Element elm) throws Exception {
        this.name = elm.getAttribute("name");
        this.command = elm.getAttribute("command");
        this.select = elm.getAttribute("select");
        this.getDetail(elm);
    }

    private void getDetail(Element elm) throws Exception {
        AbstractXtmMutableTreeNode xNode = null;
        for (Node node = elm.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            xNode = null;
            if (node.getNamespaceURI().compareTo(XtmDef.getXTMNAMESPACE()) == 0) {
                if (node.getLocalName().compareTo("preparedStatement") == 0) {
                    xNode = new XtmPreparedStatementNode((Element)node);
                } else if (node.getLocalName().compareTo("setParameter") == 0) {
                    xNode = new XtmSetParameterNode((Element)node);
                } else if (node.getLocalName().compareTo("executeUpdate") == 0) {
                    continue;
                }
            } else if (node.getNamespaceURI().compareTo(XtmDef.XSL_NAMESPACE) == 0 && node.getLocalName().compareTo("for-each") == 0) {
                this.select = ((Element)node).getAttribute("select");
                this.getDetail((Element)node);
                return;
            }
            if (xNode == null) {
                System.out.println("uri=" + node.getNamespaceURI());
                System.out.println("name=" + node.getLocalName());
                ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.resource.Res", LocaleManager.getLocale());
                throw new Exception(GuiUt.mapStringForProperty(res.getString("parse_failed_cannot_be_under_xtt_preparedstatement"), node.getNodeName()));
            }
            this.add(xNode);
        }
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public String getText() {
        if (this.name != null && this.name.length() > 0) {
            return this.name + ": " + this.command;
        }
        return this.command;
    }

    @Override
    public void setText(String str) {
        this.command = str;
    }

    public void updateParameters(XtmTreeTable treeTable) throws Exception {
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        PreparedStatement pstmt = info.conn.prepareStatement(this.command);
        WrapParameterMetaData pmd = WrapParameterMetaData.getParameterMetaData(pstmt);
        int total = pmd.getParameterCount();
        int count = 0;
        AbstractXtmMutableTreeNode child = null;
        if (this.getChildCount() > 0) {
            for (child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                if (!(child instanceof XtmSetParameterNode)) continue;
                if (count >= total) break;
                ++count;
            }
        }
        if (count >= total) {
            AbstractXtmMutableTreeNode next = null;
            int pos = 0;
            while (child != null) {
                if (child instanceof XtmSetParameterNode) {
                    next = (AbstractXtmMutableTreeNode)child.getNextSibling();
                    pos = this.getIndex(child);
                    treeTable.removeNodeFromParent(child, false);
                    this.postEdit(new RemoveNodeEdit(treeTable, this, child, pos, false));
                    child = next;
                    continue;
                }
                child = (AbstractXtmMutableTreeNode)child.getNextSibling();
            }
        } else {
            XtmSetParameterNode param = null;
            for (int i = count; i < total; ++i) {
                param = new XtmSetParameterNode(pmd.getParameterType(i + 1));
                treeTable.insertNodeInto(param, this, i, false);
                this.postEdit(new AddNodeEdit(treeTable, this, param, i, false));
            }
        }
        pstmt.close();
        treeTable.getTree().expandPath(new TreePath(this.getPath()));
        treeTable.revalidate();
        treeTable.repaint();
    }

    @Override
    public String getXPath() {
        return this.select != null ? this.select : "";
    }

    @Override
    public void setXPath(String str) {
        this.select = str;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), imagefilename);
        }
        return icon;
    }

    @Override
    public void writeXtm(Writer out) throws IOException {
        out.write("<xtm:preparedStatement");
        if (this.name != null && this.name.length() > 0) {
            Preferences.writeXmlAttribute(out, "name", this.name);
        }
        if (this.command != null && this.command.length() > 0) {
            Preferences.writeXmlAttribute(out, "command", this.command);
        }
        if (this.select != null && this.select.length() > 0) {
            Preferences.writeXmlAttribute(out, "select", this.select);
        }
        if (this.getChildCount() == 0) {
            out.write("/>\n");
        } else {
            out.write(">\n");
            for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                child.writeXtm(out);
            }
            out.write("</xtm:preparedStatement>\n");
        }
    }

    private int trace(Writer out, Node context, AbstractXtmMutableTreeNode current, boolean first) throws IOException, TransformerException {
        if (current.getChildCount() == 0) {
            return 0;
        }
        int count = 0;
        String temp = null;
        AbstractXtmMutableTreeNode child = null;
        for (child = (AbstractXtmMutableTreeNode)current.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
            if (child instanceof XtmSetParameterNode) {
                temp = ((XtmSetParameterNode)child).getStatement();
                if (temp != null && temp.length() != 0) continue;
                if (first) {
                    first = false;
                } else {
                    out.write(44);
                }
                ++count;
                child.writeScript(out, context);
                continue;
            }
            if (child instanceof XtmPreparedStatementNode) continue;
            count += this.trace(out, context, child, first);
        }
        return count;
    }

    private int trace(Writer out, Node context, String name, AbstractXtmMutableTreeNode current, boolean first) throws IOException, TransformerException {
        if (current.getChildCount() == 0) {
            return 0;
        }
        int count = 0;
        AbstractXtmMutableTreeNode child = null;
        for (child = (AbstractXtmMutableTreeNode)current.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
            if (child instanceof XtmSetParameterNode && ((XtmSetParameterNode)child).getStatement().compareTo(name) == 0) {
                if (first) {
                    first = false;
                } else {
                    out.write(44);
                }
                ++count;
                child.writeScript(out, context);
                continue;
            }
            count += this.trace(out, context, name, child, first);
        }
        return count;
    }

    @Override
    public void writeScript(Writer out, Node context) throws IOException, TransformerException {
        int i;
        out.write(this.command + ";\n");
        NodeList list = XPathAPI.selectNodeList((Node)context, (String)this.select);
        boolean first = true;
        int size = list.getLength();
        Node node = null;
        int count = 0;
        for (i = 0; i < size; ++i) {
            node = list.item(i);
            count = this.name != null && this.name.length() > 0 ? this.trace(out, node, this.name, this, true) : this.trace(out, node, this, true);
            if (count <= 0) continue;
            out.write(";\n");
        }
        if (count > 0) {
            out.write("end;\n");
        }
        for (i = 0; i < size; ++i) {
            node = list.item(i);
            if (this.getChildCount() == 0) continue;
            for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                if (child instanceof XtmSetParameterNode) continue;
                child.writeScript(out, node);
            }
        }
    }

    private void setParameterNumber(int total, XtmTreeTable treeTable) {
    }

    private int getCharCount(String str, char ch) {
        char[] a = str.toCharArray();
        int count = 0;
        int size = a.length;
        for (int i = 0; i < size; ++i) {
            if (a[i] != ch) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isAcceptable(AbstractXtmMutableTreeNode node) {
        return node instanceof XtmPreparedStatementNode;
    }

    @Override
    public boolean isAcceptable(AbstractDmTransferableTreeNode node) {
        return node instanceof ElementNode || node instanceof TableNode;
    }

    @Override
    public UndoableEdit accept(AbstractDmTransferableTreeNode obj, XtmTreeTable treeTable) {
        if (!this.isAcceptable(obj)) {
            return null;
        }
        if (obj instanceof TableNode) {
            return this.acceptTableNode((TableNode)obj, treeTable);
        }
        if (obj instanceof ElementNode) {
            UpdateNodeEdit edit = this.initXPath((AbstractXmlMutableTreeNode)obj, treeTable);
            edit.end();
            return edit;
        }
        return null;
    }

    @Override
    public void showPopup(MouseEvent e) {
        ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
        XTMMenubar menubar = XTMFrame.frame.getXTMMenuBar();
        JPopupMenu qe_popupmenu = new JPopupMenu();
        DmMenuItem insertStmtMenuitem = new DmMenuItem(menubar.getAction((short)6));
        DmMenuItem removeMenuitem = new DmMenuItem(menubar.getAction((short)7));
        DmMenuItem propertiesMenuitem = new DmMenuItem(new ReflectionAction(this, "propertiesMenuitem_actionPerformed", res.getString("Properties"), DBAImageResource.getResource(this.getClass(), "/images/menu/properties.gif")));
        qe_popupmenu.add(insertStmtMenuitem);
        qe_popupmenu.add(removeMenuitem);
        qe_popupmenu.addSeparator();
        qe_popupmenu.add(propertiesMenuitem);
        qe_popupmenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void propertiesMenuitem_actionPerformed(ActionEvent e) {
        XtmNodeDlg dlg = XtmNodeDlg.createXtmNodeDlg(this);
        dlg.show();
    }

    @Override
    public boolean isRemovabel() {
        return true;
    }

    @Override
    public boolean isAddible() {
        return true;
    }
}

