/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.gui;

import com.syscom.tree.AbstractDmMutableTreeNode;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.DbaButton;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.xml.node.AbstractXmlMutableTreeNode;
import com.syscom.xml.xtm.gui.XTMFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class SchemaChooseRootDlg
extends JDialog {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
    private DbaButton okButton = new DbaButton(this.res.getString("Ok"), 'O');
    private DbaButton cancelButton = new DbaButton(this.res.getString("Cancel"), 'C');
    private DbaButton helpButton = new DbaButton(this.res.getString("Help"), 'H');
    private AbstractXmlMutableTreeNode result = null;
    private JTree tree = null;
    private TreePath previous = null;
    private DefaultMutableTreeNode selection = null;

    public static SchemaChooseRootDlg createWorkspaceDlg(Dialog parent, JTree tree, DefaultMutableTreeNode selection) {
        SchemaChooseRootDlg dlg = null;
        dlg = GuiUt.isWindows() ? new SchemaChooseRootDlg(parent, tree, selection) : new SchemaChooseRootDlg(parent, true, tree, selection);
        return dlg;
    }

    private SchemaChooseRootDlg(Dialog dlg, boolean b, JTree tree, DefaultMutableTreeNode selection) {
        super(dlg, "", b);
        try {
            this.tree = tree;
            this.selection = selection;
            this.jbInit();
            this.pack();
            this.setSize(350, 350);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private SchemaChooseRootDlg(Dialog dlg, JTree tree, DefaultMutableTreeNode selection) {
        super(dlg);
        this.setModal(true);
        try {
            this.tree = tree;
            this.selection = selection;
            this.jbInit();
            this.pack();
            this.setSize(350, 350);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() {
        this.setResizable(false);
        this.setTitle(this.res.getString("Choose_root_element"));
        this.okButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/ok.gif"));
        this.cancelButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/cancel.gif"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/help.gif"));
        this.previous = this.selection != null ? new TreePath(this.selection.getPath()) : this.tree.getPathForRow(0);
        this.tree.setSelectionPath(this.previous);
        XTMFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "schemachooserootdlg");
        JPanel centerPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(this.okButton);
        bottomPanel.add(this.cancelButton);
        bottomPanel.add(this.helpButton);
        scrollPane.getViewport().add(this.tree);
        centerPanel.add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.getContentPane().add((Component)centerPanel, "Center");
        this.okButton.addActionListener(new ReflectionAction(this, "okButton_actionPerformed"));
        this.cancelButton.addActionListener(new ReflectionAction(this, "cancelButton_actionPerformed"));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SchemaChooseRootDlg.this.tree_valueChanged(e);
            }
        });
        this.tree.setCellRenderer(new RootTreeCellRenderer());
    }

    public void tree_valueChanged(TreeSelectionEvent e) {
        TreePath tp = e.getPath();
        if (tp.getPath().length > 2) {
            this.tree.setSelectionPath(this.previous);
            return;
        }
        this.previous = tp;
    }

    public void okButton_actionPerformed(ActionEvent e) {
        this.result = (AbstractXmlMutableTreeNode)this.tree.getLastSelectedPathComponent();
        this.setVisible(false);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.result = null;
        this.setVisible(false);
    }

    public AbstractXmlMutableTreeNode getSelection() {
        return this.result;
    }

    public class RootTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            AbstractDmMutableTreeNode xNode = (AbstractDmMutableTreeNode)value;
            this.setText(xNode.getText());
            if (xNode.getLevel() > 1) {
                this.setIcon(xNode.getDisableImageIcon());
                this.setForeground(Color.gray);
            } else {
                this.setIcon(xNode.getImageIcon());
                this.setForeground(Color.black);
            }
            return this;
        }
    }
}

