/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm;

import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.xtm.XtmInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XtmUt {
    public static void writeScript(String input, String output, XtmInfo info) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, TransformerException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File(input));
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(output));
            info.xtmRoot.writeScript(out, document);
            out.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void writeXtm(File file, XtmInfo info) throws FileNotFoundException, IOException {
        try {
            String dbbrand = "dbmaker";
            if (!LocaleManager.getIsDBMaker()) {
                dbbrand = "dbmaster";
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" \nversion=\"1.0\" \nxmlns:xtm=\"" + dbbrand + ".xml.XMLTransferMap\" \n" + "extension-element-prefixes=\"xtm\" \n");
            Hashtable namespaces = info.xmlRoot.getNamespaces();
            if (namespaces != null) {
                Enumeration enum1 = namespaces.keys();
                String key = null;
                String value = null;
                while (enum1.hasMoreElements()) {
                    key = (String)enum1.nextElement();
                    value = (String)namespaces.get(key);
                    out.write("xmlns:" + value + "=\"" + key + "\" \n");
                }
            }
            out.write(" >\n");
            info.xtmRoot.writeXtm(out);
            out.write("</xsl:stylesheet>");
            out.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

